#!/usr/bin/perl

use strict;

my $n=0;
my @bibtex = ();
my %bibtex = ();
open(FP, "bibtex.fmt") or die $!;
while(<FP>) {
    next if /^\s*$/;
    next if /^#/;
    chop;
    $bibtex[$n] = $_;
    $bibtex{$_} = $n;
    $n++;
}
close(FP);

my %citekey;
sub citekey {
    my($a, $y) = @_;
    my $x;
    if($y =~ /^\d\d(\d\d)$/) {
	$x = $1;
    } else {
	$x = "00";
    }
    my $b = $a;
    $b =~ s/^\W+//;
    $b =~ s/\W.*//;
    $b .= $x;
    if(defined $citekey{$b}) {
	$b .= 'a';
	for my $z ('a' .. 'z') {
	    $b =~ s/.$/$z/;
	    last if not defined $citekey{$b};
	}
	if(not defined $citekey{$b}) {
	    $citekey{$b} = 1;
	} else {
	    die "Cannot build citekey: $a, $y\n";
	}
    } else {
	$citekey{$b} = 1;
    }
    return ($b);	
}

while(<>) {
    chomp;
    my($author, $title, $publisher, $year, $firstedition, $edition, $category, $got, $note, $bignote) = split(/\t/);
    my @row;
    $row[$bibtex{entrytype}] = 'book';
    $row[$bibtex{citekey}] = citekey($author, ($firstedition or $year));
    $row[$bibtex{author}] = $author;
    $row[$bibtex{title}] = $title;
    $row[$bibtex{publisher}] = $publisher;
    $row[$bibtex{year}] = $year;
    $row[$bibtex{firstedition}] = $firstedition;
    $row[$bibtex{edition}] = $edition;
    $row[$bibtex{category}] = $category;
    $row[$bibtex{got}] = $got;
    $row[$bibtex{note}] = $note . "; " if $note;
    $row[$bibtex{note}] .= $bignote;
    $row[$#bibtex] |= "" if not defined $row[$#bibtex];
    print join("\t", @row) . "\n";
}
