<?php
include_once("include/bibtex.php");
include_once("include/ftpUpload.php");
include_once("include/database.php");

set_time_limit(0);
session_start();
if(!isset($_SESSION['user']))
{
	header("Location:session_expired.php");
	exit();
}

if ($_SESSION['user']['rights'] === "r")
{
	header("Location:norights.php");
}

$dbSuccess = FALSE;
$localfile = "";

// Build the bibtex Citation Entry
$bibtex = array();
foreach($bibtexFields as $field)
{
  if (array_key_exists($field, $_POST)&&(strcmp($_POST[$field],"")!=0))
  {
  	if (get_magic_quotes_gpc()==1) $bibtex[$field] = stripslashes($_POST[$field]);
  	else $bibtex[$field] = $_POST[$field];
   }
   else
   {
        $bibtex[$field] = "";
   }
}

if (!array_key_exists('bibtexEntryType', $_POST))
	$bibtex['bibtexEntryType'] = $bibtexTypes['article'][0];

if (array_key_exists('fileupload', $_POST))
	$localfile = $_POST('fileupload');

if ((array_key_exists('genBibKey', $_POST))&&(array_key_exists('author', $bibtex)))
{
	$bibtex['bibtexCitation'] = dbGenerateNewCitationKey($bibtex);
}

if ((array_key_exists('genPdf', $_POST))&&(array_key_exists('bibtexCitation', $bibtex)))
{
  if (strlen($bibtex['bibtexCitation'])>0)
    $bibtex['file'] = $bibtex['bibtexCitation'].".pdf";
}

if (!array_key_exists('confidential', $_POST))
	$bibtex['confidential'] = "n"; /* Default : an entry is not confidential */


if (array_key_exists('Insert', $_POST))
{
	$isValid = isValidBibtexEntry($bibtex);
	
	if (!$isValid) echo "<p>Some mandatory fields must be filled with information</p>";
	
	$isInserted = dbAddBibtex($bibtex);
	if (!$isInserted)
	{
		print "<p>Unable to insert this citation in the database, the citation key or the file already exists</p>";
		$sql = "SELECT * from citations_tbl WHERE bibtexCitation='".$bibtex['bibtexCitation']."'";
		dbQueryDisplayBibtex($sql);
	}
	else $dbSuccess = TRUE;
}

if ((array_key_exists('Replace', $_POST)))
{
	if (array_key_exists('oldCitation', $_POST))
	{
		$isValid = isValidBibtexEntry($bibtex);

		if (!$isValid) echo "<p>Some mandatory fields must be filled with information</p>";
		$isInserted = dbAlterBibtex($_POST['oldCitation'], $bibtex);
		
		if (isInserted&&array_key_exists('file', $bibtex)&&array_key_exists('oldFile', $_POST))
		{
		        if (strcmp($_POST['oldFile'], $bibtex['file'])!=0)
	        	{
	        	        if ((strlen($_POST['oldFile'])>0)&&(strlen($bibtex['file'])>0))
	        	        {
	        	                if (!file_exists($file_dir."/".$bibtex['file']))
	        	                {
	                			$moved = dbRenameFile($file_dir."/".$_POST['oldFile'], $file_dir."/".$bibtex['file']);
	                			if ($moved) unset($_POST['oldFile']);
	                			else print "<p>Unable to rename the file ".$_POST['oldFile']." to ".$bibtex['file']."</p>";
	                		}
					else print "<p>Unable to rename the file ".$_POST['oldFile']." to ".$bibtex['file']." It already exists</p>";
				}
	        	}
		}
		
		if (!$isInserted) print "<p>Unable to replace this citation in the database, the new citation key already exists</p>";
		else $dbSuccess = TRUE;
	}
	else
	{
	print "<p>Unable to alter a citation in the database, no previous record exists: insert it explicitely</p>";
	}
}

// Manage the file upload
if ($dbSuccess&&((array_key_exists('Replace', $_POST))||(array_key_exists('Insert', $_POST))))
{
	$localfile = "";
	if (array_key_exists('file', $bibtex))
	{
		foreach($_FILES as $file_name => $file_array)
		{
			if (is_uploaded_file($file_array['tmp_name']))
			{
			  if (file_exists($file_dir."/".$bibtex['file']))
			  {
			      if (array_key_exists('Replace', $_POST))
			      {
        		    	move_uploaded_file($file_array['tmp_name'],$file_dir."/".$bibtex['file']) or die ("Couldn't copy".$bibtex['file']);
        		    	print "File ".$bibtex['file']." Uploaded<br>";
        		    	if (array_key_exists('oldFile', $_POST))
				{
				    	if (strcmp($bibtex['file'],$_POST['oldFile'])!=0)
						unlink($file_dir."/".$_POST['oldFile']);
        			    	unset($_POST['oldFile']);
				}
			      }
			      else
			      {
			         print "Error: the file ".$bibtex['file']." already exists in the database: you must replace the citation to force its remplacement";
			         unlink($file_array['tmp_name']);
			         $dbSuccess = FALSE;
			     }
			  }
			  else
			  {
			        move_uploaded_file($file_array['tmp_name'],$file_dir."/".$bibtex['file']) or die ("Couldn't copy".$bibtex['file']);
			  	print "File ".$bibtex['file']." Uploaded<br>";
			  	unset($_POST['oldFile']);
			  }
    		        }
		}
	}
	else
	{
	        foreach($_FILES as $file_name => $file_array)
		{
	        	if (is_uploaded_file($file_array['tmp_name']))
			{
				unlink($file_array['tmp_name']);
			}
  		}
	}
}

if ($dbSuccess)
{
  print "<script language=\"javascript\">\n";
  print "if (opener) {\n";
  print "opener.parent.frames['ContentFrame'].location.reload();\n";
  print "self.close();}\n";
  print "else parent.frames['ContentFrame'].location.replace(\"welcome.php\");\n";
  print "</script>";
}
else
{
  echo "<head>";
  echo "<link href=\"css/style.css\" rel=\"Stylesheet\" type=\"text/css\">";
  echo "</head>";
  echo "<body class=\"texte\">";
  
  if (array_key_exists('oldCitation',$_POST))
	{
	        print "<strong>Beware, you can now replace the following citation</strong><br>";
	        $sql = "SELECT * FROM citations_tbl WHERE bibtexCitation=\"".$_POST['oldCitation']."\"";
	        dbQueryDisplayBibtex($sql);
	}

	echo "<FORM name=\"bibtexform\" action=\"BibtexForm.php\" enctype=\"multipart/form-data\" method=\"POST\">";
	generateBibtexForm($bibtex, $localfile);
	echo "<p>";
	if (array_key_exists('oldCitation',$_POST))
	        	print "<input type=\"hidden\" name=\"oldCitation\" value=\"".$_POST['oldCitation']."\">";
       	if (array_key_exists('oldFile',$_POST))
        	print "<input type=\"hidden\" name=\"oldFile\" value=\"".$_POST['oldFile']."\">";
	echo "<table><tr>";
	echo "<td><input type=\"submit\" name=\"Insert\" value=\"Insert\"></td>";
	echo "<td><input type=\"submit\" name=\"Replace\" value=\"Replace\"></td>";
        echo "<td><input type=\"submit\" name=\"genBibKey\" value=\"Generate BibTeX key\" title=\"Requires author and year\"></td>";
        echo "<td><input type=\"submit\" name=\"genPdf\" value=\"Generate PDF Name\" title=\"Requires bibtex citation key\"></td>";
	echo "</tr></table>";
	echo "</p>";
	echo "</FORM>";
	echo "</body>";
}
?>
