<?php
session_start();
if(!isset($_SESSION['user']))
{
	header("Location:session_expired.php");
	exit();
}
?>

<?php

include_once("include/ftpUpload.php");
include_once("include/database.php");
include_once("include/strings.php");
include_once("include/parsecreators.php");
include_once("include/bibtex.php");

set_time_limit(0);

$dbconn = mysql_connect($dbhost, $dbuser, $dbpwd);
$result = mysql_select_db($dbase, $dbconn);


echo "<head>";
echo "<link href=\"css/style.css\" rel=\"Stylesheet\" type=\"text/css\">";
echo "</head>";

echo "<body class=\"texte\">";
print "<p><strong>First Verification Step: Verifying files on disk</strong></p>";

// First: verify if all files on the disk are referenced exactly once
$rep=opendir($file_dir);
$found = FALSE;
chdir($file_dir);
while ($file = readdir($rep))
{
	if(is_file($file))
	{
        	$sql = "SELECT * from citations_tbl WHERE file=\"".$file."\"";
        	$result = mysql_query($sql, $dbconn);
        	if (mysql_num_rows($result)==0)
        	{
        	        print "The file ".$file." is not referenced in the database<br>";
        	        $found = TRUE;
        	}
        	else if (mysql_num_rows($result)>1)
        	{
        	        print "The file ".$file." has multiple references in the database<br>";
        	        $found = TRUE;
        	}
	}
}
closedir($rep);

if (!$found) print "OK: All files on disk are referenced in the database<br>";

// Second: verify if all links to a file in the citations are valid

print "<p><strong>Second Verification Step: Verifying Links to Files</strong></p>";
$found = FALSE;
$sql = "SELECT DISTINCT file from citations_tbl WHERE file <> ''";
$result = mysql_query($sql, $dbconn);
while ($file = mysql_fetch_array($result))
{
	if(!is_file($file[0]))
	{
		print "The file ".$file[0]." is referenced, but not on the disk<br>";
		$found = TRUE;
	}
}

if (!$found) print "OK: No unknown file is referenced in the database<br>";

// Third: verify database table links integrity
print "<p><strong>Third Verification Step: Verifying inter tables links consistency</strong></p>";
$sql = "SELECT bibtexCitation from keywords_cite_tbl";
$result = mysql_query($sql, $dbconn) or die(mysql_error());
$cpt = 0;
while ($bibkey = mysql_fetch_array($result))
{
	$sql = "SELECT bibtexCitation from citations_tbl WHERE bibtexCitation=\"".$bibkey[0]."\"";
	$result2 = mysql_query($sql, $dbconn) or die(mysql_error());
	$numrows = mysql_num_rows($result2);
	if ($numrows==0)
	{
	        $cpt++;
	        print "The key ".$bibkey." is referenced in keywords_cite_tbl, but does no more exist<br>";
	        $sql = "DELETE from keywords_cite_tbl WHERE bibtexCitation=\"".$bibkey[0]."\"";
	        $result2 = mysql_query($sql, $dbconn) or die(mysql_error());
	        if ($result2) print "The problem has been solved<br>";
	}
}


if ($cpt==0) print "OK: there is no reference to unknown citations in keywords_cite_tbl<br>";

$sql = "SELECT keyword from keywords_cite_tbl";
$result = mysql_query($sql, $dbconn) or die(mysql_error());
$cpt = 0;
while ($keyword = mysql_fetch_array($result))
{
	$sql = "SELECT keyword from keywords_tbl WHERE keyword=\"".$keyword[0]."\"";
	$result2 = mysql_query($sql, $dbconn) or die(mysql_error());
	$numrows = mysql_num_rows($result2);
	if ($numrows==0)
	{
	        $cpt++;
	        print "The keyword ".$keyword." is referenced in keywords_cite_tbl, but does no more exist<br>";
	        $sql = "DELETE from keywords_cite_tbl WHERE keyword=\"".$keyword[0]."\"";
	        $result2 = mysql_query($sql, $dbconn) or die(mysql_error());
	        if ($result2) print "The problem has been solved<br>";
	}
}

if ($cpt==0) print "OK: there is no reference to unknown keywords in keywords_cite_tbl<br>";

// Fourth: verify key construction using the author names
print "<p><strong>Fourth Verification Step: Verifying if the keys are correctly built</strong></p>";
$found = FALSE;
$sql = "SELECT * from citations_tbl WHERE author <> '' ORDER BY date DESC";
$result = mysql_query($sql, $dbconn);
$cpt = 0;
while ($bibtex = mysql_fetch_array($result))
{
	$bibtex = cleanBibtex($bibtex);

	$key = generateCitationKey($bibtex);
	if (strncasecmp($bibtex['bibtexCitation'], $key, strlen($key))!=0)
	{
	        print "The key of this entry should probably be: ".$key."<br>";
	        displayBibtex($bibtex);
		$cpt++;
	}
}

if ($cpt>0) print "There are ".$cpt." incorrect keys found<br>";
else print "OK: all citation keys seem to be correct<br>";

// Fifth: try to verify double titles in database
print "<p><strong>Fifth Verification Step: Verifying if there are duplicated titles</strong></p>";
$found = FALSE;
$sql = "SELECT DISTINCT title from citations_tbl WHERE title <> ''";
$result = mysql_query($sql, $dbconn);
mysql_close($dbconn);
while ($title = mysql_fetch_array($result))
{
        $dbconn = mysql_connect($dbhost, $dbuser, $dbpwd);
	$result2 = mysql_select_db($dbase, $dbconn);
	$sql = "SELECT * from citations_tbl WHERE title=\"".mysql_real_escape_string($title[0]).
		"\" or title=\"".mysql_real_escape_string(removeBracket($title[0]))."\" or ".
		"title=\"".mysql_real_escape_string(latexToFrench($title[0]))."\"";
	$result2 = mysql_query($sql, $dbconn);
	mysql_close($dbconn);
	if (mysql_num_rows($result2)>1)
	{
	        $found = TRUE;
		dbQueryDisplayBibtex($sql);
	}
}

if (!$found) print "OK: No duplicate title found in the database<br>";


?>

