<?php

include_once("ftpUpload.php");
include_once("strings.php");
include_once("parsecreators.php");

// Mandatory field
$MAN = TRUE;
// Optional field
$OPT = FALSE;

// All possible fields
$bibtexFields = array(
	"bibtexEntryType",
	"bibtexCitation",
	"author",
	"title",
	"journal",
	"year",
	"volume",
	"number",
	"pages",
	"month",
	"note",
	"editor",
	"publisher",
	"institution",
	"series",
	"address",
	"edition",
	"howpublished",
	"chapter",
	"booktitle",
	"type",
	"organization",
	"school",
	"keywords",
	"url",
	"file",
	"confidential",
	"comments" );

$ArticleFields = array(
	array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
	array("journal", $MAN),
	array("year", $MAN),
	array("volume", $OPT),
	array("number", $OPT),
	array("pages", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$BookFields = array(
        array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
	array("editor", $OPT),
	array("publisher", $MAN),
	array("year", $MAN),
	array("volume", $OPT),
	array("number", $OPT),
	array("series", $OPT),
	array("address", $OPT),
	array("edition", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$BookletFields = array(
        array("bibtexCitation", $MAN),
	array("title", $MAN),
	array("author", $OPT),
	array("howpublished", $OPT),
	array("year", $OPT),
	array("address", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$InbookFields = array(
        array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
	array("editor", $MAN),
	array("chapter", $MAN),
	array("pages", $MAN),
	array("publisher", $MAN),
	array("year", $MAN),
	array("volume", $OPT),
	array("number", $OPT),
	array("series", $OPT),
	array("type", $OPT),
	array("address", $OPT),
	array("edition", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$IncollectionFields = array(
        array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
	array("booktitle", $MAN),
	array("publisher", $MAN),
	array("year", $MAN),
	array("volume", $OPT),
	array("number", $OPT),
	array("series", $OPT),
	array("type", $OPT),
	array("address", $OPT),
	array("edition", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$InproceedingsFields = array(
	array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
	array("booktitle", $MAN),
	array("year", $MAN),
	array("editor", $OPT),
	array("volume", $OPT),
	array("number", $OPT),
	array("series", $OPT),
	array("pages", $OPT),
	array("address", $OPT),
	array("month", $OPT),
	array("organization", $OPT),
	array("publisher", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$ManualFields = array(
	array("bibtexCitation", $MAN),
	array("title", $MAN),
	array("author", $OPT),
	array("organization", $OPT),
	array("address", $OPT),
        array("edition", $OPT),
	array("month", $OPT),
	array("year", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$MastersthesisFields = array (
        array("bibtexCitation", $MAN),
	array("title", $MAN),
	array("author", $MAN),
        array("school", $MAN),
        array("year", $MAN),
        array("type", $OPT),
	array("address", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$MiscFields = array (
        array("bibtexCitation", $MAN),
	array("author", $OPT),
        array("title", $OPT),
	array("howpublished", $OPT),
	array("month", $OPT),
	array("year", $OPT),
        array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$ProceedingsFields = array (
        array("bibtexCitation", $MAN),
        array("title", $MAN),
        array("year", $MAN),
        array("editor", $OPT),
	array("volume", $OPT),
	array("number", $OPT),
	array("series", $OPT),
	array("address", $OPT),
	array("month", $OPT),
	array("organization", $OPT),
	array("publisher", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$TechreportFields = array (
	array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
        array("institution", $MAN),
        array("year", $MAN),
        array("type", $OPT),
        array("number", $OPT),
	array("address", $OPT),
	array("month", $OPT),
	array("note", $OPT),
	array("url", $OPT),
	array("keywords", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

$UnpublishedFields = array (
        array("bibtexCitation", $MAN),
	array("author", $MAN),
	array("title", $MAN),
	array("note", $MAN),
	array("month", $OPT),
	array("year", $OPT),
	array("keywords", $OPT),
	array("url", $OPT),
	array("file", $OPT),
	array("confidential", $OPT),
	array("comments", $OPT)
	);

// All bibtex citation types
$bibtexTypes = array(
	'article' => array("article", $ArticleFields),
	'book' => array("book", $BookFields),
	'booklet' => array("booklet", $BookletFields),
	'conference' => array("conference", $InproceedingsFields),
	'inbook' => array("inbook", $InbookFields),
	'incollection' => array("incollection", $IncollectionFields),
	'inproceedings' => array("inproceedings", $InproceedingsFields),
	'manual' => array("manual", $ManualFields),
	'mastersthesis' => array("mastersthesis", $MastersthesisFields),
	'misc' => array("misc", $MiscFields),
	'phdthesis' => array("phdthesis", $MastersthesisFields),
	'proceedings' => array("proceedings", $ProceedingsFields),
	'techreport' => array("techreport", $TechreportFields),
	'unpublished' => array("unpublished", $UnpublishedFields)
	);

function displayTextBibtex($bibtexentry)
{
	global $bibtexTypes, $MAN;

        $entryTypes = $bibtexTypes[$bibtexentry['bibtexEntryType']][1];
        print "<pre>";
        print "@".$bibtexentry['bibtexEntryType']."{".$bibtexentry['bibtexCitation'].",<br>";

	$cpt = 0;
	foreach($entryTypes as $fields)
	{
		 if (array_key_exists($fields[0], $bibtexentry)&&
		     (strcmp($fields[0],"comments")!=0)&&
		     (strcmp($fields[0],"bibtexCitation")!=0))
		 if (array_key_exists($fields[0], $bibtexentry))
		 {
		        if ($cpt>0) print ",\n";
			print "    ".$fields[0]." = {".frenchToLatex($bibtexentry[$fields[0]])."}";
			$cpt++;
		 }
		 else if ($fields[1] === $MAN)
		 {
		        if ($cpt>0) print ",\n";
		        print "    ".$fields[0]." = {}";
		        $cpt++;
		 }
	}
	print "\n}\n";
	print "</pre>";
}

// Display a bibtex citation on screen
function displayBibtex($bibtexentry)
{
	global $bibtexTypes, $MAN;

	$key = generateCitationKey($bibtexentry);

	if (strncmp($bibtexentry['bibtexCitation'], $key, strlen($key))!=0)
	        $color = "#8888EE";
	elseif (!isValidBibtexEntry($bibtexentry))
		$color = "#44DD44";
	else $color = "#F9F1C8";

	print "<table BORDER bordercolor=\"#000000\" bgcolor=\"".$color."\" WIDTH=\"100%\" cellspacing=0 class=\"texte\">
		<tr>";
		 if (array_key_exists('user', $bibtexentry))
	         	print "<td colspan=\"4\">".$bibtexentry['bibtexEntryType']."(".$bibtexentry['bibtexCitation'].") provided by ".$bibtexentry['user'];
	         else print "<td colspan=\"4\">".$bibtexentry['bibtexEntryType']."(".$bibtexentry['bibtexCitation'].") ";
		 if (array_key_exists('date', $bibtexentry))
		 	print " on ".$bibtexentry['date']."</td>";
		 print "</tr> <tr><td colspan=\"4\" bgcolor=\"white\"> ";
	$entryTypes = $bibtexTypes[$bibtexentry['bibtexEntryType']][1];
	$cpt = FALSE;
	foreach($entryTypes as $fields)
	{
		 if (array_key_exists($fields[0], $bibtexentry)&&(strlen($bibtexentry[$fields[0]])>0))
		 {
		        if ((strcmp($fields[0],"comments")!=0)&&(strcmp($fields[0],"bibtexCitation")!=0))
		        {
        		        if ($cpt) print ", ";
				if (strcmp($fields[0],"title")==0)
				{
					print "<b>".latexToFrench($bibtexentry[$fields[0]])."</b>";
					$cpt = TRUE;
				}
				elseif ((strcmp($fields[0],"booktitle")==0)||(strcmp($fields[0],"journal")==0))
				{
				        print "<i>".latexToFrench($bibtexentry[$fields[0]])."</i>";
				        $cpt = TRUE;
				}
				elseif (strcmp($fields[0],"url")==0)
				{
                                        print "<A HREF=\"".htmlspecialchars($bibtexentry['url'], ENT_COMPAT, 'ISO-8859-15')."\" TARGET=\"_blank\">URL</A>";
                                        $cpt = TRUE;
				}
				elseif (strcmp($fields[0],"confidential")==0)
				{
				        if(strcmp($bibtexentry[$fields[0]], "y")==0)
				                print "<b>Confidential: DO NOT CITE IN YOUR PAPER</b>";
					else print "Not confidential";
					$cpt = TRUE;
				}
				elseif (strcmp($fields[0],"pages")==0)
				{
				        print "pp. ".latexToFrench($bibtexentry[$fields[0]]);
					$cpt = TRUE;
				}
				elseif (strcmp($fields[0],"file")==0)
				{
				        $cpt = FALSE;
				}
				else
				{
					print latexToFrench($bibtexentry[$fields[0]]);
					$cpt = TRUE;
				}
			}
		}
	}
	print "</td> </tr> <tr> <td>";
	@session_start();
	if ($_SESSION['user']['rights'] === "w")
	{
		print "<form action=\"BibtexForm.php\" target=\"window\" title=\"Bibtex Edition\" method=\"POST\">";
		print "<input type=\"hidden\" name=\"bibtexEntryType\" value=\"".$bibtexentry['bibtexEntryType']."\">";
		print "<input type=\"hidden\" name=\"oldCitation\" value=\"".$bibtexentry['bibtexCitation']."\">";
		if (array_key_exists('file', $bibtexentry))
			print "<input type=\"hidden\" name=\"oldFile\" value=\"".$bibtexentry['file']."\">";
		foreach($entryTypes as $fields)
		{
	        	if (array_key_exists($fields[0], $bibtexentry))
			{
	          	print "<input type=\"hidden\" name=\"".$fields[0]."\" value=\"".htmlspecialchars($bibtexentry[$fields[0]])."\">";
			}
		}
		print "<input type=\"submit\" name=\"EditEntry\" value=\"Edit\">";
		print "</form></td>";

		print "<td><form action=\"databaseremove.php\" title=\"Welcome Page\" target=\"window\" method=\"POST\">";
		print "<input type=\"hidden\" name=\"bibtexCitation\" value=\"".$bibtexentry['bibtexCitation']."\">";
		print "<input type=\"submit\" name=\"RemoveEntry\" value=\"Remove From database\">";
		print "</form> </td>";
	}

	print "<td><form action=\"displaysinglebibtex.php\" title=\"Display Bibtex Entry\" target=\"window\" method=\"POST\">";
	print "<input type=\"hidden\" name=\"bibtexCitation\" value=\"".$bibtexentry['bibtexCitation']."\">";
	print "<input type=\"submit\" name=\"viewBibtex\" value=\"Display Bibtex\">";
	print "</form> </td>";
	print "<td valign=\"top\">";
	if (array_key_exists('file', $bibtexentry))
		print "<A HREF=\"upload/".$bibtexentry['file']."\" TARGET=\"window\">Paper View</A>";
	else
	{
		print "No paper ";
		if (array_key_exists('title', $bibtexentry))
		{
			print "(<A HREF=\"http://www.google.com/search?q=%22".htmlspecialchars(googleString(latexToFrench($bibtexentry['title'])), ENT_COMPAT, 'ISO-8859-15')."%22&start=0&ie=ISO-8859-15&oe=ISO-8859-15\" TARGET=\"_blank\">Google</A>)";
			print "(<A HREF=\"http://scholar.google.com/scholar?q=%22".htmlspecialchars(googleString(latexToFrench($bibtexentry['title'])), ENT_COMPAT, 'ISO-8859-15')."%22&start=0&ie=ISO-8859-15&oe=ISO-8859-15\" TARGET=\"_blank\">Scholar</A>)";
		}
	}
	print "</td> </tr>";
	print "</table>";
}

// Display a bibtex citation on screen as part of a tabular list
function displayBibtexListItem($bibtexentry)
{
	global $bibtexTypes, $MAN;

	$key = generateCitationKey($bibtexentry);

	if (strncmp($bibtexentry['bibtexCitation'], $key, strlen($key))!=0)
	  {
	    $color = "#8888EE";
	    $coloronmouse = "#9999FF";
	  }
	elseif (!isValidBibtexEntry($bibtexentry))
	  {
	    $color = "#44DD44";
	    $coloronmouse = "#55EE55";
	  }
	else 
	  {
	    $color = "#F9F1C8";
	    $coloronmouse = "#FAF2D9";
	  }

	print "<tr  bgcolor=\"".$color."\" onmouseover=\"javascript:style.backgroundColor='".$coloronmouse."'\" onmouseout=\"javascript:style.backgroundColor='".$color."'\"><td BORDER>";
	print "<input type=\"checkbox\" name=\"citations[]\" value=\"".$bibtexentry['bibtexCitation']."\">";
	print "</td>";
	if (array_key_exists('user', $bibtexentry))
	{
	  print "<td width=\"50\" align=\"center\">".$bibtexentry['bibtexEntryType']."</td><td align=\"center\" width=\"50\">".$bibtexentry['bibtexCitation']."</td>";
	  print "<td width=\"50\" align=\"center\">".$bibtexentry['user']."</td>";
	}
	else print "<td align=\"center\">".$bibtexentry['bibtexEntryType']."(".$bibtexentry['bibtexCitation']."</td>";
	if (array_key_exists('date', $bibtexentry))
	  print "<td align=\"center\">".$bibtexentry['date']."</td>";
	print "<td align=\"justify\"> ";
	
	$entryTypes = $bibtexTypes[$bibtexentry['bibtexEntryType']][1];
	$cpt = FALSE;
	foreach($entryTypes as $fields)
	{
		 if (array_key_exists($fields[0], $bibtexentry)&&(strlen($bibtexentry[$fields[0]])>0))
		 {
		        if ((strcmp($fields[0],"comments")!=0)&&(strcmp($fields[0],"bibtexCitation")!=0))
		        {
        		        if ($cpt) print ", ";
				if (strcmp($fields[0],"title")==0)
				{
					print "<b>".latexToFrench($bibtexentry[$fields[0]])."</b>";
					$cpt = TRUE;
				}
				elseif ((strcmp($fields[0],"booktitle")==0)||(strcmp($fields[0],"journal")==0))
				{
				        print "<i>".latexToFrench($bibtexentry[$fields[0]])."</i>";
				        $cpt = TRUE;
				}
				elseif (strcmp($fields[0],"url")==0)
				{
                                        print "<A HREF=\"".htmlspecialchars($bibtexentry['url'], ENT_COMPAT, 'ISO-8859-15')."\" TARGET=\"_blank\">URL</A>";
                                        $cpt = TRUE;
				}
				elseif (strcmp($fields[0],"confidential")==0)
				{
				        if(strcmp($bibtexentry[$fields[0]], "y")==0)
				                print "<b>Confidential: DO NOT CITE IN YOUR PAPER</b>";
					else print "Not confidential";
					$cpt = TRUE;
				}
				elseif (strcmp($fields[0],"pages")==0)
				{
				        print "pp. ".latexToFrench($bibtexentry[$fields[0]]);
					$cpt = TRUE;
				}
				elseif (strcmp($fields[0],"file")==0)
				{
				        $cpt = FALSE;
				}
				else
				{
					print latexToFrench($bibtexentry[$fields[0]]);
					$cpt = TRUE;
				}
			}
		}
	}

 	print "<td valign=\"center\" align=\"center\">";
 	if (array_key_exists('file', $bibtexentry))
 		print "<A HREF=\"upload/".$bibtexentry['file']."\" TARGET=\"window\">Paper View</A>";
 	else
 	{
 		print "No paper ";
 		if (array_key_exists('title', $bibtexentry))
 		{
 			print "(<A HREF=\"http://www.google.com/search?q=%22".htmlspecialchars(googleString(latexToFrench($bibtexentry['title'])), ENT_COMPAT, 'ISO-8859-15')."%22&start=0&ie=ISO-8859-15&oe=ISO-8859-15\" TARGET=\"_blank\">Google</A>)";
 			print "(<A HREF=\"http://scholar.google.com/scholar?q=%22".htmlspecialchars(googleString(latexToFrench($bibtexentry['title'])), ENT_COMPAT, 'ISO-8859-15')."%22&start=0&ie=ISO-8859-15&oe=ISO-8859-15\" TARGET=\"_blank\">Scholar</A>)";
 		}
 	}
 	print "</td><td class=\"vide\" style=\"width: 2px;\"></td></tr>";
}

function displayBadBibtex($bibtexentry, $error)
{
	global $bibtexTypes, $MAN;

	print "<table bordercolor=\"#000000\" bgcolor=\"red\" WIDTH=\"100%\">
		<tr>
	         <td>".$bibtexentry['bibtexCitation'].":".$error."</td>
		</tr> <tr><td bgcolor=\"yellow\"> ";
	$entryTypes = $bibtexTypes[$bibtexentry['bibtexEntryType']][1];
	$cpt = 0;
	foreach($entryTypes as $fields)
	{
		 if (array_key_exists($fields[0], $bibtexentry)&&(strlen($bibtexentry[$fields[0]])>0))
		 {
		        if (strcmp($fields[0],"comments")!=0)
		        {
        		        if ($cpt>0) print ", ";
				if ($fields[0]==='title') print "<b><i>";
				if (strcmp($fields[0],"confidential")==0)
				{
				        if(strcmp($bibtexentry[$fields[0]], "y")==0)
				                print "<b>Confidential: DO NOT REFERENCE IN YOUR PAPERS</b>";
					else print "Not confidential";
				}
				else
					print $bibtexentry[$fields[0]];
				if ($fields[0]==='title') print "</i></b>";
				$cpt++;
			}
		}
	}
	print "</tr> <tr> <td>";
	print "<form action=\"BibtexForm.php\" method=\"POST\">";
	print "<input type=\"hidden\" name=\"bibtexEntryType\" value=\"".$bibtexentry['bibtexEntryType']."\">";
	foreach($entryTypes as $fields)
	{
	        if (array_key_exists($fields[0], $bibtexentry))
		{
	          print "<input type=\"hidden\" name=\"".$fields[0]."\" value=\"".$bibtexentry[$fields[0]]."\">";
		}
	}
	print "<input type=\"submit\" name=\"EditEntry\" value=\"Edit\">";
	if (array_key_exists('file', $bibtexentry))
		print "<A HREF=\"upload/".$bibtexentry['file']."\" TARGET=\"ContentFrame\">Paper View</A>";
	print "</form>";

	print "</td> </tr>";
	print "</table>";
}

function generateInputText($field, $option, $bibtex)
{
	if (array_key_exists($field, $bibtex))
	        $value = $bibtex[$field];
	else $value = "";

	print "<tr>";
	print "<td ";
	if ($option) print "BGCOLOR=\"orange\">";
	else print ">";
	print "<strong>".$field."</strong></td>";
	print "<td><input type=\"text\" SIZE=\"133\" MAXLENGTH=\"255\" name=\"".$field."\" value=\"".htmlspecialchars($value)."\"></td>";
	
	print "</tr>";
}

function generateTextArea($field, $option, $bibtex)
{
	if (array_key_exists($field, $bibtex))
	        $value = $bibtex[$field];
	else $value = "";
	
	print "<tr>";
	print "<td ";
	if ($option) print "BGCOLOR=\"orange\">";
	else print ">";
	print "<strong>".$field."</strong></td>";
 	print "<td><TEXTAREA MAXLENGTH=\"65535\" COLS=\"100\" ROWS=\"4\" name=\"".$field."\">".$value."</textarea></td>";
	print "</tr>";
}

function generateCheckBox($field, $option, $bibtex)
{
	if (array_key_exists($field, $bibtex))
	        $value = $bibtex[$field];
	else $value = "";

        print "<tr>";
	print "<td ";
	if ($option) print "BGCOLOR=\"orange\">";
	else print ">";
	print "<strong>".$field."</strong></td>";
	print "<td><input type=\"checkbox\" name=\"".$field."\" value=\"y\"";
	if (strcmp($value, "y")==0) print " checked ";
	print "></td>";
	print "</tr>";
}

function generateTableForm($fields, $bibtex, $option)
{
	foreach($fields as $field)
	{
	        if ($option === "Edit")
		        if (strcmp($field[0], "comments")==0)
		                generateTextArea($field[0], $field[1], $bibtex);
			elseif (strcmp($field[0], "confidential")==0)
		        	generateCheckBox($field[0], $field[1], $bibtex);
			else generateInputText($field[0], $field[1], $bibtex);
		else
		        generateInputText($field[0], $field[1], $bibtex);
	}
}

function generateBibtexForm($bibtex, $localfile)
{
	global $MAN, $OPT, $bibtexTypes, $file_dir;

	print "<table>";
	print "<tr>";
	print "<td> <strong> entry type <strong> </td>";
	print "<td>";
	print "<select name=\"bibtexEntryType\" onchange=\"bibtexform.submit();\">";
	foreach ($bibtexTypes as $name)
	{
		print "<option value=\"".$name[0]."\"";
		if (array_key_exists('bibtexEntryType', $bibtex)&& ($name[0] == $bibtex['bibtexEntryType']))
		 	print " selected >".$name[0];
		else print ">".$name[0];
		print "</option>\n";
	}
	print "</select>";
	print "</td>";
	print "</tr>";

	$fields = $bibtexTypes[$bibtex['bibtexEntryType']];
	generateTableForm($fields[1], $bibtex, "Edit");
        print "<tr><td><strong>Upload</strong></td>
		  	 <td>
			 <input type=\"file\" name=\"fileupload\" value=\"".$localfile."\">";
	print "</td></tr>";
	print "</table>";
}

function generateSearchForm($bibtex)
{
	global $MAN, $OPT, $bibtexTypes, $file_dir;

	print "<p>";
	print "<select name=\"bibtexEntryType\" onchange=\"searchform.submit();\">";
	foreach ($bibtexTypes as $name)
	{
		print "<option value=\"".$name[0]."\"";
		if (array_key_exists('bibtexEntryType', $bibtex)&& ($name[0] == $bibtex['bibtexEntryType']))
		 	print " selected >".$name[0];
		else print ">".$name[0];
		print "</option>\n";
	}
	print "</select>";
	print "</p>";
	print "<table>";
	$fields = $bibtexTypes[$bibtex['bibtexEntryType']];
	generateTableForm($fields[1], $bibtex, "Search");
	print "</table>";
}

// Verify if all mandatory fields are present in citation
function isValidBibtexEntry($bibtex)
{
	$result = TRUE;
	global $MAN, $bibtexTypes;
	
	foreach ($bibtexTypes as $name)
	{
		if (array_key_exists('bibtexEntryType', $bibtex)&& ($name[0] == $bibtex['bibtexEntryType']))
		{
		        foreach($name[1] as $fields)
		        {
		                if (($fields[1] === $MAN)&&(!array_key_exists($fields[0], $bibtex)))
		                        $result = FALSE;
		        }
		}
	}
	return $result;
}

// Generate a clean bibtex citation from a missy citation
function cleanBibtex($bibtex)
{
	global $MAN, $bibtexTypes;

	$fields = $bibtexTypes[$bibtex['bibtexEntryType']][1];

	$result['bibtexEntryType'] = $bibtex['bibtexEntryType'];

	foreach ($fields as $field)
	{
	        if (array_key_exists($field[0], $bibtex))
			if (strlen($bibtex[$field[0]]) != 0)
			  $result[$field[0]] = $bibtex[$field[0]];
	}
	if (array_key_exists('user', $bibtex)) $result['user']=$bibtex['user'];
	if (array_key_exists('date', $bibtex)) $result['date']=$bibtex['date'];
	if (!array_key_exists('confidential', $bibtex)) $result['confidential']="n";
	return $result;
}

function generateFieldsList()
{
	global $bibtexFields;

	print "<select name=\"field\">";
	foreach($bibtexFields as $field)
	{
	        print "<option value=\"".$field."\" > ".$field."</option>";
	}
	print "</select>";
}

function generateCitationKey($bibtex)
{
	$creator = new PARSECREATORS();
	$key = "";
	
	if (array_key_exists('author', $bibtex))
		$authors = $bibtex['author'];
	elseif (array_key_exists('editor', $bibtex))
		$authors = $bibtex['editor'];
	else return "";
	        
	list($authorArray, $etAl) = $creator->parse($authors);

	$nbAuthors = count($authorArray);

	switch($nbAuthors)
	{
	case 0:
		if (array_key_exists('bibtexCitation', $bibtex)) $key = $bibtex['bibtexCitation'];
	        break;
	case 1:
	        $idx = count($authorArray[0])-1;
	        $author = authorForCitationKey($authorArray[0][$idx]);
	        $key = substr($author, 0, 3);
	        if (array_key_exists('year', $bibtex)) $key = $key.substr($bibtex['year'], count($bibtex['year'])-3);
	        break;
	default:
	        if ($nbAuthors>3)
	        {
	                $idx = count($authorArray[0])-1;
		        $name = authorForCitationKey($authorArray[0][$idx]);
		        $key = substr($name, 0, 1);
		        $key = $key."al.";
	        	if (array_key_exists('year', $bibtex)) $key = $key.substr($bibtex['year'], count($bibtex['year'])-3);
	        }
	        else
	        {
			foreach ($authorArray as $author)
			{
			        $idx = count($author)-1;
			        $name = authorForCitationKey($author[$idx]);
			        $key = $key.substr($name, 0, 1);
			}
			if (array_key_exists('year', $bibtex)) $key = $key.substr($bibtex['year'], count($bibtex['year'])-3);
	        }
	        break;
	}
	return $key;
}

?>
