<?php

function googleString($string)
{
	$replace = array ( " " => "+" );
	$result = strtr($string, $replace);
	return $result;
}

function authorForCitationKey($author)
{
	$transform = array (
	        "" => "a",
	        "" => "a",
	        "" => "a",
	        "" => "e",
		"" => 'e',
		"" => "e",
		"" => "e",
		"" => 'i',
		"" => "i",
		"" => "o",
		"" => 'o',
		"" => "u",
		"" => 'u',
		"" => "u",
		"" => "c",
		"" => "A",
	        "" => "A",
	        "" => "A",
	        "" => "E",
		"" => 'E',
		"" => "E",
		"" => "E",
		"" => 'I',
		"" => "I",
		"" => "O",
		"" => 'O',
		"" => "U",
		"" => 'U',
		"" => "U",
		"" => "C"
		);
	$result = latexToFrench($author);
	$result = strtr($result, $transform);
	return $result;
}

function frenchToLatex($string)
{
	$transform = array (
	        "" => "\`a",
	        "" => "\^a",
	        "" => "\~a",
	        "" => "\'e",
		"" => '\"e',
		"" => "\`e",
		"" => "\^e",
		"" => '\"\i',
		"" => "\^i",
		"" => "\^o",
		"" => '\"o',
		"" => "\`u",
		"" => '\"u',
		"" => "\^u",
		"" => "\,c",
		"" => "\`A",
	        "" => "\^A",
	        "" => "\~A",
	        "" => "\'E",
		"" => '\"E',
		"" => "\`E",
		"" => "\^E",
		"" => '\"I',
		"" => "\^I",
		"" => "\^O",
		"" => '\"O',
		"" => "\`U",
		"" => '\"U',
		"" => "\^U",
		"" => "\,C",
		"&" => "\&"
		);

	//$string = removeBracket($string);
	$result = strtr($string, $transform);

	return $result;
}

function latexToFrench($string)
{
	$transform = array (
	        "\`a" => "",
	        "\^a" => "",
	        "\~a" => "",
	        "\'e" => "",
		'\"e' => "",
		"\`e" => "",
		"\^e" => "",
		'\"\i' => "",
		"\^i" => "",
		"\^o" => "",
		'\"o' => "",
		"\`u" => "",
		'\"u' => "",
		"\^u" => "",
		"\,c" => "",
		"\`A" => "",
	        "\^A" => "",
	        "\~A" => "",
	        "\'E" => "",
		'\"E' => "",
		"\`E" => "",
		"\^E" => "",
		'\"I' => "",
		"\^I" => "",
		"\^O" => "",
		"\`U" => "",
		'\"U' => "",
		"\^U" => "",
		"\,C" => "",
		"\&" => "&"
		);

	$result = removeBracket($string);
	$result = strtr($result, $transform);
	
	return $result;
}

function removeBracket($string)
{
	$remove = array ( "{" => "", "}" => "");

	$result = strtr($string, $remove);
	return $result;
}

?>
