<?php
session_start();
if(!isset($_SESSION['user']))
{
	header("Location:session_expired.php");
	exit();
}
?>

<?php
require_once("include/parseentries.php");
require_once("include/bibtex.php");
require_once("include/database.php");

$parse = NEW PARSEENTRIES();
$parse->expandMacro = TRUE;
$parse->fieldExtract = TRUE;
$parse->removeDelimit = TRUE;
if (get_magic_quotes_gpc()==1)
	$parse->loadBibtexString(stripslashes($_POST['bibtex']));
else
        $parse->loadBibtexString($_POST['bibtex']);

$parse->extractEntries();
list($preamble, $strings, $entries) = $parse->returnArrays();
$cpt = 0;
$failed = FALSE;
if (count($entries)>0)
foreach($entries as $bibtexentry)
{
  print "<header>";
  print "<link href=\"css/style.css\" rel=\"Stylesheet\" type=\"text/css\">";
  print "</header>";
  print "<body class=\"texte\">";

  if (!dbAddBibtex($bibtexentry))
    {
      displayBadBibtex($bibtexentry, "Cannot insert in the database");
      $failed = TRUE;
    }
  $cpt++;
}

if ($failed==FALSE)
{
  print "<script language=\"javascript\">";
  print "parent.frames['ContentFrame'].location.href =\"welcome.php\";";
  print "</script>";
}
?>

