<?php
session_start();
if(!isset($_SESSION['user']))
{
	header("Location:session_expired.php");
	exit();
}
?>

<html>

<head>
<link href="css/style.css" rel="Stylesheet" type="text/css">
<title>BibTeX File Upload Results</title>

</head>

<body class="texte">

<h1>File Upload Results</h1>

<?php

include_once("include/parseentries.php");
include_once("include/ftpUpload.php");
include_once("include/bibtex.php");
include_once("include/database.php");

$ftpserver = $_POST['ftpserver'];
$ftpserverdir = $_POST['ftpserverdir'];

if ($ftpserver === "") $ftpserver = FALSE;

set_time_limit(0);


foreach($_FILES as $file_name => $file_array)
{
    if (is_uploaded_file($file_array['tmp_name']))
    {
        move_uploaded_file($file_array['tmp_name'],"$file_dir/$file_array[name]") or die ("Couldn't copy");

	$parse = NEW PARSEENTRIES();
	$parse->expandMacro = TRUE;
	//$parse->fieldExtract = TRUE;
	//$parse->removeDelimit = TRUE;
	$parse->openBib($file_dir."/".$file_array['name']);
	$parse->extractEntries();
	$parse->closeBib();
	//delete("$file_dir/$file_array[name]");
	list($preamble, $strings, $entries) = $parse->returnArrays();

	if ($ftpserver)
	{
          if (ftp_init($ftpserver, $ftpserverdir))
          {
		chdir($file_dir);
		$numberOfEntries = 0;
		$numberOfFiles = 0;
		if(count($entries)>0)
		foreach($entries as $texentry)
		{
			if ($result = try_all_files($texentry))
			{
			        $texentry['file'] = $result;
				++$numberOfFiles;
			}
			$isValid = isValidBibtexEntry($texentry);
			$error = "Error ";
			if (!$isValid) $error = $error.": Fields missing in entry ";
			$isInDb = dbAddBibtex($texentry);
			if (!$isInDb) $error = $error.": Cannot insert in the database";
			if ((!$isValid)||(!$isInDb))
			{
				displayBadBibtex($texentry, $error);
				print "<HR>";
			}
			if ($isInDb) $numberOfEntries++;
		}
		print "Number of files uploaded :".$numberOfFiles."<br>";
		print "Number of bibtex entries inserted in the database :".$numberOfEntries."<br>";
		unlink($file_array['name']);
		ftp_end();

	  }
	  else
	  {
	        echo "Unable to upload citation related files: ftp server problem <br>";
	  }
	}
	else
	{
		$numberOfEntries = 0;
		if(count($entries)>0)
		foreach($entries as $texentry)
		{
			$isValid = isValidBibtexEntry($texentry);
			$error = "Error ";
			if (!$isValid) $error = $error.": Fields missing in entry ";
			//$texentry = slashedBibtex($texentry);
			$isInDb = dbAddBibtex($texentry);
			if (!$isInDb) $error = $error.": Cannot insert in the database";
			if ((!$isValid)||(!$isInDb))
			{
				displayBadBibtex($texentry, $error);
				print "<HR>";
			}
			else $numberOfEntries++;
		}
		print "Number of bibtex entries inserted in the database :".$numberOfEntries."<br>";
		unlink($file_dir."/".$file_array['name']);
    	}
  }
}
?>

</body>

</html>
