<?php

require_once('./fc_text.php');
require_once('./parameters.php');

function highl($display_value, $patterns){
	return highlight($display_value, "", $patterns);
}

function highlight($display_value, $search_value, $patterns){
	$replace_no = 0;
	$result = $display_value;
	if (!empty($patterns)){
		global $backgr_h_col, $foregr_h_col;
		for ($i=0; $i<count($patterns);$i++){
			$j = $i - floor($i/count($backgr_h_col))*count($backgr_h_col);
			if (!empty($search_value)){
				if (is_integer($position = str_pos($search_value, $patterns[$i]))){
					if (is_integer($positio = str_pos($display_value, $patterns[$i]))){
						return substr($display_value, 0, $positio). "<font color=\"".$foregr_h_col[$j].
						"\" style=\"background-color:#".$backgr_h_col[$j]."\">".
						substr($display_value, $positio, strlen($patterns[$i]))."</font>".
						substr($display_value, $positio+strlen($patterns[$i]), strlen($display_value));
					} else {
						return "<font color=\"".$foregr_h_col[$j].
						"\" style=\"background-color:#".$backgr_h_col[$j]."\">".
						$display_value."</font>";
					}
				}
			} else {
				if (is_integer($positio = str_pos($display_value, $patterns[$i]))){
					return substr($display_value, 0, $positio). "<font color=\"".$foregr_h_col[$j].
					"\" style=\"background-color:#".$backgr_h_col[$j]."\">".
					substr($display_value, $positio, strlen($patterns[$i]))."</font>".
					substr($display_value, $positio+strlen($patterns[$i]), strlen($display_value));
				}
			}
		}
	}
	return $result;
}

function space_it($ech){
  if ($ech) return  "
<br> &nbsp; &nbsp; &nbsp; ";
  else return "
      ";
}

function displayEntry($row, $numerotata, $bibtex, $cu_link, $patterns){
  global $db_bibliography, $show_sc, $var_methods_type, $user, $publication;
	$id_pub = $row->id;
	$list_auth = get_pub_authors($id_pub, '');
	$list_edts = get_pub_authors($id_pub, '', false);
	if (!empty($bibtex)){
	        $ech = true;
		if ($bibtex == -1) {
		  $ech=false;
		  echo "\n\n";
		}
		if (is_integer($poz=strpos($row->entry_type, '('))) 
		  $enttyp = trim(substr($row->entry_type, 0, $poz));
		else 
		  $enttyp = $row->entry_type;
	       
		echo "@".$enttyp."{".$row->citation.",";
		if ($list_auth){
		        echo space_it($ech) . "AUTHOR = {";
			display_authors($list_auth, $db_bibliography, $cu_link, $bibtex, $patterns);
			echo "},";
		}
		echo space_it($ech) . "TITLE = {".
		highl($row->title, $patterns)."}";
		if (!empty($row->year)){
			echo ",".space_it($ech)."YEAR = {".
			highl($row->year, $patterns)."}";
		}
		display_months($row, $bibtex, $patterns);
		if (!empty($row->journal)){
			echo ",".space_it($ech)."JOURNAL = {".
			highl($row->journal, $patterns)."}";
		}
		if (!empty($row->booktitle)){
			echo ",".space_it($ech)."BOOKTITLE = {".
			highl($row->booktitle, $patterns)."}";
		}
		if (!empty($row->key_)){
			echo ",".space_it($ech)."KEY = {".
			highl($row->key_, $patterns)."}";
		}
		if (!empty($row->volume)){
			echo ",".space_it($ech)."VOLUME = {".
			highl($row->volume, $patterns)."}";
		}
		if (!empty($row->number_)){
			echo ",".space_it($ech)."NUMBER = {".
			highl($row->number_, $patterns)."}";
		}
		if (!empty($row->pages)){
			echo ",".space_it($ech)."PAGES = {".
			highl($row->pages, $patterns)."}";
		}

		if ($list_edts){
		  echo ",".space_it($ech)."EDITOR = {";
		  display_authors($list_edts, $db_bibliography, $cu_link, $bibtex, $patterns);
		  echo "}";
		}

		if (!empty($row->series)){
			echo ",".space_it($ech)."SERIES = {".
			highl($row->series, $patterns)."}";
		}
		if (!empty($row->address)){
			echo ",".space_it($ech)."ADDRESS = {".
			highl($row->address, $patterns)."}";
		}
		if (!empty($row->organization)){
			echo ",".space_it($ech)."ORGANIZATION = {".
			highl($row->organization, $patterns)."}";
		}
		if (!empty($row->publisher)){
			echo ",".space_it($ech)."PUBLISHER = {".
			highl($row->publisher, $patterns)."}";
		}
		if (!empty($row->school)){
			echo ",".space_it($ech)."SCHOOL = {".
			highl($row->school, $patterns)."}";
		}
		if (!empty($row->edition)){
			echo ",".space_it($ech)."EDITION = {".
			highl($row->edition, $patterns)."}";
		}
		if (!empty($row->chapter)){
			echo ",".space_it($ech)."CHAPTER = {".
			highl($row->chapter, $patterns)."}";
		}
		if (!empty($row->type)){
			echo ",".space_it($ech)."TYPE = {".
			highl($row->type, $patterns)."}";
		}
		if (!empty($row->crossref)){
			echo ",".space_it($ech)."CROSSREF = {".
			highl($row->crossref, $patterns)."}";
		}
		if (!empty($row->howpublished)){
			echo ",".space_it($ech)."HOWPUBLISHED = {".
			highl($row->howpublished, $patterns)."}";
		}
		if (!empty($row->institution)){
			echo ",".space_it($ech)."INSTITUTION = {".
			highl($row->institution, $patterns)."}";
		}
		if (!empty($row->url)){
		  if ($user or ($row->acc_url==1)) {
			echo ",".space_it($ech).
			  (($row->acc_url==0 && $bibtex!=-1)?"<i>":"")."URL = {".
			  highlight(str_replace("&", "&amp;", str_replace("&amp;", "&", $row->url)), $row->url, $patterns).(($row->acc_url==0 && $bibtex!=-1)?"</i>":"")."}";
			if ($user && $row->acc_url!=1 && $bibtex==-1)
			  echo ",".space_it($ech)."OPTacc_url = {}";
		  }
		}
		if (!empty($row->pdf)){
		  if ($user or ($row->acc_pdf==1)) {
			echo ",".space_it($ech).
			  (($row->acc_pdf==0 && $bibtex!=-1)?"<i>":"")."PDF = {".
			  highlight(str_replace("&", "&amp;",  str_replace("&amp;", "&",$row->pdf)), $row->pdf, $patterns).(($row->acc_pdf==0 && $bibtex!=-1)?"</i>":"")."}";
			if ($user && $row->acc_pdf!=1 && $bibtex==-1)
			  echo ",".space_it($ech)."OPTacc_pdf = {}";
		  }
		}
		if (!empty($row->ps)){
		  if ($user or ($row->acc_ps==1)) {
			echo ",".space_it($ech).
			  (($row->acc_ps==0 && $bibtex!=-1)?"<i>":"")."PS = {".
			  highlight(str_replace("&", "&amp;",  str_replace("&amp;", "&", $row->ps)), $row->ps, $patterns).(($row->acc_ps==0 && $bibtex!=-1)?"</i>":"")."}";
			if ($user && $row->acc_ps!=1 && $bibtex==-1)
			  echo ",".space_it($ech)."OPTacc_ps = {}";
		  }
		}
		if (!empty($row->slides)){
		  if ($user or ($row->acc_slides==1)) {
			echo ",".space_it($ech).
			  (($row->acc_slides==0 && $bibtex!=-1)?"<i>":"")."SLIDES = {".
			  highlight(str_replace("&", "&amp;",  str_replace("&amp;", "&", $row->slides)), $row->slides, $patterns).(($row->acc_slides==0 && $bibtex!=-1)?"</i>":"")."}";
			if ($user && $row->acc_slides!=1 && $bibtex==-1)
			  echo ",".space_it($ech)."OPTacc_slides = {}";
		  }
		}
		if (!empty($row->abstract)){
			echo ",".space_it($ech)."ABSTRACT = {".
			highl($row->abstract, $patterns)."}";
		}
		if (!empty($row->note)){
			echo ",".space_it($ech)."NOTE = {".
			highl($row->note, $patterns)."}";
		}
		if (!empty($row->annote)){
			echo ",".space_it($ech)."ANNOTE = {".
			highl($row->annote, $patterns)."}";
		}
		display_keywords($db_bibliography, $id_pub, $cu_link, $bibtex, $patterns);
		echo ($ech?"<br>}":"\n}");


		//else if is a HTML entry
	} else {
	        if ($list_auth){
		  display_authors($list_auth, $db_bibliography, $cu_link, $bibtex, $patterns);
		}
		else {
		  if ($row->entry_type == 'Proceedings') {
		    if ($list_edts) {
		      display_authors($list_edts, $db_bibliography, $cu_link, $bibtex, $patterns, false);
		      echo ' editor'.(count($list_edts)>1?'s':'').'. ';
		    } 
		  }
		  else if ($row->entry_type == 'Book') {
		    if ($list_edts) {
		      display_authors($list_edts, $db_bibliography, $cu_link, $bibtex, $patterns, false);
		      echo ' editor'.(count($list_edts)>1?'s':'').'. ';
		    } 
		  }
		  else if ($row->entry_type == 'Manual') echo highl($row->organization,$patterns).'. ';
		}

		echo "<b>".highl($row->title, $patterns) . "</b>";
		$tlc = $row->title{strlen($row->title)-1};
		if (!in_array($tlc, array('.','?','!','','',')',']'))) echo '. ';
		$sep=true;

		$in = 0;
		if (!(!$list_auth && ($row->entry_type == 'Proceedings' || $row->entry_type == 'Book'))) {
		  if ($list_edts) {
		    echo ' In ';
		    if ($list_edts) {
		      display_authors($list_edts, $db_bibliography, $cu_link, $bibtex, $patterns, false);
		      echo ' editor'.(count($list_edts)>1?'s':'').', ';
		    }
		    $in = 1;
		  }
		}

		if (!empty($row->booktitle)) {
		  echo (($in == 1 ? ($sep?' ':", "):" In ")."<i>").highl($row->booktitle,$patterns)."</i>";
		  $in = 1;
		  $sep = false;
		}

		if ($row->entry_type == "PhdThesis"){
		  echo " ".highlight("PhD thesis", $row->entry_type, $patterns);
		  $sep=false;
		}
		else if ($row->entry_type == "MastersThesis"){
		  echo " ".highlight("Master's thesis", $row->entry_type, $patterns);
		  $sep=false;
		}
		else if ($row->entry_type == "TechReport"){
		  echo " ".highlight("Technical report", $row->entry_type,$patterns);
		  $sep=false;
		}

		if (!empty($row->journal)) {
		  echo ($in == 1 ? ($sep?' ':", "):" In ")." <i>".highl($row->journal, $patterns)."</i>";
		  $sep=false;
		}
		if (!empty($row->howpublished)){
		  echo ($sep?' ':", ").highl($row->howpublished, $patterns);
		  $sep=false;
		}

		//todo afisare ca pasta ... pt volum non-nul si pagini non-nule ..
		//acum afisaza ramane de testat
		// bibtex entry nu  afisaza k Lumea
		if ($row->entry_type != "TechReport"){
			if (!empty($row->volume)){
				echo ($sep?' ':", ")."Vol. ";
				if (!empty($row->number_)){
					echo highl($row->volume, $patterns)."(".highl($row->number_,$patterns).")";
					if (!empty($row->pages))
					echo ":".highl($row->pages,$patterns);
				} else if (!empty($row->pages))
				echo " ".$row->volume.":".highl($row->pages,$patterns);
				else echo highl($row->volume, $patterns);
				if (!empty($row->series))
				echo " of <i>".highl($row->series, $patterns)."</i>";
				$sep = false;
			} else if (!empty($row->number_)){
			        if (!empty($row->pages))
				  echo ($sep?' ':", ")."(".highl($row->number_,$patterns)."):".
				    highl($row->pages,$patterns);
				else 
				  echo ($sep?' ':", ")."Nr. (".highl($row->number_,$patterns).")";
				$sep = false;
			} else if (!empty($row->pages)) {
			  echo ($sep?' ':", ")."Pages ".highl($row->pages,$patterns);
			  $sep = false;
			}

			if (!empty($row->type)){
			  echo ($sep?' ':", ").highl($row->type,$patterns);
			  $sep=false;
			}
		} else {
		        if (!empty($row->type)) {
			  if (!empty($row->number_)){
				echo ($sep?' ':", ").highl($row->type,$patterns)." ".highl($row->number_,$patterns);
			  } else echo ($sep?' ':", ").highl($row->type,$patterns);
			  $sep=false;
			} else if (!empty($row->number_)) {
			  echo ($sep?' ':", ").highl($row->number_,$patterns);
			  $sep=false;
			}
		}
		if (!empty($row->chapter)){
		  echo ($sep?' ':", ")."Chapter ".highl($row->chapter,$patterns);
		  $sep=false;
		}
		if(!empty($row->institution)){
		  echo ($sep?' ':", ").'<i>'.highl($row->institution,$patterns).'</i>';
		  $sep=false;
		}
		if (!empty($row->school)){
		  echo ($sep?' ':", ").'<i>'.highl($row->school,$patterns).'</i>';
		  $sep=false;
		}
		if (($list_auth || $row->entry_type != 'Manual') && !empty($row->organization)) {
		  echo ($sep?' ':", ").'<i>'.highl($row->organization,$patterns).'</i>';
		  $sep=false;
		}
		if (!empty($row->publisher)){
		  echo ($sep?' ':", ").highl($row->publisher,$patterns);
		  $sep=false;
		}
		if (!empty($row->address)){
		  echo ($sep?' ':", ").highl($row->address,$patterns);
		  $sep=false;
		}

		if (!empty($row->edition)){
		  echo ($sep?' ':", ").'<i>'.highl($row->edition,$patterns) ." edition</i>";
		  $sep = false;
		}

		echo ($sep?' ':", ");
		display_months($row, $bibtex, $patterns);

		echo " ".($cu_link?"<a href=\"$show_sc?year=".$row->year."\" title='".$publication.'s '.(empty($row->year)?"with no year defined":"of year ".$row->year)."'>":'').highl($row->year,$patterns).($cu_link?"</a>":'').".";
		if (!empty($row->url) and ($user or ($row->acc_url==1))) 
		  echo " <a href=\"".str_replace("&", "&amp;",  str_replace("&amp;", "&", $row->url))."\" title=\"URL\" target=\"_blank\"><img src=\"images/url.gif\" alt=\"URL\" height=\"18\" width=\"17\" border=\"0\" align=\"middle\"></a>";
		if (!empty($row->pdf) and ($user or ($row->acc_pdf==1)))
		  echo " <a href=\"".str_replace("&", "&amp;",  str_replace("&amp;", "&", $row->pdf))."\" title=\"PDF\" target=\"_blank\"><img src=\"images/pdf.gif\" alt=\"PDF\" height=\"18\" width=\"17\" border=\"0\" align=\"middle\"></a>";
		if (!empty($row->ps) and ($user or ($row->acc_ps==1)))
		  echo " <a href=\"".str_replace("&", "&amp;",  str_replace("&amp;", "&", $row->ps))."\" title=\"PS\" target=\"_blank\"><img src=\"images/ps.gif\" alt=\"PS\" height=\"18\" width=\"17\" border=\"0\" align=\"middle\"></a>";
		if (!empty($row->slides) and ($user or ($row->acc_slides==1)))
		  echo " <a href=\"".str_replace("&", "&amp;", str_replace("&amp;", "&", $row->slides))."\" title=\"PPT\" target=\"_blank\"><img src=\"images/ppt.gif\" alt=\"PPT\" height=\"18\" width=\"17\" border=\"0\" align=\"middle\"></a>";
		if (!empty($row->abstract))
		  echo " [<a href=\"$show_sc?id=" .
		    $row->id . "&amp;type=bib\">".highlight("Abstract",$row->abstract,$patterns)."</a>]";

		require_once('./fc_comments.php');
		$ress = mysql_db_query($db_bibliography, get_com_query($row->id, ''));
		if (!$bibtex) {
		  if ($cu_link) echo " [<a href=\"$show_sc?id=" . $row->id . "\">";
		  if (!empty($ress) and mysql_num_rows($ress)>0){
		    if (!$cu_link) echo ' ';
		    echo '<b>'.highlight(mysql_num_rows($ress).' comment'.(mysql_num_rows($ress)>1?'s':''), '', $patterns).'</b>';
		  } else {
		    if($cu_link) echo "Comment";
		  }
		  if ($cu_link) echo "</a>]";
		}
		
		$type = getParam("type", $var_methods_type[0]);
		if ($type != "both" && $cu_link) {
		  echo " &nbsp; <a href=\"$show_sc?id=" .
		    $row->id . "&amp;type=bib\" title=\"Bibtex entry\" onMouseOver=\"imgOver('bib_img_".$row->id."');return true;\" onMouseOut=\"imgOut('bib_img_".$row->id."');return true;\">".
		    "<img src=\"images/bibtex.gif\" alt=\"Bibtex entry\" height=\"19\" width=\"58\" border=\"0\" align=\"middle\" name=\"bib_img_".$row->id."\">".
		    //(highlight("bib-entry", $row->citation, $patterns)).
		    "</a>";
		}
		$dsp_kw = display_keywords($db_bibliography, $id_pub, $cu_link, $bibtex, $patterns);

		if (!empty($row->note)) {
		  if (!$dsp_kw) {
		    echo "<br>";
		    $dsp_kw = true;
		  }
		  echo "<font face=\"Times New Roman\" size=\"3\"><b>Note:</b> ".highl($row->note,$patterns).".</font>";
		}
		
		if (!empty($row->annote)) 
		  echo ' '.($cu_link?" [<a href=\"".  $show_sc . "?id=" .$row->id .
			"&amp;type=bib\">":', ').highlight("Annote", $row->annote, $patterns).($cu_link?"</a>]":'');
	}
}

function tabela_pub($res, $cu_link, $numerotata, $ed, $del, $nobasket, $patterns, $bibtex, $start_elem){
  global $db_bibliography, $user, $userid, $show_sc, $edit_sc, $delete_sc, $basket_sc, $bibs_sc, $talp, $var_methods_type, $btb, $etb, $account_sc, $pub_over_col, $current_script, $tb_comments, $user_admin, $delete_pubs, $publicationl, $tb_users, $mail_subj_prefix;
  $fc_del = ($current_script == $delete_sc);
  $script = $current_script;
  $type = getParam("type", $var_methods_type[0]);
  $ech = true;

  if ($start_elem == -1) $ech = false;
	$nr = $start_elem + 1;
	if (!empty($res)){
	  if($ech) echo "\n<table width=\"100%\" cellpadding=\"".(!$user?"0":"1")."\" cellspacing=\"".(!$user?"0":"5")."\" border=\"0\">\n <tr>\n  <td>";
		if ($fc_del or $script==$basket_sc or $script==$bibs_sc) {
			$displayed = 0;
		}
		if($ech) echo "\n   <table cellpadding=\"".(!$user?"0":"1")."\" cellspacing=\"".(!$user?"0":"1")."\"  bgcolor=\"".(empty($numerotata)?$talp:"")."\" border=\"".(empty($numerotata)?"1":"0")."\" width=\"100%\">";
		if ($fc_del) {
			global $delete_ids;
			if (!empty($delete_ids)) {
				if($ech) echo "
 <input type='hidden' name='delete_ids' value='$delete_ids'>";
			}
		}
		while ($row = mysql_fetch_object($res)){
		        $id = getParam('id', $var_methods_type[0]);
			if($ech) 
			  echo "\n    <tr>\n     <td".(empty($numerotata)?"":" valign=\"top\"")." align=\"center\" width=\"20px\"> ".
			    (empty($numerotata)?"":"<table width=\"100%\" cellpadding=\"0\" cellspacing=\"10\" border=\"0\"><tr><td align=\"right\">").
			"<a href=\"$show_sc?id=".$row->id."\" title=\"Show $publicationl #".$row->id."\" class=\"subl\">".$nr++."</a>".
			    (empty($nobasket)?" <a onclick=\"popUp('$basket_sc?fc=add&amp;record_id=".$row->id."','Adding to selection', '', '')".
			     "\" title=\"Add $publicationl to my selection\" href=\"javascript:popUp('$basket_sc?fc=add&amp;record_id=".$row->id."','Adding to selection', '', '')\"><img src=\"images/bskt.gif\" alt=\"Add to my selection\" height=\"16\" width=\"19\" border=\"0\" style='padding-top:5px'></a>":
			     (($script==$basket_sc or ($user and $script==$bibs_sc))?"\n     <input type='checkbox' class='nb' name='delete_pub_".($displayed+++1)."' value='".$row->id."'".(getParam('delete_pubs', $var_methods_type[1])!='r'?(getParam('delete_pub_'.($displayed),$var_methods_type[1])?" checked":""):"").">":"")).
			    (empty($numerotata)?"":"</td></tr></table>").
			    " </td>";
			if (!empty($ed) || !empty($del)) 
			  if($ech) echo "
     <td align=\"center\" width=\"12px\">";
			
			if (!empty($ed)) {
			  if($ech) echo "<a href=\"$edit_sc?record_id=".$row->id.
			    "\" onMouseOver=\"self.status='Edit $publicationl #".
			    $row->id.
			    "'; return true;\" title=\"Edit $publicationl #".$row->id."\"><img src=\"images/ed.gif\" alt=\"Edit $publicationl #".$row->id."\" height=\"12\" width=\"12\" align=\"left\" border=\"0\"".(!empty($del)?" style='padding-bottom: 6px; padding-left:2px; padding-right:2px;'":'')."></a>";
			}
			if (!empty($del)) {
			  $authors = get_pub_authors($row->id, "y");
			  $dele = "deletee('$delete_sc?record_id=".
			    $row->id."', '".$row->id."', '".str_replace("'", "\'",$row->title).
			    "', '" . ($authors ? implode(", " , $authors) : "NO AUTHOR").
			    "')";
			  if($ech) {
			    if (!empty($ed)) 
			      echo "<br>";
			    echo "<a onclick=\"$dele; return false;\" href=\"#\"
	onMouseOver=\"self.status='Delete $publicationl #" . $row->id .
				"'; return true;\" title=\"Delete $publicationl #".$row->id."\"><img src=\"images/del.gif\" alt=\"Delete $publicationl #".$row->id."\" height=\"16\" width=\"13\" align=\"left\" border=\"0\" style='padding-left:2px;'></a>";			    
			  }
			  if ($fc_del){
			    if($ech) 
			      echo "</td>
    <td align=\"center\">
     <input type='checkbox' class='nb' name='delete_pub_".(terms_posted() ? ($start_elem+$displayed+1) :($displayed+1))."' value='".$row->id."'>";
			    $displayed++;
			  }
			}
			if (!empty($ed) || !empty($del)) 
			  if ($ech) echo "</td>";

			if($ech) 
			  echo "
    <td".(empty($numerotata)?"":" valign=\"top\"").(empty($id)?" onMouseOver=\"javascript:chCol(this, '$pub_over_col');\" onMouseOut=\"javascript:chCol(this, '');\" onClick=\"javascript:goPub('".(($script==$delete_sc && empty($delete_pubs))?str_replace("'","\'","$dele"):($script==$edit_sc?"$edit_sc?record_id=".$row->id:"$show_sc?id=".$row->id))."', event, '".(($script==$delete_sc && empty($delete_pubs))?'y':'')."');\"":'')."><table width=\"100%\" cellpadding=\"0\" cellspacing=\"10\" border=\"0\"><tr><td".
			    (empty($numerotata)?"":" valign=\"top\"").">".(!empty($type) ? "<A NAME=\"".$row->id."\"></A>": "");
			if (!$ech) $bibtex = $start_elem;
			displayEntry($row, $numerotata, $bibtex, $cu_link, $patterns);
			if ($type == "both" and $ech) {
			  echo "<br><div style='padding-top:7px'>";
			  displayEntry($row, $numerotata, "y", $cu_link, $patterns);
			  echo "</div>";
			}
			if (($script==$account_sc and getParam('my', $var_methods_type[0])=='com') or (isset($id) and $id and $script==$show_sc and $type!='bib' and $type!='both')) {
			  $save=getParam('save', $var_methods_type[1]);
			  $comm=getParam('comm', $var_methods_type[1]);
			  $access=getParam('access', $var_methods_type[1]);
			  $name=getParam('name', $var_methods_type[1]);
			  $email=getParam('email', $var_methods_type[1]);
			  if (!empty($save)){
			    if (!empty($comm) and $user) {
			      mysql_db_query($db_bibliography, "INSERT INTO $tb_comments (id, comment, id_pub, id_user_c, date_c, ".(empty($userid)?"computer_c, ":'')."id_user_lm, date_lm, ".(empty($userid)?"computer_lm, ":'')."access) VALUES ('', '$comm', '".$row->id."', '$userid', NOW(), ".(empty($userid)?"'".getHostByAddr(GetEnv("REMOTE_ADDR"))."', ":'')."'$userid', NOW(), ".(empty($userid)?"'".getHostByAddr(GetEnv("REMOTE_ADDR"))."', ":'')."'$access');");
			    } else  if (!$user && !empty($comm) && !empty($name) && !empty($email)) {
			      global $admin_mail, $send_to_cc;
			      require_once('./fc_mail.php');
			      get_mail_4_pub($row->id, $to, $cc);
			      $email = $name . " <".$email.">";
			      $headers = get_mail_headers($email, 'y', $cc, 'y', $admin_mail, 'plain');
			      $ip=GetEnv("REMOTE_ADDR");
			      $comp_name=getHostByAddr($ip);
			      $comm = "COMMENT FROM: $email\nREMOTE_ADDR:  $comp_name / $ip\nON URL:       ".getRequestedUrl()."\n\n\nCOMMENT:\n\n".$comm;
			      mail($to, $mail_subj_prefix.'[FEEDBACK] #'.$row->id." - Web comment from ".$name, "\n".$comm, $headers);
			      echo "<b><br><br> &nbsp; &nbsp; &nbsp; Your comment has been sent! Thank you for your feedback.</b><br>";
			      $email='';$name='';
			      $comm='';
			    } else {
			      echo "<b><br><br> &nbsp; &nbsp; &nbsp; Please fill all the fields!</b>";
			    }
			  }

			  require_once('./fc_comments.php');
			  $ress = mysql_db_query($db_bibliography, get_com_query($row->id, ''));
			  if (!empty($ress) and mysql_num_rows($ress)>0){
			    echo "<font face=\"arial\" size=\"0\"><br></font>".$btb;
			    echo "<tr><td width=\"80px\" valign=\"top\" style='padding-top: 10px'><i>Comments: </i></td>\n";
			    $nr=1;

			    while ($roww = mysql_fetch_object($ress, MYSQL_ASSOC)) {
			      echo ($nr==1?'':'<tr><td></td>')."<td align=\"left\" width=\"25px\" valign=\"top\"".($nr==1?" style='padding-top: 10px'":'').">".$nr++.". </td><td align=\"left\" valign=\"top\"".($nr==2?" style='padding-top: 10px'":'')."> ".$roww->comment.($user?" &nbsp; &nbsp; (<i>".get_user_name($roww->id_user_c).
($roww->id_user_c != $roww->id_user_lm ? '/'.get_user_name($roww->id_user_lm):"").
																																	      "</i>, ".($roww->access=='ME'?"<a href='$account_sc?my=com' title='My comments'>".$roww->access."</a>":$roww->access).")".(($roww->access=='ALL' || $user_admin || $roww->id_user_c == $userid)?" &nbsp; <a href=\"$account_sc?ed_id=".$roww->id."\" title=\"Edit comment #".$roww->id."\">edit</a> &nbsp; <a href=\"javascript:deletee('$account_sc?del_id=".$roww->id."', '".$roww->id."', '". str_replace(chr(13).chr(10), " ", $roww->comment)."', '".get_user_name($roww->id_user_c)."', 'com'); return false;\" onclick=\"deletee('$account_sc?del_id=".$roww->id."', '".$roww->id."', '". str_replace(chr(13).chr(10), " ", $roww->comment)."', '".get_user_name($roww->id_user_c)."', 'com'); return false;\" title=\"Delete comment #".$roww->id."\">del</a>":''):'')."</td></tr>";
			    }		      
			    echo $etb ;
			    if (!empty($save) and !empty($comm)) {
			      if ($user) {
				echo "<br> &nbsp; &nbsp; &nbsp; Comment saved!";
				$comm='';
				$access='';
			      }
			    }
			  }
			  if ($script!=$account_sc) {
			    echo "\n".$btb;
			    get_com_form("$show_sc?id=".$row->id, $comm, $access, $userid, 'save', ($user?'Add ':'Send').' comment', $name, $email);
			    echo $etb;
			  }
			  if (!empty($ress)) mysql_free_result($ress);
			}

			if($ech) echo "
    </td></tr></table></td></tr>";
		}
		if (mysql_num_rows($res) === 0 && $ech)
		  echo "\n    <tr>\n     <td>\n      &nbsp;\n     </td>\n    </tr>";
		if($ech) {
		  echo "\n   </table>\n  </td>\n </tr>\n</table>";
		}
	}
	else if($ech) echo "Query empty";
}


function display_authors($list_auth, $db_bibliography, $cu_link, $bibtex, $patterns, $as_auth=true){
  global $show_sc, $status_list, $tb_authors, $pubs_type_biblio, $publication;
	for ($i=0; $i<count($list_auth); $i++){
		$ress = mysql_db_query($db_bibliography, "SELECT * FROM $tb_authors WHERE id='" .
				       $list_auth[$i] . "';");
		if (!empty($ress) && mysql_num_rows($ress)>0) {
		  $auth = mysql_fetch_object($ress);
		  $ident = $auth->ident;
		  $displ_n = (empty($bibtex)?(!empty($auth->surname)?$auth->surname." ":'').$auth->name
			      :$auth->name.(!empty($auth->surname)?", ".$auth->surname:''));
		  if (empty($bibtex) && (!$pubs_type_biblio||(!empty($cu_link) && ($auth->indexed != $status_list[2])))){
		    echo "
   <A HREF=\"$show_sc?author=" . $ident . "\" title='".$publication.'s of '. $displ_n ."' class=\"subl\">".
		      highlight($displ_n,
				//str_replace(".", ". ", $ident),
				$displ_n, $patterns).
		      "</A>";
		  } else {
		    echo highlight($displ_n, $displ_n, $patterns);
		  }
		  if ($i == count($list_auth) - 1)
		    echo (($as_auth && empty($bibtex)) ? ". ":"");
		  else
		    echo (empty($bibtex) ? (($i < count($list_auth) - 2)?", ":''):" and ");
		  if ($i == count($list_auth) - 2) echo (empty($bibtex) ? " and ":"");
		  mysql_free_result($ress);
		}
	}
}

function display_months($row, $bibtex, $patterns){
  $ech=true;
  if($bibtex==-1) 
    $ech=false;
  echo (empty($bibtex)?"":(empty($row->month1)?"":",".space_it($ech).
			     "MONTH = {")).highl($row->day1,$patterns);
  if (!empty($row->month2) and !empty($row->day2)){
    if ($row->month1 == $row->month2)
      echo "-" .highl($row->day2,$patterns) . " " . highl($row->month1,$patterns);
    else echo ' ' . highl($row->month1, $patterns).
      " - "  .highl($row->day2,$patterns) . " " . highl($row->month2,$patterns);
  } else echo (empty($row->day1)?'':" ") . highl($row->month1,$patterns);
  echo (empty($bibtex)?" ":(empty($row->month1)?"":"}"));
}

function display_keywords($db, $id, $cu_link, $bib, $patt){
  global $show_sc, $tb_keywords, $tb_pub_to_keyw, $publication, $publicationl;
  $ech=true;
  if($bib==-1) $ech=false;
  $present=false;
  if ($result=mysql_db_query($db,
			     "SELECT $tb_keywords.*, $tb_pub_to_keyw.level 
        FROM $tb_keywords, $tb_pub_to_keyw WHERE
	$tb_pub_to_keyw.id_pub='".$id."' and $tb_keywords.id=$tb_pub_to_keyw.id_keyw 
      	ORDER BY $tb_pub_to_keyw.level;")) {
    if (mysql_num_rows($result) > 0){
      echo (empty($bib)?"<br><font face=\"Times New Roman\" size=\"3\"><b>Keywords</b>: ":
	    ",".space_it($ech)."KEYWORDS = {");
      $present=true;
    }
    $i=0;
    while ($row2 = mysql_fetch_object($result, MYSQL_ASSOC)){
      echo ($i===0 ? "":", ").
	((empty($bib)&&$cu_link)?"<a href=\"$show_sc?keyword=".
	 $row2->name."\" title=\"".$publication."s related to '".$row2->name."'\">":"").highl($row2->name,$patt).((empty($bib)&&$cu_link)?"</a>":"");
      $i = 1;
    }
    if (mysql_num_rows($result) > 0)
      echo (empty($bib)?".</font> &nbsp;  ":"}");
    mysql_free_result ($result);
    return $present;
  }
  else{
    erroare ("No links from $publicationl #$pub_id to keywords. Malformed request", "");
    mysql_free_result ($result);
  }
}
?>