<?php
error_reporting(E_ERROR | E_WARNING | E_PARSE);

/*  Set this variable to true if the publications are the team publications or
    Set this variable to false if the publications are litterature references*/
$pubs_type_biblio       = true;

/*  Set it to true if admins should approve every modif on the DB 
     (add/edit/delete) */
$modifs_approve         = false;

/*  Set it to true if admins should be notified by email of changes
     (add/edit/delete) */
$modifs_notify_admins   = true;

/*  Set it to true if you want to save a copy of the original when
     a publication is modified. */
$modifs_save_copy       = true;

/*  The team name, URL and logo. See below for logo position */
$team_name              = '';
$team_url               = '';
$team_logo              = '';

/*  Displays the team logo on each page header or footer if set to true (see
     next variable for the position)*/
$team_logo_display      = false;

/*  Team logo will be placed in header (if $team_logo_display is true)
     and Bibadmin logo in footer (right side), if set to true;
    Bibadmin logo will be placed in the header and the team logo (if
     $team_logo_display is true) in the footer (right side), if set to false*/
$team_logo_t            = true;

/*  Sets the align to left(true) or right(false) for the top logo (team or
     BibAdmin). If $team_logo_t = true and $team_logo_display = false there 
     will be no logo on the headers, only the BibAdmin in footer (right).*/
$top_logo_l             = true;

/*  Set the favourite icon */
$shortcut_icon          = 'images/favicon.ico';

/*  Webmaster mail and displayed name (no email is visible to visitors nor
     to users) */
$webm_mail              = '';
$webm_name              = '';

/*  Prefix for email's subject (used for folders filters) */
$mail_subj_prefix       = '['.($pubs_type_biblio?'BIB':'REF').(!empty($team_name)?$team_name:'').']';

/*  This should be set to true if the publications are references, as it will
     block all visitors (login will be required even to browse/search on the
     pages).
    When set to false visitors can browse and search publications/references.
    Recommended: false for team publications, true for literature references.*/
$login_required         = false;

/*  MySQL DB Parameters. Make sure the user has Create Tables privileges.*/
$hostname               = 'localhost';
$port                   = '3306';
$host                   = $hostname.':'.$port;
$login_user_db          = 'root'; 
$login_pass_db          = '';
$db_bibliography        = 'bibliography';

/*  Tables prefix. For example 'bib_'. */
$tables_prefix          = 'bib_'; 

/*  The PDF, PS, SLIDES upload directory. Move the uploads folder to the new
     name if you change it. */
$uploaddir              = 'uploads/'; 

/*  Unix permision to be set on the uploaded files (pdfs, ps, slides) */
$default_upload_perm    = 0664;

/*  Maximum size for the uploaded files */
$max_size_uploaded_file = 3000000;

/*  Colors */
$body_color             = '#FFFFFF'; //Body bgcolor (leave '') for no color
$hd_ft_col              = '#4E9258'; //The header and footer color
//$hd_ft_col            = '#3169c8';
$title_bg               = '#ababab'; //The titles bgcolor
//$title_bg             = '#669999';
$subt_col               = '#E0E0E0'; //Subtitle bgcolor color
//$subt_col             = '#ededed';
$talp                   = '#ededed'; //Sections bgcolor
//$talp                 = '#badfe1';
$warn_col               = '#db7455'; //Warning color
$pub_over_col           = '#edede0'; //Color when mouseover-ing publications

/*  Alternate fields colors */
$pub_col1               = '#fcfcfc'; //'D5D5D5';
$pub_col2               = '#E5E5E5';

/*  The used CSS style */
$sty                    = 'style.css';

/*  If set to true, new accounts must be approved by admins */
$users_approve_creation = true;

/* If set to true, users account creation will be possible only from the
    IPs in $tb_comp */
$users_creation_from_ips_only = false;

/* Users maximum conexion time (in seconds). Autologout when expired */
$max_con_time           = 3601;
$max_dif_time           = 601;
$max_chall_time         = 181;

/*  Maximum username lenght */
$max_len_usern          = 50;

/*  Default user password (for the first install) */
$default_user_pass      = 'admin';

/*  Main page header (in <tr></tr>) 
    Example : $index_page_head = "<tr><td bgcolor = '$subt_col' align = 'left' style = 'padding: 5px'><b>&nbsp;&nbsp;My text here</b></td></tr>";
*/
$index_page_head        = '';

/*  Put the main page header on index even if DB is of type references */
$index_page_head_on_refs = false;

/*  Set to true if you want also the publication's authors to receive
    visitors comments (admins or webm receive by default) */
$send_to_cc             = true;

/*  Unique admin email address. If set, all notification mails will be send 
     only to this address. If not set, all mails will be sent to all admins
     accounts. (Use $modifs_notify_admins above to disable notifications)*/
$admin_mail             = false;


/*  Other settings (play with then if you like) */

$default_dnwl_file_name = ($pubs_type_biblio?'bibliography.bib':'references.bib');

$tb_publications        = $tables_prefix.'publications';
$tb_authors             = $tables_prefix.'authors';
$tb_pub_to_auth         = $tables_prefix.'pub_to_auth';
$tb_keywords            = $tables_prefix.'keywords';
$tb_pub_to_keyw         = $tables_prefix.'pub_to_keyw';
$tb_comments            = $tables_prefix.'comments';
$tb_bibs                = $tables_prefix.'bibs';
$tb_bib_to_pub          = $tables_prefix.'bib_to_pub';
$tb_comp                = $tables_prefix.'computer';
$tb_users               = $tables_prefix.'user';
$tb_logins              = $tables_prefix.'logins';
$tb_bad_log             = $tables_prefix.'bad_logins';

$tb_tmp_pubs            = $tables_prefix.'tmp_pubs';
$tb_tmp_auths           = $tables_prefix.'tmp_auths';
$tb_tmp_kywds           = $tables_prefix.'tmp_kywds';
$tb_tmp_auths           = $tables_prefix.'tmp_auths';
$tb_tmp_kywds           = $tables_prefix.'tmp_kywds';
$tb_tmp_p_2_a           = $tables_prefix.'tmp_p_to_a';
$tb_tmp_p_2_k           = $tables_prefix.'tmp_p_to_k';

$publication            = ($pubs_type_biblio?'Publication':'Reference');
$publicationl           = ($pubs_type_biblio?'publication':'reference');

/*  Main page title */
$main_page_title        = $team_name.' '.$publication.'s';

/*  Search highlight colors */
$backgr_h_col           = array('FF0000', 'FFFF00', '0000FF', '00aa00', 'FFFFFF');
$foregr_h_col           = array('FFFFFF', '000000', 'FFFFFF', 'FFFFFF', '000000');

$col_req                = '#FF0000';
$col_opt                = '#FFFF00';
$col_oth                = '#0000FF';

$max_initial_search     = 30;
$max_results_search     = 50;

/*  Scripts names  */
$main_script            = 'index.php'; 
$load_sc                = 'load.php';
$create_sc              = 'create_db.php';
$logout_sc              = 'logout.php';
$login_sc               = 'login.php';
$show_sc                = 'show.php';
$search_sc              = 'browse.php';
$edit_sc                = 'edit.php';
$delete_sc              = 'delete.php';
$add_sc                 = 'add.php';
$basket_sc              = 'basket.php';
$account_sc             = 'account.php';
$bibs_sc                = 'bibs.php';
$feed_sc                = 'feedback.php';

$months_list            = array('January', 'February', 'March', 'April', 'May', 'June', 
				'July', 'August', 'September', 'October', 'November', 'December');
$months_list_fr         = array('Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Julliet',
				'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre');
$months_list_fr_acc     = array('Janvier', 'Fvrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 
				'Aot', 'Septembre', 'Octobre', 'Novembre', 'Dcembre');
$days_list              = array('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16',
				'17','18','19','20','21','22','23','24','25','26','27','28','29','30','31');

$entries_list           = array('Article (Journal)', 'InProceedings', 'InCollection', 'InBook', 'MastersThesis', 
				'PhdThesis', 'TechReport', 'Misc', 'Manual', 'Unpublished', 'Book', 'Proceedings', 
				'Booklet');
//$entries_list         = array('Book', 'Proceedings', 'PhdThesis', 'InBook', 'InCollection', 'Article', 'InProceedings',
//                              'Booklet', 'MastersThesis', 'TechReport', 'Manual', 'Unpublished', 'Misc');

$status_list            = array('Actual '.$team_name.' member', 'Past '.$team_name.' member', 'Not an '.$team_name.' member');

$var_methods_type       = array('GET', 'POST', 'COOKIE');

$chkClr                 = '
&nbsp; &nbsp; &nbsp; <font face="arial" size="0"><a onClick="checkAll(true); return false;" href="javascript:checkAll(true)">Check all</a> &nbsp; | &nbsp; <a onClick="checkAll(false); return false;" href="javascript:checkAll(false)">Clear all</a> &nbsp; | </font>';

$top_btn                = '</font></td><td align="right" width="16px"><font><a href="#TOP"><img src="images/top.gif" alt="TOP" height="17" width="17" border="0" align="bottom"></a>';
$dwn_btn                = '<img src="images/dwn.gif" alt="Download bibtex file" height="18" width="17" border="0" align="bottom">';
$srt_dsc                = '<img src="images/srt_dsc.gif" alt="Sorted descending" height="5" width="9" border="0">';
$srt_asc                = '<img src="images/srt_asc.gif" alt="Sorted ascending" height="5" width="9" border="0">';

$btb                    = '
<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">';
$etb                    = '
</table>';

$search_terms = (isset($_GET['q'])?trim(str_replace('+', ' ', getParam('q', $var_methods_type[0]))):false);
if ($search_terms && !empty($search_terms)) {
  $search_terms = str_replace("\'", ' ', $search_terms);
  $search_terms = trim($search_terms);
  $search_terms = str_replace("\\", '', $search_terms);
  $search_leastthree = (isset($_GET['l3'])?getParam('l3', $var_methods_type[0]):false);
  $search_leastthree = ((strtolower($search_leastthree) != 'y')?false:$search_leastthree);
  $search_in = (isset($_GET['s_in'])?getParam('s_in', $var_methods_type[0]):false);
 } else {
  $search_terms = false;
 }

$current_script = getScriptName($_SERVER['REQUEST_URI']);

$months_delimiters      = array('-', '/', 'and', 'et', 'au');
$months_prefixes        = array('from', 'starting', 'in', 'du', 'a partir du', ' partir du', 'en');

$link = mysql_connect($host, $login_user_db, $login_pass_db);
$c = getParam('c', $var_methods_type[2]);
if (empty($c)){
  $user = false;
 } else {
  $user = getParam('user', $var_methods_type[2]);
  if ($user !== false) {
    if (empty($user)){
      $user = false;
    } else {
      $userid = getParam('userid', $var_methods_type[2]);
      $user_admin = (getParam('admin', $var_methods_type[2])=='y');
    }
  }
  $res = mysql_db_query($db_bibliography, 'SELECT * FROM '.$tb_logins.' WHERE challenge=\''.$c.'\';');
  if (!empty($res) && mysql_num_rows($res) == 1){
    $row = mysql_fetch_object($res, MYSQL_ASSOC);
    require_once('./fc_login.php');
    if (getTimeDif(getTimeStamp(), $row->last_acc)>$max_con_time) {
      delog($user, $userid, $c);
    } else {
      if (empty($row->id_user) and isset($userid) and empty($userid)) {
	if (GetEnv('REMOTE_ADDR') != $row->ip){
	  delog($user, $userid, $c);
	}
      } else if (isset($userid) and $userid != $row->id_user) {
	delog($user, $userid, $c);
      } else if (GetEnv('REMOTE_ADDR') != $row->ip) {
	delog($user, $userid, $c);
      }
    }
  } else {
    delog($user, $userid, $c);
  }
  if (!empty($res)) mysql_free_result($res);
  if ($user and $c) mysql_db_query($db_bibliography, 'UPDATE '.$tb_logins.' SET last_acc=\''.getTimeStamp().'\' WHERE challenge=\''.$c.'\';');
 }

//TODO: replace $user, $usern, $user_admin with object $logged_user in all scripts
if ($user && $userid) {
  $res = mysql_db_query($db_bibliography, 'SELECT * FROM '.$tb_users.' WHERE id=\''.$userid.'\';');
  if (!empty($res) && mysql_num_rows($res)==1){
    $logged_user = mysql_fetch_object($res, MYSQL_ASSOC);
  } else {
    delog($user, $userid, $c);
  }
 } else {
  $logged_user = false;
 }

//W3C validator
if (false) {
  //if ($_SERVER['REMOTE_ADDR'] == '128.30.52.13' || $_SERVER['REMOTE_ADDR'] == '133.27.228.132') {
  $user = 'toto';
  $userid = '0';
 }

$col_uid = getParam('col_uid', $var_methods_type[0]);
if (empty($col_uid)){
  $col_uid = getParam('col', $var_methods_type[2]);
  if (empty($col_uid) and !empty($userid)){
    $col_uid = $userid;
    setcookie('col', $userid);
  }
 } else {
    setcookie('col', $col_uid);  
 }
if(!empty($col_uid)){
  $res = mysql_db_query($db_bibliography, 'SELECT * FROM '.$tb_users.' WHERE id=\''.$col_uid.'\';');
  if (!empty($res)){
    if (mysql_num_rows($res) == 1){
      $row = mysql_fetch_object($res, MYSQL_ASSOC);
      setStyle($row, $sty, $body_color, $title_bg, $subt_col, $talp);
    }	
    mysql_free_result($res);
  }
 }
unset($col_uid);

$invalid_user_email = getParam('invalid_email', $var_methods_type[2]);
if ($invalid_user_email && 
    $current_script.'?'.$_SERVER['QUERY_STRING'] != $account_sc.'?ch=mail' && 
    $current_script.'?'.$_SERVER['QUERY_STRING'] != $account_sc.'?ch=pass' && 
    $current_script != $logout_sc) {
  Header('Location: '.$account_sc.'?ch=mail');
  exit;
 }

$unchg_user_pass = getParam('unchg_pass', $var_methods_type[2]);
if ($unchg_user_pass && 
    $current_script.'?'.$_SERVER['QUERY_STRING'] != $account_sc.'?ch=pass' && 
    $current_script.'?'.$_SERVER['QUERY_STRING'] != $account_sc.'?ch=mail' && 
    $current_script != $logout_sc) {
  Header('Location: '.$account_sc.'?ch=pass');
  exit;
 }

function delog(&$user, &$userid, &$c) {
  global $db_bibliography, $tb_logins;
  $user = false;
  setcookie ('user', '', (time () - 2592000));
  if (isset($userid)) {
    unset($userid);	 
    setcookie ('userid', '', (time () - 2592000));
  }
  if ($c) {
    mysql_db_query($db_bibliography, 'DELETE FROM '.$tb_logins.' WHERE challenge=\''.$c.'\';');
    setcookie ('c', '', (time () - 2592000));
  }
}

function getParam($var_name, $method_type){
  return getParamRepEr($var_name, $method_type, true);
}

function getParamRepEr($var_name, $method_type, $report_error){
  global $var_methods_type;
  if ($method_type == $var_methods_type[0]){
    if (isset($_GET[$var_name])){
      return $_GET[$var_name];
    }
  }
  if ($method_type == $var_methods_type[1]){
    if (isset($_POST[$var_name])){
      return $_POST[$var_name];
    }
  }
  if ($method_type == $var_methods_type[2]){
    if (isset($_COOKIE[$var_name])){
      return $_COOKIE[$var_name];
    }
  }
  if ($report_error) {
    #test  for bad var set
    if (isset($_GET[$var_name])){
      reportParamEror($var_name, $_GET[$var_name], $method_type, $var_methods_type[0]);
      //exit;
    } 
    if (isset($_POST[$var_name])){
      reportParamEror($var_name, $_POST[$var_name], $method_type, $var_methods_type[1]);
      //exit;
    } 
    if (isset($_COOKIE[$var_name])) {
      reportParamEror($var_name, $_COOKIE[$var_name], $method_type, $var_methods_type[2]);
      //exit;
    }
  }
  return '';
}

function reportParamEror($var_name, $bad_var_val, $meth, $bad_meth){
  echo '<br><br>Bad variable type :  '.$bad_meth.' for ' . $var_name . ' = ' . $bad_var_val . 
    '. Should be of type ' . $meth;
}

function getScriptName($ref){
  if (is_integer($pos = strpos($ref, '?'))) $ref = substr($ref, 0, $pos);
  unset($pos);
  if (is_integer($pos = strrpos($ref, '/'))) $ref = substr($ref, $pos + 1);
  return $ref;
}

function setStyle(&$row, &$sty, &$body_color, &$title_bg, &$subt_col, &$talp){
  if (!empty($row->body_col)) $body_color = getNoneCol($row->body_col);
  if (!empty($row->css)) $sty = getNoneCol($row->css);  
  if (!empty($row->title_col)) $title_bg = getNoneCol($row->title_col);
  if (!empty($row->subt_col)) $subt_col = getNoneCol($row->subt_col);
  if (!empty($row->col_2)) $talp = getNoneCol($row->col_2);
}

function getNoneCol(&$col) {
  return (strtolower($col) == 'none'?'':$col);
}
?>