<?php
/*
Aigaion: A web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers main functions for connecting to the database and global settings.

  html_activate_links($str)
    replaces text links with html links
      
  haveRights($right)
    returns true if the user has the requested rights. Allowed rights are:
    MANAGEDATABASE
    USERCHANGE
    SELECTDATABASE
    EDIT
    COMMENT
    CHANGEPROFILE
    PDF
    READNOTES

  rprint($right,$text)
    prints $text if the user has sufficient rights

  checkRights($right)
    breaks if the user has not sufficient rights.
*/


require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

//global variables. Others are defined after including config.php and after including personfunctions.php
$ROOT="";

$U_DBADMIN    = 6;
$U_ADMIN      = 5;
$U_EDITOR     = 4;
$U_COMMENTER  = 3;
$U_READONLY   = 2;
$U_NOPDF      = 1;
$U_NONOTES    = 0;

$U_RIGHTTEXT                = array();
$U_RIGHTTEXT[$U_DBADMIN]    = "DB admin (can manage database)";
$U_RIGHTTEXT[$U_ADMIN]      = "Admin (can add/change users)";
$U_RIGHTTEXT[$U_EDITOR]     = "Editor (can add/change publications)";
$U_RIGHTTEXT[$U_COMMENTER]  = "Commentor (can only give comments and ratings)";
$U_RIGHTTEXT[$U_READONLY]   = "Readonly (only read access)";
$U_RIGHTTEXT[$U_NOPDF]      = "No pdf (can read notes, can't read pdf)";
$U_RIGHTTEXT[$U_NONOTES]    = "No notes (can't read notes, can't read pdf)";


$MONTHS_ENG     = array("","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

error_reporting(E_ALL ^ E_NOTICE);

//Error message if no config file
if(!(file_exists("config.php"))) {
  ?>
  <html>
  <head>
  <title>Aigaion: please configure</title>
  <link REL="StyleSheet" HREF="themes/darkdefault/css/style.css" TYPE="text/css"/>
  </head>
  <body bgcolor="#202570">
  <center>
  <table bgcolor="F7F7F7" cellspacing="0" cellpadding="0" style="border:1px solid black" width="80%" height="50" style='width:872px;'>
  <tbody>
  <tr>
  <td  class=errormessage bgcolor="F7F7F7" height=5>
  Error: Aigaion has not been configured properly. Probably 'config.php' does not exist. Please copy sample_config.php to config.php and modify its contents to reflect the suitable settings for this server. See the INSTALL file for instructions for installing Aigaion correctly.
  </td>
  </tr>
  </tbody>
  </table>
  </body>
  </html>
  <?php 
  die();
}

include("config.php");
//SO. Here, if config is included, we may check the configuration settings for some common mistakes. If the check fails, the system will not load.
include_once("checkconfigsettings.php"); //NOT with $DIR as prefix, because if $DIR setting in config was incorrect, we cannot find this file
if (!checkConfig()) { //errors in config: give appropriate feedback
  ?>
  <html>
  <head>
  <title>Aigaion: please check configuration</title>
  <link REL="StyleSheet" HREF="themes/darkdefault/css/style.css" TYPE="text/css"/>
  </head>
  <body bgcolor="#202570">
  <center>
  <table bgcolor="F7F7F7" cellspacing="0" cellpadding="0" style="border:1px solid black" width="80%" height="50" style='width:872px;'>
  <tbody>
  <tr>
  <td class=errormessage bgcolor="F7F7F7" height=5>
  <?php 
  echo $_SESSION["aigaionerror"];
  $_SESSION["aigaionerror"] = "";
  ?>
  </td>
  </tr>
  </tbody>
  </table>
  </body>
  </html>
  <?php 
  die();
}

#DR: check user theme setting, override $THEME from config
include_once($DIR."lib/functions/personfunctions.php");
if (isset($_SESSION["usertheme"])) {
    $THEME="themes/".$_SESSION["usertheme"]."/";
}

if (!(isset($_SESSION['database']) && ($_SESSION['database'] != "") && ($_SESSION['database'] == $mysql_db)))
{
  $_SESSION['database'] = $mysql_db;
}

#DR: always include configfunctions
include_once($DIR."lib/functions/configfunctions.php");

/*
A long bit of code: it simply connects to the database, but contains feedback html for when an error occurs.
*/
if (mysql_connect($mysql_host,$mysql_user,$mysql_pass)) {
  if (!mysql_select_db($_SESSION['database'])) {
    ?>
    <html>
    <head>
    <title>Aigaion: database connection failed</title>
    <link REL="StyleSheet" HREF="themes/darkdefault/css/style.css" TYPE="text/css"/>
    </head>
    <body bgcolor="#202570">
    <center>
    <table bgcolor="F7F7F7" cellspacing="0" cellpadding="0" style="border:1px solid black" width="80%" height="50" style='width:872px;'>
    <tbody>
    <tr>
    <td  class=errormessage bgcolor="F7F7F7" height=5>
    Error: Aigaion did not succeed in selecting the correct database (<?php  echo $_SESSION['database']; ?>). Please check the database settings in config.php.
    </td>
    </tr>
    </tbody>
    </table>
    </body>
    </html>
    <?php 
    die();
  }
} else {
  //if no connection, give error message about existence/config of database & die.
  ?>
  <html>
  <head>
  <title>Aigaion: database connection failed</title>
  <link REL="StyleSheet" HREF="themes/darkdefault/css/style.css" TYPE="text/css"/>
  </head>
  <body bgcolor="#202570">
  <center>
  <table bgcolor="F7F7F7" cellspacing="0" cellpadding="0" style="border:1px solid black" width="80%" height="50" style='width:872px;'>
  <tbody>
  <tr>
  <td  class=errormessage bgcolor="F7F7F7" height=5>
  Error: Aigaion did not succeed in connecting to the database server. Please check the database settings in config.php.
  </td>
  </tr>
  </tbody>
  </table>
  </body>
  </html>
  <?php 
  die();
}
/*
end of code for connecting to database
*/

        
function html_activate_links($str) {
  $str = eregi_replace('(((f|ht){1}tp://)[-a-zA-Z0-9@:%_\+.~#?&//=]+)', '<a href="\\1" target="_blank">\\1</a>', $str);
  $str = eregi_replace('([[:space:]()[{}])(www.[-a-zA-Z0-9@:%_\+.~#?&//=]+)', '\\1<a href="http://\\2" target="_blank">\\2</a>', $str);
  $str = eregi_replace('([_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,3})','<a href=\"mailto:\\1\">\\1</a>', $str);
  return $str;
}

function haveRights($right)
{
  global $U_DBADMIN;
  global $U_ADMIN;
  global $U_EDITOR;
  global $U_COMMENTER;
  global $U_READONLY;
  global $U_NOPDF;
  global $U_NONOTES;
  
  if ($right == "MANAGEDATABASE")
  {
    if ($_SESSION['u_rights'] >= $U_DBADMIN)
    {
      return true;
    }
  }
  else if ($right == "USERCHANGE")
  {
    if ($_SESSION['u_rights'] >= $U_ADMIN)
    {
      return true;
    }
  }
  else if ($right == "SELECTDATABASE")
  {
    if ($_SESSION['u_rights'] >= $U_DBADMIN)
    {
      return true;
    }
  }
  else if ($right == "EDIT")
  {
    if ($_SESSION['u_rights'] >= $U_EDITOR)
    {
      return true;
    }
  }
  else if ($right == "COMMENT")
  {
    if ($_SESSION['u_rights'] >= $U_COMMENTER)
    {
      return true;
    }
  }
  else if ($right == "CHANGEPROFILE")
  {
    if ($_SESSION['u_rights'] >= $U_COMMENTER)
    {
      return true;
    }
  }
  else if ($right == "PDF")
  {
    if ($_SESSION['u_rights'] >= $U_READONLY)
    {
      return true;
    }
  }
  else if ($right == "READNOTES")
  {
    if ($_SESSION['u_rights'] > $U_NONOTES)
    {
      return true;
    }
  }
  else 
  {
    echo "Fatal error nr. 23, contact author";
    die();
    return false;
  }
}

//Print if sufficient rights
function rprint($right,$text)
{
  if (haveRights($right))
  {
    echo $text;
  }
}

function checkRights($right)
{
  if (haveRights($right))
  {
    return true;
  }
  else
  {
    echo "Access denied, IP logged.";
    die();
    return false;
  }
}


?>
