<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/personfunctions.php");

#Register request and session vars
$action="";
if (isset($_REQUEST["action"])) {
    $action=$_REQUEST["action"];
}
if (isset($_REQUEST["dbadmin"])) {
    $dbadmin=$_REQUEST["dbadmin"];
}
if (isset($_REQUEST["dbadminpwd"])) {
    $dbadminpwd=$_REQUEST["dbadminpwd"];
}
$message="";
if (isset($_REQUEST["message"])) {
  $message=$_REQUEST["message"];
}

$login = false;
$notice = "";

#Correct sesion vars are set, so user is logged in
if (isset($_SESSION['personID']) && ($_SESSION['personID'] > 0))
{
    if ($action=="logOut")
    {
        session_destroy();
        // Begin GtB: Delete cookie values if user logs off
        setcookie("loginname",FALSE); 
        setcookie("password",FALSE); 
        // End   GtB: Delete cookie values if user logs off
        $login=false;
    }
    else
    {
        # Logged in
        $login=true;
    }
} else {
#else: user was not logged in. Try to see if user can be logged in through cookies or through login submit
    $continueLoggingIn = FALSE;
    //determine user name & pwd from cookie or from login screen
    if (((isset($_POST['loginName']))) && (isset($_POST['loginPass']))) { 
        #user logs in via login screen.
        //get username & pwd
        $loginName = $_POST['loginName'];
        $loginPwd = md5($_POST['loginPass']);
        $continueLoggingIn = TRUE;
    } else if (isset($_COOKIE["loginname"])) {
        //user logs in via cookie
        $loginName = $_COOKIE['loginname'];
        $loginPwd = $_COOKIE['password'];
        $continueLoggingIn = TRUE;
    } 
    if ($continueLoggingIn) {
        //check username / password in user-table
        $Q = mysql_query("SELECT * FROM person WHERE login='$loginName'");
        $R = mysql_fetch_array($Q);
        //successful login: perform login, store cookies, etc
        if ($loginPwd == $R['password'])
        {
            //login OK
            $login = true;

            //store cookies after login was checked
            if (isset($_POST['remember']))
            {  
              setcookie("loginname",$R['login'],(30*24*60*60)+time()); 
              setcookie("password",$R['password'],(30*24*60*60)+time()); 
            }
            
            //grab settings and user data from user-table and store in session vars
            $_SESSION['personID'] = $R['ID'];
            $_SESSION['personLogin'] = $R['login'];
            $_SESSION['database'] = $R['database'];
            $_SESSION['admin'] = $R['admin'];
            $_SESSION['u_rights'] = $R['u_rights'];
            $_SESSION["usertheme"] = "darkdefault";
            if (themeExists($R["theme"])) {
                $_SESSION["usertheme"] = $R["theme"];
                $THEME="themes/".$_SESSION["usertheme"]."/";
            } else if ($R['theme'] != ""){
                $_SESSION["aigaionerror"].="Theme '".$R["theme"]."' no longer exists. You can select a new theme on your <a href=\"index.php?page=form&type=person&form=change&person_id=".$_SESSION["personID"]."\">configuration</a> page.<br>";
            }
            $_SESSION['summarystyle'] = $R["summarystyle"];
            $_SESSION['liststyle'] = $R["liststyle"];
            	
            $_SESSION['seeoneall'] = 'all';
            $_SESSION['userview'] = 'CREATE VIEW userpubs AS SELECT * FROM publication';
            if (isset($_SESSION['database']) && ($_SESSION['database'] != ""))
            {
                $database = $_SESSION['database'];
            }
            else
            {
                $database = $mysql_db;
                $_SESSION['database'] = $database;
            }
            mysql_select_db($database);
    
            #SO. Here, if login was successful, we will check the database structure once. 
            include "schema/checkschema.php";
            if (!checkDatabase()) {
                echo "<div class=errormessage>ERROR: DATABASE STRUCTURE CANNOT BE UPDATED TO NEW VERSION. PLEASE CONTACT ADMIN</div>";
                die();
            }
                
            #set a welcome message/advertisement after login
            if (!$_SESSION["aigaionmessage"]||($_SESSION["aigaionmessage"]=="")) {
                $_SESSION["aigaionmessage"]="";
                $_SESSION["aigaionmessage"].="\n<table>\n<tr><td>";
                $_SESSION["aigaionmessage"].="This site is powered by Aigaion - A PHP/Web based management system for shared and annotated bibliographies.\n";
                $_SESSION["aigaionmessage"].="For more information visit <a href='http://aigaion.sourceforge.net/' target='_blank'> Aigaion on Sourceforge</a>.";
                $_SESSION["aigaionmessage"].="</td><td><a target=_blank  href='http://aigaion.sourceforge.net'><img  src='http://sourceforge.net/sflogo.php?group_id=109910&type=1' width='88' height='31' border='0' alt='SourceForge.hetLogo'/></a></td></tr>\n</table>";
            }
                
        }
        else //login was NOT successful
        {
            $notice =  "Login failed :( <BR>";
        }
    }
}


#After login has been checked, and user turns out NOT to be logged in: show login dialog.
if ($login == false) 
{
    # Show login dialog
    ?>
    <html>
    <head>
    <title>Aigaion | Please login</title>
    <link REL="StyleSheet" HREF="themes/darkdefault/css/style.css" TYPE="text/css"/>
    </head>
    <body onload="javascript:document.loginForm.loginName.focus();">
    <center>
        <?php echo $notice ?>
        <form name=loginForm method="post" action="<?php echo($_SERVER['PHP_SELF']);?>">
            <input type=hidden name=page value="<?php echo($_REQUEST['page']);?>">
            <input type=hidden name=topic_id value="<?php echo($_REQUEST['topic_id']);?>">        
            <input type=hidden name=kind value="<?php echo($_REQUEST['kind']);?>">
            <input type=hidden name=arg value="<?php echo($_REQUEST['arg']);?>">
            <input type=hidden name=ID value="<?php echo($_REQUEST['ID']);?>">
            <input type=hidden name=query value="<?php echo($_REQUEST['query']);?>">
            <input type=hidden name=message value="<?php echo($_REQUEST['message']);?>">
            <?php if (isset($dbadmin)) { ?>
                <input type=hidden name=dbadmin value="<?php echo($_REQUEST['dbadmin']);?>">
                <input type=hidden name=dbadminpwd value="<?php echo($_REQUEST['dbadminpwd']);?>">
            <?php } ?>
            <?php if ($message) {
              ?>
              <div class="message"><?php echo $message;?></div>
            <?php }?>
            <table bgcolor="F7F7F7" cellspacing="3" cellpadding="3" style="border:1px solid black" width="400"  style='width:395px;'>

                <TR>
                <TD>Name:</TD>
                <TD><input type=text name=loginName size=50></TD>
                </TR>

                <TR>
                <TD>Password:</TD>
                <TD><input type=password name=loginPass size=50></TD>
                </TR>

                <TR>
                <TD></TD>
                <TD><input name=remember type=checkbox>&nbsp;Remember me.<p align=right><input type=submit value="Login"></TD>
                </TR>

                <tr>
                <td colspan=2>
                If you want a password, please mail to <?php echo getConfigSetting("CFG_ADMIN") ?>
                <br><?php echo getConfigSetting("CFG_ADMINMAIL") ?>
                </td>
                </tr>

                <tr>
                <td colspan=2>
                For more information about the Aigaion bibliography system visit <a href="http://aigaion.sourceforge.net/" target="_blank"> Aigaion on Sourceforge</a>.
                </td>
                </tr>
            </TABLE>

        </form>
        
    </center>
    </body>
    </html>
    <?php 
} else {

/*
DR: a temporary addition here. If connection to database is successful, we immediately map the bibtexIDs to 
cite links, for use in topic and note displays.
This saves on the number of times this is calculated per page request...
*/
    if (strpos($_SERVER["SCRIPT_NAME"],"indexempty")===FALSE) {
        # INIT BIBTEX_ID - to - PUBLICATION LINK mapping
        include_once($DIR."lib/displays/publicationdisplays.php");
        $citeIdArray = array();
        $citeLinkArray = array();
        $Q = mysql_query("SELECT pub_id,bibtex_id FROM publication");
        $count = 0;
        while ($R = mysql_fetch_array($Q))
        {
          //$citeIdArray[] = "/\b(?<!\.)(".addslashes($R["bibtex_id"]).")\b/";
          if ($R["bibtex_id"] != "")
          {
            $citeIdArray[] = "/\b(?<!\.)(".preg_quote($R["bibtex_id"], "/").")\b/";
            $citeLinkArray[] = getLinkToPublicationDisplayPage($R['pub_id'],$R["bibtex_id"]);
            $count++;
            }
        }
    }    
}    
?>