<?php 
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
 Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
The function 'checkConfig()' checks the settings of the config.php file for some common mistakes.
It is called just after login is successfull (see _login.php).
It returns true if the config settings are OK, false otherwise.
If it returns false, session variable $_SESSION["aigaionerror"] will contain an explanation of what is wrong.

Current tests:
does the $URL variable end with a slash 
does the $DIR variable end with slashes or backslashes? 
does the $FILEDIR variable end with slashes or backslashes?
does the $FILEDIR (attachment directory) exist, and is it writable?
*/
function checkConfig() {
    global $DIR,$FILEDIR,$URL;
    
    $success = true;
    $errorreport = "";
    
    #DR 2006.04.11
    //test: does the $URL variable end with a slash ? If not, return error...
    if ((substr(trim($URL), -1, 1) != '/')) {
        $errorreport .= "<li>The \$URL setting should end with a slash.";
        $success = false;
    }

    #DR 2006.04.11
    //test: does the $DIR variable end with slashes or backslashes? If not, return error...
    if ((substr(trim($DIR), -1, 1) != '\\')&&(substr(trim($DIR), -1, 1) != '/')) {
        $errorreport .= "<li>The \$DIR setting should end with a slash (*N*X) or double-backslash (Windows).";
        $success = false;
    }

    #DR 2006.04.11
    //test: does the $FILEDIR variable end with slashes or backslashes? If not, return error...
    if ((substr(trim($FILEDIR), -1, 1) != '\\')&&(substr(trim($FILEDIR), -1, 1) != '/')) {
        $errorreport .= "<li>The \$FILEDIR setting should end with a slash (*N*X) or double-backslash (Windows).";
        $success = false;
    }

    #DR 2006.04.11
    //test: does the $FILEDIR (attachment directory) exist, and is it writable?
    if (!file_exists($FILEDIR)) {
        $errorreport .= "<li>The \$FILEDIR setting should point to an existing directory.";
        $success = false;
    } else if (!is_writable($FILEDIR)) {
        $errorreport .= "<li>The directory specified in the \$FILEDIR setting should be writable.";
        $success = false;
    }

    #Store error information in appropriate session var
    if (!$success) {
        $_SESSION["aigaionerror"] .= "There is an error in the configuration of this database, defined in \"config.php\". Please contact <a href='mailto:".getConfigSetting("CFG_ADMINMAIL")."'>".getConfigSetting("CFG_ADMIN")."</a><br>";
        $_SESSION["aigaionerror"] .= "More information:<br>";
        $_SESSION["aigaionerror"] .= "<ul>";
        $_SESSION["aigaionerror"] .= $errorreport;
        $_SESSION["aigaionerror"] .= "</ul>";
    }
        
    return $success;    
}
?>