<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
?>



<p class="header">Importing Publications</p>
New publications can be imported either as BibTeX or as RIS text. 

<p class='header2'>Entering the publications</p>
Simply paste the publication BibTeX or RIS data into the text area, select the format to import and press 'import'. If you want to import a really large file, you may have to cut it in slightly smaller pieces and import them separately to avoid time-out problems, as many web browsers have a problem with posting really large amounts of text through an input form. However, smaller files can be imported in one piece without any problem.

<p class='header2'>Checking the import</p>
The next step is checking the import. The publication data may contain authors that are already present in the database, possibly under a slightly different name. The BiBTeX cite-key may already be in use in the database. Publications may already exist in the database. The import-check page will report all potential conflicts in the import, leaving it to the user to decide how to handle them. This will be done through entries such as the one below.

<div class='message'>
<table>
	<tr>
		<td valign=top><input type=checkbox checked title='Uncheck to skip importing this article'></td>
		<td>Import inproceedings: Boker, S.M. and Covey, E. and Tiberio, S. and Deboeck, P., <i>'Synchronization in Dancing is Not Winner-Takes-All: Ambiguity Persists in Spatiotemporal Symmetry Between Dancers.'</i>, 2005<br/><br/></td>
	</tr>
	<tr>
		<td></td>
		<td>
			<div class=errormessage><p><b>Similar BiBTeX IDs exist:</b><br/>
			<table>
				<tr>
					<td>boker2003</td><td>Boker, Rotondo, Stamenov, Gallese, <i>Symmetry building and symmetry breaking in synchronized movement</i> (2003) </td>
				</tr>
			</table><br/></p>
			</div>
		</td>
	</tr>
	<tr>
		<td></td><td>BiBTeX cite ID:&nbsp;<INPUT title='enter new bibtex cite id here if you want to change the current cite id' name='citeID0' value=boker2005><br/><br/></td>
	</tr>
	<tr>
		<td></td><td><b>Choose alternative authors</b><br/>Options for BiBTeX-author Boker, S.M.:<br/><input title='select to use author as found in BiBTeX' type=radio checked name=author0_1>Boker, S.M. [keep]<br/><input title='select to use similar author found in database' type=radio name=author0_1>Bayer, Stefan [from database]<br/><input title='select to use similar author found in database' type=radio name=author0_1>Baker, Matthias [from database]<br/></div><br/><br/></td>
	</tr>
</table>
<br><br><i><u>An example entry for the import check</u></i>
</div>

<p class='header2'>Committing</p>
After reviewing the import entries, you can commit the results by pressing the 'commit' button. All publications that were not unchecked will be added, as well as any new authors.
If an author appears twice or more times in publications to import, in EXACTLY the same form, it will be added as a new author at most once.
<p class='header2'>Crossrefs</p>
Some BiBTeX, most notably that from the DBLP server, contains crossref entries for journals and books. For example, an LNCS article in DBLP typically consists of an entry for the LNCS volume, and an entry for the article in the volume, with the article containing a crossref to the volume for information such as editor or series etc. The bibteximport in Aigaion will import such entries separately and keep the crossref information intact.


