<?php
/*
Web based document management system
Copyright (C) 2003, 2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/* A class to parse RIS(Rough Information Structure) files */
/* Copyright (C) 2006, Gerbert ten Brinke				   */

class parseRIS
{
  //parseRIS(): initialize the class
  function parseRIS()
  {
    $this->preamble = $this->strings = $this->entries = array();
    $this->currentLine=1;
    $this->risString="1";
    $this->count=0;
  }

  //getLine(): returns a line if there are more lines to parse, otherwise returns false
  function getLine()
  {
/*
    if($this->parseFile)
		{
			if(!feof($this->fid))
			{
				do
				{
					$line = trim(fgets($this->fid));
				}
				while(!feof($this->fid) && !$line);
				return $line;
			}
			return FALSE;
		}
		else
		{
*/
			do
			{
				$sLine = trim($this->risString[$this->currentLine]);
				$this->currentLine++;
			}
			while ($this->currentLine < count($this->risString) && !$sLine);
			return $sLine;
/*		}
    $line = $this->bibtexString[$this->currentLine];
    $this->currentLine++;
    $val = ($this->currentLine < count($this->bibtexString)) ? $line : FALSE;
    return $val;
*/
  }

  //loadRISString($ris_string): loads the inputdata to the risString
  function loadRISString($ris_string)
  {
    if (is_string($ris_string)){
      $this->risString = explode("\n",$ris_string);
    }
    else
    {
      $this->risString = $ris_string;
    }
    $this->currentLine = 0;
  }


  function extractEntries()
  {
    $search = array ('@TY@',
    '@ID@',
    '@T1@',
    '@TI@',
    '@JO@',
    '@JT@',
    '@VL@',
    '@VI@',
    '@IS@',
    '@IP@',
    '@SP@',
    '@EP@',
    '@PY@',
    '@DP@',
    '@Y1@',
    '@A1@',
    '@A2@',
    '@AU@',
    '@UR@',
    '@AB@',
    '@N1@',
    '@N2@',
    '@KW@',
    '@PG@',
    '@SN@',
    '@ER@'
    );
    // evaluate as php
    $replace = array ('bibtexEntryType',
    'bibtexCitation',
    'title',
    'title',
    'journal',
    'journal',
    'volume',
    'volume',
    'issue',
    'number',
    'startpage',
    'endpage',
    'risyear',
    'risyear',
    'risyear',
    'author',
    'editor',
    'author',
    'url',
    'abstract',
    'abstract',
    'abstract',
    'keywords',
    'pages',
    'issn',
    'ENDOFENTRY'
    );

    while ($this->currentLine < count($this->risString))
    {
      $sLine = $this->getLine();
      if ($elementName == "ENDOFENTRY")
        $this->count++;
      
      $matchArray = preg_split("/-/", $sLine); // split the line and store in array $matchArray
      
      if (substr($sLine,1,4)=="    ")
      {
        $matchValue = trim($sLine);
      }
      else
      {
        sscanf($sLine,"%s",$matchElement);
        $elementValue = substr($sLine,strlen($matchElement)+1,10000);
        $elementValue = substr(trim($elementValue),2);
      }
      $elementName = preg_replace($search, $replace, $matchElement);
      if ($elementName == "bibtexEntryType")
      {
        switch (trim($elementValue)) {
          case "JOUR":
            $elementValue = "article";
            break;
          case "JFULL":
            $elementValue = "article";
            break;
          case "BOOK":
            $elementValue = "book";
            break;
          case "CHAP":
            $elementValue = "inbook";
            break;
          case "CONF":
            $elementValue = "inproceedings";
            break;
          case "THES":
            $elementValue = "PHDThesis";
            break;
          case "RPRT":
          	$elementValue = "report";
          	break;
          case "UNPB":
          	$elementValue = "unpublished";
          	break;
          default:
            $elementValue = "misc";
            break;
        }
      }
      
      if ($elementName == "ENDOFENTRY")
      {
        //check if publicationtype has been set, if note, set to default (article)
        if (empty($this->entries[$this->count]["bibtexEntryType"]))
        {
          $this->entries[$this->count]["bibtexEntryType"] = "article";
        }
        
        //merge startpage and endpage to "pages"
        if (!empty($this->entries[$this->count]["startpage"]))
        {
          $this->entries[$this->count]["pages"]=$this->entries[$this->count]["startpage"]."--".$this->entries[$this->count]["endpage"];
          $count = $this->count;
          unset($this->entries[$count]['startpage']);
          unset($this->entries[$count]['endpage']);
        }
        
        //convert from ris year format to bibtex year format
        if (!empty($this->entries[$this->count]["risyear"]))
        {
          $output=str_replace("/"," / ",$this->entries[$this->count]["risyear"]);
  
          sscanf($output,"%s %s %s %s %s",$year,$dummy1,$month,$dummy2,$day);
  
          $this->entries[$this->count]["year"]=$year;
          switch ($month)
          {
            case 1: $this->entries[$this->count]["month"]="jan";break;
            case 2: $this->entries[$this->count]["month"]="feb";break;
            case 3: $this->entries[$this->count]["month"]="mar";break;
            case 4: $this->entries[$this->count]["month"]="apr";break;
            case 5: $this->entries[$this->count]["month"]="may";break;
            case 6: $this->entries[$this->count]["month"]="jun";break;
            case 7: $this->entries[$this->count]["month"]="jul";break;
            case 8: $this->entries[$this->count]["month"]="aug";break;
            case 9: $this->entries[$this->count]["month"]="sep";break;
            case 10: $this->entries[$this->count]["month"]="oct";break;
            case 11: $this->entries[$this->count]["month"]="nov";break;
            case 12: $this->entries[$this->count]["month"]="dec";break;
          }
          $count = $this->count;
          unset($this->entries[$count]['risyear']);
        }
      }
      elseif (empty($this->entries[$this->count][$elementName]) )
      {
        $this->entries[$this->count][$elementName] = $elementValue;
      }
      else
      {
        if ($elementName=="author")
        {
          $this->entries[$this->count]["author"] .= " and ".$elementValue;
        }
        elseif ($elementName=="keywords")
        {
          $this->entries[$this->count]["keywords"] .= ", ".$elementValue;
        }
        else
        {
          $this->entries[$this->count][$elementName] .= " ".$elementValue;
        }
      }
    }
    //for the case that te ris entry did not end with and end of entry element, convert the untill now uncoverted entries.
    //check if publicationtype has been set, if note, set to default (article)
    if (empty($this->entries[$this->count]["bibtexEntryType"]))
    {
      $this->entries[$this->count]["bibtexEntryType"] = "article";
    }
    
    //merge startpage and endpage to "pages"
    if (!empty($this->entries[$this->count]["startpage"]))
    {
      $this->entries[$this->count]["pages"]=$this->entries[$this->count]["startpage"]."--".$this->entries[$this->count]["endpage"];
      $count = $this->count;
      unset($this->entries[$count]['startpage']);
      unset($this->entries[$count]['endpage']);
    }
    
    //convert from ris year format to bibtex year format
    if (!empty($this->entries[$this->count]["risyear"]))
    {
      $output=str_replace("/"," / ",$this->entries[$this->count]["risyear"]);

      sscanf($output,"%s %s %s %s %s",$year,$dummy1,$month,$dummy2,$day);

      $this->entries[$this->count]["year"]=$year;
      switch ($month)
      {
        case 1: $this->entries[$this->count]["month"]="jan";break;
        case 2: $this->entries[$this->count]["month"]="feb";break;
        case 3: $this->entries[$this->count]["month"]="mar";break;
        case 4: $this->entries[$this->count]["month"]="apr";break;
        case 5: $this->entries[$this->count]["month"]="may";break;
        case 6: $this->entries[$this->count]["month"]="jun";break;
        case 7: $this->entries[$this->count]["month"]="jul";break;
        case 8: $this->entries[$this->count]["month"]="aug";break;
        case 9: $this->entries[$this->count]["month"]="sep";break;
        case 10: $this->entries[$this->count]["month"]="oct";break;
        case 11: $this->entries[$this->count]["month"]="nov";break;
        case 12: $this->entries[$this->count]["month"]="dec";break;
      }
      $count = $this->count;
      unset($this->entries[$count]['risyear']);
    }
  }


  function returnArrays()
  {
    if (empty($this->preamble))
      $this->preamble = FALSE;
    if (empty($this->strings))
      $this->strings = FALSE;
    if (empty($this->entries))
      $this->entries = FALSE;
    
    return array($this->preamble, $this->strings, $this->entries);
  }
}

?>
