<?php
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/*
====================================================================================================
ACTION PERFORMING FUNCTIONS 
====================================================================================================

    //store file on server. if ismain==true, old main files are set to non-main
    attachmentAddNew ($pub_id, $note, $alternativename, $ismain=false)
    
    //store link to external file...
    attachmentAddNewRemote($pub_id, $note, $alternativename, $reallocation, $ismain=false) {
    
    //update the attachment note
    attachmentUpdateNote($pub_id, $location, $note)
    
    //delete attachment
    attachmentDelete ($pub_id, $location)
    
    //set given attachment as main; set all other attachments of this publication as not-main
    attachmentSetMain($pub_id, $location)
    
    //set given attachment as not-main
    attachmentUnsetMain($pub_id, $location)

*/


#The functions performing the actual work
/* Delete attachment. */
function attachmentDelete($pub_id, $location) {
    global $FILEDIR;
    #get att from database
    $res = mysql_query("SELECT * FROM publicationfile WHERE pub_id=".$pub_id." AND location='".addslashes($location)."';");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            $location=$row["location"];
            if ($row["isremote"]!="TRUE") {
                unlink($FILEDIR.$location);
            }
            $res = mysql_query("DELETE FROM publicationfile WHERE pub_id=".$pub_id." AND location='".addslashes($location)."';");
            if (mysql_error()) {
                $_SESSION["aigaionerror"].="Error deleting attachment ".$location." for publication ".$pub_id.".<br/>";
                $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
                $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
            }
        }
    }
}

/* Add attachment with given parameters (just uploaded through php!), 
   copy file to new location, return true iff successful */
function attachmentAddNew($pub_id, $note, $alternativename, $ismain=false) {
    global $FILEDIR,$DIR;
    include_once($DIR."includes/file_upload/upload_class.php"); 
    
    #upload not possible: return with error
    if (getConfigSetting("SERVER_NOT_WRITABLE") == "TRUE") {
        $_SESSION["aigaionerror"].=  "You cannot upload attachment files to this server (is the server write-only?); please use remote attachments instead.<br>";
        return false;
    }
    
    $my_upload = new file_upload;

    #determine real name (the one exposed to user) and storename (the one 
    #used for storage) of file, from alternative name or from original name
    #
    $realname=$_FILES['upload']['name'];
    if (!file_exists($_FILES['upload']['tmp_name'])) {
        $_SESSION["aigaionerror"].= "File ".$realname." was not uploaded to server. Does the specified file exist on your computer?<br>";
        return false;        
    }
    if (filesize($_FILES['upload']['tmp_name'])<=0) {
        $_SESSION["aigaionerror"].= "File size 0: file ".$realname." was not uploaded to server. Does the specified file exist on your computer?<br>";
        return false;        
    }
    
    //$_SESSION["aigaionmessage"].="alternativename: ".$alternativename."<br>";
    $ext=$my_upload->get_extension($realname);
    //$_SESSION["aigaionmessage"].="Extension: ".$ext."<br>";
    if (isset($alternativename) && ($alternativename!="")) {
        if ($my_upload->get_extension($alternativename)!=$ext) {
            $alternativename.=$ext;
            //$_SESSION["aigaionmessage"].="alternativename: ".$alternativename."<br>";
        }
        $realname = $alternativename;
    }
    $new_name = (str_replace(' ','_',$realname))."-".generateUniqueSuffix();
    //$_SESSION["aigaionmessage"].="new_name: ".$new_name."<br>";
    //sanitize quotes and other stuff out of name
    $badchars = array("'", "\"", "\\", "/");
    $new_name = str_replace($badchars, "", $new_name);

    #prepare upload of file from temp to permanent location
    #
    $max_size = 1024*100; // the max. size for uploading
    $my_upload->upload_dir = $FILEDIR; // "files" is the folder for the uploaded files (you have to create this folder)
    $my_upload->extensions = getConfigSetting("ALLOWED_ATTACHMENT_EXTENSIONS"); // specify the allowed extensions here
    $my_upload->max_length_filename = 255; // change this value to fit your field length in your database (standard 100)
    $my_upload->rename_file = true;
	$my_upload->the_temp_file = $_FILES['upload']['tmp_name'];
	$my_upload->the_file = $_FILES['upload']['name'];

    #get mime type...
    #	
	$mime = $_FILES['upload']['type'];
    //fix some problematic types?
	if ($ext==".doc") {
	    $mime="application/msword";
	}

    #more prepare upload of file from temp to permanent location
    #
    $my_upload->http_error = $_FILES['upload']['error'];
	$my_upload->replace = "n"; // because only a checked checkboxes is true
	$my_upload->do_filename_check = "n"; // use this boolean to check for a valid filename
   	
    #do actual upload
    #
    if ($my_upload->upload($new_name)) { // new name is an additional filename information, use this to rename the uploaded file
        //echo "mimie:".$mime.".";
        #upload was succesfull:
        #   if ismain, old main attachment should be un-main-ed
        if ($ismain=="TRUE") {
            $res = mysql_query("UPDATE publicationfile SET ismain='FALSE' where pub_id=".$pub_id);
            if (mysql_error()) {
                $_SESSION["aigaionerror"].= mysql_error()."<br>";
                return false;
            }
        }
        #   add appropriate info about new attachment to database
        $res = mysql_query("INSERT INTO publicationfile (pub_id, note, name, location, mime, ismain, isremote, person_id) VALUES (".$pub_id.", '".addslashes($note)."','".addslashes($realname)."','".addslashes($new_name.$ext)."','".addslashes($mime)."', '".$ismain."', 'FALSE', ".$_SESSION["personID"].")");
        if (mysql_error()) {
            $_SESSION["aigaionerror"].= mysql_error();
            return false;
        }
        return true;
    } else {
        $_SESSION["aigaionerror"].= "ERROR UPLOADING: ".$my_upload->show_error_string()."<br>Need other file types? Ask <a href='mailto:".getConfigSetting("CFG_ADMINMAIL")."'>".getConfigSetting("CFG_ADMIN")."</a><br>";
        return false;
    }
}

function attachmentUpdateNote($pub_id, $location, $note) {
    global $FILEDIR;
    #get att from database
    $res = mysql_query("UPDATE publicationfile SET note='".addslashes($note)."' WHERE location='".addslashes($location)."'");
    $row = mysql_fetch_array($res);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].= mysql_error()."<br/>";
        return false;
    }
    return true;
}

//store a link in the database to a file residing elsewhere;
function attachmentAddNewRemote($pub_id, $note, $alternativename, $remotelocation, $ismain=false) {
    global $DIR;
    $ALLOW_ALL_EXTERNAL_ATTACHMENTS = getConfigSetting('ALLOW_ALL_EXTERNAL_ATTACHMENTS');
    $ALLOWED_ATTACHMENT_EXTENSIONS = getConfigSetting('ALLOWED_ATTACHMENT_EXTENSIONS');

    include_once($DIR."includes/file_upload/upload_class.php"); 
    $my_upload = new file_upload;

    #determine real name (the one exposed to user) 
    #from alternative name or from original name
    #
    $realname=$remotelocation;
    $ext=$my_upload->get_extension($realname);
    if ((!isset($ALLOW_ALL_EXTERNAL_ATTACHMENTS)) || (!$ALLOW_ALL_EXTERNAL_ATTACHMENTS)) {
    	if (!in_array($ext, $ALLOWED_ATTACHMENT_EXTENSIONS)) { 
            $_SESSION["aigaionerror"].= "ERROR UPLOADING: ".$ext." is not an allowed extension for remote files."."<br>Need other file types? Ask <a href='mailto:".getConfigSetting("CFG_ADMINMAIL")."'>".getConfigSetting("CFG_ADMIN")."</a>"."<br>";
            return false;
        }
    }

    if (isset($alternativename) && ($alternativename!="")) {
        if ($my_upload->get_extension($alternativename)!=$ext) {
            $alternativename.=$ext;
        }
        $realname = $alternativename;
    }
   	
    #get mime type...
    #	
	$mime = $ext; //not good... how to get proper mime info here?
        //fix often used types..
        if ($mime==".pdf") {
            $mime="application/pdf";
        }
        if ($mime==".doc") {
            $mime="application/msword";
        }
        if ($mime==".txt") {
            $mime="text/plain";
        }


    #if ismain, old main attachment should be un-main-ed
    if ($ismain=="TRUE") {
        $res = mysql_query("UPDATE publicationfile SET ismain='FALSE' where pub_id=".$pub_id);
        if (mysql_error()) {
            $_SESSION["aigaionerror"].= mysql_error()."<br>";
            return false;
        }
    }
    #store link in database
    #
    //echo "mimie:".$mime.".";
    $res = mysql_query("INSERT INTO publicationfile (pub_id, note, name, location, mime, ismain, isremote, person_id) VALUES (".$pub_id.", '".addslashes($note)."','".addslashes($realname)."','".addslashes($remotelocation)."','".addslashes($mime)."', '".$ismain."', 'TRUE', ".$_SESSION["personID"].")");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].= mysql_error();
        return false;
    }
    return true;
}

function generateUniqueSuffix() {
    $suffix = md5(time());
    while (file_exists($suffix)) {
        $suffix= md5(time());
    }
    return $suffix;
}

function attachmentSetMain($pub_id, $location) {
    #any old main attachment should be un-main-ed
    $res = mysql_query("UPDATE publicationfile SET ismain='FALSE' where pub_id=".$pub_id);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].= mysql_error()."<br>";
        return false;
    }
    #set given attachment to main
    $res = mysql_query("UPDATE publicationfile SET ismain='TRUE' where pub_id=".$pub_id." AND location='".addslashes($location)."'");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].= mysql_error()."<br>";
        return false;
    }
}
function attachmentUnsetMain($pub_id, $location) {
    #set given attachment to not-main
    $res = mysql_query("UPDATE publicationfile SET ismain='FALSE' where pub_id=".$pub_id." AND location='".addslashes($location)."'");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].= mysql_error()."<br>";
        return false;
    }
}

?>