<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

function setConfig($CFG_ADMIN, $CFG_ADMINMAIL, $WINDOW_TITLE, $ALLOWED_ATTACHMENT_EXTENSIONS, $ALLOW_ALL_EXTERNAL_ATTACHMENTS, $ALWAYS_INCLUDE_PAPERS_FOR_TOPIC, $SERVER_NOT_WRITABLE, $USE_DOI, $CONVERT_LATINCHARS_IN) {
    if (!haveRights("MANAGEDATABASE")) {
        $_SESSION["aigaionerror"] .= "Only DB Admins are allowed to change the configuration of the site.<br>";
        return;
    }
    $errorocurred = FALSE;
    $errorfeedback="";
    $feedback="";
   	
   	#check settings where needed; if it is correct, set it and give feedback; if it is wrong, give errorfeedback
    //no check needed: 
    setConfigSetting('CFG_ADMIN',$CFG_ADMIN);
    setConfigSetting('CFG_ADMINMAIL',$CFG_ADMINMAIL);
    setConfigSetting('WINDOW_TITLE',$WINDOW_TITLE);
    setConfigSetting('ALLOW_ALL_EXTERNAL_ATTACHMENTS',$ALLOW_ALL_EXTERNAL_ATTACHMENTS);
    setConfigSetting('ALWAYS_INCLUDE_PAPERS_FOR_TOPIC',$ALWAYS_INCLUDE_PAPERS_FOR_TOPIC);
    setConfigSetting('SERVER_NOT_WRITABLE',$SERVER_NOT_WRITABLE);
    setConfigSetting('USE_DOI',$USE_DOI);
    setConfigSetting('CONVERT_LATINCHARS_IN',$CONVERT_LATINCHARS_IN);

    #check allowed extensions: all extensions should be prefixed with a . and should be trimmed of spaces
    $templist = array();
    foreach (split(",",$ALLOWED_ATTACHMENT_EXTENSIONS) as $ext) {
        $ext = trim($ext);
        if (($ext=="") || ($ext==".")) {
            continue;
        }
        if (strpos($ext,".") === FALSE) {
            $ext = ".".$ext;
        }
        $templist[] = $ext;
    }
    if (sizeof($templist)==0) {
        $templist[] = ".pdf";
    }
    setConfigSetting('ALLOWED_ATTACHMENT_EXTENSIONS',implode(",",$templist));
    
    #reset cached config settings
    $_SESSION["config"] = array();
}

function setConfigSetting($setting, $value) {
    if (!haveRights("MANAGEDATABASE")) {
        $_SESSION["aigaionerror"] .= "Only DB Admins are allowed to change the configuration of the site.<br>";
        return;
    }
    
    #check existence of setting
    mysql_query("INSERT IGNORE INTO config (setting) VALUES ('$setting')");
    
    #update value
    mysql_query("UPDATE config SET value='".addslashes($value)."' WHERE setting='$setting'");
    if (mysql_error()) {
        $_SESSION["aigaionerror"] .= "Error updating config: <br>";
        $_SESSION["aigaionerror"] .= mysql_error()."<br>";
    }
    return true;
}
?>