<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file offers several functions to import publications into Aigaion
Each function returns a string that contains (parts of) a form.

  bibImportEntries($entries)
    imports parsed $entries into the db.
    supports standard bibtex entries
    TO IMPLEMENT: aigaiontopics and aigaiontopictopiclinks
    returns the ID of the first imported publication
    
  bibImportEntry($entry, $entryNr, &$addedAuthors)
    Imports a standard bibtex entry.
    returns:
    1 on skipping
    -1 on error while importing authors or editors
    -2 on error because of double bibtex id
    -3 on error while inserting the publication
    0 when everything is ok.
    
  bibImportAuthors($authors, $entryNr, $authorIDPrefix, &$addedAuthors)
    Imports Authors belonging to an $entryNr.
    Checks wether the Authors really have to be imported, if not, existing IDs are returned.
    returns an array with author IDs, -1 upon error.
    
  commitAuthor($author,&$addedAuthors)
    Does the actual committing of authors.
    Upon error, a <div> block is echoed.
    returns -1 upon error, otherwise the ID of the author is returned.
    
  commitPublication($entry,$citeID,$authorIDs,$editorIDs)
    Does the actual committing of a publication.
    returns -1 upon error, otherwise 0.

*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."_basicfunctions.php");
include_once($DIR."lib/displays/importdisplays.php");
include_once($DIR."lib/displays/publicationdisplays.php");
include_once($DIR."lib/functions/configfunctions.php");
include_once($DIR."lib/functions/importfunctions.php");
include_once($DIR."lib/functions/specialcharfunctions.php");


# bibImportEntries($entries)
function bibImportEntries($entries) {
  $result = "";
  $nrOfEntries = 0;
  $nrOfEntriesCommitted = 0;
  $nrOfTopics = 0;
  $nrOfTopicLinks = 0;
  $addedAuthors = array();
  $errorEntryNrs = array();
  $importedEntryIDs = array();
  $nrErrorEntries = 0;

  foreach ($entries as $entry) {
    if ($entry['bibtexEntryType']=='aigaiontopic') {
      //importAigaionTopic
      //importAigaionTopic($entry)
      //$nrOfTopics++;
    }
    else if ($entry['bibtexEntryType']=='aigaiontopictopiclink') {
      //importAigaionTopicLink
      //importAigaionTopicLink($entry)
      //$nrOfTopicLinks++;
    }
    else {
      //bibImportEntry
      $importedEntryIDs[] = bibImportEntry($entry, $nrOfEntries, $addedAuthors);
      
      $nrOfEntries++;
    }
  }

  $_SESSION['aigaionmessage'] .= "Succesful import of ".$nrOfEntries." publications.<br/>";

  return $importedEntryIDs[0];
}

# bibImportEntry($entry, $entryNr, &$addedAuthors)
# returns 0 when everything OK, returns 1 when skipped else returns -1
function bibImportEntry($entry, $entryNr, &$addedAuthors) {

  //check if entry is to be imported
  if ($_REQUEST["importNr".$entryNr] != "on") {
    return 0;
  }
  //still alive so import this entry
  //import authors and editors
  if ($entry['author']) {
    $authors = bibParseAuthors($entry['author']);
    $authorIDs = bibImportAuthors($authors, $entryNr, "author", $addedAuthors);
  }
  if ($entry['editor']) {
    $editors = bibParseAuthors($entry['editor']);
    $editorIDs = bibImportAuthors($editors, $entryNr, "editor", $addedAuthors);
  }

  if (($authorIDs == -1)||($editorIDs == -1))
  {
    $_SESSION['aigaionerror'] .= "An error occurred while committing authors<br/>";;
  }
  
  //check for double citeID
  //if double citeID keep this entry (bibtex) and show it again in the import form
  $citeID = $_REQUEST["citeID".$entryNr];
  if ($citeID != "") {
    $Q = mysql_query('SELECT * FROM publication WHERE bibtex_id = "'.$citeID.'"');
    if (mysql_num_rows($Q) > 0)
    {
      $_SESSION['aigaionerror'] .= "The bibtex cite-id ".$citeID." was not unique, appended underscore.<br/>";;
    }
    while (mysql_num_rows($Q) > 0) {
      $citeID = $citeID."_";
      $Q = mysql_query('SELECT * FROM publication WHERE bibtex_id = "'.$citeID.'"');
    }
  }
  //if citeID ok, do a straightforward import
  $pub_id = commitPublication($entry,$citeID,$authorIDs,$editorIDs);

  return $pub_id;
}

# bibImportAuthors($authors, $entryNr, $authorIDPrefix)
# returns -1 on error, otherwise the author IDs in an array
function bibImportAuthors($authors, $entryNr, $authorIDPrefix, &$addedAuthors) {
  $authorIDs = array();

  $rank = 1;
  
  foreach ($authors as $author) {
    //Only if similar authors are in the database, there is a corresponding field.
    $authorIDRef = $authorIDPrefix.$entryNr."_".$rank;
    if (isset($_REQUEST[$authorIDRef])) {
      $authorID=$_REQUEST[$authorIDRef];
    }
    else {
      $authorID = -1;
    }

    if ($authorID == -1) {
      $authorID = commitAuthor($author, $addedAuthors);
      if ($authorID == -1)
      return -1;
    }
    else {
      //keep author, do nothing!
    }

    $authorIDs[$rank] = $authorID;
    $rank++;
  }
  
  return $authorIDs;
}

# commitAuthor($author, &$addedAuthors)
# Adds one author to the DB if not already present in $addedAuthors.
# returns -1 on error, authorID otherwise
function commitAuthor($author,&$addedAuthors) {

  //check if author was already added by looking up $addedAuthors.
  $firstName = parseAigaionFirstName($author);
  $surName = trim(''.$author[2].' '.$author[3]);
  $completeName = $firstName.'; '.$surName;
  
  if (getConfigSetting("CONVERT_LATINCHARS_IN") == "TRUE")
  {
  	latinToBibCharsFromString($surName);
		latinToBibCharsFromString($firstName);
  }
  if ((findSpecialCharsInString($surName)) || (findSpecialCharsInString($firstName))) {
    $specialChars = "TRUE";
  }
  else {
    $specialChars = "FALSE";
  }
    
  
  if (isset($addedAuthors[$completeName])) {
    $authorID = $addedAuthors[$completeName];
  }
  else {
    mysql_query('INSERT INTO author(surname, name, email, institute, specialchars) VALUES ("'.addslashes($surName).'","'.addslashes($firstName).'","","", "'.$specialChars.'")');
    $authorID=mysql_insert_id();

    $error = "";
    $error = mysql_error();
    if ($error != "") {
      //output error message
      echo "<div class=errormessage>There was an error while committing the following Author: ".$surName.", ".$firstName."<br/>";
      echo "Please report this errormessage to your aigaion administrator.<br/>";
      echo $error."</div>";
      $authorID = -1;
    }
    $addedAuthors[$completeName] = $authorID;
  }

  return $authorID;
}

# commitPublication($nextentry,$citeid,$authorids,$editorids)
# commits a new publication to the DB
# returns -1 on error, 0 otherwise
function commitPublication($entry,$citeID,$authorIDs,$editorIDs) {
  $pub_id = "";
  $entry = fillEmptyFields($entry);

  if (!$entry['mark'] || ($entry['mark'] == ''))
  $entry['mark'] = 5;

  if ($entry['pages'] != '')
  list($entry['firstpage'], $entry['lastpage']) = bibParsePages($entry['pages']);

  if (!$entry['chapter']|| ($entry['chapter'] == ''))
  $entry['chapter'] = 0;

  if ($entry['survey'] == '')
  $entry['survey'] = 0;

  if (!$entry['firstpage'] || ($entry['firstpage'] == ''))
  $entry['firstpage'] = 0;

  if (!$entry['lastpage'] || ($entry['lastpage'] == ''))
  $entry['lastpage'] = 0;

  if (!$entry['month'] || ($entry['month'] == '')) {
    $entry['month'] = 0;
  }
  else {
    list($month, $day) = bibParseMonth($entry['month']);
    $entry['month'] = $month;
  }

  if (getConfigSetting("CONVERT_LATINCHARS_IN") == "TRUE")
  	latinToBibCharsFromArray($entry);
  	
  $specialChars = "FALSE";
  if (findSpecialCharsInArray($entry))
  {
    $specialChars = "TRUE";
  }
  
  //addslashes to all entries, to avoid mysql problems with quotes in names etc
  addSlashesToArray($entry);
  
  //extract the user fields
  $userFields = array_diff(array_keys($entry), bibGetSupportedFields());
  $userFieldsText = "";
  foreach ($userFields as $field) {
    $userFieldsText.=$field."={".$entry[$field]."},";
  }
  
  $enteredBy = $_SESSION["personID"];
  $query = 'INSERT INTO publication (entered_by,year,title,bibtex_id,pub_type,type,survey,mark,';
  $query.= 'series,volume,publisher,location,issn,isbn,firstpage,lastpage,';
  $query.= 'journal,booktitle,number,institution,address,chapter,edition,';
  $query.= 'howpublished,month,organization,school,note,url,keywords, abstract, crossref, namekey, userfields, specialchars)';
  $query.= ' VALUES ("'.$enteredBy.'","'.$entry['year'].'","'.$entry['title'].'","'.$citeID.'","'.$entry['type'].'","'.ucfirst(strtolower($entry['bibtexEntryType'])).'","'.$entry['survey'].'","'.$entry['mark'].'",';
  $query.= '"'.$entry['series'].'","'.$entry['volume'].'","'.$entry['publisher'].'","'.$entry['location'].'","'.$entry['issn'].'","'.$entry['isbn'].'",'.$entry['firstpage'].','.$entry['lastpage'].',';
  $query.= '"'.$entry['journal'].'","'.$entry['booktitle'].'","'.$entry['number'].'","'.$entry['institution'].'","'.$entry['address'].'",'.$entry['chapter'].',"'.$entry['edition'].'",';
  $query.= '"'.$entry['howpublished'].'","'.$entry['month'].'","'.$entry['organization'].'","'.$entry['school'].'","'.$entry['note'].'","'.$entry['url'].'","'.$entry['keywords'].'","'.$entry['abstract'].'","'.$entry['crossref'].'","'.$entry['key'].'","'.$userFieldsText.'","'.$specialChars.'")';
  $res=mysql_query($query);
  $pub_id = mysql_insert_id();

  $error = mysql_error();
  if ($error != "") {
    //output error message
    echo "<div class=errormessage>There was an error while committing the following ".getBibtexSummary($entry)."<br/>(Insert publication failed)";
    echo "Please report this errormessage to your aigaion administrator.<br/>";
    echo $error."</div>";
    return -1;
  }

  //add to publicationauthor, for authors and editors
  if (sizeof($authorIDs) != 0) {
    $rank=1;
    foreach ($authorIDs as $authorID) {
      $result = mysql_query('INSERT INTO publicationauthor(pub_id, author, rank, is_editor) VALUES ('.$pub_id.', '.$authorID.', '.$rank.', "N")');

      $error = "";
      $error = mysql_error();
      if ($error != "") {
        //output error message
        echo "<div class=errormessage>There was an error while linking an author to ".getBibtexSummary($entry)."<br/>";
        echo "Please report this errormessage to your aigaion administrator.<br/>";
        echo $error."</div>";
        return -1;
      }

      $rank++;
    }
  }
  if (sizeof($editorIDs) != 0) {
    $rank=1;
    foreach ($editorIDs as $editorID) {
      $result = mysql_query('INSERT INTO publicationauthor(pub_id, author, rank, is_editor) VALUES ('.$pub_id.', '.$editorID.', '.$rank.', "Y")');

      $error = "";
      $error = mysql_error();
      if ($error != "") {
        //output error message
        echo "<div class=errormessage>There was an error while linking an editor to ".getBibtexSummary($entry)."<br/>";
        echo "Please report this errormessage to your aigaion administrator.<br/>";
        echo $error."</div>";
        return -1;
      }
      $rank++;
    }
  }

  $result = mysql_query('INSERT INTO topicpublication(topic_id, pub_id) VALUES ("1", '.$pub_id.')');
  $error = "";
  $error = mysql_error();
  if ($error != "") {
    //output error message
    echo "<div class=errormessage>There was an error while linking a topic to ".getBibtexSummary($entry)."<br/>";
    echo "Please report this errormessage to your aigaion administrator.<br/>";
    echo $error."</div>";
    return -1;
  }

  return $pub_id;
}
?>