<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file offers several functions to handle actions on multiple publications in Aigaion
  

publicationMultipleAddToTopic($pub_ids, $topic_id)
    $pub_ids is a comma separated string of publication IDs
    add the given publications to the topic and all of its ancestors
    
function publicationMultipleRemoveFromTopic($pub_ids, $topic_id)     
    $pub_ids is a comma separated string of publication IDs
    remove the given publications from the topic and all its children (!)
    
*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/actions/publicationactions.php");

function publicationMultipleAddToTopic($pub_ids, $topic_id) {
    $_SESSION["aigaionmessage"].="Adding publications (".$pub_ids.") to topic ".$topic_id."...<br/>";
    foreach (split(",",$pub_ids) as $next_pub) {
        publicationAddToTopic($next_pub, $topic_id);
    }
}

function publicationMultipleRemoveFromTopic($pub_ids, $topic_id) {
    $_SESSION["aigaionmessage"].="Removing publications (".$pub_ids.") from topic ".$topic_id."...<br/>";
    foreach (split(",",$pub_ids) as $next_pub) {
        publicationRemoveFromTopic($next_pub, $topic_id);
    }
}
?>