<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file offers several functions to handle publications in Aigaion
  
  publicationUpdate($publicationArray, $updateCrossrefs = "N")
    updates the publication passed via $publicationArray
    
  publicationSubmit($publicationArray)
    submits the publication passed via $publicationArray
    returns new $pub_id, if successfull
    
  publicationAddMark($pub_id, $mark)
    sets the mark for $pub_id for the current user
    
  publicationUnread($pub_id)
    marks $pub_id as unread for the current user
    
  publicationDelete($pub_id)
    delete publication, remove all corresponding notes and marks, etc
    You cannot delete publications for which other people have stored reader notes.
    
  publicationAddToTopic($pub_id, $topic_id)
    add the given publication to the topic and all of its ancestors

  publicationRemoveFromTopic($pub_id, $topic_id)
    remove the given publication from the topic and all its children (!)
    
*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage


function publicationUpdate($publicationArray, $updateCrossrefs = "N")
{
  global $FILEDIR, $DIR;
  include_once($DIR."lib/functions/specialcharfunctions.php");
  
  stripHtmlEntitiesFromArray($publicationArray);
  
  if (getConfigSetting("CONVERT_LATINCHARS_IN") == "TRUE")
  	latinToBibCharsFromArray($publicationArray);
  	
  $specialChars = "FALSE";
  if (findSpecialCharsInArray($publicationArray))
  {
    $specialChars = "TRUE";
  }
  
  addSlashesToArray($publicationArray);
 
  $stop = 0;
  $pub_id = $publicationArray['pub_id'];
  
  if ($updateCrossrefs == "Y")
  {
    $Q = mysql_query("SELECT publication.bibtex_id FROM publication, publication as copy WHERE publication.pub_id=".$pub_id." AND publication.bibtex_id=copy.crossref");
    if (mysql_num_rows($Q) > 0)
    {
      $R = mysql_fetch_array($Q);
      if ($R['bibtex_id']!= stripslashes($publicationArray['bibtexCitation']))
      {
        $Q = mysql_query("UPDATE publication SET crossref='".$publicationArray['bibtexCitation']."' WHERE crossref='".$R['bibtex_id']."'");
        if (mysql_error()) 
        {
          $_SESSION["aigaionerror"] .= "publicationUpdate: ".mysql_error()."<br/>";
        }
        else
        {
          $_SESSION["aigaionmessage"].= "Crossreferences updated.<br/>";
        }
      }
    }
  }

  $query = "UPDATE publication SET ";
  $query .= "entered_by='".$publicationArray['enteredby']."', ";
  $query .= "year='".$publicationArray['year']."', ";
  $query .= "title='".$publicationArray['title']."', ";
  $query .= "bibtex_id='".$publicationArray['bibtexCitation']."', ";
  $query .= "pub_type='".$publicationArray['type']."', ";
  $query .= "type='".$publicationArray['bibtexEntryType']."', ";
  $query .= "series='".$publicationArray['series']."', ";
  $query .= "volume='".$publicationArray['volume']."', ";
  $query .= "publisher='".$publicationArray['publisher']."', ";
  $query .= "location='".$publicationArray['location']."', ";
  $query .= "issn='".$publicationArray['issn']."', ";
  $query .= "isbn='".$publicationArray['isbn']."', ";
  if ($publicationArray['firstpage'] && ($publicationArray['firstpage']!="") ) 
    $query .= "firstpage=".$publicationArray['firstpage'].", ";
  if ($publicationArray['lastpage'] && ($publicationArray['lastpage']!="") )
    $query .= "lastpage=".$publicationArray['lastpage'].", ";
  $query .= "journal='".$publicationArray['journal']."', ";
  $query .= "booktitle='".$publicationArray['booktitle']."', ";
  $query .= "number='".$publicationArray['number']."', ";
  $query .= "institution='".$publicationArray['institution']."', ";
  $query .= "address='".$publicationArray['address']."', ";
  if ($publicationArray['chapter'] && ($publicationArray['chapter']!="") )
    $query .= "chapter=".$publicationArray['chapter'].", ";
  $query .= "edition='".$publicationArray['edition']."', ";
  $query .= "howpublished='".$publicationArray['howpublished']."', ";
  $query .= "month='".$publicationArray['month']."', ";
  $query .= "organization='".$publicationArray['organization']."', ";
  $query .= "school='".$publicationArray['school']."', ";
  $query .= "note='".$publicationArray['note']."', ";
  $query .= "url='".$publicationArray['url']."', ";
  $query .= "keywords='".$publicationArray['keywords']."', ";
  $query .= "abstract='".$publicationArray['abstract']."', ";
  $query .= "crossref='".$publicationArray['crossref']."', ";
  $query .= "namekey='".$publicationArray['namekey']."', ";
  $query .= "userfields='".$publicationArray['userfields']."', ";
  $query .= "specialchars='".$specialChars."' ";
  $query .= "WHERE pub_id=".$pub_id." ";
  
  $Q = mysql_query($query);
  if (mysql_error()) 
  {
    
    $_SESSION["aigaionerror"].= "publicationUpdate: ".mysql_error()."<br/>";
    $_SESSION["aigaionerror"].= $query;
  }

  if (!$Q)
    $stop = 1;
    
  //delete old authors
  if ($stop == 0)
  {
    $Q = mysql_query("DELETE FROM publicationauthor WHERE pub_id='".$pub_id."'");
   if (mysql_error()) {
     $_SESSION["aigaionerror"].= "publicationUpdate: ".mysql_error()."<br/>";
    }
    if (!$Q) //An error occurred. Show error message, then skip the rest.
       $stop=1;
  }
  //add authors again
  if ($stop == 0)
  {
    $rank=1;
    $author = strtok($publicationArray['authors'],",");
    while ($author)
    {
      $Q = mysql_query("INSERT INTO publicationauthor (pub_id, author, rank, is_editor) VALUES ('".$pub_id."','".$author."','".$rank."','N')");
        if (mysql_error()) 
        {
          $_SESSION["aigaionerror"].= "publicationUpdate: ".mysql_error()."<br/>";
        }
      $author = strtok(",");
      $rank+=1;
    }
    if (!$Q) //An error occurred. Show error message, then skip the rest.
      $stop=1;
  }


  //add editors
  if ($stop == 0)
  {
    $rank=1;
    $editor = strtok($publicationArray['editors'],",");
    while ($editor)
    {
      $Q=mysql_query("INSERT INTO publicationauthor (pub_id, author, rank, is_editor) VALUES ".
      "('".$pub_id."','".$editor."','".$rank."','Y')");
        if (mysql_error()) 
        {
          $_SESSION["aigaionerror"].= "publicationUpdate: ".mysql_error()."<br/>";
        }

      $editor = strtok(",");
      $rank+=1;
    }

    if (!$Q) //An error occurred. Show error message, then skip the rest.
      $stop=1;
  }



  if ($stop == 0)
  {
    $_SESSION["aigaionmessage"].= "Publication updated.<br/>";
  }
}

function publicationSubmit($publicationArray)
{
  global $FILEDIR, $DIR;
  include_once($DIR."lib/functions/specialcharfunctions.php");
  
  stripHtmlEntitiesFromArray($publicationArray);
  
  if (getConfigSetting("CONVERT_LATINCHARS_IN") == "TRUE")
  	latinToBibCharsFromArray($publicationArray);
  
  $specialChars = "FALSE";
  if (findSpecialCharsInArray($publicationArray))
  {
    $specialChars = "TRUE";
  }
  
  addSlashesToArray($publicationArray);
   
  $stop = 0;
  if ($publicationArray['mark'] == "")
  $publicationArray['mark'] = 5;

  if ($publicationArray['firstpage'] == "")
  $publicationArray['firstpage'] = 0;

  if ($publicationArray['lastpage'] == "")
  $publicationArray['lastpage'] = 0;

  if ($publicationArray['chapter'] == "")
  $publicationArray['chapter'] = 0;

  if ($publicationArray['specialchars'] == "")
  $publicationArray['specialchars'] = "FALSE";

  $query = "INSERT INTO publication (entered_by,year,title,bibtex_id,pub_type,type,mark,";
  $query .= "series,volume,publisher,location,issn,isbn,firstpage,lastpage,";
  $query .= "journal,booktitle,number,institution,address,chapter,edition,";
  $query .= "howpublished,month,organization,school,note,url,keywords,abstract,";
  $query .= "crossref,namekey,userfields,specialchars)";
  $query .= " VALUES ('".$publicationArray['enteredby']."','".$publicationArray['year']."','".$publicationArray['title']."','".$publicationArray['bibtexCitation']."','".$publicationArray['type']."','".$publicationArray['bibtexEntryType']."','".$publicationArray['mark']."',";
  $query .= "'".$publicationArray['series']."','".$publicationArray['volume']."','".$publicationArray['publisher']."','".$publicationArray['location']."','".$publicationArray['issn']."','".$publicationArray['isbn']."','".$publicationArray['firstpage']."','".$publicationArray['lastpage']."',";
  $query .= "'".$publicationArray['journal']."','".$publicationArray['booktitle']."','".$publicationArray['number']."','".$publicationArray['institution']."','".$publicationArray['address']."','".$publicationArray['chapter']."','".$publicationArray['edition']."',";
  $query .= "'".$publicationArray['howpublished']."','".$publicationArray['month']."','".$publicationArray['organization']."','".$publicationArray['school']."','".$publicationArray['note']."','".$publicationArray['url']."','".$publicationArray['keywords']."','".$publicationArray['abstract']."',";
  $query .= "'".$publicationArray['crossref']."','".$publicationArray['namekey']."','".$publicationArray['userfields']."','".$specialChars."')";
  
  $Q = mysql_query($query);
  if (mysql_error()) 
  {
    $_SESSION["aigaionerror"].= "publicationSubmit: ".mysql_error()."<br/>";
  }
  $pub_id = mysql_insert_id();
  
  if (!$Q)
    $stop = 1;

  //add authors
  if ($stop == 0)
  {
    $rank=1;
    $author = strtok($publicationArray['authors'],",");
    while ($author)
    {
      $Q = mysql_query("INSERT INTO publicationauthor (pub_id, author, rank, is_editor) VALUES ".
      "('".$pub_id."','".$author."','".$rank."','N')");
      $author = strtok(",");
      $rank+=1;
    }
   
    if (mysql_error()) 
    {
      $_SESSION["aigaionerror"].= "publicationSubmit: ".mysql_error()."<br/>";
    }
    if (!$Q) //An error occurred. Show error message, then skip the rest.
      $stop=1;
  }


  //add editors
  if ($stop == 0)
  {
    $rank=1;
    $editor = strtok($publicationArray['editors'],",");
    while ($editor)
    {
      $Q = mysql_query("INSERT INTO publicationauthor (pub_id, author, rank, is_editor) VALUES ".
      "('".$pub_id."','".$editor."','".$rank."','Y')");

      $editor = strtok(",");
      $rank+=1;
    }
    if (mysql_error()) 
    {
      $_SESSION["aigaionerror"].= "publicationSubmit: ".mysql_error()."<br/>";
    }
    if (!$Q) //An error occurred. Show error message, then skip the rest.
      $stop=1;
  }

  //assign to topic 1
  $Q = mysql_query("INSERT INTO topicpublication (topic_id, pub_id) VALUES (1, ".$pub_id.")");
  
  if (mysql_error()) 
  {
    $_SESSION["aigaionerror"].= "publicationSubmit: ".mysql_error()."<br/>";
  }
  
  if ($stop == 0)
  {
    $_SESSION["aigaionmessage"].= "Publication added.<br/>";
    return $pub_id;
  }
  else 
  {
    return -1;
  }
}

function publicationAddMark($pub_id, $mark)
{
  checkRights("COMMENT");
  $person_id = $_SESSION['personID'];

  $Q = mysql_query("DELETE FROM personpublicationmark WHERE pub_id=".$pub_id." AND person_id=".$person_id);
  if ($mark!="")
  {
    $Q = mysql_query("INSERT IGNORE INTO personpublicationmark (pub_id,person_id,mark,`read`) VALUES (".$pub_id.", ".$person_id.", ".$mark.", 'y') ");
  }
  else
  {
    $Q = mysql_query("INSERT IGNORE INTO personpublicationmark (pub_id,person_id,mark, `read`) VALUES (".$pub_id.", ".$person_id.", -1, 'y') ");
  }

  //Re-calculate mean mark
  $Q = mysql_query("SELECT * FROM personpublicationmark WHERE pub_id=".$pub_id." AND mark > 0");

  $markSum = 0;
  $markCount = mysql_num_rows($Q);
  while ($R = mysql_fetch_array($Q))
  {
    $markSum += $R['mark'];
  }
  if ($markCount > 0)
  {
    $markNew = round($markSum / $markCount);
  }
  else
  {
    $markNew = 5;
  }

  $Q = mysql_query("UPDATE publication SET mark = ".$markNew." WHERE pub_id=".$pub_id);
}

function publicationUnread($pub_id)
{
  checkRights("COMMENT");
  $person_id = $_SESSION['personID'];

  $Q = mysql_query("DELETE FROM personpublicationmark WHERE pub_id=".$pub_id." AND person_id=".$person_id);

  //Re-calculate mean mark
  $Q = mysql_query("SELECT * FROM personpublicationmark WHERE pub_id=".$pub_id." AND mark > 0");

  $markSum = 0;
  $markCount = mysql_num_rows($Q);
  while ($R = mysql_fetch_array($Q))
  {
    $markSum += $R['mark'];
  }
  if ($markCount > 0)
  {
    $markNew = round($markSum / $markCount);
  }
  else
  {
    $markNew = 5;
  }

  $Q = mysql_query("UPDATE publication SET mark = ".$markNew." WHERE pub_id=".$pub_id);
}

function publicationDelete($pub_id) {
    global $DIR;
    include_once($DIR."lib/actions/attachmentactions.php");
    
    if (!haveRights("EDIT")) {
        $_SESSION["aigaionerror"].="Sorry, you are not allowed to delete publications.<br/>";
        return;
    }
    #check if anybody else has stored notes for this publication (because then you cannot delete it)
    $countOtherNote = mysql_fetch_array(mysql_query("SELECT COUNT(*) FROM personpublicationnote WHERE pub_id=$pub_id AND NOT (person_id=".$_SESSION["personID"].")"));
    if ($countOtherNote[0] > 0) {
        $_SESSION["aigaionerror"].="Error deleting publication: you cannot delete this publication because somebody else has stored reader notes for it.<br/>";
        $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
        return;
    }
    
    #Check for refering publications, but only if crossref not empty
    $Q = mysql_query("SELECT crosspub.* FROM publication AS crosspub, publication AS curentpub WHERE curentpub.pub_id=$pub_id AND crosspub.crossref = curentpub.bibtex_id AND NOT curentpub.bibtex_id=''");
    if (mysql_num_rows($Q) > 0)
    {
        $_SESSION["aigaionerror"].="Error deleting publication: you cannot delete this publication because there are the following references to this publication:<br/>";
        while ($R = mysql_fetch_array($Q))
        {
            $_SESSION["aigaionerror"].="<A HREF='index.php?page=publication&kind=single&ID=".$R["pub_id"]."'>".$R["title"]."</a><br/>";
        }
        $_SESSION["aigaionerror"].="Please delete them first.";
        return;
    }
    
    
    
    #possibly: check other things such as whether somebody else had any notes attached to this publication?
    //not implemented... but maybe we want to reconsider this.
    #delete is OK: 
    #remove all corresponding attachments
    $res = mysql_query("SELECT * FROM publicationfile WHERE pub_id=$pub_id");
    if ($res) { //get all attachments, delete each
        while ($row = mysql_fetch_array($res)) {
            //try to delete next attachment...
            attachmentDelete($row["pub_id"],$row["location"]);
            //feedback if fail...
        }
    }
    #remove all corresponding personpublicationmarks
    $res = mysql_query("DELETE FROM personpublicationmark WHERE pub_id=$pub_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting publication, couldn't remove publicationmarks.<br/>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
        $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
        return;
    }
    #remove all corresponding notes
    $res = mysql_query("DELETE FROM personpublicationnote WHERE pub_id=$pub_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting publication, couldn't remove reader notes.<br/>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
        $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
        return;
    }
    #remove from topics
    $res = mysql_query("DELETE FROM topicpublication WHERE pub_id=$pub_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting publication, couldn't remove publication from topics.<br/>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
        $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
        return;
    }
    #remove from authors
    $res = mysql_query("DELETE FROM publicationauthor WHERE pub_id=$pub_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting publication, couldn't remove publication from authors.<br/>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
        $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
        return;
    }
    #remove publication itself
    $res = mysql_query("DELETE FROM publication WHERE pub_id=$pub_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting publication.<br/>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
        $_SESSION["aigaionerror"].="Publication: ".$pub_id."<br/>";
        return;
    }
    $_SESSION["aigaionerror"].="Publication deleted.<br/>";
}

function publicationAddToTopic($pub_id, $topic_id) {
    
    global $DIR;
    include_once($DIR."treefunctions.php");
    
    //add the given publication to the topic and all of its ancestors
    //find parents
    $allTopics = makeTopicArray($topic_id);
    foreach ($allTopics as $oneTopic) {
        #add to each topic
         // ignore due to makeTopicArray
        $res=mysql_query("INSERT IGNORE INTO topicpublication (pub_id, topic_id) VALUES ('$pub_id','$oneTopic')");             
        if (mysql_error()) {
            $_SESSION["aigaionerror"].="Error adding publication $pub_id to topic $oneTopic.<br/>";
            $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
            return;
        }
    }
}

function publicationRemoveFromTopic($pub_id, $topic_id) {
    //remove the given publication from the topic and all its children (!)
    //remove publication from topic 
    $res = mysql_query("DELETE FROM topicpublication WHERE topic_id=$topic_id AND pub_id=$pub_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting publication $pub_id from topic $topic_id.<br/>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br/>";
        return;
    }
    //call recursively for all children
    $res = mysql_query("SELECT * FROM topictopiclink WHERE target_topic_id=$topic_id");
    if ($res) {
        while ($row=mysql_fetch_array($res)) {
            publicationRemoveFromTopic($pub_id, $row["source_topic_id"]);
        }
    }
}


?>