<?php
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/*
====================================================================================================
ACTION RELATED FUNCTIONS (database changing)
====================================================================================================

Adding and removing topics, changing main topic information
    topicAdd($parent,$name,$description,$url="")     
        | checkRights("EDIT");
        add topic, 
        subscribe current user to new topic
    topicDelete($topic_id)  
        | checkRights("EDIT");   furthermore, topic should have no children
        Only admins can remove topics to which other users are subscribed.
        unsubscribe everybody from topic
        remove links from publications to this topic
        delete topic
    topicChange($topic_id,$parent,$removepubsfromoldancestors,$name,$description,$url) 
        | checkRights("EDIT");  
        modify contents of topic
    topicSetParent($topic_id,$parent) 
        | checkRights("EDIT");  
        give topic new parent
        change membership of publications to reflect new tree structure (are there different strategies for this?)
        
Collapsing and expanding
    topicSetCollapsed($topic_id, $person_id, $collapsed) 
        Has no influence on collapsed status of children
        
Subscription
    topicSubscribe($topic_id, $person_id)
        If you subscribe, you also subscribe to any ancestors.
    topicSubscribeRecursive($topic_id, $person_id)
        If you subscribe, you also subscribe to any ancestors.
    topicUnsubscribe($topic_id, $person_id)   
        is always recursive downwards (to children)
        unsubscribe from root is ignored.
    topicSetStarred($topic_id,$person_id,$starred)
        star values are related to the subscription of separate users to a topic.
        starred means also subscribed!
    topicUnsubscribeRemaining($person_id)
        unsubscribe given person from all topics that were not yet decided
*/

include_once($DIR."lib/functions/topicfunctions.php");

function topicAdd($parent,$name,$description,$url="") {   
    $success=True;
    if (!haveRights("EDIT")) {
        $_SESSION["aigaionerror"].="Sorry, you are not allowed to add topics.<br>";
        return;
    }
    #add topic
    $query="INSERT INTO topic (name, description,url) VALUES ('".addslashes($name)."', '".addslashes($description)."', '".addslashes($url)."');";
	$res=mysql_query($query);
	$newID=mysql_insert_id();
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error adding topic.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
        $success=False;
    }     	
    #add topictopiclink to parent
    $query="INSERT INTO topictopiclink (source_topic_id, target_topic_id) VALUES ($newID, $parent);";
	$res=mysql_query($query);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error adding topic: adding parent-link failed.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
        $success=False;
    }     	
    #if user was up to date with topic review, set lastreviewedtopic
    //automatic increase of topicread
    $res=mysql_query("SELECT MAX(ID) FROM topic");
    if ($res) {
        $row = mysql_fetch_array($res);
        $highestID = $row["MAX(ID)"];
        $res2 = mysql_query("SELECT lastreviewedtopic FROM person WHERE ID='".$_SESSION["personID"]."'");
        if ($res2) {
            $row2 = mysql_fetch_array($res2);
            $lastreviewedtopic=$row2[0];
            if ($lastreviewedtopic == ($highestID - 1)) { //the user was up-to-date
                $res3 = mysql_query("UPDATE person SET lastreviewedtopic='".$highestID."' WHERE ID='".$_SESSION["personID"]."'");
            }
        }
    }
	#subscribe current user to new topic
	$query="INSERT INTO persontopic (person_id,topic_id,star) VALUES (".$_SESSION["personID"].",$newID,0)";
    $res=mysql_query($query);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error adding topic: subscribe current user failed.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
        $success=False;
    } 
    if($success)$_SESSION["aigaionmessage"].="Topic added to parent $parent.<br>";
}
        
function topicDelete($topic_id) {
    $success = True;
    //$_SESSION["aigaionmessage"].="Deleting topic...";
    if (!haveRights("EDIT")) {
        $_SESSION["aigaionerror"].="Sorry, you are not allowed to delete topics.<br>";
        return;
    }
    #check children. Topics with children cannot be deleted
    $row = mysql_fetch_array(mysql_query("SELECT COUNT(*) FROM topictopiclink WHERE topictopiclink.target_topic_id=".$topic_id.""));
    if ($row[0]>0) {    
        $_SESSION["aigaionerror"].="You cannot delete topics that still have children.<br>";
        return;
    }
    $row = mysql_fetch_array(mysql_query("SELECT COUNT(*) FROM persontopic WHERE topic_id=".$topic_id." AND person_id!=".$_SESSION['personID']));
    if (($row[0] > 0) && (!haveRights("USERCHANGE"))){    
        $_SESSION["aigaionerror"].="There are still other users subscribed to this topic. Only Administrators have the right to delete topics that other users are subscribed to. Please ask your administrator to remove the topic.<br>";
        return;
    }
    #delete is OK: unsubscribe everybody from topic
    $res = mysql_query("DELETE FROM persontopic WHERE topic_id=$topic_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting topic: unsubscribe failed.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Topic: ".$topic_id."<br>";
        $success=False;
    }
    //$_SESSION["aigaionmessage"].="Unsubscribed everyone...";
    #remove links from publications to this topic
    $res = mysql_query("DELETE FROM topicpublication WHERE topic_id=".$topic_id."");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting topic: removing topic-publication links failed.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Topic: ".$topic_id."<br>";
        $success=False;
    }     
    #remove links from other topics to this topic
    $res = mysql_query("DELETE FROM topictopiclink WHERE source_topic_id=$topic_id OR target_topic_id=$topic_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting topic: removing topic-topic links failed.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Topic: ".$topic_id."<br>";
        $success=False;
    }     
    #delete topic
    $res = mysql_query("DELETE FROM topic WHERE ID=$topic_id");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting topic.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Topic: ".$topic_id."<br>";
        $success=False;
    }     
    #check lastreviewedtopic: if larger than max id, we just deleted the largest topic, and must therefore
    #update the lastreviewedtopic values...
    $row = mysql_fetch_array(mysql_query("SELECT MAX(ID) from topic"));
    $MAXTOPIC = $row["MAX(ID)"];
    $res = mysql_query("UPDATE person SET lastreviewedtopic=".$MAXTOPIC." WHERE lastreviewedtopic>".$MAXTOPIC);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error deleting topic: couldn't correct lastreviewedtopic values.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Topic: ".$topic_id."<br>";
        $success=False;
    }     
    if($success)$_SESSION["aigaionmessage"].="Topic deleted.<br>";
}

function topicChange($topic_id,$parent,$removepubsfromoldancestors,$name,$description,$url) {
    $success=True;
    if (!haveRights("EDIT")) {
        $_SESSION["aigaionerror"].="Sorry, you are not allowed to delete topics.<br>";
        return;
    }
    #modify contents of topic
	$query="UPDATE topic SET name='".addslashes($name)."', description='".addslashes($description)."', url='".addslashes($url)."' WHERE ID=$topic_id";
    $res=mysql_query($query);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error changing topic.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
        $success=False;
    } 
    #set parent
    topicSetParent($topic_id,$parent,$removepubsfromoldancestors);
    if($success)$_SESSION["aigaionmessage"].="Topic changed.<br>";
}


function topicSetParent($topic_id,$parent,$removepubsfromoldancestors) {
    if (!haveRights("EDIT")) {
        $_SESSION["aigaionerror"].="Sorry, you are not allowed to delete topics.<br>";
        return;
    }
    
    global $DIR;
    include_once($DIR."lib/actions/publicationactions.php");
    
    #give topic new parent
    $query="UPDATE topictopiclink SET target_topic_id=$parent WHERE source_topic_id=$topic_id;";
	  $res=mysql_query($query);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error changing topic: could not set parent.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
        $success=False;
    }     	
    #change membership of publications to reflect new tree structure (are there different strategies for this?)
    //get all publications that are member of $topic_id
    $publications = mysql_query("SELECT publication.pub_id FROM publication, topicpublication WHERE topicpublication.pub_id=publication.pub_id AND topicpublication.topic_id=".$topic_id);
    if ($publications) {
        while ($publication = mysql_fetch_array($publications)) {
            if ($removepubsfromoldancestors=="TRUE") {
                //remove publications from this topic's ancestors
                //not yet implemented.
                //$oldparent = remember old parent of topic; 
                //go through old ancestors; for each: remove publication if it is not top and has no 
                //*other* child topics with the publication a member.
            }
            //always add these publications to this topic again (so they will also become member of 
            //ancestors)
            publicationAddToTopic($publication["pub_id"],$topic_id);
        }
    }
    
    
}

function topicSetCollapsed($topic_id, $person_id, $collapsed) {
    $query = "UPDATE persontopic SET ";
    if ($collapsed>0) {
         $query = $query."collapsed='1' ";
    } else {
         $query = $query."collapsed='0' ";
    }
    $query = $query."WHERE topic_id='$topic_id' and person_id='$person_id';";
    $res = mysql_query($query);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error (un)collapsing topic.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
    }
}    

function topicSubscribe($topic_id, $person_id) {
    $query = "SELECT COUNT(*) FROM persontopic WHERE topic_id='$topic_id' and person_id='$person_id'";
    $res = mysql_fetch_array(mysql_query($query));
    if ($res[0]<=0) {
        //create row with default value
        $query2="INSERT INTO persontopic (topic_id,person_id,collapsed,star) VALUES ($topic_id,$person_id,1,0)";
        $res2=mysql_query($query2);
        if (mysql_error()) {
            $_SESSION["aigaionerror"].="Error subscribing topic.<br>";
            $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
            $_SESSION["aigaionerror"].="Topic: ".$topic_id.". User: ".$person_id."<br>";
        }    
        //fix supertopics: subscribe to parent if not yet subscribed to parent...
        $res2 = mysql_query("SELECT topictopiclink.target_topic_id FROM topictopiclink WHERE topictopiclink.source_topic_id='".$topic_id."'");
        if ($res2) {
            while ($row=mysql_fetch_array($res2)) {
                topicSubscribe($row["target_topic_id"],$person_id);
            }
        }
    }
}
function topicSubscribeRecursive($topic_id, $person_id) {
    // ==1== subscribe to this topic, and check its ancestors
    $query = "SELECT COUNT(*) FROM persontopic WHERE topic_id='$topic_id' and person_id='$person_id'";
    $res = mysql_fetch_array(mysql_query($query));
    if ($res[0]<=0) {
        //create row with default value
        $query2="INSERT INTO persontopic (topic_id,person_id,collapsed,star) VALUES ($topic_id,$person_id,1,0)";
        $res2=mysql_query($query2);
        if (mysql_error()) {
            $_SESSION["aigaionerror"].="Error subscribing topic.<br>";
            $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
            $_SESSION["aigaionerror"].="Topic: ".$topic_id.". User: ".$person_id."<br>";
        }    
        //fix supertopics: subscribe to parent if not yet subscribed to parent...
        $res2 = mysql_query("SELECT topictopiclink.target_topic_id FROM topictopiclink WHERE topictopiclink.source_topic_id='".$topic_id."'");
        if ($res2) {
            while ($row=mysql_fetch_array($res2)) {
                topicSubscribe($row["target_topic_id"],$person_id);
            }
        }
    }
    // ==2== subscribe recursive to any children
    $res2 = mysql_query("SELECT topictopiclink.source_topic_id FROM topictopiclink WHERE topictopiclink.target_topic_id='".$topic_id."'");
    if ($res2) {
        while ($row=mysql_fetch_array($res2)) {
            topicSubscribeRecursive($row["source_topic_id"],$person_id);
        }
    }
}
function topicUnsubscribe($topic_id, $person_id) {
    if ($topic_id==getTopTopic())return;
    $res = mysql_query("DELETE FROM persontopic WHERE topic_id='$topic_id' and person_id='$person_id'");
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error unsubscribing topic.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Topic: ".$topic_id.". User: ".$person_id."<br>";
    }    
    //fix subtopics: unsubscribe from all children to which user was subscribed
    $res2 = mysql_query("SELECT topictopiclink.source_topic_id FROM persontopic, topictopiclink WHERE persontopic.person_id='".$person_id."' AND topictopiclink.target_topic_id='".$topic_id."' AND persontopic.topic_id=topictopiclink.source_topic_id");
    if ($res2) {
        while ($row=mysql_fetch_array($res2)) {
            topicUnsubscribe($row["source_topic_id"],$person_id);
        }
    }
}
function topicSetStarred($topic_id, $person_id, $starred) {
    topicSubscribe($topic_id, $person_id);
	$query="UPDATE persontopic SET star=$starred WHERE person_id=$person_id AND topic_id=$topic_id";
    $res=mysql_query($query);
    if (mysql_error()) {
        $_SESSION["aigaionerror"].="Error changing starred-value of topic.<br>";
        $_SESSION["aigaionerror"].="Error: ".mysql_error()."<br>";
        $_SESSION["aigaionerror"].="Query: ".$query."<br>";
    } 
}

function topicUnsubscribeRemaining($person_id) {
    $res = mysql_query("SELECT MAX(ID) FROM topic");
    $row=mysql_fetch_array($res);
    $res2 = mysql_query("UPDATE person SET lastreviewedtopic='".$row["MAX(ID)"]."' WHERE ID='".$person_id."'");
}

?>