<?php
require_once ($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/*
====================================================================================================
DISPLAY RELATED FUNCTIONS (non-edit)
====================================================================================================
This file offers several functions to display basic information about an attachment.
Each function returns a string, which can then be processed as the caller sees fit.
It is up to the caller to choose the most efficient series of function calls to 
achieve a certain goal.

- getAttachmentDownloadLinkByID($pub_id, $location, $linkText="")
- getAttachmentDownloadLink($pub_id, $location, $linkText="")

getLinkToAttAddPage($pub_id) 
getLinkToAttDeletePage

    //resulting link will set given attachment as main; set all other attachments of this publication as not-main
    getAttachmentSetMainLink($pub_id, $location, $return="")
    
    //resulting link will set given attachment as not-main
    getAttachmentUnsetMainLink($pub_id, $location, $return="")

*/


/* getAttachmentDownloadLinkByID($att_id) returns a link to the attachment. */
function getAttachmentDownloadLinkByID($pub_id, $location, $linkTitle='') {
    #get att from database
    $res = mysql_query("SELECT * FROM publicationfile WHERE pub_id=".$pub_id." AND location='".addslashes($location)."';");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getAttachmentDownloadLink($row, $linkTitle);
        }
    }
    #not successfull in finding att...
    $result = "<DIV class=errormessage>\nAttachment with pub-ID ".$pub_id." and location ".$location." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "\n</DIV>\n";
    return $result;
}

/*  getAttachmentDownloadLink($attachment_table_row, $linkTitle='') returns a link to the attachment. */
function getAttachmentDownloadLink($attachment_table_row, $linkText='') {
    global $URL,$DIR,$THEME;
    include_once($DIR."lib/functions/specialcharfunctions.php");
    
    if (!haveRights("PDF")) {
        return "";
    }
    quotesToHTMLFromString($linkText);
    $result = "";

    #open in new window?
    $personrow = mysql_fetch_array(mysql_query("SELECT newwindowforatt FROM person WHERE ID=".$_SESSION["personID"]));
    $target="_top";
    if ($personrow["newwindowforatt"] == "TRUE")
        $target="_blank";

    $title="Download ".addslashes($attachment_table_row["name"]);
    if ($attachment_table_row["isremote"]=="TRUE") {
        $result .= "\n<span alt='$title' title='$title' >";
        $result .= "<a target=".$target." href='".addslashes($attachment_table_row["location"])."'>";
        if ($linkText=="") {
            $icon="attachment";
            #get file type
            $extension=strtolower(substr(strrchr($attachment_table_row["location"],"."),1));
            #check existence of icon
            if (file_exists($DIR.$THEME."icons/".$icon."_".$extension.".gif"))$icon.="_".$extension;
            $icon.=".gif";
            $result .=  "<img border=0 src='".$URL.$THEME."icons/".$icon."' width=12 border=0>";
        } else {
            $result .=  $linkText;
        }
        $result .= "</a></span>";
    } else {
        $result .= "\n<span alt='$title' title='$title' >";
        $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' target=".$target." action='".$URL."indexempty.php'>";
        $result .= "\n<input type='hidden' name=page    value='actionattachment'>";
        $result .= "\n<input type='hidden' name=action    value='open'>";
        $result .= "\n<input type='hidden' name=pub_id  value='".$attachment_table_row["pub_id"]."'>";
        $result .= "\n<input type='hidden' name=location  value='".addslashes($attachment_table_row["location"])."'>";
        $result .= "\n<input type='hidden' name=return  value='".$return."'>";
        if ($linkText=="") {
            $icon="attachment";
            #get file type
            $extension=strtolower(substr(strrchr($attachment_table_row["location"],"."),1));
            #check existence of icon
            if (file_exists($DIR.$THEME."icons/".$icon."_".$extension.".gif"))$icon.="_".$extension;
            $icon.=".gif";
            $result .=  "\n<input class='noborder' type='image' src='".$URL.$THEME."icons/".$icon."' width=12 border=0>";
        } else {
            $result .=  "\n<input type='submit' value='".$linkText."'>";
        }
        $result .= "\n</form></span>";
    }
    return $result;
}

function getAttachmentEditLink($pub_id, $location, $return="") {
    global $URL,$DIR,$THEME;
    
    $active=True;
    if (!haveRights("EDIT")) {
        $active=false;
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result = "";

    $title="edit attachment note";
    if (!$active) {
        $title="cannot edit attachment note";
    }
    $result .= "\n<span alt='$title' title='$title' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='form'>";
    $result .= "\n<input type='hidden' name=type    value='attachment'>";
    $result .= "\n<input type='hidden' name=form    value='edit'>";
    $result .= "\n<input type='hidden' name=pub_id  value='".$pub_id."'>";
    $result .= "\n<input type='hidden' name=location  value='".addslashes($location)."'>";
    $result .= "\n<input type='hidden' name=return  value='".$return."'>";
    if ($active==True) {
        $result .= "\n<input class='noborder' type='image' src='".$URL.$THEME."icons/_edit_small.gif'>";
    } else {
        $result .= "\n<img border=0 src='".$URL.$THEME."icons/_edit_small.gif'>";
    }
    $result .= "\n</form></span>";
    return $result;
}

function getLinkToAttDeletePage($pub_id, $location, $return="") {
    global $URL,$THEME;
    $active=True;
    if (!haveRights("EDIT")) {
        $active=false;
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result = "";

    $title="delete attachment";
    if (!$active) {
        $title="cannot delete attachment";
    }
    $result .= "\n<span alt='$title' title='$title' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='form'>";
    $result .= "\n<input type='hidden' name=type    value='attachment'>";
    $result .= "\n<input type='hidden' name=form    value='delete'>";
    $result .= "\n<input type='hidden' name=pub_id  value='".$pub_id."'>";
    $result .= "\n<input type='hidden' name=location  value='".addslashes($location)."'>";
    $result .= "\n<input type='hidden' name=return  value='".$return."'>";
    if ($active==True) {
        $result .= "\n<input class='noborder' type='image' src='".$URL.$THEME."icons/_delete_small.gif'>";
    } else {
        $result .= "\n<img border=0 src='".$URL.$THEME."icons/_delete_small.gif'>";
    }
    $result .= "\n</form></span>";
    return $result;
}

function getLinkToAttAddPage($pub_id) {
    global $URL,$THEME;
    $result = "";
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];

    $result .= "\n<span alt='add attachment' title='add attachment' >";
    $result .= "<a href='".$URL."index.php?page=form&type=attachment&form=add&pub_id=$pub_id&return=".rawurlencode($return)."'>";
    $result .= "[Add a new attachment...]";
    $result .= "</a></span>";
    return $result;
}

function getAttachmentSetMainLink($pub_id, $location, $return="") {
    global $URL,$THEME;
    if (!haveRights("EDIT")) {
        return "";
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result = "";

    $result .= "\n<span alt='set as main file' title='set as main file' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='actionattachment'>";
    $result .= "\n<input type='hidden' name=action    value='setmain'>";
    $result .= "\n<input type='hidden' name=pub_id  value='".$pub_id."'>";
    $result .= "\n<input type='hidden' name=location  value='".addslashes($location)."'>";
    $result .= "\n<input type='hidden' name=return  value='".$return."'>";
    $result .= "\n<input type='submit' value='Set as main'>";
    $result .= "\n</form></span>";
    return $result;
}
function getAttachmentUnsetMainLink($pub_id, $location, $return="") {
    global $URL,$THEME;
    if (!haveRights("EDIT")) {
        return "";
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result = "";

    $result .= "\n<span alt='set as non-main file' title='set as non-main file' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='actionattachment'>";
    $result .= "\n<input type='hidden' name=action    value='unsetmain'>";
    $result .= "\n<input type='hidden' name=pub_id  value='".$pub_id."'>";
    $result .= "\n<input type='hidden' name=location  value='".addslashes($location)."'>";
    $result .= "\n<input type='hidden' name=return  value='".$return."'>";
    $result .= "\n<input type='submit' value='Set as non-main'>";
    $result .= "\n</form></span>";
    return $result;
}


?>