<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*

This file offers several functions to display authors in Aigaion
Each function returns a string that contains (parts of) a display.

  getEditorsForPublication($pub_id) 
  getAuthorsForPublication($pub_id)
    returns a formatted list of all editors / authors of a publication with given pub_id.
    Each displayed name links to the corresponding author page.
  
  getWritersForPublication($pub_id, $editor)
    returns a formatted list of all authors and/or editors for a publication.
    $editor = 'N' for authors, 'Y' for editors

  getAuthorList($type)
    will show a list of author names linked to author pages for all authors in the database,
    in an unordered list

  getAuthorListForTopic($topic_id) 
    will show a list of author names linked to author pages for all authors 
    in the database that publish on the given topic.
    When $topic_id == 0, all authors in the database are listed.

  getAuthorByID($author_id)
    gets a complete overview of the authors details and publications the author is related to.
    
  getLinkToAuthorPageFromRow($authorRow)
    gets the link to the author page.

  getLinkToAuthorEditPage($author_id, $size = "normal") {
    gets the link to the author edit page.

  getLinkToAuthorDeletePage($author_id, $size = "normal", $return="") {
    gets the link to the author delete page.

  getAuthorSearchJavaScript()
    get the javascript code to be included for the author search-box
*/

//if this script is not called from within one of the base pages, redirect to frontpage
require_once("checkBase.php");

function getEditorsForPubication($pub_id) 
{
  return getWritersForPublication($pub_id, 'Y');
}


function getAuthorsForPublication($pub_id) 
{
  return getWritersForPublication($pub_id, 'N');
}

function getWritersForPublication($pub_id, $editor = 'N') 
{
  $result = "";
  $Q = mysql_query("SELECT * FROM publicationauthor, author WHERE pub_id = ".$pub_id." AND is_editor='".$editor."' AND publicationauthor.author = author.ID ORDER by rank;");
  
  if ($Q) 
  {
    $authorNr = 1;
    $numAuthors = mysql_num_rows($Q);
    while($R = mysql_fetch_array($Q)) 
    {
      switch ($authorNr) 
      {
        case 1:
          break;
        
        case $numAuthors:
          $result.= " and ";
          break;
        
        default:
          $result.= ", ";
          break;
      }
      
      $authorNr++;
      
      $result .= getLinkToAuthorPageFromRow($R);
    }
    
    if (($editor == "Y") && ($numAuthors > 0)) 
    {
      $result .= " (eds), ";
    } 
    else if ($numAuthors > 0) 
    {
      $result.=", ";
    }
  }
  return $result;
}



function getAuthorList($type) 
{
  $result = "";
  switch ($type) {
    case "all":
      $result .= getAuthorListForTopic(0);  //this is an invalid topic_id, but displays all authors
      break;
    
    case "topic":
      $ID = "0";
      if (isset($_REQUEST["ID"])) {
        $ID = $_REQUEST["ID"];
      }
      $result .= getAuthorListForTopic($ID);
      break;
      
    default:
      break;
  }
  return $result;
}

function getAuthorListForTopic($topic_id) 
{
  global $DIR;
  include_once($DIR."lib/displays/topicdisplays.php");

  $result = "";
  if (!isset($topic_id))
  {
    return "<div class='errormessage'>An error occurred while fetching the topic id for listing authors. Please try again or ask your Aigaion administrator.</div>\n";
  }
  
  if ($topic_id == 0)
  {
    $result .= "<p class=header>All authors in the database</p>\n";
    
    $query = "SELECT * FROM author ORDER BY author.surname";
  }
  else
  {
    $Q = mysql_query("SELECT name from topic where ID=".$topic_id);
    $R = mysql_fetch_array($Q);
    
    $result .= "<p class=header>Authors that publish on ".getLinkToTopicPage($topic_id, $R['name'])."</p>";
    
    $query  = "SELECT DISTINCT author.* FROM topicpublication, publicationauthor, author WHERE";
    $query .= " topicpublication.topic_id = ".$topic_id." AND topicpublication.pub_id = publicationauthor.pub_id AND publicationauthor.author = author.ID";
    $query .= " GROUP BY author.ID ORDER BY author.surname ";
  }
     
    $result .= getAuthorSearchJavaScript($query);
    $result .= '<INPUT id="authorsearchinput" type=text onkeyup="AuthorSearch();" name=authorsearchinput size=50><BR>'."\n";

  
  $Q = mysql_query($query);
  
  $result .= "<ul type=\"none\">\n";
  
  while ($R = mysql_fetch_array($Q))
  {
    $result .= "<span id='authorsearch_".$R["ID"]."' name='authorsearch_".$R["ID"]."'><li>".getLinkToAuthorPageFromRow($R)."</li></span>\n";
  }
  $result .= "</ul>\n";
  
  return $result;
}

function getAuthorByID($author_id)
{
  global $URL, $DIR;
  include_once($DIR."lib/displays/publicationdisplays.php");
  include_once($DIR."lib/functions/authorfunctions.php");
  include_once($DIR."lib/functions/specialcharfunctions.php");

  $result = "";

  if ($author_id == "")
  {
    return "<div class='errormessage'>An error occurred while fetching the author ID. Please try again or ask your Aigaion administrator.</div>\n";
  }
  $Q = mysql_query("SELECT * FROM author WHERE ID = ".$author_id);
  $R = mysql_fetch_array($Q);
  
  $url = "";
  if ($R['url'] != "")
  {
    $url = htmlentities($R['url'],ENT_QUOTES);
    if (strpos($url,"http")===false) 
    {
      $url = 'http://'.$url;
    }
  }
  
  if ($R['specialchars'] == 'TRUE')
  {
    prettyPrintBibCharsFromArray($R);
  }
  quotesToHTMLFromArray($R);
  
  $result .= "<p class=header>".getPrettyNameFromRow($R)."&nbsp;&nbsp;&nbsp;&nbsp;";
  if (haveRights("EDIT")) {
    $result .= getLinkToAuthorEditPage($author_id)." ".getLinkToAuthorDeletePage($author_id, "normal", $URL);
  }
  $result .= "</p>";

  $result .= "<table class=vlist cellspacing='0'>";
  $result .= "<tr><td>Name:</td><td>".$R['name']."&nbsp;</td></tr>\n";
  $result .= "<tr><td>Surname:</td><td>".$R['surname']."&nbsp;</td></tr>\n";
  $result .= "<tr><td>Email:</td><td><a href=\"mailto:".$R['email']."\">".$R['email']."&nbsp;</td></tr>\n";
  $result .= "<tr><td>Institute:</td><td>".$R['institute']."&nbsp;</td></tr>\n";
  $result .= "<tr><td>Homepage:</td><td><a href=\"".$url."\">".$url."</a>&nbsp;</td></tr>\n";
  $result .= "</table>\n";
  $result .= "<br/><br/><br/><br/>";
  $result .= getPublicationList("author", $author_id);
  
  return $result;
}

function getLinkToAuthorPageFromRow($authorRow)
{
  global $DIR;
  include_once($DIR."lib/functions/authorfunctions.php");

  $result  = "";
  $result .= '<a href="index.php?page=author&kind=single&ID='.$authorRow["ID"].'">';
  $result .= getPrettyNameFromRow($authorRow);
  $result .= '</a>';
  return $result;
}

function getLinkToAuthorEditPage($author_id, $size = "normal") {
  global $URL,$THEME;
  $return  = rawurlencode($_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"]);  
  $result  = "";
  $result .= '<a class=small href="index.php?page=author&kind=edit&ID='.$author_id.'&return='.$return.'">';
  
  if ($size == "normal")
  {
    $result .= "<IMG SRC='".$URL.$THEME."icons/_edit.gif' border=0>";
  }
  else if ($size == "small")
  {
    $result .= "<IMG SRC='".$URL.$THEME."icons/_edit_small.gif' border=0>";
  }
  
  $result .= "</a>";

  return $result;
}

function getLinkToAuthorDeletePage($author_id, $size = "normal", $return="") {
  global $URL,$THEME;
  if ($return=="") {
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
  }
  
  $result  = "";
  $result .= '<a class=small href="index.php?page=author&kind=delete&ID='.$author_id.'&return='.rawurlencode($return).'">';
  
  if ($size == "normal")
  {
    $result .= "<IMG SRC='".$URL.$THEME."icons/_delete.gif' border=0>";
  }
  else if ($size == "small")
  {
    $result .= "<IMG SRC='".$URL.$THEME."icons/_delete_small.gif' border=0>";
  }
  
  $result .= "</a>";

  return $result;
}


function getAuthorSearchJavaScript($query)
{
    $retString = '';
    $retString .=  '<!-- Javascript for quick-searching the author list --> '."\n";
    $retString .=  '<SCRIPT LANGUAGE="JavaScript"> '."\n";
    //collect all author names indexed by ID
    $retString .=  'var AUTHORNAMES = { };'."\n";
    $Q = mysql_query($query);
    $retString .= mysql_error();
    while ($R = mysql_fetch_array($Q))
    {
    	$retString .= 'AUTHORNAMES['.$R["ID"].'] = "'.addslashes($R["surname"]).', '.addslashes($R["name"]).'";'."\n";    	
    }
    $retString .= 'function AuthorSearchEl(id) {'."\n";
    $retString .= '    return document.getElementById(id);'."\n";
    $retString .= '}'."\n";

    $retString .= 'function AuthorSearch()'."\n";
    $retString .= '{'."\n";
    $retString .= 'var searchtext = AuthorSearchEl("authorsearchinput").value;'."\n";
    $retString .= 'if (searchtext == "")'."\n";
    $retString .= '{'."\n";
    $retString .= '    for(a in AUTHORNAMES)'."\n";
    $retString .= '    {'."\n";        
    $retString .= '        AuthorSearchEl("authorsearch_"+a).className = \'expanded\';'."\n";    
    $retString .= '    }'."\n";
    $retString .= '}'."\n";
    $retString .= 'else'."\n";
    $retString .= '{'."\n";
    $retString .= '    for(a in AUTHORNAMES)'."\n";
    $retString .= '    {'."\n";
    $retString .= '        AuthorSearchEl("authorsearch_"+a).className = \'collapsed\';'."\n";        
    $retString .= '    }'."\n";
	$retString .= '    for(a in AUTHORNAMES)'."\n";
	$retString .= '    {'."\n";
	$retString .= '        var astring = new String(AUTHORNAMES[a]);'."\n";
	$retString .= '	    if (astring.toUpperCase().indexOf(searchtext.toUpperCase()) != -1)'."\n";
	$retString .= '	    {'."\n";
	$retString .= '        AuthorSearchEl("authorsearch_"+a).className = \'expanded\';'."\n";        
    $retString .= '	    }'."\n";        
	$retString .= '	}'."\n";
    $retString .= '}'."\n";
    $retString .= '}'."\n";
    
    $retString .= '</SCRIPT>'."\n";
    return $retString;
}

?>