<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to export publications to BibTeX
Each function returns a string.

    getBibtexByID($pub_id)
      returns the bibtex code for one single publication
      
    getBibtexLinkByID($pub_id)
      returns a link to the bibtex of the publication with the selected pub_id

    getTopicBibtexLinkByID($topic_id)
      returns a link to the bibtex of a topic with the selected topic_id
      
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

function getBibtexByID($pub_id)
{
  $result = "";
  
  return $result;
}

function getBibtexLinkByID($pub_id, $type = "image")
{
  global $URL, $THEME;
  $result = "";
  $result .= "<a target='_blank' HREF=".$URL."indexlight.php?page=perbibtex&ID=".$pub_id.">";
  if ($type == "image")
  {
    $result .= "<IMG SRC=\"".$URL.$THEME."icons/_bibtex_small.gif\" border=0>";
  }
  else if ($type == "text")
  {
    $result .= "BibTeX";
  }
  $result .= "</a>";
  
  return $result;
}

function getTopicBibtexLinkByID($topic_id, $type = "image")
{
  global $URL, $THEME;
  $result = "";
  $result .= "<a target='_blank' HREF=".$URL."indexlight.php?page=perbibtex&type=topic&topic_id=".$topic_id.">";
  if ($type == "image")
  {
    $result .= "<IMG SRC=\"".$URL.$THEME."icons/_bibtex_small.gif\" border=0>";
  }
  else if ($type == "text")
  {
    $result .= "BibTeX";
  }
  $result .= "</a>";
  
  return $result;
}

function getRISLinkByID($pub_id, $type = "image")
{
  global $URL, $THEME;
  $result = "";
  $result .= "<a target='_blank' HREF=".$URL."indexlight.php?page=perbibtex&format=ris&ID=".$pub_id.">";
  if ($type == "image")
  {
    $result .= "<IMG SRC=\"".$URL.$THEME."icons/_ris_small.jpg\" border=0>";
  }
  else if ($type == "text")
  {
    $result .= "RIS";
  }
  $result .= "</a>";
  
  return $result;
}

function getTopicRISLinkByID($topic_id, $type = "image")
{
  global $URL, $THEME;
  $result = "";
  $result .= "<a target='_blank' HREF=".$URL."indexlight.php?page=perbibtex&format=ris&type=topic&topic_id=".$topic_id.">";
  if ($type == "image")
  {
    $result .= "<IMG SRC=\"".$URL.$THEME."icons/_ris_small.jpg\" border=0>";
  }
  else if ($type == "text")
  {
    $result .= "RIS";
  }
  $result .= "</a>";
  
  return $result;
}
?>