<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to import publications into Aigaion
Each function returns a string.

    getBibtexSummary($entry)
      returns a formatted summary of the bibtex entry.
      $entry must be a single entry, as parsed by the bibliophile bibtex parser.
      
    getSimilarityWarnings($entry, $entryNr)
      returns a <div class=errormessage> with warnings if there are similar publications in the database.
      If no similar publications are found, an empty string is returned.
        
    getPublicationSummariesByRows($rowArray)
      used by getSimilarityWarnings.
      returns a table with a short summary for each publication as found in the rowArray
      $rowArray contains the result of a query of the publication table.
    
      
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/specialcharfunctions.php");


# getBibtexSummary($entry)
# Returns a short summary of the given bibtex entry
function getBibtexSummary($entry) {
  //entry type
  $result = $entry['bibtexEntryType'].": ";

  //author / editor
  if ($entry['author'] != "") {
    $result .= $entry['author'].", ";
  }
  else if ($entry['editor'] != "") {
    $result .= $entry['editor']." (eds), ";
  }

  //title
  $result .= "<i>'".$entry['title']."'</i>";

  //year
  if ($entry['year'] != "") {
    $result .= ", ".$entry['year'];
  }
  prettyPrintBibCharsFromString($result);
  $result .= "<br/><br/>";

	
  return $result;
}


# getSimilarityWarnings($entry, $entryNr)
# Shows similar publications
function getSimilarityWarnings($entry, $entryNr) {
  $result = "";
  $bibCiteSimilarityHtml = "";
  $bitTitleSimilarityHtml = "";

  // bibCiteSimilarity
  if ($entry['bibtexCitation']!='') {
    //check for similarity in the database on the first five chars.
    $bibCiteID = substr($entry['bibtexCitation'],0,5);
    $Q = mysql_query('SELECT * FROM publication WHERE bibtex_id LIKE "'.$bibCiteID.'%"');

    if (mysql_num_rows($Q) == 1) {
      $bibCiteSimilarityHtml.= "<p><b>A similar BiBTeX ID exists:</b><br/>";
    }
    else if (mysql_num_rows($Q) > 1) {
      $bibCiteSimilarityHtml.= "<p><b>Similar BiBTeX IDs exist:</b><br/>";
    }

    if (mysql_num_rows($Q) >= 1) {
      $bibCiteSimilarityHtml.= getPublicationSummariesByRows($Q)."<br/>";
      $bibCiteSimilarityHtml.= "</p>";
    }
  }

  // bibTitleSimilarityHtml
  if (!strpos($entry['title'],'\'')) {
    $Q = mysql_query('SELECT * FROM publication WHERE LOWER(title) LIKE LOWER(\''.$entry['title'].'\')');

    if ($Q)
    {
      if (mysql_num_rows($Q) == 1) {
        $bibTitleSimilarityHtml.= "<p><b>A publication with similar title exists:</b><br/>";
      }
      else if (mysql_num_rows($Q) > 1) {
        $bibTitleSimilarityHtml.= "<p><b>Publications with similar titles exist:</b><br/>";
      }

      if (mysql_num_rows($Q) >= 1) {
        $bibTitleSimilarityHtml.= getPublicationSummariesByRows($Q)."<br/>";
        $bibTitleSimilarityHtml.= "</p>";
      }
    }
  }

  if (($bibCiteSimilarityHtml != "") || ($bibTitleSimilarityHtml != '')) {
    $result.= "<div class=errormessage>".$bibCiteSimilarityHtml.$bibTitleSimilarityHtml."</div>";
  }

  return $result;
}

# getPublicationSummariesByRows($rowArray)
# displays a summary of a publication
function getPublicationSummariesByRows($rowArray) {
  $result = '';
  while ($row = mysql_fetch_array($rowArray)) {
    $Q = mysql_query("SELECT * FROM publication WHERE bibtex_id='".$row["bibtex_id"]."'");
    if ($Q) {
      $result.= "<tr><td>".$row["bibtex_id"]."</td>";

      while ($R = mysql_fetch_array($Q)) {
        $Q2 = mysql_query("SELECT surname FROM author, publicationauthor WHERE author.ID=publicationauthor.author AND publicationauthor.pub_id=".$R['pub_id']);
        if ($Q2) {
          $authors = '';
          while ($R2 = mysql_fetch_array($Q2)) {
            $authors.= $R2["surname"].", ";
          }
        }
        $result.= "<td>".$authors."<i>".$R['title']."</i> (".$R['year'].") ".$R['booktitle']."</td></tr>\n";
        prettyPrintBibCharsFromString($result);
      }
    }
  }
  if ($result != '') {
    $result = "\n<table>".$result."</table>";
  }

  return $result;
}



?>