<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file offers several functions to display notes for publications.
Each function returns a string, which can then be processed as the caller sees fit.

These functions return emtpy strings if the user has no right to read notes.

    getNoteDisplayByID($note_id, $includemenu=true)
    getNoteDisplay($note_table_row, $includemenu=true)
          returns a <DIV class=readernote> block containing the information of the 
          given note. If the note is created by the current user, edit and delete links are added to the display.
          The note text will be enhanced with links to corresponding publications for every valid bibtex ID 
          included in the note text.

    getAllNotesForPublicationByPubID($pub_id) 
        returns a series of <DIV class=readernote> blocks, one for each note added to the given publication.

Furthermore, this file contains a few methods to get links to edit and add pages.
    getNoteMenuByID($note_id)
    getNoteMenu($note_table_row)
        returns the edit link, public/private link and delete link for a note in one span; 
        each of the links will be empty if the user does not have appropriate rights 
    
    getLinkToNoteDeletePage($note_table_row)
    getLinkToNoteEditPage($note_table_row)
    getLinkToNoteAddPage($pub_id) 
    getLinkToNoteSetRightsPage($note_table_row)
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/displays/persondisplays.php");
include_once($DIR."lib/displays/publicationdisplays.php");

function getNoteDisplayByID($note_id, $includemenu=true) {
    #get note from database
    $res = mysql_query("SELECT * FROM personpublicationnote WHERE note_id=".$note_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getNoteDisplay($row, $includemenu);
        }
    }
    #not successfull in finding note...
    $result = "<DIV class=errormessage>Reader note with ID ".$note_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "</DIV>\n";
    return $result;
}
    

function getNoteDisplay($note_table_row, $includemenu=true) {
    $result = "";
    if (haveRights("READNOTES") && ($note_table_row["rights"]=="public" || $note_table_row["person_id"]==$_SESSION["personID"])) {
        
        # INIT BIBTEX_ID - to - PUBLICATION LINK mapping
        global $citeIdArray,$citeLinkArray;
        
        # DISPLAY NOTE DATA 
        $result .= "<DIV class=\"readernote\">\n";
        #[reader]:
        $result .= getPersonAbbrevDisplayByID($note_table_row["person_id"]).":&nbsp;";
        #note text
    	$text = html_activate_links($note_table_row["text"]); //get text, replace links
    	$text = str_replace($citeIdArray,$citeLinkArray,$text);
        $result .= $text."\n";
        #[edit][delete]
        if ($includemenu) {
            $result .= getNoteMenu($note_table_row)."\n";
        }
        $result .= "</DIV>\n";
    }    
    return $result;
}

function getAllNotesForPublicationByPubID($pub_id) {
    $result = "";
    if (haveRights("READNOTES")) {
        # INIT BIBTEX_ID - to - PUBLICATION LINK mapping
        global $citeIdArray,$citeLinkArray;

        $person_id="";
        if (isset($_SESSION["personID"])) {
          $person_id=$_SESSION["personID"];
        }

        #get notes from database
        $res = mysql_query("SELECT * FROM personpublicationnote WHERE pub_id=".$pub_id." AND (rights='public' OR person_id=".$_SESSION["personID"].") ORDER BY note_id ASC;");
        if ($res) {
            while ($row = mysql_fetch_array($res)) {
                #add next note to result
                $result .= "<DIV class=\"readernote\">\n";
                #[reader]:
                $result .= getPersonAbbrevDisplayByID($row["person_id"]).":&nbsp;";
                #note text
                $text = html_activate_links($row["text"]); //get text, replace links
                //echo $text;
                //print_r($citeIdArray);
                //print_r($citeLinkArray);
                //echo $text;
                $text = preg_replace($citeIdArray,$citeLinkArray,$text);
                $result .= $text."\n";
                #[edit][delete]
                $result .= getNoteMenu($row)."\n";
                $result .= "</DIV>\n";
            }
        }
    }
    return $result;
}


function getNoteMenuByID($note_id) {
    #get note from database
    $res = mysql_query("SELECT * FROM personpublicationnote WHERE note_id=".$note_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getNoteMenu($row);
        }
    }
    #not successfull in finding note...
    $result = "<DIV class=errormessage>Reader note with ID ".$note_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "</DIV>";
    return $result;
}

function getNoteMenu($note_table_row) { 
    $result = "";
    $result .= getLinkToNoteEditPage($note_table_row);
    $result .= getLinkToNoteSetRightsPage($note_table_row);
    $result .= getLinkToNoteDeletePage($note_table_row);
    return $result;
}
function getLinkToNoteSetRightsPage($note_table_row) {
    global $URL,$THEME;
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    $result = "";
    $note_id = $note_table_row["note_id"];
    //if writer of note is current user, add set public etc links
    if ($note_table_row["person_id"]==$_SESSION['personID']) {
        if ($note_table_row["rights"] == 'public') {
            $rights="private";
            $img = "_greenstoplight_small.gif";
        }
        else {
            $rights="public";
            $img = "_redstoplight_small.gif";
        }
        $result .= "\n<span alt='make ".$rights."' title='make ".$rights."' >";
        $result .= "<a href='".$URL."index.php?page=form&type=note&form=setrights&note_id=$note_id&rights=$rights&return=".rawurlencode($return)."'>";
        $result .= "<img border=0  src='".$URL.$THEME."icons/".$img."'>";
        $result .= "</a></span>";
    }
    return $result;
}

function getLinkToNoteDeletePage($note_table_row) {
    global $URL,$THEME;
    $result = "";
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    $note_id = $note_table_row["note_id"];
    //if writer of note is current user, add delete links
    if ($note_table_row["person_id"]==$_SESSION['personID']) {
        $result .= "\n<span alt='delete' title='delete' >";
        $result .= "<a href='".$URL."index.php?page=form&type=note&form=delete&note_id=$note_id&return=".rawurlencode($return)."'>";
        $result .= "<img border=0 src='".$URL.$THEME."icons/_delete_small.gif'>";
        $result .= "</a></span>";
    }
    return $result;
}

function getLinkToNoteEditPage($note_table_row) {
    global $URL,$THEME;
    $result = "";
    $note_id = $note_table_row["note_id"];
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    //if writer of note is current user, add edit links
    if ($note_table_row["person_id"]==$_SESSION['personID']) {
        $result .= "\n<span alt='edit' title='edit' >";
        $result .= "<a href='".$URL."index.php?page=form&type=note&form=change&note_id=$note_id&pub_id=".$note_table_row["pub_id"]."&return=".rawurlencode($return)."'>";
        $result .= "<img border=0 src='".$URL.$THEME."icons/_edit_small.gif'>";
        $result .= "</a></span>";
    }
    return $result;
}

function getLinkToNoteAddPage($pub_id) {
    global $URL,$THEME;
    $result = "";
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    $result .= "\n<span alt='add' title='add' >";
    $result .= "<a href='".$URL."index.php?page=form&type=note&form=add&pub_id=".$pub_id."&return=".rawurlencode($return)."'>";
    $result .= "[Add a new note...]";
    $result .= "</a></span>";
    return $result;
}



?>
