<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/*
====================================================================================================
DISPLAY RELATED FUNCTIONS (non-edit)
====================================================================================================

getPersonAbbrevDisplayByID

function getLinkToPersonEditPage($person_id, $return="") 
function getLinkToPersonAddPage($return="") 
function getLinkToPersonDeletePage($person_id, $return="") 

*/

function getPersonAbbrevDisplayByID($person_id) {
    $result = "[]";
    $res = mysql_query("SELECT * from person WHERE ID=".$person_id);
    if ($res) {
        if ($row=mysql_fetch_array($res)) {
            $result = "<SPAN title=\"";
            $result .= $row["surname"];
            $result .= "\"><b>[";
            $result .= $row["abbreviation"];
            $result .= "]</b></SPAN> ";
        }
    }
    return $result;
}

function getLinkToPersonAddPage($return="") {
    global $URL,$THEME;
    $result = "";
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result .= "\n<span alt='add person' title='add person' >";
    $result .= "<a href='".$URL."index.php?page=form&type=person&form=add&return=".rawurlencode($return)."'>";
    $result .= "[Add a new person...]";
    $result .= "</a></span>";
    return $result;
}
function getLinkToPersonEditPage($person_id, $return="") {
    global $URL,$THEME;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    if (!haveRights("USERCHANGE")) {
        return "";
    }
    $result = "";
    $result .= "\n<span alt='edit person' title='edit person' >";
    $result .= "<a href='".$URL."index.php?page=form&type=person&form=change&person_id=$person_id&return=".rawurlencode($return)."'>";
    $result .= "<img border=0 src='".$URL.$THEME."icons/_edit_small.gif'>";
    $result .= "</a></span>";
    return $result;
}
function getLinkToPersonDeletePage($person_id, $return="") {
    global $URL,$THEME;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    if (!haveRights("USERCHANGE")) {
        return "";
    }
    $result = "";
    $result .= "\n<span alt='delete person' title='delete person' >";
    $result .= "<a href='".$URL."index.php?page=form&type=person&form=delete&person_id=$person_id&return=".rawurlencode($return)."'>";
    $result .= "<img border=0 src='".$URL.$THEME."icons/_delete_small.gif'>";
    $result .= "</a></span>";
    return $result;
}
?>