<?php 
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/topicfunctions.php");
/*
====================================================================================================
DISPLAY RELATED FUNCTIONS (non-edit)
====================================================================================================

getTopicDescriptionDisplayByID($topic_id)
getTopicDescriptionDisplay($topic_table_row)
    return the description of the topic with html-activated links and linked bibtex_id's

getLinkToTopicPage($topic_id, $name="", $linktext="")
    Input: text forlink (usually name of topic); name and topic.ID.
    Output: returns a proper html link to the page for this topic; with name of topic as text.
getLinkToTopicEditPage($topic_id, $active=True, $return="")
    Input: topic.ID. $active is true if the edit link should be active. Otherwise some 'inactive' link is returned
    Output: returns a proper html link to the page for EDITING this topi
    If no edit rights, the link is inactive anyhow
getLinkToTopicAddPage($parent=topparent, $linktext="", $return="")
    as it says... default text is "add a subtopic"
getLinkToTopicDeletePage($topic_id, $active=True, $return="")
    if there are children, the link will still be active, but when you follow it you will encounter a message 
    'cannot delete topic with children'


*/

function getTopicDescriptionDisplayByID($topic_id) {
    #get TOPIC from database
    $res = mysql_query("SELECT * FROM topic WHERE ID=".$topic_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getTopicDescriptionDisplay($row);
        }
    }
    #not successfull in finding note...
    $result = "<DIV class=errormessage>Topic with ID ".$topic_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "</DIV>\n";
    return $result;
}
    

function getTopicDescriptionDisplay($topic_table_row) {
  global $citeIdArray,$citeLinkArray;

  $description = str_replace("\n", "<p>", $topic_table_row["description"]);
  $description = html_activate_links($description);
  $description = str_replace($citeIdArray,$citeLinkArray,$description);
  return $description;
    
}
    
/*
Input: text forlink (usually name of topic); name and topic.ID.
Output: returns a proper html link to the page for this topic; with name of topic as text.
*/
function getLinkToTopicPage($topic_id, $name="", $linktext="") {
    if ($name=="") {
        $name=$topic_id;
    }
    if ($linktext=="") {
        $linktext=$name;
    }
    return '<a href="index.php?page=topic&topic_id='.$topic_id.'" title="Go to topic '.$name.'">'.$linktext.'</a>';
}       

function getLinkToTopicEditPage($topic_id, $active=True, $return="") {
    global $URL,$THEME;
    if (!haveRights("EDIT")) {
        $active=false;
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }    
    $title="edit topic";
    if (!$active) {
        $title="cannot edit topic";
    }
    $result = "";
    $result .= "\n<span alt='$title' title='$title' >";
    if ($active==True) {
        $result .= "<a href='".$URL."index.php?";
        $result .= "page=form&";
        $result .= "type=topic&";
        $result .= "form=change&";
        $result .= "topic_id=$topic_id&";
        $result .= "return=".rawurlencode($return);
        $result .= "'>";
    }
    $result .= "<img border=0 src='".$URL.$THEME."icons/_edit_small.gif'>";
    if ($active==True) {
        $result .= "</a>";
    }
    $result .= "</span>";
    return $result;
}
function getLinkToTopicAddPage($parent=-1, $linktext="", $return="") {
    global $URL,$THEME;
    if (!haveRights("EDIT")) {
        return "";
    }
    if ($linktext=="") {
        $linktext="add a sub topic";
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }    
    if ($parent==-1) {
        $parent=getTopTopic();
    }
    $result = "";
    $result .= "\n<span alt='add subtopic' title='add subtopic' >";
    $result .= "<a href='".$URL."index.php?page=form&type=topic&form=add&parent=$parent&return=".rawurlencode($return)."'>";
    $result .= $linktext;
    $result .= "</a></span>";
    return $result;
}

function getLinkToTopicDeletePage($topic_id, $active=True, $return="") {
    global $URL,$THEME;
    if (!haveRights("EDIT")) {
        $active=false;
    }
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }    
    $title="delete topic";
    if (!$active) {
        $title="cannot delete topic";
    }
    $result = "";
    $result .= "\n<span alt='$title' title='$title' >";
    if ($active==True) {
        $result .= "<a href='".$URL."index.php?page=form&type=topic&form=delete&topic_id=$topic_id&return=".rawurlencode($return)."'>";
    }
    $result .= "<img border=0 src='".$URL.$THEME."icons/_delete_small.gif'>";
    if ($active==True) {
        $result .= "</a>";
    }
    $result .= "</span>";
    return $result;
}
?>