<?php
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage


/*
====================================================================================================
EDIT-FORM RELATED FUNCTIONS 
====================================================================================================
This file offers several functions to display edit forms or edit links for attachments.
Each function returns a string, which can then be included on a page.
The string will be a <div class=editform...> block containing a form that refers to 
../pageactionattachment.php in order to actually perform the actions.
Most functions take a $return parameter, which tells where to return the 
browser to after processing the edit form.

getAttAddForm
getAttAddRemoteForm($pub_id, $return="index.php?")
getAttDeleteForm[ByID]


*/



function getAttAddForm($pub_id, $return="") {
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";
    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Upload new attachment from this computer</p>";
    if (getConfigSetting("SERVER_NOT_WRITABLE") == "TRUE") {
        $form .= "\n<div class=message>You cannot upload attachment files to this server; please use remote attachments instead.</div>";
    } else {
        $form.="\n<form name='addattform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionattachment'>";
        $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
        $form.="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
        $form.="\n<input type='hidden' name=action value='add'>";
        $form.="\n<input type='hidden' name=isremote value='FALSE'>";
        $form.="\n<input type='hidden' name=ismain value='FALSE'>";
        $form.="\n<table>";
    
        $form.="\n<tr>";
        $form.="<td><label for='upload'>Select a file...</label></td><td><input type='file' name='upload' size='30'></td>";
        $form.="</tr>";
    
        $form.="\n<tr>";
        $form.="<td><label for='alternativename'>Set new name (blank: keep original name)...</label></td><td><input type='text' name='alternativename' size='30'></td>";
        $form.="</tr>";
    
        $form.="\n<tr>";
        $form.="<td><label for='note'>Note</label></td><td><input type='text' name='note' size='30'></td>";
        $form.="</tr>";
    
        $form.="\n<tr>";
        $form.="<td><input type=submit value='Add attachment'></td>";
        $form.="</tr>";
        $form.="\n</table>";
        $form.="\n</FORM>";
    
        $form.="\n<form name='cancel' method='post' action='".$return."'>";
        $form.="\n<table>";
        $form.="<tr>";
        $form.="<td>";
        $form.="<input type='hidden' name=message value='Cancelled'>";
        $form.="<input type=submit value='Cancel'/>";
        $form.="</td>";
        $form.="</tr>";
        $form.="\n</table>";
        $form.="\n</FORM>";
    }
    
    $form.="\n</DIV>";
    return $form;
}

function getAttAddRemoteForm($pub_id, $return="") {
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";
    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Add new attachment as a link, without uploading</p>";
    $form.="\n<form name='addattform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionattachment'>";
    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
    $form.="\n<input type='hidden' name=action value='add'>";
    $form.="\n<input type='hidden' name=isremote value='TRUE'>";
    $form.="\n<input type='hidden' name=ismain value='FALSE'>";
    $form.="\n<table>";

    $form.="\n<tr>";
    $form.="<td><label for='upload'>Location of file</label></td><td><input type='text' name='remotelocation' size='30'></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><label for='alternativename'>Set internal name (blank: keep original name)...</label></td><td><input type='text' name='alternativename' size='30'></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><label for='note'>Note</label></td><td><input type='text' name='note' size='30'></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><input type=submit value='Add file link'></td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
    return $form;
}

function getAttEditFormByID($pub_id, $location, $return="") {
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";
    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Change attachment note</p>";
    $form.="\n<form name='editattform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionattachment'>";
    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
    $form.="\n<input type='hidden' name=location value='".addslashes($location)."'>";
    $form.="\n<input type='hidden' name=action value='edit'>";
    $form.="\n<table>";

    $Q = mysql_query("SELECT * FROM publicationfile WHERE pub_id=".$pub_id." AND location='".addslashes($location)."';");
    if ($Q) {
        $R = mysql_fetch_array($Q);
        if ($R) {
            $name = $R["name"];
            $note = $R["note"];
        }
    }
    
    $form.="\n<tr>";
    $form.="<td><label for='note'>Note</label></td><td><input type='text' name='note' size='30' value=\"".$note."\"></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><input type=submit value='Update description'></td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
    return $form;
}

function getAttDeleteFormByID($pub_id, $location, $return="") {
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";
    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Delete attachment: confirm</p>";
    $form.="\n<form name='adddeleteform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionattachment'>";
    $form.="\n<input type='hidden' name=return value='".($return)."'>";
    $form.="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
    $form.="\n<input type='hidden' name=location value='".addslashes($location)."'>";
    $form.="\n<input type='hidden' name=action value='delete'>";
    $form.="\n<input type='hidden' name=confirmed value='True'>";
    
    $form.="\n<table>";

    $name = "";
    #get att from database
    $res = mysql_query("SELECT * FROM publicationfile WHERE pub_id=".$pub_id." AND location='".addslashes($location)."';");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            $name = "('".$row["name"]."')";
        }
    }

    $form.="\n<tr>";
    $form.="<td><div class=errormessage>Are you sure that you want to delete this attachment ".htmlentities($name,ENT_QUOTES)." completely?</td>";
    $form.="</tr>";
    
    $form.="\n<tr>";
    $form.="<td><input type=submit value='Confirm delete'/></td>";
    $form.="</tr>";
    
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
    return $form;
}



?>