<?php
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to get author editforms.
Each function returns a string that contains (parts of) a form.

  getPersonDeleteFormByID($person_id, $return="")
  getPersonDeleteForm($person_table_row) 
      get a form that asks for confirmation to delete a Person
      
  getAuthorForm($type, $ID = "", $return = "")
    get a form for editing or adding an author
    allowed $types:
    - edit for changing an author
    - new for adding a new author

  getAuthorSelectionForm($pub_id, $authors = "", $editors = "")
    gets the form for selecting authors for a publication.
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

function getAuthorDeleteFormByID($ID, $return="") {
    //get author from database
    $Q = mysql_query("SELECT * FROM author WHERE ID=".$ID.";");
    if ($Q) 
    {
        $R = mysql_fetch_array($Q);
        if ($R) {
            #create result and return
            return getAuthorDeleteForm($R, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>Author with ID ".$ID." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "\n</DIV>";
    return $result;
}

function getAuthorDeleteForm($author_table_row, $return="") {
    //if writer of note is not current user, return error
    if (!haveRights("EDIT")) {    
        return "<DIV class=errormessage>You are not allowed to delete authors.</div>";
    }    
    global $URL, $DIR;
    include_once($DIR."lib/functions/authorfunctions.php");
    
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";

    $form.="\n<DIV class=editform>";
    $form.="\n<form name='deleteauthorform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionauthor'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=ID value='".$author_table_row["ID"]."'>";
    $form.="\n<input type='hidden' name=action value='delete'>";
    
    $form.="\n<table>";
    $form.="\n<tr>";
    
    $message = "";
    $Q = mysql_query("SELECT COUNT(*) FROM publicationauthor WHERE author = ".$author_table_row["ID"]);
    if ($Q)
    {
      $R = mysql_fetch_array($Q);
      if ($R[0] > 0) {
        $message .= "There are ".$R[0]." publications linked to this author. ";
      }  
    }    
    $form.="<td><div class=errormessage>".$message." Are you sure that you want to delete ".getPrettyNameFromRow($author_table_row)."?</td>";
    $form.="</tr>";
    $form.="\n<tr>";
    $form.="<td><input type=submit value='Confirm delete'/></td>";
    $form.="</tr>";

    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;    
}

function getAuthorForm($type, $ID = "", $return = "")
{
  //allowed $types:
  //- edit for changing an author
  //- new for adding a new author
  
  global $DIR;
  include_once($DIR."lib/functions/authorfunctions.php");
    
  $LocalURL = $_SERVER['PHP_SELF'];
  if ($return=="") 
  {
    $return=$_SERVER['PHP_SELF'];
  }
  $authorArray = array();
  
  $form = "";
    
  if ($type == "new")
  {
    //new author, so nothing to do
    $form .= "<p class=header>New author</p>\n";
    getAuthorArrayFromSubmit($authorArray);
  }
  
  else if ($type == "edit")
  {
    $form .= "<p class=header>Edit author</p>\n";
    
    //if submitType is set, we were returned from the actionauthor page so get everything from the input.
    //if submitType is not set, we have to get everything from the database.
    $submitType = "";
    if (isset($_REQUEST["submittype"])) {
        $submitType = $_REQUEST["submittype"];
    }
    
    if ($submitType == "change")
    {
      getAuthorArrayFromSubmit($authorArray);
      $ID = $authorArray['ID'];
    }
    else
    {
      getAuthorArrayFromDB($ID, $authorArray);
    }
  }
  
  //$form .= "<form name='authorform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionauthor'>\n";
  $form .= "<form name='authorform' enctype='multipart/form-data' method='post' action='".$LocalURL."?page=actionauthor'>\n";
  $form .= "<input type='hidden' name=return value='".rawurlencode($return)."'>\n";
  $form .= "<input type='hidden' name=action value='".$type."'>\n";
  $form .= "<input type='hidden' name=confirm value='".$authorArray['confirm']."'>\n";
  $form .= "<input type='hidden' name=ID value='".$ID."'>\n";
  $form .= "<input type='hidden' name=submittype value='submit'>\n";  //can be set to 'change' for indicating a changed entrytype
  $form .= "<table class=vlist>\n";
  $form .= "<tr><td>Surname</td><td><input type=text name=surname value=\"".$authorArray['surname']."\" size=30></td></tr>\n";
  $form .= "<tr><td>Initials</td><td><input type=text name=name value=\"".$authorArray['name']."\" size=30><i class=small>If possible write first names in full.</i></td></tr>\n";
  $form .= "<tr><td>Email</td><td><input type=text name=email value=\"".$authorArray['email']."\" size=30></td></tr>\n";
  $form .= "<tr><td>Institute</td><td><input type=text name=institute  value=\"".$authorArray['institute']."\" size=30></td></tr>\n";
  $form .= "<tr><td>URL</td><td><input type=text name=url  value=\"".$authorArray['url']."\" size=30></td></tr>\n";
  $form .= "<tr><td>&nbsp;</td><td>";
  
  $form .= "<table><tr><td valign=top><input type=submit value=";
  if ($authorArray['confirm'] == 'TRUE')
  { 
    $form .= "continue";
  }
  else if ($type == "new")
  {
    
    $form .= "create";
  }
  else
  {
    $form .= "update";
  }
  $form .= "></form></td><td valign=top>";
  if (($authorArray['confirm'] == "TRUE" ) || ($type == "edit"))
  {
    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="<input type=submit value='cancel'/>";
    $form.="\n</form></td></tr></table>";
  }
  $form .= "</td></tr>\n";
  $form .= "</table>\n";
  $form .= "\n";
  
  
  return $form;
}

function getAuthorSelectionForm($pub_id, $authors = "", $editors = "")
{
  global $DIR;
  include_once($DIR."lib/functions/authorfunctions.php");
  include_once($DIR."javascript/authorselection.js");
  
  $result = "";
  $result .= "<form name=authorform>\n";
  $result .= "<table width=100%>\n";
  $result .= "<tr><td colspan=2 align=center>\n";
  $result .= "<span class=islink onclick=\"javascript:window.open('indexlight.php?page=author&kind=new','author_window','resizable, scrollbars,width=800, height=480,  dependent, left=0, top=0');\">[Add new author]</span>\n";
  $result .= "</td></tr>\n";
  $result .= "<tr><td  width=45% valign=top>\n";
  $result .= "<table width=100%>\n";
  $result .= "<tr><td><input type=text onkeyup=\"AuthorSearch();\" name=inputtext size=50></td></tr>\n";
  $result .= "<tr><td><select  style=\"width:100%;\" size=23  name=inputselect> </td></tr>\n";
  $result .= "<tr><td align=right></td></tr>\n";
  $result .= "</table>\n";
  $result .= "</td>\n";
  $result .= "<td  width=55% valign=top>\n";
  $result .= "<table width=100%>\n";
  $result .= "<tr><td width=20%></td><td width = 80% align=left>Authors</td></tr>\n";
  $result .= "<tr><td align=center><span onclick=\"AddAuthor();\" class=islink >[add&nbsp;>>]</span><br/>\n";
  $result .= "<span class=islink onclick=\"RemoveAuthor();\">[<<&nbsp;rem]</span></td>\n";
  $result .= "<td align=right><select name=\"selectedauthors\" style=\"width:100%;\" size=10>\n";
  
  $author_id = strtok($authors,",");
	while (strlen($author_id) > 0) 
	{
		$Q = mysql_query("SELECT * FROM author WHERE ID = ".$author_id);
    $R = mysql_fetch_array($Q);
    
    $result .= "<option value=".$R["ID"].">".getCleanNameFromRow($R)."</option>\n";		
		
		$author_id = strtok(",");
	}

  $result .= "</select></td></tr>\n";
  $result .= "<tr><td></td><td align=right><span class=islink onclick=\"AuthorUp();\" >[up]</span> <span class=islink onclick=\"AuthorDown();\" >[down]</span> </td></tr>\n";
  $result .= "<tr><td></td><td align=left>Editors</td></tr>\n";
  $result .= "<tr><td align=center><span onclick=\"AddEditor();\" class=islink >[add&nbsp;>>]</span><br/>\n";
  $result .= "<span class=islink onclick=\"RemoveEditor();\">[<<&nbsp;rem]</span></td>\n";
  $result .= "<td align=right><select name=\"selectededitors\" style=\"width:100%;\" size=10>\n";

  $editor_id = strtok($editors,",");
	while (strlen($editor_id) > 0) 
	{
		$Q = mysql_query("SELECT * FROM author WHERE ID = ".$editor_id);
    $R = mysql_fetch_array($Q);
    
    $result .= "<option value=".$R["ID"].">".getCleanNameFromRow($R)."</option>\n";		
		
		$editor_id = strtok(",");
	}

  $result .= "</select></td></tr>\n";
  $result .= "<tr><td></td><td align=right><span class=islink onclick=\"EditorUp();\" >[up]</span> <span class=islink onclick=\"EditorDown();\" >[down]</span> </td></tr>\n";
  $result .= "<tr><td></td><td align=right><input type=button onclick=\"Commit();\" value=Commit></td></tr>\n";
  $result .= "</table>\n";
  $result .= "</td></tr>\n";
  $result .= "</table>\n";
  $result .= "</form>\n";
  $result .= "</td></tr>\n";
  $result .= "</table>\n";
  $result .= "<SCRIPT LANGUAGE=\"JavaScript\">\n";
  $result .= "Init();\n";
  $result .= "</script>\n";

  return $result;
}
?>
