<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file contains the forms and subforms that the user needs to fill out in order to configure the 
aigaion database. The form is (of course...) accessed by calling 'getSiteConfigForm'. 

  MAIN FORM
    
    getSiteConfigForm()
        returns the full form.
  
  SUB FORMS
    getAdminSettingsSubForm
    getAttachmentSettingsSubForm
    getDisplaySettingsSubForm  
    getFieldsSettingsSubForm  
*/
    
function getSiteConfigForm() {
    if (!haveRights("MANAGEDATABASE")) {
        return "\n<div class=errormessage>Only DB Admins are allowed to change the configuration of the site.</div>";
    }
    $form  = "";
    $form .="\n<DIV class=editform>";
    $form .="<p class=header>AIGAION SITE CONFIGURATION FORM</p>";
    $form .="\n<FORM name='configform' enctype='multipart/form-data' method='post' action='".getConfigSetting("URL")."index.php?page=actionconfig'>";
    
    $form .="\n<TABLE width=100%>";
    $form .= getAdminSettingsSubForm();
    $form .= getAttachmentSettingsSubForm();
    $form .= getDisplaySettingsSubForm();
    //$form .= getFieldsSettingsSubForm(); NOT YET ACTIVATED, since it has no effect yet.
    $form .= getIOSettingsSubform();
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr>";
    $form .="<input type=submit value=Commit>";
    $form .="<input type=hidden name=action value=commit>";
    
    $form .="</TD></TR>";

    $form .="\n</TABLE>";
    
    $form .="\n</FORM>";

    $form .="\n<FORM name='cancel' method='post' action='".getConfigSetting("URL")."index.php?page=siteconfig'>";
    $form .="\n<TABLE>";
    $form .="<tr>";
    $form .="<td>";
    $form .="<input type='hidden' name=message value='Cancelled'>";
    $form .="<input type=submit value='Cancel'/>";
    $form .="</td>";
    $form .="</tr>";
    $form .="\n</TABLE>";
    $form .="\n</FORM>";
    
    $form .="\n</DIV>";
    return $form;

}


function getAdminSettingsSubForm() {
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>Site Admin:</p>";
    $form .="</TD></TR>";

    $form .="\n<TR>";
    $form .="<td><label for=CFG_ADMIN>Name of aigaion administrator:</label></td>";
    $form .="<td align=left><input type=text cols=60 name=CFG_ADMIN value='".getConfigSetting("CFG_ADMIN")."'></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label for=CFG_ADMINMAIL>Email of aigaion administrator:</label></td>";
    $form .="<td align=left><input type=text cols=60 name=CFG_ADMINMAIL value='".getConfigSetting("CFG_ADMINMAIL")."'></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
    return $form;
}


function getDisplaySettingsSubForm() {
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>Some display settings:</p>";
    $form .="</TD></TR>";

    $form .="\n<TR>";
    $form .="<td><label for=WINDOW_TITLE>Title of the site:</label></td>";
    $form .="<td align=left><input type=text cols=60 name=WINDOW_TITLE value='".getConfigSetting("WINDOW_TITLE")."'></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label>Display publications on single-topic page:</label></td>";
    $form .="<td align=left><input type=checkbox name=ALWAYS_INCLUDE_PAPERS_FOR_TOPIC ";
    if (getConfigSetting("ALWAYS_INCLUDE_PAPERS_FOR_TOPIC")=="TRUE") {
        $form .= " CHECKED ";
    }
    $form .= "></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>Checking this box means that the full list of publications for a topic is included below the topic description, to speed up browsing for papers. Turning this on might however slow down the loading of the topic pages.</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    

    return $form;
}


function getFieldsSettingsSubForm() {
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>Some settings concerning the entry fields:</p>";
    $form .="</TD></TR>";


    $form .="\n<TR>";
    $form .="<td><label>Use DOI:</label></td>";
    $form .="<td align=left><input type=checkbox name=USE_DOI ";
    if (getConfigSetting("USE_DOI")=="TRUE") {
        $form .= " CHECKED ";
    }
    $form .= "></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>Turn this on if you want this database to use the DOI field.</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    

    return $form;
}

function getAttachmentSettingsSubForm() {
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>Attachment settings:</p>";
    $form .="</TD></TR>";

    $form .="\n<TR>";
    $form .="<td><label>Allowed extensions for attachments:</label></td>";
    $form .="<td align=left><input type=text cols=60 name=ALLOWED_ATTACHMENT_EXTENSIONS value='".implode(",",getConfigSetting("ALLOWED_ATTACHMENT_EXTENSIONS"))."'></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>The list of allowed extensions for attachments. Attachments that do not have an extension from this list can not be uploaded.</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    $form .="\n<TR>";
    $form .="<td><label>Allow all remote attachments:</label></td>";
    $form .="<td align=left><input type=checkbox name=ALLOW_ALL_EXTERNAL_ATTACHMENTS ";
    if (getConfigSetting("ALLOW_ALL_EXTERNAL_ATTACHMENTS")=="TRUE") {
        $form .= " CHECKED ";
    }
    $form .= "></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>Check this box if you want to allow all external attachment names, instead of just those ending in one of the 'allowed extensions' specified above. This may be useful because external attachments are often to sites such as portal.acm or doi, with link names ending in meaningless numbers instead of a proper file name. This only affects *remote* attachments.</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
    $form .="\n<TR>";
    $form .="<td><label>The server is read only:</label></td>";
    $form .="<td align=left><input type=checkbox name=SERVER_NOT_WRITABLE ";
    if (getConfigSetting("SERVER_NOT_WRITABLE")=="TRUE") {
        $form .= " CHECKED ";
    }
    $form .= "></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>Check this box if the server is read-only, i.e. if you cannot write files such as attachments to the server.</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";

    return $form;
}

function getIOSettingsSubForm() {
    $form = "";    
    $form .="\n<TR><TD colspan=2>";
    $form .="<hr><p class=header2>In- and output settings:</p>";
    $form .="</TD></TR>";


    $form .="\n<TR>";
    $form .="<td><label>Convert latinchars</label></td>";
    $form .="<td align=left><input type=checkbox name=CONVERT_LATINCHARS_IN ";
    if (getConfigSetting("CONVERT_LATINCHARS_IN")=="TRUE") {
        $form .= " CHECKED ";
    }
    $form .= "></td>";
    $form .="</tr><tr><td align=left colspan=2><img border=0 src='themes/darkdefault/icons/_subtopic_arrow_small.gif'>Turn this on if you want to convert input latin characters to bibtex conform characters. Latin characters are &uuml;, &ntilde;, &ccedil; etc...</td>";
    $form .="</tr><tr><td align=left colspan=2></td>";
    $form .="</TR>";
    
   return $form;
}

?>