<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to import publications into Aigaion
Each function returns a string that contains (parts of) a form.

  getReviewForm($entries, $bibtexData, type="bibtex")
    returns a string with the review form for the gven bibtexData.
    
  getEntryReviewForm($entry, $entryNr)
    returns a string with a <div> environment, containing a complete review
    form of a single entry
    
  getSimilarAuthorForm($authors, $entryNr, $inputIDPrefix)
    returns a string with form elements for selection of alternative authors
      
*/
require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

include_once($DIR."lib/displays/importdisplays.php");
include_once($DIR."lib/functions/importfunctions.php");


# getReviewForm($entries, $bibtexData)
# displays the full review form of all entries to be imported
function getReviewForm($entries, $bibtexData, $type="bibtex") 
{
  $result = '';

  //present import review form
  $result .='<form method="post">';
  $result .='<input type=hidden name=action value=commit>';
  $result .='<input type=hidden name=type value='.$type.'>';

  $nrOfEntries=0;
  $nrOfTopics=0;
  $nrOfTopicLinks=0;

  $topicReviewHtml="";
  $topicLinkReviewHtml="";
  $entryReviewHtml="";

  
  foreach ($entries as $entry) 
  {
    //check whether input is normal bibtex or aigaion code (topic, topiclink)
    if ($entry["bibtexEntryType"]=="aigaiontopic") {
      //getTopicReviewForm
      //$topicReviewHtml .= getTopicReviewForm
      //$nrOfTopics++;
    }
    else if ($entry["bibtexEntryType"]=="aigaiontopictopiclink") {
      //getTopicLinkReviewForm
      //$topicLinkReviewHtml .= getTopicLinkReviewForm
      //$nrOfTopicLinks++;
    }
    else {
      //getEntryReviewForm
      $entryReviewHtml .= getEntryReviewForm($entry, $nrOfEntries);
      $nrOfEntries++;
    }
  }

  if ($nrOfEntries != 0) {
    $result .="<p class=header>Please review the publications to be imported</p>";
    $result .=$entryReviewHtml;
  }
  if ($nrOfTopics != 0) {
    $result .="<p class=header>Please review the topics to be imported</p>";
    $result .=$topicReviewHtml;
  }
  if ($nrOfTopicLinks != 0) {
    $result .="<p class=header>Please review the topic links to be imported</p>";
    $result .=$topicLinkReviewHtml;
  }

  //the presented forms only contains IDs and no complete corrected entries.
  //when commiting, the original input is parsed again. Changes are updated either
  //directly out of the database or (in case of citeID) from the form.

  $result .="<div style='visibility:hidden; display:none;'>";
  $result .="<textarea name=bibtexData>".$bibtexData."</textarea>";
  $result .="</div>";


  //end the form with the commit button
  $result .="<input type=submit value='Commit'>";
  $result .="</form>";

  return $result;
}

# getEntryReviewForm($entry, $entryNr)
function getEntryReviewForm($entry, $entryNr) {

  $result='';

  //the review form for one entry is presented in a div-message environment containing a complete table.
  $result.= "<div class='message'>\n<table>";

  //first table row: Let user choose whether to import or not.
  //and present a short summary
  $result.= "<tr><td valign=top><input type=checkbox checked title='Uncheck to skip importing this article' name='importNr".$entryNr."'></td><td>";
  $result.= "Import ".getBibtexSummary($entry);
  $result.= "</td></tr>\n";

  //second row: check for similar publications
  $simPubHtml = getSimilarityWarnings($entry, $entryNr);
  if ($simPubHtml != "") {
    $result.= "<tr><td></td><td>".$simPubHtml."</td></tr>\n";
  }

  //third (optional) row: allow user to change bibtex id
  $result.= "<tr><td></td><td>BiBTeX cite ID:&nbsp;<INPUT title='enter new bibtex cite id here if you want to change the current cite id' name='citeID".$entryNr."' value=".$entry['bibtexCitation']."><br/><br/></td></tr>\n";

  //fourth (optional) row: check for similar authors / editors
  //show only when similar authors or editors exist.
  $simAuthorHtml = "";
  $simEditorHtml = "";

  if ($entry['author']) {
    $simAuthorHtml = getSimilarAuthorForm($entry['author'], $entryNr, 'author');
  }
  if ($entry['editor']) {
    $simEditorHtml = getSimilarAuthorForm($entry['editor'], $entryNr, 'editor');
  }

  $result .= "<tr><td></td><td>";
  $result .= $simAuthorHtml;
  $result .= $simEditorHtml;
  $result .= "</td></tr>\n";


  //and close the table of this entry
  $result.= "</table>";
  $result.= "</div>";

  return $result;
}

function getSimilarAuthorForm($authors, $entryNr, $inputIDPrefix) {
  $result = '';
  $singleResult = '';
  $parsedAuthors = bibParseAuthors($authors);
  $rank=1;
  $nameIDArray = array();
  $showOutput = false;

  foreach ($parsedAuthors as $author) {
    //format the name
    $firstname = parseAigaionFirstname($author);
    $surname   = trim($author[2]);
    $prefix    = trim($author[3]);
    
    //just to show in the overview..
    if (($surname == "") && ($firstname == ""))
    {
      $surname = $prefix;
    }

    //check for existence in authorslist
    $Q = mysql_query('SELECT * FROM author');
    $nameIDArray[-1] = $surname.', '.$firstname;
    prettyPrintBibCharsFromString($nameIDArray[-1]);
    $keepNew = "[add new]";
    $keepNewID = -1;
    
    //we check on surname, freed from specialchars
    $cleanName = $surname;
    stripBibCharsFromString($cleanName);
    
    while ($R = mysql_fetch_array($Q))
    {
      //get the cleared surname from the row
      $rowName = $R['surname'];
      stripBibCharsFromString($rowName);
      
      if (levenshtein($cleanName,$rowName) < 3)
      {
        if (($R["surname"] != $surname) || ($R["name"] != $firstname))
        {
          $nameIDArray[$R["ID"]] = getPrettyNameFromRow($R);
        }
        else
        {
          $keepNew = "[keep]";
          $keepNewID=$R['ID'];
        }
      }
    }
    $singleResult = "Options for BiBTeX-author ".$nameIDArray[-1].":<br/>";

    //author as found in bibtex
    $singleResult .= "<input title='select to use author as found in BiBTeX' type=radio checked name=".$inputIDPrefix.$entryNr."_".$rank." value='".$keepNewID."' >".$nameIDArray[-1]." ".$keepNew."<br/>";

    //all alternatives based on levenshtein metric
    $fromDB = false;
    foreach ($nameIDArray as $ID => $name)
    {
      if ($ID != -1)
      {
        $singleResult .= "<input title='select to use similar author found in database' type=radio name=".$inputIDPrefix.$entryNr."_".$rank." value='".$ID."'>".$name." [from database]<br/>";
        $fromDB = true;
      }
    }

    if (!$fromDB) {
      $result.= '<div style="visibility:hidden; display:none;">'.$singleResult.'</div>';
    }
    else {
      $result .= $singleResult.'<br/>';
      $showOutput = true;
    }

    $nameIDArray = array();
    $rank++;
  }
  if ($showOutput) {
    $result = '<b>Choose alternative '.$inputIDPrefix.'s</b><br/>'.$result.'<br/><br/>';
  }
  return $result;
}

?>