<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to handle multiple-publication actions in Aigaion
Each function returns a string that contains (parts of) a form.
Some of the forms explicitly relate to pageactionmultipublication.php and multipublicationactions.php
for performing their task.

usage: 
    1 - for each publication, add a checkform to the page, e.g. in front of the publication summary.
      (use getPublicationCheckForm)
    2 - somewhere in the page, include the javascript 'collectCheckedPublications', which will be
      responsible for collecting the id's of the checked publications to post them as form data
      to whichever target.
    3 - somewhere on the page, include a form which looks somewhat like this:
       <form onSubmit="return collectAndSendCheckedPublications($formtarget,$formID);"  method="post" enctype="multipart/form-data">
        [...]
       </form>
      $formtarget will be the file where the formdata will be submitted to (don't forget the question mark at the end!) (e.g. "index.php?")
      $formID will be the ID of the form containing the submitbutton (i.e. THIS form)
      In place of [...] you can add any kind of extra form data, such as radiobuttons containing a list of potential 
      actions to be performed on the checked publications or a dropdown list containing the topic tree.
      The checked publications will be submitted as parameter 'pub_ids', which is a comma separated list of publication IDs.
      It is possible to include more than one of those multi-publication-action forms, 
      while using the same publicationCheckForms and the only once-included javascript.
      
getPublicationCheckForm($pub_id,$checked=FALSE)
    Returns one inline checkbox, usable for the multi-publication action forms.
    If $checked==TRUE, the box will be pre-checked
    Note: the ID of this form will be publicationcheckform_$pub_id; the ID of this checkbox will be 
          publicationcheckbox_$pub_id; both IDs should not be used otherwise.
    
getSetTopicMembership($topic_id) 
NOT IMPLEMENTED YET
    Return a form as described in point 3 above, only a submit button,
    that will cause all checked publications to be added to the given topic and all unchecked publications to
    be removed from the given topic.
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.
    
getAddCheckedToSelectedTopicForm()
    Return a form as described in point 3 above, that contains a topictree-dropdown-list and a submit button,
    that will cause all checked publications to be added to the selected topic.
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.
    
getRemoveCheckedFromSelectedTopicForm() 
NOT IMPLEMENTED YET
    Return a form as described in point 3 above, that contains a topictree-dropdown-list and a submit button,
    that will cause all checked publications to be removed from the selected topic.
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.
    
getRemoveCheckedFromTopicForm($topic_id) 
    Return a form as described in point 3 above, that contains a submit button,
    that will cause all checked publications to be removed from the given topic.
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.

getExportSelectedToBiBTeXForm() 
    Return a form as described in point 3 above, that contains a submit button,
    that will cause all checked publications to be exported as bibtex.
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.

getExportSelectedToZipForm() 
NOT IMPLEMENTED YET
    Return a form as described in point 3 above, that contains a submit button,
    that will cause all checked publications to be exported in a zip file containing
    a bibtex file for those publications as well as all on-server attachments.
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.

getSelectAllForm() 
NOT IMPLEMENTED YET
    Return a button that will select or unselect all publications on the page
    Note: you still need to include the javascript 'collectCheckedPublications' somewhere for this to work.

*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

function getPublicationCheckForm($pub_id, $checked=FALSE) {
    $check = "";
    if ($CHECKED) {
        $check = " checked ";
    }
    $form = "\n<form class=inlineform name='publicationcheckform_$pub_id' ID='publicationcheckform_$pub_id'><input type=CHECKBOX".$check." name='publicationcheckbox_$pub_id' ID='publicationcheckbox_$pub_id'></form>";
    return $form;
}

function getAddCheckedToSelectedTopicForm($return="") {
    global $URL, $DIR;
    include_once($DIR."treefunctions.php");

    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    
    $form = "";
    $form .= "\n<form name='AddCheckedToSelectedTopicForm' ID='AddCheckedToSelectedTopicForm' onSubmit=\"return collectAndSendCheckedPublications('".$URL."index.php?page=actionmultipublication&action=addtotopic&','AddCheckedToSelectedTopicForm');\"  method='post' enctype='multipart/form-data'>";
    $form .= "\n<input type=submit value='Add all checked publications to selected topic'>";

    $totaltopictree=array();
    $form.= "\n<select name='topic_id' size=1>";
    $query="SELECT ID FROM topic,persontopic WHERE persontopic.topic_id=ID AND persontopic.person_id=".$_SESSION["personID"]." ORDER BY topic.name";
    $res2=mysql_query($query);
    while($row2 = mysql_fetch_array($res2)) {
	    $totaltopictree[] = $row2["ID"];
    }
	$form.= getTopicOptionTree(makeTopicTree($totaltopictree),1);
    $form.= "</select>";

    $form .= "\n<input type=hidden name=return value='".$return."'>";
    $form .= "\n</form>";
    return $form;
}

function getRemoveCheckedFromTopicForm($topic_id, $return="") {
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    
    $form = "";
    $form .= "\n<form name='RemoveCheckedFromTopicForm' ID='RemoveCheckedFromTopicForm' onSubmit=\"return collectAndSendCheckedPublications('".$URL."index.php?page=actionmultipublication&action=removefromtopic&','RemoveCheckedFromTopicForm');\"  method='post' enctype='multipart/form-data'>";
    $form .= "\n<input type=submit value='Remove all checked publications from this topic'>";
    $form .= "\n<input type=hidden name=return value='".$return."'>";
    $form .= "\n<input type=hidden name=topic_id value='".$topic_id."'>";
    $form .= "\n</form>";
    return $form;
}

function getExportSelectedToBiBTeXForm() {
    global $URL;
    
    $form = "";
    $form .= "\n<form name='ExportSelectedToBiBTeXForm' ID='ExportSelectedToBiBTeXForm' onSubmit=\"return collectAndSendCheckedPublications('".$URL."indexlight.php?page=perbibtex&type=list&','ExportSelectedToBiBTeXForm');\"  target=_blank method='post' enctype='multipart/form-data'>";
    $form .= "\n<input type=submit value='Export selected publications to bibtex'>";
    $form .= "\n</form>";
    return $form;    
}

function getExportSelectedForm($type, $buttonText="") {
    global $URL;
    if ($buttonText == "") $buttonText = $type;
    $form = "";
    $form .= "\n<form name='ExportSelectedTo".$type."Form' ID='ExportSelectedTo".$type."Form' onSubmit=\"return collectAndSendCheckedPublications('".$URL."indexlight.php?page=perbibtex&type=list&format=".strtolower($type)."&','ExportSelectedTo".$type."Form');\"  target=_blank method='post' enctype='multipart/form-data'>";
    $form .= "\n<input type=submit title='Export selected publications to ".$type."' value='".$buttonText."'>";
    $form .= "\n</form>";
    return $form;    
}
?>

