<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
====================================================================================================
EDIT-FORM RELATED FUNCTIONS 
====================================================================================================
This file offers several functions to display edit forms or edit links for reader notes.
Each function returns a string, which can then be included on a page.
The string will usually be a <div class=editform...> block containing a form that refers to 
../pageactionattachment.php in order to actually perform the actions.
Most functions take a $return parameter, which tells where to return the 
browser to after processing the edit form.

==> NOTE: some functions (such as getNoteSetPublicFormByID) return not a form, but a link which 
behaves otherwise similarily. This is beacuse forms are rendered as a <div>, i.e. introducing 'hard returns'.

getNoteAddForm($pub_id,$return="")

getNoteChangeFormByID($note_id, $return="")
getNoteChangeForm($note_table_row, $return="")
    returns a form that can be used to edit notes.


getNoteSetRightsFormByID($note_id) 
getNoteSetRightsForm($note_table_row)
    get a form that asks for confirmation to set the note to public/private (depending on current value)
    if writer of note is not current user, it returns an empty error...

getNoteDeleteFormByID($note_id, $return="")
getNoteDeleteForm($note_table_row) 
    get a form that asks for confirmation to delete a note

*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

function getNoteAddForm($pub_id, $return="") {
    checkRights("COMMENT");
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";
    $form.="\n<DIV class=editform>";
    $form.="<p class=header2>Add new note</p>";
    $form .= "For publication ".$pub_id;
    $form.="\n<form name='addnoteform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionnote'>";
    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
    $form.="\n<input type='hidden' name=action value='add'>";
    $form.="\n<input type='hidden' name=person_id value='".$_SESSION["personID"]."'>";
    $form.="\n<table>";

    $form.="\n<tr>";
    $form.="<td><label for='text'>New note:</label></td></tr><tr><td><textarea name='text' wrap=virtual cols=70 rows=7></textarea></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><input type=submit value='Add note'></td>";
    $form.="</tr>";
    
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
    return $form;
}

function getNoteChangeFormByID($note_id, $return="") {
    #get note from database
    $res = mysql_query("SELECT * FROM personpublicationnote WHERE note_id=".$note_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getNoteChangeForm($row, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>\nReader note with ID ".$note_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "\n</DIV>";
    return $result;
}
function getNoteChangeForm($note_table_row, $return="") {
    checkRights("COMMENT");
    //if writer of note is not current user, return error
    if ($note_table_row["person_id"]!=$_SESSION['personID']) {    
        return "<DIV class=errormessage>You are not allowed to edit notes of other people.</div>";
    }    
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";
    $form.="\n<DIV class=editform>";
    $form.="<p class=header2>Edit note</p>";
    $form.="\n<form name='editnoteform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionnote'>";
    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=note_id value='".$note_table_row["note_id"]."'>";
    $form.="\n<input type='hidden' name=action value='change'>";
    $form.="\n<input type='hidden' name=person_id value='".$_SESSION["personID"]."'>";
    $form.="\n<input type='hidden' name=rights value='".$note_table_row["rights"]."'>";
    
    $form.="\n<table>";

    $form.="\n<tr>";
    $form.="<td><label for='text'>New text:</label></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><textarea name='text' wrap=virtual cols=70 rows=7>".htmlentities($note_table_row["text"],ENT_QUOTES)."</textarea></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><input type=submit value='Change note'></td>";
    $form.="</tr>";
    
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
    return $form;    
    
}
function getNoteDeleteFormByID($note_id, $return="") {
    #get note from database
    $res = mysql_query("SELECT * FROM personpublicationnote WHERE note_id=".$note_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getNoteDeleteForm($row, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>\nReader note with ID ".$note_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "\n</DIV>";
    return $result;
}
function getNoteDeleteForm($note_table_row, $return="") {
    checkRights("COMMENT");
    //if writer of note is not current user, return error
    if ($note_table_row["person_id"]!=$_SESSION['personID']) {    
        return "<DIV class=errormessage>You are not allowed to edit notes of other people.</div>";
    }    
    global $URL, $DIR;
    include_once($DIR."lib/displays/notedisplays.php");
    
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";

    $form.="\n<DIV class=editform>";
    $form.="<p class=header2>Delete note: confirm</p>";
    $form.="\n<form name='deletenoteform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionnote'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=note_id value='".$note_table_row["note_id"]."'>";
    $form.="\n<input type='hidden' name=action value='delete'>";
    $form.="\n<input type='hidden' name=confirmed value='True'>";
    
    $form.="\n<table>";

    $form.="\n<tr>";
    $form.="<td><label >Note summary:</label></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td>".getNoteDisplay($note_table_row, False)."</td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><div class=errormessage>Are you sure that you want to delete reader note ".$note_table_row["note_id"]." completely?</td>";
    $form.="</tr>";
    
    $form.="\n<tr>";
    $form.="<td><input type=submit value='Confirm delete'/></td>";
    $form.="</tr>";

    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;    
}
function getNoteSetRightsFormByID($note_id, $return="") {
    #get note from database
    $res = mysql_query("SELECT * FROM personpublicationnote WHERE note_id=".$note_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getNoteSetRightsForm($row, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>\nReader note with ID ".$note_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "\n</DIV>";
    return $result;
}
function getNoteSetRightsForm($note_table_row, $return="") {
    checkRights("COMMENT");
    //if writer of note is not current user, return error
    if ($note_table_row["person_id"]!=$_SESSION['personID']) {    
        return "<DIV class=errormessage>You are not allowed to edit notes of other people.</div>";
    }    
    global $URL, $DIR;
    include_once($DIR."lib/displays/notedisplays.php");
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $rights = "public";
    if ($note_table_row["rights"] == "public") {
        $rights="private";
    }
    
    $form = "";

    $form.="\n<DIV class=editform>";
    $form.="<p class=header2>Set note access rights to ".$rights."</p>";
    $form.="\n<form name='deletenoteform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionnote'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=note_id value='".$note_table_row["note_id"]."'>";
    $form.="\n<input type='hidden' name=action value='setrights'>";
    $form.="\n<input type='hidden' name=rights value='".$rights."'>";
    
    $form.="\n<table>";

    $form.="\n<tr>";
    $form.="<td><label >Note summary:</label></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td>".getNoteDisplay($note_table_row, False)."</td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td><input type=submit value='Confirm'/></td>";
    $form.="</tr>";
    
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;    
}

?>
