<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to handle publications in Aigaion
Each function returns a string that contains (parts of) a form.

  getPublicationDeleteFormByID($pub_id, $return = "")
  getPublicationDeleteForm($pub_table_row, $return = "") 
    get a form that asks for confirmation to delete a publication

  getPublicationForm($type, $pub_id = "", $return = "")
    returns the full publication edit form for $pub_id.
    $type indicates the type of form:
    - edit for changing a publication.
    - new for adding a new publication.
    On new publications, the pub_id has not to be set.
    Getting new and edit forms is combined in one method for efficiency reasons, because both 
    forms are quite large, and both forms are much alike.
    
  getPublicationConfirmForm($return = "");
    
  getPublicationAuthorsForm($pub_id, $authors = "", $editors = "")
    gets two select boxes, one with authors and one with editors
    
  getYearBox($name, $selectedYear = "") 
    gets a dropdown list with years. When $selectedYear is given, 
    this is marked. Otherwise the current year will be marked.
    
  getMonthBox($name, $selectedMonth = "")
    gets a dropdown list with months. When $selectedMonth is given, 
    this is marked. Otherwise the current month will be marked.
    
  getMarkAddForm($pub_id, $return = "") 
    returns a string with the addMark form
    
  getUnreadForm($pub_id, $return = "")
    returns a string with the 'unread' button.
    
  getTypeSpecificForm($publicationArray) 
    gets the type specific form elements for the publication in $publicationArray
  
  getFormElement($elements, $element, $data, $name, $pubType="")
    gets one single form element, if it is present in the $elements array.
    
*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage


function getPublicationDeleteFormByID($pub_id, $return="") {
    #get pub from database
    $res = mysql_query("SELECT * FROM publication WHERE pub_id=".$pub_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getPublicationDeleteForm($row, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>Publication with ID ".$pub_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "\n</DIV>";
    return $result;
}
function getPublicationDeleteForm($pub_table_row, $return="") {
    //if writer of note is not current user, return error
    if (!haveRights("EDIT")) {    
        return "<DIV class=errormessage>You are not allowed to delete publications.</div>";
    }    
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";

    $countOtherNote = mysql_fetch_array(mysql_query("SELECT COUNT(*) FROM personpublicationnote WHERE pub_id=".$pub_table_row["pub_id"]." AND NOT (person_id=".$_SESSION["personID"].")"));
    if ($countOtherNote[0] > 0) {
        return "<div class=errormessage>You cannot delete this publication because somebody else has stored reader notes for it.</div>";
    }
    
    $form.="\n<DIV class=editform>";
    $form.="<p class=header2>Delete publication: confirm</p>";
    $form.="\n<form name='deletepubform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionpublication'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=pub_id value='".$pub_table_row["pub_id"]."'>";
    $form.="\n<input type='hidden' name=action value='delete'>";
    
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td><div class=errormessage>Are you sure that you want to delete publication ".$pub_table_row["pub_id"]." completely? This will also remove ALL notes and attachments for this publication, and there is NO undo!</td>";
    $form.="</tr>";
    
    $form.="\n<tr>";
    $form.="<td><input type=submit value='Confirm delete'/></td>";
    $form.="</tr>";

    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;    
}

function getPublicationForm($type, $pub_id = "", $return = "")
{
  //allowed $types:
  //- edit for changing a publication
  //- new for adding a new publication
  
  global $URL, $DIR;
  include_once($DIR."lib/functions/authorfunctions.php");
  include_once($DIR."lib/functions/bibtexfunctions.php");
  include_once($DIR."lib/functions/publicationfunctions.php");
  include_once($DIR."lib/functions/specialcharfunctions.php");
  

  
  if ($return=="") 
  {
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
  }
  $person = $_SESSION['personID'];
  $publicationArray = array();
  
  $form = "";
  $form .= "<script type=\"text/javascript\" src=\"javascript/publications.js\"></script>\n";
  
  if ($type == "new")
  {
    //new publication, so nothing to do
    $form .= "<p class=header>New publication</p>\n";
    getPublicationArrayFromSubmit($publicationArray);
  }
  
  else if ($type == "edit")
  {
    $form .= "<p class=header>Edit publication</p>\n";
    
    //if submitType is set, we were returned from the actionpublication page so get everything from the input.
    //if submitType is not set, we have to get everything from the database.
    $submitType = "";
    if (isset($_REQUEST["submittype"])) {
        $submitType = $_REQUEST["submittype"];
    }
    
    if ($submitType == "change")
    {
      getPublicationArrayFromSubmit($publicationArray);
      $pub_id = $publicationArray['pub_id'];
    }
    else
    {
      getPublicationArrayFromDB($pub_id, $publicationArray);
    }
  }
  
  $form .= "<form name='publicationform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionpublication'>\n";
  $form .= "<input type='hidden' name=return value='".rawurlencode($return)."'>\n";
  $form .= "<input type='hidden' name=pub_id value='".$pub_id."'>\n";
  $form .= "<input type='hidden' name=action value='".$type."'>\n";
  $form .= "<input type='hidden' name=authors value=''>\n";
  $form .= "<input type='hidden' name=editors value=''>\n";
  $form .= "<input type='hidden' name=submittype value='submit'>\n";  //can be set to 'change' for indicating a changed entrytype
  
  
  $form .= "<table class=vlist>\n";
  
  //get the type selection dropdown list
  $entryTypes = bibGetSupportedEntries();
  $entryTypeForm  = "<select name=bibtexEntryType";
  $entryTypeForm .= " ONCHANGE=\"document.publicationform.submittype.value='change'; submitPublicationForm()\">\n";
  foreach ($entryTypes as $entryType)
  {
    $entryTypeForm .= "<OPTION VALUE=\"".$entryType."\"";
    if ($publicationArray['bibtexEntryType'] == $entryType)
    {
      $entryTypeForm .= ' selected ';
    }
    $entryTypeForm .= ">".$entryType."</OPTION>\n";
  }
  $entryTypeForm .= "</select>\n";
  
  if ($publicationArray['bibtexEntryType'] == "")
  {
    $publicationArray['bibtexEntryType'] = $entryTypes[0];
  }
  
  $form .= "<tr><td>Type of publication</td><td>".$entryTypeForm."</td></tr>\n";
  
  
  //get entered by dropdown list
  $enteredByForm = "<select name=enteredby>";
  $Q = mysql_query("SELECT * FROM person ORDER BY surname;");
  if ($Q)
  {
    if (isset($publicationArray['enteredby']) && $publicationArray['enteredby'] != "")
    {
      $select = $publicationArray['enteredby'];
    }
    else
    {
      $select = $person;
    }
    
    while ($R = mysql_fetch_array($Q))
    {
      $enteredByForm .= "<option value = ".$R['ID'];
      
      if ($R["ID"]==$select)
      {
        $enteredByForm .= " SELECTED";
      }
      $enteredByForm .= ">".getCleanNameFromRow($R)."</option>";
    }
  }
  $enteredByForm .= "</select>\n";
  
  $form .= "<tr><td>Entered by</td><td>".$enteredByForm."</td></tr>\n";
  quotesToHTMLFromString($publicationArray['title']);
  $form .= "<tr><td>Title</td><td><input name=title type=text size=45 value=\"".$publicationArray['title']."\"></td></tr>\n";
  $form .= "<tr><td>Bibtex cite ID</td><td><input type=text size=45 name=bibtexCitation value=\"".$publicationArray['bibtexCitation']."\"></td></tr>\n";
  
  //make year form
  $year = "";
  if (isset($publicationArray['year']))
    $year = $publicationArray['year'];
  
  $form .= "<tr><td>Year".bibCheckRequired($publicationArray['bibtexEntryType'], 'year')."</td><td>".getYearBox("year",$year)."</td></tr>\n";
    
  //and the type specific forms
  $form .= getTypeSpecificForm($publicationArray);
  
  $form .= "<tr><td>User fields [<span alt=\"input in bibtex format\" title=\"input in bibtex format\"><a href>?</a></span>]</td><td><input type=text size=45 name=userfields value=\"".$publicationArray['userfields']."\"></td></tr>\n";
  
  $form .= "<tr><td valign=top>Abstract </td><td><textarea name=abstract wrap=virtual cols=50 rows=10>".$publicationArray['abstract']."</textarea></td></tr>\n";
  $form .= "<tr><td colspan=2>".getPublicationAuthorsForm($pub_id, $publicationArray['authors'], $publicationArray['editors'])."</td></tr>\n";
  
  //DR attachment adding form elements: this attachment is always supposed to be main, and (if server is writable) not remote. Such information is processed in pageactionpublication...
  if (getConfigSetting("SERVER_NOT_WRITABLE") == "TRUE") {
    $form .= "\n<tr><td colspan=2><div class=message>You cannot upload attachment files to this server; please use remote attachments instead.</div></td></tr>";
  } else {
    $form.="\n<tr>";
    $form.="<td><label for='upload'>Select a main file<br/>(blank: no change)</label></td><td><input type='file' name='upload' size='30'></td>";
    $form.="</tr>";
    $form.="\n<tr>";
    $form.="<td><label for='alternativename'>Set new name<br/>(blank: keep original name)</label></td><td><input type='text' name='alternativename' size='30'></td>";
    $form.="</tr>";
 }

  
  $form .= "</table>\n";
  $form .= "</form>\n";
  $form .= "<form name='submitform' action=\"javascript:submitPublicationForm()\">\n";
  $form .= "<input type=submit value='Submit'>\n";
  $form .= "</form>\n";

  return $form;
}

function getPublicationConfirmForm($return = "")
{
  $publicationArray = array();
  getPublicationArrayFromSubmit($publicationArray);
  
  if ($return=="") 
  {
    if ($publicationArray['return'] != "")
      $return = urldecode($publicationArray['return']);
    else
      $return = $_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
  }
  
  $form  = "";
  $form .= "<script type=\"text/javascript\" src=\"javascript/publications.js\"></script>\n";
  $form .= "<table><tr><td>The bibtex cite ID has changed but is used by other publications as a crossreference. Do you want to update these crossreferences?</td></tr><tr><td align=right>";
  $form .= "<form name='publicationform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionpublication'>\n";
  
  $keys = array_keys($publicationArray);
  foreach ($keys as $key)
  {
    $form .= "<input type='hidden' name=".$key." value='".$publicationArray[$key]."'>\n";
  }
  $form .= "<input type='hidden' name=upd_crossref value='Y'>";
  $form .= "</form>\n";
  $form .= "</td></tr><tr><td><table><tr><td>";
  $form .= "<form name='submitformyes' action=\"javascript:submitPublicationConfirmForm('Y')\">\n";
  $form .= "<input type=submit value='Yes'>\n";
  $form .= "</form>\n";
  $form .= "</td><td>";
  $form .= "<form name='submitformno' action=\"javascript:submitPublicationConfirmForm('N')\">\n";
  $form .= "<input type=submit value='No'>\n";
  $form .= "</form>\n";
  $form .= "</td><td>";
  $form .= "\n<form name='cancel' method='post' action='".$return."'>";
  $form .= "<input type='hidden' name=message value='Cancelled'>";
  $form .= "<input type=submit value='Cancel'/>";
  $form .= "\n</form>";
  $form .= "</td></tr></table>";
  $form .= "</td></tr></table>";
  
  return $form;
}

function getPublicationAuthorsForm($pub_id, $authors = "", $editors = "")
{
  global $DIR;
  include_once($DIR."lib/functions/authorfunctions.php");
  
  $form  = "";
  $form .= "<table border=0 width=100%><tr><td width=50%>Authors".bibCheckRequired('author')."</td><td width=50% align=right>Editors".bibCheckRequired('editor')."</td></tr>\n";
  $form .= "<tr>";
  
  //author form
  $form .= "<td valign=top><select multiple name='authorsbox' style=\"width:100%;\" size=6>\n";
  if ($authors != "") //we already have infos on the authors, in a comma separated string
  {
    $author = strtok($authors, ",");
    while ($author)
    {
      $Q = mysql_query("SELECT * FROM author WHERE ID = ".$author);
      $R = mysql_fetch_array($Q);
      $form .= "<option value=".$R["ID"].">".getCleanNameFromRow($R)."</option>\n";
      $author = strtok(",");
    }
  }
  else //get the authors form the DB
  {
    $Q = mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='N' ORDER BY rank;");
    if ($Q)
    {
      while ($R = mysql_fetch_array($Q))
      {
        $Q2 = mysql_query("SELECT * FROM author WHERE ID = ".$R['author']);
        $R2 = mysql_fetch_array($Q2);
        $form .= ",<option value=".$R2["ID"].">".getCleanNameFromRow($R2)."</option>\n";
      }
    }
  }
  $form .= "</select></td>";
  
  //editor form
  $form .= "<td align=right valign=top><select mutliple name='editorsbox' style='width:100%;' size=6>\n";
  if ($editors != "") //we already have infos on the authors, in a comma separated string
  {
    $editor = strtok($editors, ",");
    while ($editor)
    {
      $Q = mysql_query("SELECT * FROM author WHERE ID = ".$editor);
      $R = mysql_fetch_array($Q);
      $form .= "<option value=".$R["ID"].">".getCleanNameFromRow($R)."</option>\n";
      $editor = strtok(",");
    }
  }
  else //get the authors form the DB
  {
    $Q = mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='Y' ORDER BY rank;");
    if ($Q)
    {
      while ($R = mysql_fetch_array($Q))
      {
        $Q2 = mysql_query("SELECT * FROM author WHERE ID = ".$R['author']);
        $R2 = mysql_fetch_array($Q2);
        $form .= ",<option value=".$R2["ID"].">".getCleanNameFromRow($R2)."</option>\n";
      }
    }
  }
  $form .= "</select></td></tr>\n";
  $form .= "<tr><td colspan=2 align=right><input onclick=\"javascript:window.open('indexlight.php?page=author&kind=select&pub_id=".$pub_id."&authors='+getAuthors()+'&editors='+getEditors(),'open_window','resizable, scrollbars,width=800, height=480, dependent, left=0, top=0');\" value=\"Edit authors/editors\" type=\"button\"></td></tr>\n";
  $form .= "</table>\n";
  
  return $form;
}

function getYearBox($name, $selectedYear = "") 
{
  $form = "";
  if ($selectedYear != "" && $selectedYear < 2999) 
  {
    if ($selectedYear <= 0) 
      $selected = 0;
    else 
      $selected = $selectedYear;
  } 
  else 
    $selected=date("Y");
  
  $form .= "<select name=".$name.">\n";
  $form .= "<option value=\"0000\">not known</option>\n";     #changed by wim-x
  
  for ($i = 1900; $i < 2020; $i++)
  { 
    $form .= "<option value=".$i;
    if ($i ==$selected)
    {
      $form .= " selected";
    }
    $form .= ">".$i."</option>\n";
  }
  $form .= "</select>\n";
  
  return $form;
}

function getMonthBox($name, $selectedMonth = "")
{
  global $MONTHS_ENG;
  $form = "";
  
  if ($selectedMonth != "" && $selectedMonth <= 12 ) 
  {
    if ($selectedMonth <= 0) 
      $selected = 0;
    else 
      $selected = $selectedMonth;
  } 
  else 
  {
    $selected = 0;//date("n"); DR: no default month anymore
  }
  $form .= "<select name=".$name.">\n";
  $form .= "<option value=0";
  
  if ($selected == 0)
    $form.= " selected";
  
  $form .= ">not known</option>\n";
  
  for ($i = 1; $i <= 12; $i++) 
  {
    $form .= "<option value=".$i;
  
    if ($selected == $i)
      $form .= " selected";
  
    $form .= ">".$MONTHS_ENG[$i]."</option>\n";
  }
  $form .= "</select>\n";
  
  return $form;
}

function getMarkAddForm($pub_id, $return = "") 
{
  global $URL;
  if ($return=="") {
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
  }
  $person = $_SESSION['personID'];

  $Q = mysql_query("SELECT mark,`read` FROM personpublicationmark WHERE pub_id=".$pub_id." AND person_id=".$person);
  $R= mysql_fetch_array($Q);
  $ownMark = $R['mark'];
  $haveRead = $R['read'];

  $form  = "";
  $form .="\n<form name='addmarkform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionpublication'>";
  $form .="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
  $form .="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
  $form .="\n<input type='hidden' name=action value='addmark'>";
  $form .="1";
  for ($i = 1; $i < 6; $i++)
  {
    if ($i == $ownMark)
    $checked = " checked";
    else
    $checked = "";

    $form .= "\n<input type=radio name='mark' value='".$i."'".$checked.">";
  }
  $form .= "5";
  if ($haveRead == 'y')
  {
    $form .="\n<input type=submit value='Update mark'>";
  }
  else
  {
    $form .= "\n<input type=submit value='Read/Add mark'>";
  }
  $form .="\n</form>";
  if ($haveRead == 'y')
  {
    $form .= getUnreadForm($pub_id, $return);
  }
  return $form;
}

function getUnreadForm($pub_id, $return = "")
{
  global $URL;
  if ($return=="") {
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
  }

  $form  = "";
  $form .="\n<form name='unreadform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actionpublication'>";
  $form .="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
  $form .="\n<input type='hidden' name=pub_id value='".$pub_id."'>";
  $form .="\n<input type='hidden' name=action value='unread'>";
  $form .="\n<input type=submit value='Unread'>";
  $form .="\n</form>";
  return $form;
}

function getTypeSpecificForm($publicationArray) 
{ 
  $pubType = strtolower($publicationArray['bibtexEntryType']);
  $elements = bibGetFieldArray($pubType);
  if (in_array("pages", $elements))
  {
    $elements[] = "firstpage";
    $elements[] = "lastpage";
  }

  $result .= getFormElement($elements, "journal",      $publicationArray['journal'],      "Journal", 			$pubType);
  $result .= getFormElement($elements, "type",         $publicationArray['type'],         "Type");
  $result .= getFormElement($elements, "booktitle",    $publicationArray['booktitle'],    "Booktitle", 		$pubType);
  $result .= getFormElement($elements, "series",       $publicationArray['series'],       "Series");
  $result .= getFormElement($elements, "volume",       $publicationArray['volume'],       "Volume");
  $result .= getFormElement($elements, "number",       $publicationArray['number'],       "Number");
  $result .= getFormElement($elements, "edition",      $publicationArray['edition'],      "Edition");
  if (in_array("month", $elements))
  {
    $result .= "<tr><td>Month</td><td>".getMonthBox("month", $publicationArray['month'])."</td></tr>\n";
  }
  $result .= getFormElement($elements, "firstpage",    $publicationArray['firstpage'],    "First page", 	$pubType);
  $result .= getFormElement($elements, "lastpage",     $publicationArray['lastpage'],     "Last page", 		$pubType);
  $result .= getFormElement($elements, "chapter",      $publicationArray['chapter'],      "Chapter", 			$pubType);
  $result .= getFormElement($elements, "publisher",    $publicationArray['publisher'],    "Publisher", 		$pubType);
  $result .= getFormElement($elements, "school",       $publicationArray['school'],       "School", 			$pubType);
  $result .= getFormElement($elements, "organization", $publicationArray['organization'], "Organization", $pubType);
  $result .= getFormElement($elements, "institution",  $publicationArray['institution'],  "Institution", 	$pubType);
  $result .= getFormElement($elements, "location",     $publicationArray['location'],     "Location");
  $result .= getFormElement($elements, "address",      $publicationArray['address'],      "Address");
  $result .= getFormElement($elements, "howpublished", $publicationArray['howpublished'], "How published");
  
  $result .= getFormElement($elements, "isbn",         $publicationArray['isbn'],         "ISBN");
  $result .= getFormElement($elements, "issn",         $publicationArray['issn'],         "ISSN");
  $result .= getFormElement($elements, "note",         $publicationArray['note'],         "Note", 				$pubType);
  $result .= getFormElement($elements, "url",          $publicationArray['url'],          "URL");
  $result .= getFormElement($elements, "key",          $publicationArray['key'],          "Key");
  $result .= getFormElement($elements, "crossref",     $publicationArray['crossref'],     "Crossref");
  $result .= getFormElement($elements, "keywords",     $publicationArray['keywords'],     "Keywords");
  
  return $result;
}

function getFormElement($elements, $element, $data, $name, $pubType="")
{
  $result = "";
  $required = "";
  if ($pubType != "")
  {
  	$required = bibCheckRequired($pubType, $element);
  }
  
  if (in_array($element, $elements)) 
  {
    $result .= "<tr><td>".$name."".$required."</td><td><input type=text size=45 name=".$element." value=\"".$data."\"></td></tr>\n";
  }
  return $result;
}

?>
