<?php
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/*
====================================================================================================
EDIT-FORM RELATED FUNCTIONS 
====================================================================================================

getTopicAddForm($parent) 
    get a form that allows a user to add a topic below the given parent

getTopicDeleteFormByID($topic_id, $return="")
getTopicDeleteForm($topic_table_row, $return="") 
    get a form that asks for confirmation to delete a topic

getTopicChangeFormByID($topic_id, $return="")
getTopicChangeForm($topic_table_row, $return="") 
    get a form that allows user to change the topic

getTopicSubscribeForm($topic_id)//for current user
    always returns to current page. 
getTopicSubscribeRecursiveForm($topic_id)//for current user
    always returns to current page. 
getTopicUnsubscribeForm($topic_id)//for current user
    always returns to current page. 
getTopicUnsubscribeRemainingForm($linktext="Unsubscribe from all remaining topics", $return="")//for current user
    Unsubscribe from all undecided topics...
    always returns to current page. 

*/

function getTopicAddForm($parent, $return="") {
    global $DIR;
    include_once($DIR."lib/functions/topicfunctions.php");
    include_once($DIR."treefunctions.php");
    
    if (!haveRights("EDIT")) {
        return "\n<div class=errormessage>Sorry, you are not allowed to add topics.</div>";
    }
    #check existence of parent.
    $query="SELECT * FROM topic WHERE ID=$parent";
    $res = mysql_query($query);
    if (!$res || (!($row=mysql_fetch_array($res)))) {    
        return "\n<div class=errormessage>You cannot add a topic to a non-existent parent ($parent).<br>Error: ".mysql_error()."<br>Query: ".$query."</div>";
    }    
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }    
    #create and return form
    $form = "";

    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Add new topic</p>";
    $form.="\n<form name='addtopicform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actiontopic'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=action value='add'>";
    
    $form.="\n<table>";

    #change parent of topic
    $form.="\n<tr>";
    $form.="<td>Parent:</td>";
    $form.="</tr>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.= '<select name="parent" size=1>';
    $query="SELECT ID FROM topic,persontopic WHERE persontopic.topic_id=ID AND persontopic.person_id=".$_SESSION["personID"]." ORDER BY topic.name";
    $res2=mysql_query($query);
    while($row2 = mysql_fetch_array($res2)) {
	    $totaltopictree[] = $row2["ID"];
    }
	$form.= getTopicOptionTree(makeTopicTree($totaltopictree),$parent);
    $form.= "</select>";
    $form.="</td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td>Name:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><input type=text name=name size=70></td>";
    $form.="</tr>";

    $form.="\n<tr>";
    $form.="<td>URL:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><input type=text name=url size=70></td>";
    $form.="</tr>";


    $form.="\n<tr>";
    $form.="<td valign='top'>Description:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><textarea cols=70 rows=15 name=description></textarea></td>";
    $form.="</tr>";
    
    $form.="\n<tr>";
    $form.="<td><input type=submit value=Create></td>";
    $form.="</tr>";    
    
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;        
}

function getTopicDeleteFormByID($topic_id, $return="") {
    #get note from database
    $res = mysql_query("SELECT * FROM topic WHERE ID=".$topic_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getTopicDeleteForm($row, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>Topic note with ID ".$topic_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "</DIV>";
    return $result;
}
function getTopicDeleteForm($topic_table_row, $return="") {
    if (!haveRights("EDIT")) {
        return "\n<div class=errormessage>Sorry, you are not allowed to delete topics.</div>";
    }
    #check children. Topics with children cannot be deleted
    $row = mysql_fetch_array(mysql_query("SELECT COUNT(*) FROM topictopiclink WHERE topictopiclink.target_topic_id='".$topic_table_row["ID"]."'"));
    if ($row[0]>0) {    
        return "\n<div class=errormessage>You cannot delete topics that still have children.</div>";
    }    
    global $URL;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $form = "";

    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Delete topic: confirm</p>";
    
    $row = mysql_fetch_array(mysql_query("SELECT COUNT(*) FROM persontopic WHERE topic_id=".$topic_table_row["ID"]." AND person_id!=".$_SESSION['personID']));
    if ($row[0] > 0){
        $form .="\nThere are <b>".$row[0]." other users</b> subscribed to this topic.<br/>";
    }
    
    $form.="<p><b>If you only want to remove the topic from your personal list, use 'unsubscribe' instead.</b>";
    $form.="<p>All references to this topic will be lost, for other users as well!<p>";
    $form.="You should first delete the children before you delete a parent topic.";
    
    $form.="\n<form name='deletetopicform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actiontopic'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=topic_id value='".$topic_table_row["ID"]."'>";
    $form.="\n<input type='hidden' name=action value='delete'>";
    $form.="\n<input type='hidden' name=confirmed value='True'>";
    
    $form.="\n<table>";

    $form.="\n<tr>";
    $form.="<td><div class=errormessage>Are you sure that you want to delete topic '".htmlentities($topic_table_row["name"],ENT_QUOTES)."' completely?</td>";
    $form.="</tr>";
    
    $form.="\n<tr>";
    $form.="<td><input type=submit value='Confirm delete'/></td>";
    $form.="</tr>";

    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="\n<td>";
    $form.="\n    <input type='hidden' name=message value='Cancelled'>";
    $form.="\n    <input type=submit value='Cancel'/>";
    $form.="\n</td>";
    $form.="\n</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;    
}


function getTopicChangeFormByID($topic_id, $return="") {
    #get note from database
    $res = mysql_query("SELECT * FROM topic WHERE ID=".$topic_id.";");
    if ($res) {
        $row = mysql_fetch_array($res);
        if ($row) {
            #create result and return
            return getTopicChangeForm($row, $return);
        }
    }
    #not successfull in finding note...
    $result = "\n<DIV class=errormessage>Topic with ID ".$topic_id." was not found in the database.";
    if (mysql_error()!="") {
        $result .= " Error: ".mysql_error();
    }
    $result .= "</DIV>";
    return $result;
}
function getTopicChangeForm($topic_table_row, $return="") {
    if (!haveRights("EDIT")) {
        return "\n<div class=errormessage>Sorry, you are not allowed to change topics.</div>";
    }
    global $DIR, $URL;
    include_once($DIR."treefunctions.php");
    
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    #get parent
    $topictopicrow = mysql_fetch_array(mysql_query("SELECT * FROM topictopiclink WHERE topictopiclink.source_topic_id=".$topic_table_row["ID"]));
    #get subscription row of current user, to determine star status
    $persontopicrow = mysql_fetch_array(mysql_query("SELECT * FROM persontopic WHERE topic_id=".$topic_table_row["ID"]." AND person_id=".$_SESSION["personID"]));
    $starcheck = "";
    if ($persontopicrow["star"] > 0) {
        $starcheck=" checked ";
    }
    
    #build form
    $form = "";
    
    $form.="\n<DIV class=editform>";
    $form.="\n<p class=header2>Change topic '".htmlentities($topic_table_row["name"],ENT_QUOTES)."'</p>";
    $form.="\n<form name='changetopicform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=actiontopic'>";

    $form.="\n<input type='hidden' name=return value='".rawurlencode($return)."'>";
    $form.="\n<input type='hidden' name=topic_id value='".$topic_table_row["ID"]."'>";
    $form.="\n<input type='hidden' name=action value='change'>";
    
    $form.="\n<table>";

    #change parent of topic
    $form.="\n<tr>";
    $form.="<td>Parent:</td>";
    $form.="</tr>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.= '<select name="parent" size=1>';
    $query="SELECT ID FROM topic,persontopic WHERE persontopic.topic_id=ID AND persontopic.person_id=".$_SESSION["personID"]." ORDER BY topic.name";
    $res2=mysql_query($query);
    while($row2 = mysql_fetch_array($res2)) {
	    $totaltopictree[] = $row2["ID"];
    }
	$form.= getTopicOptionTree(makeTopicTree($totaltopictree),$topictopicrow["target_topic_id"]);
    $form.= "</select>";
    $form.="</td>";
    $form.="</tr>";
//    THIS IS NOT YET IMPLEMENTED
//    $form.="\n<tr>";
//    $form.="<td>Remove publications in this topic from old ancestors when setting new parent:</td>";
//    $form.="</tr>";
//    $form.="\n<tr>";
//    $form.="<td><input type=checkbox name=removepubsfromoldancestors></td>";
//    $form.="</tr>";

    #change name of topic
    $form.="\n<tr>";
    $form.="<td>Name:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><input type=text name=name size=70 value='".htmlentities($topic_table_row["name"],ENT_QUOTES)."'></td>";
    $form.="</tr>";

    #change URL of topic
    $form.="\n<tr>";
    $form.="<td>URL:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><input type=text name=url size=70 value='".htmlentities($topic_table_row["url"],ENT_QUOTES)."'></td>";
    $form.="</tr>";

    #change 'starred'
    $form.="\n<tr>";
    $form.="<td>Star:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><input type=checkbox name=starred ".$starcheck."></td>";
    $form.="</tr>";
    
    #change description of topic
    $form.="\n<tr>";
    $form.="<td valign='top'>Description:</td>";
    $form.="</tr>";    
    $form.="\n<tr>";
    $form.="<td><textarea cols=70 rows=15 name=description>".htmlentities($topic_table_row["description"],ENT_QUOTES)."</textarea></td>";
    $form.="</tr>";

    #commit and cancel
    $form.="\n<tr>";
    $form.="<td><input type=submit value=Change></td>";
    $form.="</tr>";    
    
    $form.="\n</table>";
    $form.="\n</FORM>";

    $form.="\n<form name='cancel' method='post' action='".$return."'>";
    $form.="\n<table>";
    $form.="\n<tr>";
    $form.="<td>";
    $form.="<input type='hidden' name=message value='Cancelled'>";
    $form.="<input type=submit value='Cancel'/>";
    $form.="</td>";
    $form.="</tr>";
    $form.="\n</table>";
    $form.="\n</FORM>";
    
    $form.="\n</DIV>";
        
    return $form;    
}


function getTopicSubscribeForm($topic_id, $return="") {
    global $URL,$THEME;
    if ($return=="") {
        $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result = "";
    $result .= "\n<span alt='subscribe to topic' title='subscribe to topic' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='actiontopic'>";
    $result .= "\n<input type='hidden' name=action    value='subscribe'>";
    $result .= "\n<input type='hidden' name=topic_id  value='".$topic_id."'>";
    $result .= "\n<input type='hidden' name=return  value='".htmlentities($return,ENT_QUOTES)."'>";
    $result .= "\n<input class='noborder' type='image' src='".$URL.$THEME."icons/_subscribe_small.gif'>";
    $result .= "\n</form></span>";
    return $result;
}
function getTopicSubscribeRecursiveForm($topic_id) {
    global $URL,$THEME;
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    $result = "";
    $result .= "\n<span alt='subscribe to topic and all its descendants' title='subscribe to topic and all its descendants' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='actiontopic'>";
    $result .= "\n<input type='hidden' name=action    value='subscriberecursive'>";
    $result .= "\n<input type='hidden' name=topic_id  value='".$topic_id."'>";
    $result .= "\n<input type='hidden' name=return  value='".htmlentities($return,ENT_QUOTES)."'>";
    $result .= "\n<input class='noborder' type='image' src='".$URL.$THEME."icons/_subscribe_recursive_small.gif'>";
    $result .= "\n</form></span>";
    return $result;

}
function getTopicUnsubscribeForm($topic_id) {
    global $URL,$THEME;
    $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    $result = "";
    $result .= "\n<span alt='unsubscribe from topic and all its descendants' title='unsubscribe from topic and all its descendants' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='actiontopic'>";
    $result .= "\n<input type='hidden' name=action    value='unsubscribe'>";
    $result .= "\n<input type='hidden' name=topic_id  value='".$topic_id."'>";
    $result .= "\n<input type='hidden' name=return  value='".htmlentities($return,ENT_QUOTES)."'>";
    $result .= "\n<input class='noborder' type='image' src='".$URL.$THEME."icons/_unsubscribe_small.gif'>";
    $result .= "\n</form></span>";
    return $result;
}
function getTopicUnsubscribeRemainingForm($linktext="Unsubscribe from all remaining topics", $return="") {
    global $URL,$THEME;
    if ($return == "")
    {  
      $return=$_SERVER['PHP_SELF']."?".$_SERVER["QUERY_STRING"];
    }
    $result = "";
    $result .= "\n<span alt='".$linktext."' title='".$linktext."' >";
    //$result .= "\n<span alt='Unsubscribe from all remaining topics' title='Unsubscribe from all remaining topics' >";
    $result .= "<form class=linkimageform enctype='multipart/form-data' method='post' action='".$URL."index.php'>";
    $result .= "\n<input type='hidden' name=page    value='actiontopic'>";
    $result .= "\n<input type='hidden' name=action    value='unsubscriberemaining'>";
    $result .= "\n<input type='hidden' name=return  value='".htmlentities($return,ENT_QUOTES)."'>";
    $result .= "\n<input type='submit' value='".htmlentities($linktext,ENT_QUOTES)."'>";
    $result .= "\n</form></span>";
    return $result;
}
?>