<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to handle authors in Aigaion

  getNameFromRow($row, $toInitials)
    returns a name from $row. When $initials == 'Y', the first name
    is converted to initials.
  
  getCleanNameFromRow($row, $toInitials)
    returns a "clean" name from $row. When $initials == 'Y', the first name
    is converted to initials. When special chars occur, they are stripped off.
  
  getPrettyNameFromRow($row, $toInitials)
    returns a name from $row. When $initials == 'Y', the first name
    is converted to initials. When special chars occur, they are converted to HTML.
    
  getAuthorArrayFormSubmit(&$authorArray)
    Gets all the author fields that were posted into an array.
    
  getAuthorArrayFromDB($ID, &$authorArray)
    Gets all the author fields form the database into an array.
    
  checkSubmittedAuthorFields(&$authorArray)
    Checks whether there are invalid entries in the author field. Also checks for double entries.
    
  authorRepost(&$authorArray)
    Reposts all the fields in the authorArray.
    
*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/bibtexfunctions.php");
include_once($DIR."lib/functions/specialcharfunctions.php");

function getNameFromRow($row, $toInitials = 'N') {
  $surname=$row["surname"];

  if ($toInitials == 'N') {
    //return htmlentities(urldecode($surname.", ".$row["name"]),ENT_QUOTES);
    return $surname.", ".$row["name"];
  } 
  else {
    return $surname.", ".bibParseInitials($row["name"]);
  }
}

function getCleanNameFromRow($row, $toInitials = 'N') {
  $name = "";
  $surname = $row["surname"];

  if ($toInitials == 'N') {
    $name = $surname.", ".$row["name"];
  } 
  else {
    $name = $surname.", ".bibParseInitials($row["name"]);
  }
  if ($row['specialchars'] == "TRUE")
  {
    stripBibCharsFromString($name);
  }
  return $name;
}

function getPrettyNameFromRow($row, $toInitials = 'N') {
  $name = "";
  
  $surname = $row["surname"];
  if ($toInitials == 'N') {
    $name = $surname.", ".$row["name"];
  } 
  else {
    $name = $surname.", ".bibParseInitials($row["name"]);
  }
  
  if ($row['specialchars'] == "TRUE")
  {
    prettyPrintBibCharsFromString($name);
  }
  
  quotesToHTMLFromString($name);
  
  return $name;
  
}

function getAuthorArrayFromSubmit(&$authorArray)
{
  $authorArray['return'] = "";
  if (isset($_REQUEST["return"])) {
    $authorArray['return'] = $_REQUEST["return"];
  }
  
  $authorArray['action'] = "";
  if (isset($_REQUEST["action"])) {
    $authorArray['action'] = $_REQUEST["action"];
  }
  
  $authorArray['submittype'] = "";
  if (isset($_REQUEST["submittype"])) {
    $authorArray['submittype'] = $_REQUEST["submittype"];
  }
  
  $authorArray['ID'] = "";
  if (isset($_REQUEST["ID"])) {
    $authorArray['ID'] = $_REQUEST["ID"];
  }
  $authorArray['surname'] = "";
  if (isset($_REQUEST["surname"])) {
    $authorArray['surname'] = $_REQUEST["surname"];
  }
  $authorArray['name'] = "";
  if (isset($_REQUEST["name"])) {
    $authorArray['name'] =$_REQUEST["name"];
  }
  $authorArray['email'] = "";
  if (isset($_REQUEST["email"])) {
    $authorArray['email'] = $_REQUEST["email"];
  }
  $authorArray['institute'] = "";
  if (isset($_REQUEST["institute"])) {
    $authorArray['institute'] = $_REQUEST["institute"];
  }
  $authorArray['url'] = "";
  if (isset($_REQUEST["url"])) {
    $authorArray['url']=$_REQUEST["url"];
  }
  $authorArray['specialchars'] = "";
  if (isset($_REQUEST["specialchars"])) {
    $authorArray['specialchars'] = $_REQUEST["specialchars"];
  }
  $authorArray['confirm'] = "FALSE";
  if (isset($_REQUEST["confirm"])) {
    $authorArray['confirm'] = $_REQUEST["confirm"];
  }
  if (get_magic_quotes_gpc()==1) 
  {
    stripSlashesFromArray($authorArray);
  }
  quotesToHTMLFromArray($authorArray);

}

function getAuthorArrayFromDB($ID, &$authorArray)
{
  $Q = mysql_query("SELECT * FROM author WHERE ID = ".$ID);
  
  if (mysql_num_rows($Q) > 0)
  {
    $authorArray = mysql_fetch_array($Q);
  }
  $authorArray['confirm'] = "FALSE";
  
  quotesToHTMLFromArray($authorArray);
}

function checkSubmittedAuthorFields(&$authorArray)
{
  //check for similar authors
  if (($authorArray['surname'] == "") && ($authorArray['name'] == ""))
  {
    return -1;
  }
  
  if ($authorArray['confirm'] != "TRUE")
  {
    $ID = $authorArray['ID'];
    $surname  = html_entity_decode($authorArray['surname'], ENT_QUOTES);
    stripBibCharsFromString($surname);
    $authorfound = false;
    
    $Q = mysql_query("SELECT * FROM author");
  	while ($R = mysql_fetch_array($Q))
  	{
  	  $rowSurname = $R['surname'];
  	  if ($R['specialchars'] == 'TRUE')
  	  {
  	    stripBibCharsFromString($rowSurname);
  	  }
  	  if ((levenshtein($surname,$rowSurname) < 3) && ($ID != $R['ID']))
  		{
  			$_SESSION['aigaionerror'] .= "Similar author found: <br/><b>".getPrettyNameFromRow($R)."</b><br/><br/>";
  			$authorfound = true;
  		}
  	}
    if ($authorfound)
    {
      $_SESSION['aigaionerror'] .= "Update?";
      return -2;
    }
  }
  return 0;
}

function authorRepost(&$authorArray)
{
  $LocalURL = $_SERVER['PHP_SELF'];
  $form  = "";
  $form .= "<form name='authorform' enctype='multipart/form-data' method='post' action='".$LocalURL."?page=author&kind=".$authorArray['action']."'>\n";
  
  $keys = array_keys($authorArray);
  foreach ($keys as $key)
  {
    $form .= "<input type='hidden' name=".$key." value='".$authorArray[$key]."'>\n";
  }
  $form .= "</form>\n";
  echo $form;
  ?>
  <script type="text/javascript">
    document.authorform.submit();
  </script>
  <?php 
}
?>
