<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to access site-configuration in Aigaion

Most configuration settings are stored in the AIGAION tables. A select few (such as mysql username)
are stored in the config.php file. All can be accessed from here. To avoid needless repeated queries to 
the database, settings that have been accessed before are stored in a session array-variable $_SESSION["config"].

getConfigSetting
    return the value of the specified setting. If not in cache, retrieve from database or config file
    The function getConfigSetting has been made in such a way that things still work if settings are, for some 
    reason, defined in config.php where they should have been defined in the database.

*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

function getConfigSetting($setting) {
    if (!isset($_SESSION["config"]))
        $_SESSION["config"] = array();
    #retrieve setting if necessary
    if (!isset($_SESSION["config"][$setting])) {
        //get it from the database
        $Q = mysql_query("SELECT value FROM config WHERE setting='$setting'");
        if ($Q) {
            if ($R = mysql_fetch_array($Q)) {
                //where needed, interpret setting as other than string
                if ($setting == "ALLOWED_ATTACHMENT_EXTENSIONS") {
                    $_SESSION["config"][$setting] = split(",",$R["value"]);
                } else {
                    $_SESSION["config"][$setting] = $R["value"];
                }
                //echo "Return setting from database";
                return $_SESSION["config"][$setting];
            }
        }
        //else: one of the config.php settings?
        global $$setting;
        if (isset($$setting)) {
            $_SESSION["config"][$setting] = $$setting;
            //echo "Return setting from config";
            return $$setting;
        }
    } else {
        //echo "Return setting from session-var";
        return $_SESSION["config"][$setting];
    }
    //$_SESSION["aigaionerror"] .= "Setting '$setting' does not exist.<br>";
    return "no such setting";
}

?>
