<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to export publications out of Aigaion


*/
require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/bibtexfunctions.php");
include_once($DIR."lib/functions/risfunctions.php");
include_once($DIR."lib/functions/authorfunctions.php");


function exportBufferStart() {
  ob_start();
}

function exportBufferFileEnd($resfile = '/var/www/html/phpdebug',$clear = true) 
{
  error_reporting(0);
  $fp = fopen($resfile, ($clear) ? 'w' : 'a');
  $result=ob_get_contents();
  fwrite($fp,$result);

  ob_end_clean();
  return $result;
}

function exportBufferEnd() 
{
	$output = ob_get_contents();
	ob_end_clean();
	$output = str_replace("\n","<BR>",$output);
	echo $output;
}

//RETURNS the output instead of exporting it!!!
function exportBufferEndNoBR() 
{
	$output = ob_get_contents();
	ob_end_clean();
	return $output;
}

function exportBibtexList($pub_ids, $initialsonly = 'N') {
    $result = "";
    foreach (split(",",$pub_ids) as $pub_id) {
        exportBibtex($pub_id, $initialsonly); // will echo the bibtex of this single publication
    }
    echo $result;
}

function exportRISList($pub_ids, $initialsonly = 'N') {
    $result = "";
    foreach (split(",",$pub_ids) as $pub_id) {
        exportRIS($pub_id, $initialsonly); // will echo the bibtex of this single publication
    }
    echo $result;
}

function exportBibtexForTopic($topic_id, $initialsonly = 'N') {
    $result = "";
    //get all publications in topic
    $Q = mysql_query("SELECT publication.* FROM publication, topicpublication WHERE publication.pub_id = topicpublication.pub_id AND topicpublication.topic_id = ".$topic_id." ORDER BY bibtex_id ASC");
    if ($Q) {
        while ($R=mysql_fetch_array($Q)) {
            exportBibtex($R["pub_id"], $initialsonly); // will echo the bibtex of this single publication
        }
    }
    echo $result;
}

function exportRISForTopic($topic_id, $initialsonly = 'N') {
    $result = "";
    //get all publications in topic
    $Q = mysql_query("SELECT publication.* FROM publication, topicpublication WHERE publication.pub_id = topicpublication.pub_id AND topicpublication.topic_id = ".$topic_id." ORDER BY bibtex_id ASC");
    if ($Q) {
        while ($R=mysql_fetch_array($Q)) {
            exportRIS($R["pub_id"], $initialsonly); // will echo the RIS of this single publication
        }
    }
    echo $result;
}

function exportBibtex($pub_id, $initialsonly = 'N')
{
  $result = "";

  $Q = mysql_query("SELECT * FROM publication WHERE pub_id =".$pub_id.";");
  
  if($Q)
  {
    $R=mysql_fetch_array($Q);
  }
  $supportedFields = bibGetSupportedFields();
  $publicationArray = array();
  foreach ($supportedFields as $field)
  {
    $publicationArray[$field] = $R[$field];
  }
  
  //some fields have different names in the DB
  $publicationArray['pub_id'] = $pub_id;
  $publicationArray['year'] = checkYear( $R["year"] );      # added
  $publicationArray['bibtexCitation'] =  $R["bibtex_id"];
  $publicationArray['bibtexEntryType'] = $R["type"];
  $publicationArray['type'] = $R["pub_type"];
  $publicationArray['key'] = $R["namekey"];
  $publicationArray['userfields'] = $R["userfields"];

  //here, the export begins
  $result .= "@".strtoupper($publicationArray['bibtexEntryType'])." {".$publicationArray['bibtexCitation'].",\n";
  $result .= getBibExportElements($publicationArray, $initialsonly);
  $result .= getBibExportUserfields($publicationArray["userfields"]);
  $result .= "}\n";
  
  echo $result;
}

function exportRIS($pub_id, $initialsonly = 'N')
{
  $result = "";

  $Q = mysql_query("SELECT * FROM publication WHERE pub_id =".$pub_id.";");
  
  if($Q)
  {
    $R=mysql_fetch_array($Q);
  }
  $supportedFields = bibGetSupportedFields();
  $publicationArray = array();
  foreach ($supportedFields as $field)
  {
    $publicationArray[$field] = $R[$field];
  }
  
  //some fields have different names in the DB
  $publicationArray['pub_id'] = $pub_id;
  $publicationArray['bibtexEntryType'] = $R["type"];
  
  //format the date
  if ($R["year"] == "0000") $R["year"] = "";
  $publicationArray['year'] = $R["year"];
  if ($R["month"] != "0")
  $publicationArray['year'] .= "/".$R["month"];
  
  $publicationArray['userfields'] = $R["userfields"];

  //here, the export begins
  $result .= "TY  - ".getRISEntryType($R["type"])."\n";
  if ($publicationArray['bibtexCitation'] != "")
  	$RESULT .= "ID  - ".$publicationArray['bibtexCitation']."\n";
  $result .= getRISExportElements($publicationArray, $initialsonly);
  $result .= getRISExportUserfields($publicationArray["userfields"]);
  $result .= "ER  -\n";
  
  echo $result;
}

function getExportAuthorString($pub_id, $editor = 'N', $initialsonly = 'N')
{
  $result = "";
  $Q = mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='".$editor."' ORDER BY rank");
  
  if ($Q)
  {
    while ($R = mysql_fetch_array($Q))
    {
      $author_id = $R["author"];
      $Q2 = mysql_query("SELECT author.* FROM author WHERE author.ID=".$author_id);
      $R2 = mysql_fetch_array($Q2);
      if ($result != "")
      {
        $result .= " and ";
      }
      $result .= getNameFromRow($R2, $initialsonly);
    }
  }

  return $result;
}

function getBibExportElements(&$publicationArray, $initialsonly)
{
  $elements = bibGetFieldArray($publicationArray['bibtexEntryType']);
  if (in_array("pages", $elements)) {
    $pages = "";
    if ($publicationArray['firstpage']) {
      $pages = $publicationArray['firstpage']."-".$publicationArray['lastpage'];
    }
  }
  if (in_array("abstract", $elements))
  {
    $abstract = "";
    if ($publicationArray['abstract'])
    {
      $abstract .= urldecode($publicationArray['abstract']);
    }
  }
  if (in_array("month", $elements)) {
    global $MONTHS_ENG;
    $month = $MONTHS_ENG[$publicationArray['month']];
  }
  
  $authors = getExportAuthorString($publicationArray['pub_id'], 'N', $initialsonly);
  if ($authors != "")
  {
    $elements[] = "author";
  }
  $editors = getExportAuthorString($publicationArray['pub_id'], 'Y', $initialsonly);
  if ($editors != "")
  {
    $elements[] = "editor";
  }
  
  $result .= getBibExportElement($elements, "key",          $publicationArray['key'],          "key");
  $result .= getBibExportElement($elements, "title",        $publicationArray['title'],        "title");
  $result .= getBibExportElement($elements, "author",       $authors,                          "author");
  $result .= getBibExportElement($elements, "editor",       $editors,                          "editor");
  $result .= getBibExportElement($elements, "crossref",     $publicationArray['crossref'],     "crossref");
  $result .= getBibExportElement($elements, "journal",      $publicationArray['journal'],      "journal");
  $result .= getBibExportElement($elements, "booktitle",    $publicationArray['booktitle'],    "booktitle");
  $result .= getBibExportElement($elements, "series",       $publicationArray['series'],       "series");
  $result .= getBibExportElement($elements, "year",         $publicationArray['year'],         "year");
  $result .= getBibExportElement($elements, "month",        $month,                            "month");
  $result .= getBibExportElement($elements, "volume",       $publicationArray['volume'],       "volume");
  $result .= getBibExportElement($elements, "type",         $publicationArray['type'],         "type");
  $result .= getBibExportElement($elements, "number",       $publicationArray['number'],       "number");
  $result .= getBibExportElement($elements, "edition",      $publicationArray['edition'],      "edition");
  $result .= getBibExportElement($elements, "pages",        $pages,                            "pages");
  $result .= getBibExportElement($elements, "chapter",      $publicationArray['chapter'],      "chapter");
  $result .= getBibExportElement($elements, "publisher",    $publicationArray['publisher'],    "publisher");
  $result .= getBibExportElement($elements, "school",       $publicationArray['school'],       "school");
  $result .= getBibExportElement($elements, "organization", $publicationArray['organization'], "organization");
  $result .= getBibExportElement($elements, "institution",  $publicationArray['institution'],  "institution");
  $result .= getBibExportElement($elements, "location",     $publicationArray['location'],     "location");
  $result .= getBibExportElement($elements, "address",      $publicationArray['address'],      "address");
  $result .= getBibExportElement($elements, "howpublished", $publicationArray['howpublished'], "howpublished");
  $result .= getBibExportElement($elements, "isbn",         $publicationArray['isbn'],         "isbn");
  $result .= getBibExportElement($elements, "issn",         $publicationArray['issn'],         "issn");
  $result .= getBibExportElement($elements, "note",         $publicationArray['note'],         "note");
  $result .= getBibExportElement($elements, "url",          $publicationArray['url'],          "url");
  $result .= getBibExportElement($elements, "keywords",     $publicationArray['keywords'],     "keywords");
  $result .= getBibExportElement($elements, "abstract",     $abstract,                         "abstract");
  
  return $result;
}

function getRISExportElements(&$publicationArray, $initialsonly)
{
  $elements = bibGetFieldArray($publicationArray['bibtexEntryType']);
  
  if (in_array("abstract", $elements))
  {
    $abstract = "";
    if ($publicationArray['abstract'])
    {
      $abstract .= urldecode($publicationArray['abstract']);
    }
  }
  
  $authorstring = getExportAuthorString($publicationArray['pub_id'], 'N', $initialsonly);
  $authors = split(' and ', $authorstring);
  if ($authorstring != "")
  {
    $elements[] = "author";
  }
  
  $editorstring = getExportAuthorString($publicationArray['pub_id'], 'Y', $initialsonly);
  $editors = split(' and ', $editorstring);
  if ($editorstring != "")
  {
    $elements[] = "editor";
  }
  $keywords = split('[,;]', $publicationArray['keywords']);
  
  $result .= getRISExportElement($elements, "title",        $publicationArray['title'],        "T1");
  foreach ($authors as $author)
  	$result .= getRISExportElement($elements, "author",     $author,                           "A1");
  foreach ($editors as $editor)
  	$result .= getRISExportElement($elements, "editor",     $editor,                           "ED");
  $result .= getRISExportElement($elements, "journal",      $publicationArray['journal'],      "JA");
  $result .= getRISExportElement($elements, "booktitle",    $publicationArray['booktitle'],    "TI");
  $result .= getRISExportElement($elements, "series",       $publicationArray['series'],       "T3");
  $result .= getRISExportElement($elements, "year",         $publicationArray['year'],         "Y1");
  $result .= getRISExportElement($elements, "volume",       $publicationArray['volume'],       "VL");
  $result .= getRISExportElement($elements, "type",         $publicationArray['type'],         "M1");
  $result .= getRISExportElement($elements, "number",       $publicationArray['number'],       "IS");
  $result .= getRISExportElement($elements, "edition",      $publicationArray['edition'],      "U1");
  $result .= getRISExportElement($elements, "pages",        $publicationArray['firstpage'],    "SP");
  $result .= getRISExportElement($elements, "pages",        $publicationArray['lastpage'],     "EP");
  $result .= getRISExportElement($elements, "chapter",      $publicationArray['chapter'],      "U2");
  $result .= getRISExportElement($elements, "publisher",    $publicationArray['publisher'],    "PB");
  $result .= getRISExportElement($elements, "school",       $publicationArray['school'],       "T2");
  $result .= getRISExportElement($elements, "organization", $publicationArray['organization'], "T2");
  $result .= getRISExportElement($elements, "institution",  $publicationArray['institution'],  "T2");
  $result .= getRISExportElement($elements, "location",     $publicationArray['location'],     "CY");
  $result .= getRISExportElement($elements, "address",      $publicationArray['address'],      "AD");
  $result .= getRISExportElement($elements, "isbn",         $publicationArray['isbn'],         "SN");
  $result .= getRISExportElement($elements, "issn",         $publicationArray['issn'],         "SN");
  $result .= getRISExportElement($elements, "note",         $publicationArray['note'],         "N1");
  $result .= getRISExportElement($elements, "url",          $publicationArray['url'],          "UR");
  foreach($keywords as $keyword)
  	$result .= getRISExportElement($elements, "keywords",   $keyword,     										 "KW");
  $result .= getRISExportElement($elements, "abstract",     $abstract,                         "N2");
  
  return $result;
}

function getBibExportElement($elements, $element, $data, $name)
{
  $result = "";
  if (in_array($element, $elements) && trim($data) != "") 
  {
    $result .= "  ".$name." = {".urldecode($data)."},\n";
  }
  return $result;
}

function getRISExportElement($elements, $element, $data, $name)
{
	//U1: edition
	//U2: chapter
  $result = "";
  if (in_array($element, $elements) && trim($data) != "") 
  {
  	if ($name == "U1") $data = "Edition: ".$data;
  	if ($name == "U2") $data = "Chapter: ".$data;
    
    $result .= $name."  - ".urldecode($data)."\n";
  }
  return $result;
}

function getBibExportUserfields($userfields)
{
  $result = "";
  if ($userfields != "")
  {
    $field = strtok($userfields,",");
	  while (strlen($field) > 0) 
	  {
  		$result .= $field.",\n";
  		$field = strtok(",");
	  }
	}
	return $result;
}

function getRISExportUserfields($userfields)
{
  $result = "";
  if ($userfields != "")
  {
    $field = strtok($userfields,",");
	  while (strlen($field) > 0) 
	  {
  		$result .= "M1  - ".$field."\n";
  		$field = strtok(",");
	  }
	}
	return $result;
}

function checkYear( $year )
{
    if ( $year == "0000" )
    {
        return "\bibnodate";
    }
    else
    {
        return $year;
    }
}



?>