<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to import publications into Aigaion
Each function returns a string that contains (parts of) a form.

  parseAigaionFirstName($author)
    returns a formatted first name.
    
  fillEmptyFields($entry)
    sets unset fields to a value suited for storing in the DB
      
*/
require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/functions/bibtexfunctions.php");
include_once($DIR."lib/functions/risfunctions.php");




# parseAigaionFirstName
# returns a neatly formatted first author name
function parseAigaionFirstName($author) {
  
  $initials = str_replace(" ", ".", trim($author[1]));
  if ($initials != "") {
    $initials .= ".";
  }
  $firstname = trim(trim($author[0]).' '.$initials);
  
  return $firstname;
}

# fillEmptyFields($entry)
# sets unset fields to a value suited for storing in the DB
function fillEmptyFields($entry) {
  if (!isset($entry["year"]))
  $entry["year"] = "0000";
  if (!isset($entry["title"]))
  $entry["title"] = "";
  if (!isset($entry["type"])) //used for indicating report type
  $entry["type"] = "";
  if (!isset($entry["survey"]))
  $entry["survey"] = "0";
  if (!isset($entry["mark"]))
  $entry["mark"] = "5";
  if (!isset($entry["series"]))
  $entry["series"] = "";
  if (!isset($entry["volume"]))
  $entry["volume"] = "";
  if (!isset($entry["publisher"]))
  $entry["publisher"] = "";
  if (!isset($entry["location"]))
  $entry["location"] = "";
  if (!isset($entry["issn"]))
  $entry["issn"] = "";
  if (!isset($entry["isbn"]))
  $entry["isbn"] = "";
  if (!isset($entry["firstpage"]))
  $entry["firstpage"] = "";
  if (!isset($entry["lastpage"]))
  $entry["lastpage"] = "";
  if (!isset($entry["journal"]))
  $entry["journal"] = "";
  if (!isset($entry["booktitle"]))
  $entry["booktitle"] = "";
  if (!isset($entry["number"]))
  $entry["number"] = "";
  if (!isset($entry["institution"]))
  $entry["institution"] = "";
  if (!isset($entry["address"]))
  $entry["address"] = "";
  if (!isset($entry["chapter"]))
  $entry["chapter"] = "";
  if (!isset($entry["edition"]))
  $entry["edition"] = "";
  if (!isset($entry["howpublished"]))
  $entry["howpublished"] = "";
  if (!isset($entry["month"]))
  $entry["month"] = "";
  if (!isset($entry["organization"]))
  $entry["organization"] = "";
  if (!isset($entry["school"]))
  $entry["school"] = "";
  if (!isset($entry["note"]))
  $entry["note"] = "";
  if (!isset($entry["url"]))
  $entry["url"] = "";
  if (!isset($entry["keywords"]))
  $entry["keywords"] = "";
  if (!isset($entry["abstract"]))
  $entry["abstract"] = "";
  if (!isset($entry["pages"]))
  $entry["pages"] = "";
  if (!isset($entry["key"]))
  $entry["key"] = "";
  if (!isset($entry["crossref"]))
  $entry["crossref"] = "";

  return $entry;
}
?>