<?php
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*

This file contains general functions for users, among which those that are about personalized theme-support.

themeExists($themeName)
   this function checks whether a named theme exists. Themes are subdirectories of ROOT/themes/
   other than the CVS directory. 

getThemes()
   Return a list of available themes. Themes are subdirectories of ROOT/themes/
   other than the CVS directory. 
   
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

/* this function checks whether a named theme exists. Themes are subdirectories of ROOT/themes/
   other than the CVS directory. 
   Furthermore, the directory should not be empty :-/  (CVS will keep the dirs even if the theme is gone).
   So we also check for theme/css/style.css */
function themeExists($themeName) {
    global $DIR;
    #don't accidentally accept CVS directory...
    if (strtolower($themeName)=="cvs") return false;
    $path = $DIR."themes/".$themeName."/";
    return (file_exists($path) && file_exists($path."css/style.css") && is_dir($path));
}

/* Return a list of available themes. Themes are subdirectories of ROOT/themes/
   other than the CVS directory. */
function getThemes() {
    global $DIR;
    $themepath = $DIR."themes/";
    $themelist = array();
    if ($handle = opendir($themepath)) {
    
        /* This is the correct way to loop over the directory. */
        while (false !== ($nextfile = readdir($handle))) {
            if (($nextfile != "." && $nextfile != "..") && (strtolower($nextfile)!="cvs") && (is_dir($themepath."/".$nextfile))&& file_exists($themepath."/".$nextfile."/css/style.css")) {
                $themelist[] = $nextfile;
            }
        }
        closedir($handle);
    }    
    return $themelist;
}

?>