<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to handle publications in Aigaion
  
  getPublicationArrayFromSubmit(&$publicationArray)
    gets all elements in the publication form and stores it in the input array
  
  getPublicationArrayFromDB(&$publicationArray)
    gets all elements in the publication form and stores it in the input array
  
  checkSubmittedPublicationFields(&$publicationArray)
    checks the submitted fields for errors
    
  publicationRepost(&$publicationArray, $targetPage=publication)
    repost the submitted fields to the selected targetPage
*/
require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

function getPublicationArrayFromSubmit(&$publicationArray)
{
  global $DIR;
  
  include_once($DIR."lib/functions/bibtexfunctions.php");
  include_once($DIR."lib/functions/specialcharfunctions.php");

  $publicationArray['return'] = "";
  if (isset($_REQUEST["return"])) {
    $publicationArray['return'] = $_REQUEST["return"];
  }
  
  $publicationArray['pub_id'] = "";
  if (isset($_REQUEST["pub_id"])) {
    $publicationArray['pub_id'] = $_REQUEST["pub_id"];
  }
  
  $publicationArray['action'] = "";
  if (isset($_REQUEST["action"])) {
    $publicationArray['action'] = $_REQUEST["action"];
  }
  
  $publicationArray['submittype'] = "";
  if (isset($_REQUEST["submittype"])) {
    $publicationArray['submittype'] = $_REQUEST["submittype"];
  }
  
  $publicationArray['enteredby'] = "";
  if (isset($_REQUEST["enteredby"])) {
    $publicationArray['enteredby'] = $_REQUEST["enteredby"];
  }
  
  $publicationArray['authors'] = "";
  if (isset($_REQUEST["authors"])) {
    $publicationArray['authors'] = $_REQUEST['authors'];
  }
  
  $publicationArray['editors'] = "";
  if (isset($_REQUEST["editors"])) {
    $publicationArray['editors'] = $_REQUEST['editors'];
  }
  
  $publicationArray['userfields'] = "";
  if (isset($_REQUEST["userfields"])) {
    $publicationArray['userfields'] = $_REQUEST['userfields'];
  }
  
  $supportedFields = bibGetSupportedFields();
  
  foreach ($supportedFields as $supportedField)
  {
    $publicationArray[$supportedField] = "";
    if (isset($_REQUEST[$supportedField])) {
      $publicationArray[$supportedField] = $_REQUEST[$supportedField];
    }
  }
  if (get_magic_quotes_gpc()==1) 
  {
    stripSlashesFromArray($publicationArray);
  }
  quotesToHTMLFromArray($publicationArray);
}

function getPublicationArrayFromDB($pub_id, &$publicationArray)
{
  global $DIR;
  
  include_once($DIR."lib/functions/bibtexfunctions.php");
  include_once($DIR."lib/functions/specialcharfunctions.php");

  $Q = mysql_query("SELECT * FROM publication WHERE pub_id = ".$pub_id);
  
  if (mysql_num_rows($Q) > 0)
  {
    $publicationArray = mysql_fetch_array($Q);
  }
  //not all fields have the same name as in the database 

  $publicationArray['bibtexEntryType']  = $publicationArray['type'];
  $publicationArray['bibtexCitation']   = $publicationArray['bibtex_id'];
  $publicationArray['type']             = $publicationArray['pub_type'];
  
  quotesToHTMLFromArray($publicationArray);
}

function checkSubmittedPublicationFields($publicationArray)
{
  //error codes:
  //-1: Double bibtex cite id. choose other
  //-2: Title is empty
  //-3: Bibtex ID changed while other publications refer to this bibtex id
  $error = 0;
  if (trim($publicationArray['bibtexCitation']) != "")
  {
    $pub_id = $publicationArray['pub_id'];
    if ($pub_id != "")
    {
      $Q = mysql_query("SELECT bibtex_id FROM publication WHERE bibtex_id='".$publicationArray['bibtexCitation']."' AND pub_id!=".$pub_id."");
    }
    else
    {
      $Q = mysql_query("SELECT bibtex_id FROM publication WHERE bibtex_id='".$publicationArray['bibtexCitation']."'");
    }

    if ($Q) 
    {
    	if (mysql_numrows($Q)>0) 
    	{  //apparently, there is already an article with the same bibtex ID
        $_SESSION["aigaionerror"] .= "The bibtex ID is already in use, please choose another ID.<br/>";
        $error = -1;
      }
    }
  }
  if ($publicationArray['title'] == "") 
  {
    $_SESSION["aigaionerror"] .= "The title field is empty, please enter a title.<br/>";
    $error = -2;
  }
  
  if (($pub_id != "") && ($error == 0))
  {
    $Q = mysql_query("SELECT publication.bibtex_id FROM publication, publication as copy WHERE publication.pub_id=".$pub_id." AND publication.bibtex_id=copy.crossref AND publication.bibtex_id!=''");
    if (mysql_num_rows($Q) > 0)
    {
      $R = mysql_fetch_array($Q);
      if ($R['bibtex_id']!= $publicationArray['bibtexCitation'])
      {
        $_SESSION["aigaionerror"] .= "Bibtex cite ID changed.<br/>";
        $error = -3;
      }
    }
  }
  
  
  return $error;
}

function publicationRepost(&$publicationArray, $targetPage="publication")
{
  global $URL;
  $form  = "";
  $form .= "<form name='publicationform' enctype='multipart/form-data' method='post' action='".$URL."index.php?page=".$targetPage."&kind=".$publicationArray['action']."'>\n";
  
  $keys = array_keys($publicationArray);
  foreach ($keys as $key)
  {
    $form .= "<input type='hidden' name=".$key." value='".$publicationArray[$key]."'>\n";
  }
  $form .= "</form>\n";
  echo $form;
  ?>
  <script type="text/javascript">
    document.publicationform.submit();
  </script>
  <?php 
}
?>