<?php 
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This file offers several functions to import publications into Aigaion. For parsing
the entries, the RIS parser is called. The rest can be parsed by the standard bibtex parser.
Each function returns a string that contains (parts of) a form.

  risParse($risData)
    Creates an instance of therisparser to parse ris data. Output is the same as from 
    the bibliophile bibtex parser.
    returns an array with parsed entries
    
  getRISEntryType($bibEntryType)
  	Converts a bibtex entry type to the corresponding RIS type
    
*/
require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."includes/risparse/risPARSEENTRIES.php");

# risParse($risData)
function risParse($risData) {
  
  $cParseEntries = NEW parseRIS();
  
  $cParseEntries->loadRISString($risData);

  $cParseEntries->extractEntries();

  list($preamble, $strings, $entries) = $cParseEntries->returnArrays();

  return $entries;
}

function getRISEntryType($bibEntryType)
{
	$return = "";
	switch($bibEntryType) {
	  case "Article":
    $return = "JOUR";
    break;
    case "Book":
    $return = "BOOK";
    break;
    case "Booklet":
    $return = "BOOK";
    break;
    case "Inbook":
    $return = "CHAP";
    break;
    case "Incollection":
    $return = "MGZN";
    break;
    case "Inproceedings":
    $return = "CONF";
    break;
    case "Manual":
    $return = "GEN ";
    break;
    case "Mastersthesis":
    $return = "RPRT";
    break;
    case "Misc":
    $return = "GEN ";
    break;
    case "Phdthesis":
    $return = "THES";
    break;
    case "Proceedings":
    $return = "CONF";
    break;
    case "Techreport":
    $return = "RPRT";
    break;
    case "Unpublished":
    $return = "UNPB";
    break;
    default:
    break;
  }
  return $return;
}
?>