<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file offers several functions to display authors.
Each function returns a string, which can then be processed as the caller sees fit.

- displayEditors($pub_id) returns a formatted list of all editors of a publication with given pub_id.
  Each displayed name links to the corresponding author page.

- displayAuthors($pub_id) returns a formatted list of all authors of a publication with given pub_id.
  Each displayed name links to the corresponding author page.

- showAllAuthors will show a list of author names linked to author pages for all authors in the database,
  in an unordered list

- showAuthorsForTopic($topic_id) will show a list of author names linked to author pages for all authors 
  in the database that publish on the given topic, in an unordered list.

- In the future, the name-formatting functions may move to this file as well.


*/

//if this script is not called from within one of the base pages, redirect to frontpage
require_once("checkBase.php");
include_once($DIR."lib/functions/authorfunctions.php");


/* displayEditors($pub_id) returns a formatted list of all editors of a publication with given pub_id.
   Each displayed name links to the corresponding author page.*/
function displayEditors($pub_id) {
    return displayPersons($pub_id, 'Y');
}


/* displayAuthors($pub_id) returns a formatted list of all authors of a publication with given pub_id.
   Each displayed name links to the corresponding author page.*/
function displayAuthors($pub_id) {
    return displayPersons($pub_id, 'N');
}

/* showAllAuthors will show a list of author names linked to author pages for all authors in the database,
   in an unordered list */
function showAllAuthors() {
    showAuthorsForTopic(0);
}

/* showAuthorsForTopic($topic_id) will show a list of author names linked to author pages for all authors 
   in the database that publish on the given topic, in an unordered list. */
function showAuthorsForTopic($topic_id) {
    $result = "";
    // Has topic_id as id for topic	
    if ((isset($topic_id)) && ($topic_id > 0 ))
    {
        $query="SELECT DISTINCT author.ID , author.surname, author.name FROM publicationauthor, topicpublication, author WHERE";
        $query .= " topicpublication.topic_id='$topic_id' AND topicpublication.pub_id=publicationauthor.pub_id AND publicationauthor.author=author.ID";
        $query .= " ORDER BY author.surname ";
    }
    else
    {
        $query = "SELECT *  FROM author ORDER BY author.surname";
    }
    
    
    $result .= "<UL TYPE=\"none\">\n";
    $Q = mysql_query($query);		
    while ($R = mysql_fetch_array($Q))
    {
        $result .= "<LI><A HREF=\"$ROOT?page=author&author_id=".$R['ID']."\">".getNameFromRow($R)."&nbsp;</A>\n";
    }
    $result .= "</UL>\n";
    return $result;
}

?>

<?php 
/*
HELPER FUNCTIONS, USED INTERNALLY
*/

/* This function does the actual work, getting the authors or editors and displaying them. */
function displayPersons($pub_id, $editor='N') {
    $result = "";
    $res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='".$editor."' ORDER by rank;");
    if($res) {
        $authornr=1;
        $num=mysql_num_rows($res);
        while($row=mysql_fetch_array($res)) {
            switch ($authornr) {
                case 1:
                    break;
                case $num:
                    $result.="&nbsp;and&nbsp;";
                    break;
                default:
                    $result.=",&nbsp;";
                    break;
            }
            $authornr++;
            //get author data
            $res2=mysql_query("SELECT author.* FROM author WHERE author.ID=".$row["author"]." ORDER BY surname,name");
            if ($res2) {
                $row=mysql_fetch_array($res2);
                $result.='<A HREF="index.php?page=author&author_id='.$row["ID"].'">';
                $result.=$row["surname"].", ".$row["name"];
                $result.="</A>";
            }
        }
        if (($editor=="Y") && ($num>0)) {
            $result.=" (eds), ";
        } else if ($num>0) {
            $result.="&nbsp;";
        }
    }
    return $result;
}
?>