<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This file offers several functions to display notes for publications.
Each function returns a string, which can then be processed as the caller sees fit.

- displayNote($note_id) returns a <DIV class=readernote> block containing the information of the 
  given note. If the note is created by the current user, edit and delete links are added to the display.
  The note text will be enhanced with links to corresponding publications for every valid bibtex ID 
  included in the note text.

- displayNotesForPublication($pub_id) returns a series of <DIV class=readernote> blocks, one for each 
  note added to the given publication.

*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."lib/displays/publicationdisplays.php");

#Register request and session vars
//none...

/*  Function which adds a magnifying glass icon when a note contains 'file://'. 
    All remaining contents of the note are used to form a hyperlink
    (c) GtB
    */
function displaypublicationnetworkfilelink($pub_id)
{
    include "config.php"; // for access to themes etc
    $result="";
    // If Note is starting with 'file' then interpret as file location
    $query = "SELECT note_id, person_id, text FROM personpublicationnote WHERE pub_id=$pub_id AND text LIKE  '%file://%' ORDER BY note_id ASC";
    $notes = mysql_query($query);
    while( $row = mysql_fetch_array($notes) ) {
		$text=$row["text"]; 
		$result .= "<IMG onmousedown=\"window.open('".str_replace('\\','\\\\',$text)."','mywindow');\" title='view this article' SRC=\"".$URL.$THEME."icons/_download_small.gif\" border=0>";
    }
    return $result;
}

/*  Function which adds an icon when a note contains 'mustread://'. 
    (c) GtB
    */
function displaypublicationprinted($pub_id)
{
    include "config.php"; // for access to themes etc
    $result="";
    // If Note is starting with 'file' then interpret as file location
    $query = "SELECT note_id, person_id, text FROM personpublicationnote WHERE pub_id=$pub_id AND text LIKE  '%printed://%' ORDER BY note_id ASC";
    $notes = mysql_query($query);
    while( $row = mysql_fetch_array($notes) ) {
		$text=$row["text"]; 
		$result .= "<IMG title='This article is printed and stored somewhere' SRC=\"".$URL.$THEME."icons/__printer_small.gif\" border=0>";
	
    }
    return $result;
}

/*  Function which adds an icon when a note contains 'mustread://'. 
    (c) GtB
    */
function displaypublicationmustread($pub_id)
{
    include "config.php"; // for access to themes etc
    $result="";
		
    // If Note is starting with 'file' then interpret as file location
    $query = "SELECT note_id, person_id, text FROM personpublicationnote WHERE pub_id=$pub_id AND text LIKE  '%mustread://%' ORDER BY note_id ASC";
    $notes = mysql_query($query);
    while( $row = mysql_fetch_array($notes) ) {
		
		$result .= "<FONT color=#FF0000><B>!</B></FONT>";
	
    }
    return $result;
}

/*  Function which adds an icon. When clicked on this icon, a box appears in which the user can 
    add the publication to a topic
    (c) GtB
    
    DR: wat heeft dit met notes te maken?
    */
function displaypublicationaddtopic($pub_id)
{
    include "config.php"; // for access to themes etc
    $result="";
    $result .= "<IMG title='Klikdan' SRC=\"".$URL.$THEME."icons/_expand_small.gif\" border=0 ";
    $result .= "onmousedown=\"if (document.getElementById('lala$pub_id').style.display=='none'){document.getElementById('lala$pub_id').style.display = 'block'}else{document.getElementById('lala$pub_id').style.display = 'none'};\">";
	$result.= "<DIV ID='lala$pub_id' style='display:none; border-style:solid ;border-width:1px'> <BR>";
    $res=mysql_query("SELECT * FROM topic, topicpublication WHERE topicpublication.pub_id=$pub_id  AND topicpublication.topic_id=topic.ID AND name<>'Top' ");
    if ($res) {
        while ($row=mysql_fetch_array($res))
        {
        $result.=$row["name"];
        $result.="<BR>";
        }
	}
	$result.= "<BR><FORM action=\"index.php?page=unassignedpublications\" method=\"post\">";
	$result.= "<input type=\"hidden\" name=\"action\" value=\"topicadd\" />";
	$result.= "<input type=\"hidden\" name=\"pubid\" value=$pub_id />";
	$result.= "Select in which topic the publication must be added:  <select id='SELECT$pub_id' name='value'>";
    $res=mysql_query("SELECT topic.name, topic.ID FROM topic WHERE name<>'Top'");
    if ($res) {
        while ($row=mysql_fetch_array($res))
        {
          $val=$row["name"];
          $value=$row["ID"];
          $result.= "<option value=$value>$val</option>";
        }
    }
	$result.= "</select>";     
    $result.= "<INPUT TYPE=submit value=\"Add topic\">";
    $result.= "</FORM>";                
    $result.="</DIV>";
    return $result;
}

/*  Stub for normal displayNotesForPublication function */
/*  displayNotesForPublication($pub_id) returns a series of <DIV class=readernote> blocks, one for each 
    note added to the given publication. 
	Notes will be not be filtered on keywords	
	(c) GtB
	*/
function displayNotesForPublication($pub_id){
	return displayNotesForPublicationsub($pub_id,0);
}


/*  Stub for filtered displayNotesForPublication function */
/*  displayNotesForPublication($pub_id) returns a series of <DIV class=readernote> blocks, one for each 
    note added to the given publication. 
	Notes will be be filtered on keywords
	(c) GtB
	*/
function displayNotesForPublicationFilterFile($pub_id) {   
	return displayNotesForPublicationsub($pub_id,1);
}

/* displayNotesForPublicationsub($pub_id, $FilterFile) returns a series of <DIV class=readernote> blocks, one for each 
   note added to the given publication. 
   
   $filterfile can be 0 or 1, if filterfile is 1 then the notes with 'keywords' will not be displayed
   
   */
function displayNotesForPublicationsub($pub_id, $FilterFile) {   
    $result = "";
    if (haveRights("READNOTES")) {
        // INIT BIBTEX_ID - to - PUBLICATION LINK mapping
        global $citeIdArray,$citeLinkArray;
        
        //get all notes and display them
        $person_id="";
        if (isset($_SESSION["personID"])) {
          $person_id=$_SESSION["personID"];
        }
        
        //only display all public notes and private notes from the current user
        if ($FilterFile == 1)
        {
			    $query = "SELECT note_id, person_id, rights, text FROM personpublicationnote WHERE pub_id=$pub_id AND (rights = 'public' OR person_id = '".$person_id."') AND text NOT LIKE '%file://%' AND text NOT LIKE '%printed://%'ORDER BY note_id ASC";
        }else
        {
    			$query = "SELECT note_id, person_id, rights, text FROM personpublicationnote WHERE pub_id=$pub_id AND (rights = 'public' OR person_id = '".$person_id."') ORDER BY note_id ASC";
        }
        $notes = mysql_query($query);
        while( $row = mysql_fetch_array($notes) ) {
            $result.= displayNoteText($row["note_id"], $row["person_id"], $row["rights"], $row["text"], $citeIdArray, $citeLinkArray);
        }
    }
    return $result;    
}

/* displayNote($note_id) returns a <DIV class=readernote> block containing the information of the 
   given note. If the note is created by the current user, edit and delete links are added to the display.
   The note text will be enhanced with links to corresponding publications for every valid bibtex ID 
   included in the note text. */
function displayNote($note_id) {
    $result = "";
    if (haveRights("READNOTES")) {
        // INIT BIBTEX_ID - to - PUBLICATION LINK mapping
        global $citeIdArray,$citeLinkArray;
        
        //get note data and display it
        $query = "SELECT note_id, person_id, rights, text FROM personpublicationnote WHERE note_id=$note_id";
        $notes = mysql_query($query);
        if ($row = mysql_fetch_array($notes)) {
            $result.= displayNoteText($row["note_id"], $row["person_id"], $row["rights"], $row["text"], $citeIdArray, $citeLinkArray);
        }
    }    
    return $result;
}

/*
INTERNAL UTILITY FUNCTIONS
*/

/* This function returns the formatted note, with bibtexid's replaced by links to the corresponding publications, 
   using the given arrays as input for replacing bibtex_id's with links to publications. Used by 
   displaynotesforpublication and displaynotes. 
   */
function displayNoteText($note_id, $person_id, $rights, $text, $citeIdArray, $citeLinkArray) {
    include "config.php"; //to get access to theme...
    $result = "";
    $result .= "<DIV class=\"readernote\">";
    //get abbrev for user who wrote note
    $readquery = "SELECT surname,abbreviation FROM person WHERE ID=$person_id";
    $readerrows = mysql_query($readquery);
    $readerrow=mysql_fetch_array($readerrows);
    $result .= "<SPAN title=\"";
    $result .= $readerrow["surname"];
    $result .= "\"><b>";
    $result .= $readerrow["abbreviation"];
    $result .= ":</b></SPAN> ";
    /* GtB */
    if (substr( $text, 0, 7 )=="file://")
    {
		$textold=$text;
		$text = "<a href='";
		$text.= $textold;
		$text.= "'>";
		$text.= "Link to local file";
		$text.= "</a>";
    }else
    {
    //get text, replace links
		$text = html_activate_links($text);
		$text = str_replace($citeIdArray,$citeLinkArray,$text);
    }
    //if writer of note is current user, add edit/delete links
    if ($person_id==$_SESSION['personID'])
    {
        $text.= ' <A title="edit" HREF="index.php?page=notechange&note_id='.$note_id.'"><IMG SRC="'.$URL.$THEME.'icons/_edit_small.gif" ALT="Edit" border=0></A>';
        if ($rights == 'public') {
          $text.= ' <A title="make private" HREF="index.php?page=noterights&note_id='.$note_id.'&new_rights=private"><IMG SRC="'.$URL.$THEME.'icons/_greenstoplight_small.gif" ALT="Make private" border=0></A>';
        }
        else {
          $text.= ' <A title="make public" HREF="index.php?page=noterights&note_id='.$note_id.'&new_rights=public"><IMG SRC="'.$URL.$THEME.'icons/_redstoplight_small.gif" ALT="Make public" border=0></A>';
        }
        $text.= ' <A title="delete" HREF="index.php?page=notedelete&note_id='.$note_id.'"><IMG SRC="'.$URL.$THEME.'icons/_delete_small.gif" ALT="Delete" border=0></A>';
    }
    $result .= $text;
    $result .= "</DIV>";
    return $result;
}
?>
