<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
This page contains functions to display single publications as well as lists publications resulting
from queries on the database. Each function returns a string, which can then be processed as the 
caller sees fit.

- displayPublication($publication_table_row) returns a completely formatted publication for the given 
  row from the publication table. 

- displayPublicationNoNotes($publication_table_row) returns the same, but without the reader notes at 
  the end.
  
- displayPublicationByID($pub_id) returns a completely formatted publication text for the publication 
  with the given ID. 
  
- displayPublicationListFromQuery($querytext) returns a list completely formatted publication for all
  publications resulting from the query. Use with care: if the query returns anything else than 
  publications from the publication table, unpredictable behaviour may follow. 
  

GtB:
- Extra parameters $tabletype and $displaytype are added, see functions for reference. 
  displaytype is used to define the display order of the publication (title or authors first)
  tabletype is used to add additional table formatting, in this case the UI is much more friendlier and ordered.
  In most functions these variables are just forwarded to a subfunction... 
*/
require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include "displayauthors.php";
//include_once "displaynotes.php";
include_once($DIR."lib/displays/attachmentdisplays.php");
include_once($DIR."lib/displays/notedisplays.php");



/* displayPublicationByID($pub_id, $displaytype=0) returns a completely formatted publication text for the publication 
   with the given ID. 
   
   If Displaytype is 0 then normal formatting is applied
   If Displaytype is 1 then the title of the publication will be put in front of the publication
   If tabletype is 1, then extra Table formatting HTML code is inserted
   */

function displayPublicationByID($pub_id, $displaytype=0, $tabletype=0) {
    $result = "";
    $res=mysql_query("SELECT publication.* FROM publication where pub_id=".$pub_id);
    if ($res) {
        $row = mysql_fetch_array($res);
		
		$result .= displayPublication($row,$displaytype,$tabletype);
    }
    return $result;
}   

/* displayPublication($publication_table_row) returns a completely formatted publication for the given 
   row from the publication table. 

   If Displaytype is 0 then normal formatting is applied
   If Displaytype is 1 then the title of the publication will be put in front of the publication
   If tabletype is 1, then extra Table formatting HTML code is inserted
   */
function displayPublication($publication_table_row, $display_type=0, $tabletype=0) {
    
    $result = displayPublicationNoNotes($publication_table_row, $display_type, $tabletype);
    
    $result .= "<ul>";
    //DR: new notes libraries activated
    $result .= getAllNotesForPublicationByPubID($publication_table_row["pub_id"]);
    //DR: add a note directly from list of publications...
    //$result .= "<div>".getPersonAbbrevDisplayByID($_SESSION["personID"]).":".getLinkToNoteAddPage($publication_table_row["pub_id"])."</div>";

    //$result .= displayNotesForPublicationFilterFile($publication_table_row["pub_id"]);
    $result .= "</ul>\n";
    return $result;
}  


/* displayPublicationNoNotes($publication_table_row, $displaytype, $tabletype) returns the same, but without the reader notes at 
   the end. 
   
   If displaytype is 0 then normal formatting is applied
   If displaytype is 1 then the title of the publication will be put in front of the publication
   If tabletype is 1, then extra Table formatting HTML code is inserted
   
   */
function displayPublicationNoNotes($publication_table_row, $displaytype=0, $tabletype=0) {
	$result = "";
    if ($tabletype==1)
	{
		
		$result.="<TR><TD >";//width=25px
	}
    include "config.php"; // for access to themes etc
    //read fields from table row
    //$result = "<DIV>";
    $pub_id=$publication_table_row["pub_id"];
    $entered=$publication_table_row["entered_by"];
    $year=$publication_table_row["year"];
    $title=$publication_table_row["title"];
    $bibtex_id=$publication_table_row["bibtex_id"];
    $pubtype=$publication_table_row["type"];
    $journal=$publication_table_row["journal"];
    $iss=$publication_table_row["issn"];
    $volume=$publication_table_row["volume"];
    $firstpage=$publication_table_row["firstpage"];
    $lastpage=$publication_table_row["lastpage"];
    $series=$publication_table_row["series"];
    $volume=$publication_table_row["volume"];
    $publisher=$publication_table_row["publisher"];
    $location=$publication_table_row["location"];
    $isbn=$publication_table_row["isbn"];
    $number=$publication_table_row["number"];
    $institution=$publication_table_row["institution"];
    $booktitle=$publication_table_row["booktitle"];

//DR 2005.06.13: a checkbox per publication, named check_<pub_id>, that can be used for e.g. 'move all to topic X'
//echo '<input title="see bottom of page for multiple-publication-operations" type=checkbox name="check_"'.$pub_id.'">';
                
    //BIBTEX link
    $result .= "<a title='BiBTeX' class=small HREF='".$URL."indexlight.php?page=perbibtex&ID=".$pub_id."' target='_blank'><IMG SRC=\"".$URL.$THEME."icons/_bibtex_small.gif\" border=0></a>&nbsp;";
    
    //edit publication link, if user has sufficient rights
    if (haveRights("EDIT")) {
        $result .= "<a title='edit' class=small href=\"index.php?page=publicationform&command=edit&ID=$pub_id\"><IMG SRC=\"".$URL.$THEME."icons/_edit_small.gif\" border=0></a>&nbsp;";
    }

	//DR: temporarily removed, till we know how these tags are to be solved
	//$result.= displaypublicationnetworkfilelink($pub_id);
    //$result.= displaypublicationprinted($pub_id);
        
    
    //view publication file link, if user has sufficient rights
    $res=mysql_query("SELECT * FROM publicationfile WHERE pub_id =".$pub_id." AND ismain='TRUE';");
    if ($res) {
        if ($row=mysql_fetch_array($res) ) {
            if (haveRights("PDF")) {
                //DR: new attachment libraries activated
                $result .= getAttachmentDownloadLink($row)."&nbsp;";
                //$result .= "<A title='view article' target='_blank' HREF=".$FILEURL.$row['location']."><IMG SRC=\"".$URL.$THEME."icons/_download_small.gif\" border=0></a>&nbsp;";
            }
        }                
    }
    if ($tabletype==1)
	{
		$result.="</TD><TD>";
	}
    
    //DR: removed (temporarily?). I think we wat to do this completely different.
    //$result.= displaypublicationaddtopic($pub_id);
    
    $result.= " ";
    if ($displaytype==0)
    {
		//display authors            
		$result .= displayAuthors($pub_id);
    
		//display title as link to publication page
		$result .= "<i><A HREF=".$ROOT."?page=perpublication&ID=".$pub_id.">".htmlspecialchars(urldecode($title))."</A></i>,&nbsp;";
    }else
    {
		//display title as link to publication page
		$result .= "<i><A HREF=".$ROOT."?page=perpublication&ID=".$pub_id.">".htmlspecialchars(urldecode($title))."</A></i>,&nbsp;";
	
		//display authors            
		$result .= displayAuthors($pub_id);
    }
    //other fields are publication type dependent..
    switch ($pubtype) {
        case "Proceedings":
            if ($booktitle) {
                $result .= "in <i>".htmlspecialchars(urldecode($booktitle))."</i>, ";
            }
            $result .= displayEditors($pub_id);
            if ($series) {
                $result .= "<i>".urldecode($series)."</i>, ";
            }
            if ($volume) {
                $result .= "volume ".urldecode($volume).", ";
            }
            if ($publisher) {
                $result .= urldecode($publisher).", ";
            }
            if ($location) {
                $result .= urldecode($location).", ";
            }
            if ($isbn) {
                $result .= "ISBN&nbsp;".urldecode($isbn).", ";
            }
            if ($iss) {
                $result .= "ISS&nbsp;".urldecode($iss).", ";
            }
            if ($firstpage) {
                if ($lastpage) {
                    $result .= "pp.&nbsp;".$firstpage."-".$lastpage.", ";
                }
            }
            break;
        case "Journal":
            if ($journal) {
                $result .= urldecode($journal).", ";
            }
            $result .= displayEditors($pub_id);
            if ($volume) {
                $result .= urldecode($volume);
            }
            if ($firstpage) {
                if ($lastpage) {
                    if ($volume) {
                        $result .= ":";
                    } else {
                        $result .= "pages&nbsp;";
                    }
                    $result .= $firstpage."-".$lastpage.", ";
                }
            } else {
                if ($volume) {
                    $result .= ", ";
                }
            }
            if ($iss) {
                $result .= "ISS&nbsp;".urldecode($iss).", ";
            }
            break;

        case "Report":
            if ($number) {
                $result .= urldecode($number).", ";
            }
            if ($institution) {
                $result .= urldecode($institution).", ";
            }
            if ($location) {
                $result .= urldecode($location).", ";
            }
            if ($publisher) {
                $result .= urldecode($publisher).", ";
            }
            break;

        case "BookSection":
            if ($firstpage) {
                $result .= "pp. ".urldecode($firstpage)."-";
            }
            if ($lastpage) {
                $result .= $lastpage.". ";
            }
            if ($titlebook) {
                $result .= "In&nbsp;<i>".htmlspecialchars(urldecode($titlebook))."</i>, ";
            }
            $result .= displayEditors($pub_id);
            if ($publisher) {
                $result .= urldecode($publisher).", ";
            }
            if ($location) {
                $result .= urldecode($location).", ";
            }
            if ($iss) {
                $result .= "ISS&nbsp;".urldecode($iss).", ";
            }
            if ($isbn) {
                $result .= "ISBN&nbsp;".urldecode($isbn).", ";
            }
            break;

        case "Misc":
            if ($location) {
                $result .= $location.", ";
            }
            break;

        case "Book":
            $result .= displayEditors($pub_id);
            if ($series) {
                $result .= urldecode($series).", ";
            }
            if ($volume) {
                $result .= "Vol: ".urldecode($volume).". ";
            }
            if ($publisher) {
                $result .= urldecode($publisher).", ";
            }
            if ($location) {
                $result .= urldecode($location).", ";
            }
            if ($iss) {
                $result .= "ISS&nbsp;".urldecode($iss).", ";
            }
            if ($isbn) {
                $result .= "ISBN&nbsp;".urldecode($isbn).", ";
            }
            break;

        case "Dissertation":
            if ($location) {
                $result .= urldecode($location).", ";
            }
            break;
    } // end of publication-type dependent switch

    //display year
    $result .= $year;
    

    return $result;
}   

  
/* displayPublicationListFromQuery($querytext) returns a list completely formatted publication for all
   publications resulting from the query. Use with care: if the query returns anything else than 
   publications from the publication table, unpredictable behaviour may follow. 

   If tabletype is set, the extra Table formatting HTML code is inserted
   
   */
//NOTE: RIGHT NOW< THIS FUNCTION ASSUMES THE QUERY SORTS ON YEAR!!
function displayPublicationListFromQuery($querytext,$tabletype=0) {
    $result = "";
    $res=mysql_query($querytext);
    $oldyear = "";
    if($res) {
        while ($row=mysql_fetch_array($res)) { //for each row from publication table contained in query result
		    $result .= "<tr><td>";

            $year=$row["year"];

            //mention year
            if ($oldyear != "$year") {
                
                $result .= "<p class=header>".$year."</p>";
                $result .= "</TD><TD><p class=header>&nbsp </p>";
                $oldyear=$year;
            }
			
            $result .= displayPublication($row,0,$tabletype);
            $result .= "</td></tr>";
        }
    }
    return $result;
}

?>
