<?php 
/* test bibtex input:
@inproceedings{spb95,
	author	    =	"Shapiro J. L. and A. Pr{\"u}gel-Bennett",
	title	    =	"Maximum {E}ntropy {A}nalysis of {G}enetic
			 {A}lgorithm {O}perators",
	booktitle   =	"Lecture notes in Computer Science {\bf 993}",
	year	    =	"1995",
	editor	    =	"T. C. Fogarty",
	pages	    =	"14--24",
	publisher   =	"Springer-Verlag",
	address	    =	"Berlin"
}
*/
/*
Web based document management system
Copyright (C) 2003,2004 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

#Register request and session vars
$action="";
if (isset($_REQUEST["action"])) {
  $action=$_REQUEST["action"];
}
$bibtexData="";
if (isset($_REQUEST["bibtexData"])) {
  $bibtexData=$_REQUEST["bibtexData"];
}

checkRights("EDIT");

######### HELPER FUNCTIONS ############

# bibParse($bibtexData)
# calls the bibtex parser and returns the parsed entries in an array
function bibParse($bibtexData) {
  $cParseEntries = NEW PARSEENTRIES();
  $cParseEntries->expandMacro = TRUE;

  $cParseEntries->loadBibtexString($bibtexData);

  $cParseEntries->extractEntries();
  
  //$macro = array("shapiro" => "shipira");
  $macro = array('"u' => '&uuml;');
  $cParseEntries->loadStringMacro($macro);

  list($preamble, $strings, $entries) = $cParseEntries->returnArrays();
  
  return $entries;
}


# bibParseAuthors($authors)
function bibParseAuthors($authors) {
  $cParseCreators = NEW PARSECREATORS();
  
  return $cParseCreators->parse($authors);
}

# bibParsePages($pages)
# returns a list ($firstpage, $lastpage)
function bibParsePages($pages) {
  $cParsePage = new PARSEPAGE();
  return $cParsePage->init($pages);
}

# bibParseMonth($month)
# returns a list ($month, $day)
function bibParseMonth($month) {
  $cParseMonth = new PARSEMONTH();
  return $cParseMonth->init($month);
}

# getAigaionFirstName
# returns a neatly formatted first author name
function getAigaionFirstName($author) {
  $initials = str_replace(" ", ".", trim($author[1]));
  if ($initials != "") {
    $initials .= ".";
  }
  $firstname = trim(trim($author[0]).' '.$initials);
  return $firstname;
}

# fillEmptyFields($entry)
# sets unset fields to a value suited for storing in the DB
function fillEmptyFields($entry) {
  if (!isset($entry["year"]))
    $entry["year"] = "0000";
  if (!isset($entry["title"]))
    $entry["title"] = "";
  if (!isset($entry["type"]))
    $entry["type"] = "Journal";
  if (!isset($entry["survey"]))
    $entry["survey"] = "0";
  if (!isset($entry["mark"]))
    $entry["mark"] = "6";
  if (!isset($entry["series"]))
    $entry["series"] = "";
  if (!isset($entry["volume"]))
    $entry["volume"] = "";
  if (!isset($entry["publisher"]))
    $entry["publisher"] = "";
  if (!isset($entry["location"]))
    $entry["location"] = "";
  if (!isset($entry["issn"]))
    $entry["issn"] = "";
  if (!isset($entry["isbn"]))
    $entry["isbn"] = "";
  if (!isset($entry["firstpage"]))
    $entry["firstpage"] = "";
  if (!isset($entry["lastpage"]))
    $entry["lastpage"] = "";
  if (!isset($entry["journal"]))
    $entry["journal"] = "";
  if (!isset($entry["booktitle"]))
    $entry["booktitle"] = "";
  if (!isset($entry["number"]))
    $entry["number"] = "";
  if (!isset($entry["institution"]))
    $entry["institution"] = "";
  if (!isset($entry["address"]))
    $entry["address"] = "";
  if (!isset($entry["chapter"]))
    $entry["chapter"] = "";
  if (!isset($entry["edition"]))
    $entry["edition"] = "";
  if (!isset($entry["howpublished"]))
    $entry["howpublished"] = "";
  if (!isset($entry["month"]))
    $entry["month"] = "";
  if (!isset($entry["organization"]))
    $entry["organization"] = "";
  if (!isset($entry["school"]))
    $entry["school"] = "";
  if (!isset($entry["note"]))
    $entry["note"] = "";
  if (!isset($entry["keywords"]))
    $entry["keywords"] = "";
  if (!isset($entry["abstract"]))
    $entry["abstract"] = "";
  if (!isset($entry["pages"]))
    $entry["pages"] = "";
  if (!isset($entry["key"]))
    $entry["key"] = "";
  
  return $entry;
}

# normalizedType($type)
# normalizes bibtex to aigaion types
function normalizedType($type) {
  switch (strtolower($type) )
  {
    case "article":
    return "Journal";
    break;
    case "book":
    return "Book";
    break;
    case "booklet":
    return "Booklet";
    break;
    case "inbook":
    return "BookSection";
    break;
    case "incollection":
    return "Incollection";
    break;
    case "inproceedings":
    return "Proceedings";
    break;
    case "manual":
    return "Manual";
    break;
    case "mastersthesis";
    return "Mastersthesis";
    break;
    case "misc":
    return "Misc";
    break;
    case "phdthesis":
    return "Dissertation";
    break;
    case "proceedings":
    return "Proceedings";
    break;
    case "techreport":
    return "Report";
    break;
    case "unpublished";
    return "Unpublished";
    break;
    default :
    echo "<div class='errormessage'>";
    echo "No entrytype: ".$firstpubtype." does not exist, see http://www.ecst.csuchico.edu/~jacobsd/bib/formats/bibtex.html for details";
    echo "</div>";
    
    die();

  }
}



######### EDIT FUNCTIONS ############

# getReviewForm($entries, $bibtexData)
# displays the full review form of all entries to be imported
function getReviewForm($entries, $bibtexData) {
  $result = '';

  //present import review form
  $result .='<form method="post">';
  $result .='<input type=hidden name=action value=commit>';

  $nrOfEntries=0;
  $nrOfTopics=0;
  $nrOfTopicLinks=0;

  $topicReviewHtml="";
  $topicLinkReviewHtml="";
  $entryReviewHtml="";

  foreach ($entries as $entry) {
    //check whether input is normal bibtex or aigaion code (topic, topiclink)
    if ($entry["bibtexEntryType"]=="aigaiontopic") {
      //getTopicReviewForm
      //$topicReviewHtml .= getTopicReviewForm
      //$nrOfTopics++;
    }
    else if ($entry["bibtexEntryType"]=="aigaiontopictopiclink") {
      //getTopicLinkReviewForm
      //$topicLinkReviewHtml .= getTopicLinkReviewForm
      //$nrOfTopicLinks++;
    }
    else {
      //getEntryReviewForm
      $entryReviewHtml .= getEntryReviewForm($entry, $nrOfEntries);
      $nrOfEntries++;
    }
  }

  if ($nrOfEntries != 0) {
    $result .="<p class=header>Please review the publications to be imported</p>";
    $result .=$entryReviewHtml;
  }
  if ($nrOfTopics != 0) {
    $result .="<p class=header>Please review the topics to be imported</p>";
    $result .=$topicReviewHtml;
  }
  if ($nrOfTopicLinks != 0) {
    $result .="<p class=header>Please review the topic links to be imported</p>";
    $result .=$topicLinkReviewHtml;
  }

  //the presented forms only contains IDs and no complete corrected entries.
  //when commiting, the original input is parsed again. Changes are updated either
  //directly out of the database or (in case of citeID) from the form.

  $result .="<div style='visibility:hidden; display:none;'>";
  $result .="<textarea name=bibtexData>".$bibtexData."</textarea>";
  $result .="</div>";


  //end the form with the commit button
  $result .="<input type=submit value='Commit'>";
  $result .="</form>";

  return $result;
}

# getEntryReviewForm($entry, $entryNr)
function getEntryReviewForm($entry, $entryNr) {

  $result='';

  //the review form for one entry is presented in a div-message environment containing a complete table.
  $result.= "<div class='message'>\n<table>";

  //first table row: Let user choose whether to import or not.
  //and present a short summary
  $result.= "<tr><td valign=top><input type=checkbox checked title='Uncheck to skip importing this article' name='importNr".$entryNr."'></td><td>";
  $result.= "Import ".getBibtexSummary($entry);
  $result.= "</td></tr>\n";

  //second row: check for similar publications
  $simPubHtml = getSimilarityWarnings($entry, $entryNr);
  if ($simPubHtml != "") {
    $result.= "<tr><td></td><td>".$simPubHtml."</td></tr>\n";
  }
  
  //third (optional) row: allow user to change bibtex id
  $result.= "<tr><td></td><td>BiBTeX cite ID:&nbsp;<INPUT title='enter new bibtex cite id here if you want to change the current cite id' name='citeID".$entryNr."' value=".$entry['bibtexCitation']."><br/><br/></td></tr>\n";

  //fourth (optional) row: check for similar authors / editors
  //show only when similar authors or editors exist.
  $simAuthorHtml = "";
  $simEditorHtml = "";
  
  if ($entry['author']) {
    $simAuthorHtml = getSimilarAuthorBlock($entry['author'], $entryNr, 'author');
  }
  if ($entry['editor']) {
    $simEditorHtml = getSimilarAuthorBlock($entry['editor'], $entryNr, 'editor');
  }

  $result .= "<tr><td></td><td>";
  $result .= $simAuthorHtml."<br/><br/>";
  $result .= $simEditorHtml."<br/><br/>";
  $result .= "</td></tr>\n";
  

  //and close the table of this entry
  $result.= "</table>";
  $result.= "</div>";

  return $result;
}

######### DISPLAY FUNCTIONS ############

# getBibtexSummary($entry)
# Returns a short summary of the given bibtex entry
function getBibtexSummary($entry) {
  //entry type
  $result = $entry['bibtexEntryType'].": ";

  //author / editor
  if ($entry['author'] != "") {
    $result .= $entry['author'].", ";
  }
  else if ($entry['editor'] != "") {
    $result .= $entry['editor']." (eds), ";
  }

  //title
  $result .= "<i>'".$entry['title']."'</i>";

  //year
  if ($entry['year'] != "") {
    $result .= ", ".$entry['year'];
  }
  $result .= "<br/><br/>";

  return $result;
}

# getPublicationSummariesByRows($rowArray)
# displays a summary of a publication
function getPublicationSummariesByRows($rowArray) {
  $result = '';
  while ($row = mysql_fetch_array($rowArray)) {
    $Q = mysql_query("SELECT * FROM publication WHERE bibtex_id='".$row["bibtex_id"]."'");
    if ($Q) {
      $result.= "<tr><td>".$row["bibtex_id"]."</td>";
  
      while ($R = mysql_fetch_array($Q)) {
        $Q2 = mysql_query("SELECT surname FROM author, publicationauthor WHERE author.ID=publicationauthor.author AND publicationauthor.pub_id=".$R['pub_id']);
        if ($Q2) {
          $authors = '';
          while ($R2 = mysql_fetch_array($Q2)) {
            $authors.= $R2["surname"].", ";
          }
        }
        $result.= "<td>".$authors."<i>".$R['title']."</i> (".$R['year'].") ".$R['booktitle']."</td></tr>\n";
      }
    }
  }
  if ($result != '') {
    $result = "\n<table>".$result."</table>";
  }
  
  return $result;
}

# getSimilarityWarnings($entry, $entryNr)
# Shows similar publications
function getSimilarityWarnings($entry, $entryNr) {
  $result = "";
  $bibCiteSimilarityHtml = "";
  $bitTitleSimilarityHtml = "";

  // bibCiteSimilarity
  if ($entry['bibtexCitation']!='') {
    //check for similarity in the database on the first five chars.
    $bibCiteID = substr($entry['bibtexCitation'],0,5);
    $Q = mysql_query('SELECT * FROM publication WHERE bibtex_id LIKE "'.$bibCiteID.'%"');

    if (mysql_num_rows($Q) == 1) {
      $bibCiteSimilarityHtml.= "<p><b>A similar BiBTeX ID exists:</b><br/>";
    }
    else if (mysql_num_rows($Q) > 1) {
      $bibCiteSimilarityHtml.= "<p><b>Similar BiBTeX IDs exist:</b><br/>";
    }

    if (mysql_num_rows($Q) >= 1) {
      $bibCiteSimilarityHtml.= getPublicationSummariesByRows($Q)."<br/>";
      $bibCiteSimilarityHtml.= "</p>";
    }
  }

  // bibTitleSimilarityHtml
  if (!strpos($entry['title'],'\'')) {
    $Q = mysql_query('SELECT * FROM publication WHERE LOWER(title) LIKE LOWER(\''.$entry['title'].'\')');

    if ($Q)
    {
      if (mysql_num_rows($Q) == 1) {
        $bibTitleSimilarityHtml.= "<p><b>A publication with similar title exists:</b><br/>";
      }
      else if (mysql_num_rows($Q) > 1) {
        $bibTitleSimilarityHtml.= "<p><b>Publications with similar titles exist:</b><br/>";
      }
  
      if (mysql_num_rows($Q) >= 1) {
        $bibTitleSimilarityHtml.= getPublicationSummariesByRows($Q)."<br/>";
        $bibTitleSimilarityHtml.= "</p>";
      }
    }
  }

  if (($bibCiteSimilarityHtml != "") || ($bibTitleSimilarityHtml != '')) {
    $result.= "<div class=errormessage>".$bibCiteSimilarityHtml.$bibTitleSimilarityHtml."</div>";
  }

  return $result;
}


function getSimilarAuthorBlock($authors, $entryNr, $inputIDPrefix) {
  $result = '';
  $singleResult = '';
  $parsedAuthors = bibParseAuthors($authors);
  $rank=1;
  $nameIDArray = array();
  $showOutput = false;
  
  foreach ($parsedAuthors as $author) {
    //format the name
    $firstname = getAigaionFirstname($author);
    $surname   = trim($author[2]);
    $prefix    = trim($author[3]);
    
    //check for existence in authorslist
    $Q = mysql_query('SELECT ID, surname, name FROM author');
    $nameIDArray[-1] = $surname.', '.$firstname;
    $keepNew = "[add new]";
    $keepNewID = -1;
    while ($R = mysql_fetch_array($Q))
    {
      if (levenshtein($surname,$R["surname"]) < 3)
      {
        if (($R["surname"] != $surname) || ($R["name"] != $firstname))
        {
          $nameIDArray[$R["ID"]]= $R["surname"].', '.$R["name"];
        }
        else
        {
          $keepNew = "[keep]";
          $keepNewID=$R['ID'];
        }
      }
    }
    $singleResult .= "Options for BiBTeX-author ".$nameIDArray[-1].":<br/>";

    //author as found in bibtex
    $singleResult .= "<input title='select to use author as found in BiBTeX' type=radio checked name=".$inputIDPrefix.$entryNr."_".$rank." value='".$keepNewID."' >".$nameIDArray[-1]." ".$keepNew."<br/>";

    //all alternatives based on levenshtein metric
    $fromDB = false;
    foreach ($nameIDArray as $ID => $name)
    {
      if ($ID != -1)
      {
        $singleResult .= "<input title='select to use similar author found in database' type=radio name=".$inputIDPrefix.$entryNr."_".$rank." value='".$ID."'>".$name." [from database]<br/>";
        $fromDB = true;
      }
    }
    
    if (!$fromDB) {
      $result.= '<div style="visibility:hidden; display:none;">'.$singleResult.'</div>';
    }
    else {
      $result .= $singleResult.'<br/>';
      $showOutput = true;
    }
      
    $nameIDArray = array();
    $rank++;
  }
  if ($showOutput) {
    $result = '<b>Choose alternative '.$inputIDPrefix.'s</b><br/>'.$result;
  }
  return $result;
}


######### ACTION FUNCTIONS ############

# bibImportEntries($entries)
function bibImportEntries($entries) {
  $result = "";
  $nrOfEntries = 0;
  $nrOfEntriesCommitted = 0;
  $nrOfTopics = 0;
  $nrOfTopicLinks = 0;
  $addedAuthors = array();
  $errorEntryNrs = array();
  $nrErrorEntries = 0;
  
  $topicImportHtml = "";
  $topicImportHtml = "";
  $topicLinkImportHtml = "";
  
  foreach ($entries as $entry) {
    if ($entry['bibtexEntryType']=='aigaiontopic') {
      //importAigaionTopic
      //$topicImportHtml .= importAigaionTopic($entry)
      //$nrOfTopics++;
    }
    else if ($entry['bibtexEntryType']=='aigaiontopictopiclink') {
      //importAigaionTopicLink
      //$topicLinkImportHtml .= importAigaionTopicLink($entry)
      //$nrOfTopicLinks++;
    }
    else {
      //bibImportEntry
      $return = bibImportEntry($entry, $nrOfEntries, $$addedAuthors);
      if ($return < 0) {
        $entryImportHtml .= "<div class = 'errormessage'>An error occurred while importing ".getBibtexSummary($entry)."<br/>";
        if (-1 == $return) {//error while importing authors or editors
          $entryImportHtml .= "The error occurred while importing one of the authors or editors";
        }
        if (-2 == $return) {//error inserting citeID
          $entryImportHtml .= "The BiBTeX cite ID was not uniqe. An underscore was appended.";
        }
        if (-3 == $return) {//error committing publication
        }
        $entryImportHtml .= "</div>";
      }
      else if (1 == $return) {
        $entryImportHtml .= "<div class = 'message'>".getBibtexSummary($entry)." was skipped.</div>";
        //everything OK, but entry skipped as indicated
      }
      else {
        $entryImportHtml .= "<div class = 'message'>Succesful import of ".getBibtexSummary($entry)."</div>";
      }
      $nrOfEntries++;
    }
  }
  
  $result.= $entryImportHtml.$topicImportHtml.$topicLinkImportHtml;
  
  
  return $result;
}

# bibImportEntry($entry, $entryNr, &$addedAuthors)
# returns 0 when everything OK, returns 1 when skipped else returns -1
function bibImportEntry($entry, $entryNr, &$addedAuthors) {
  $result = 0;
  
  //check if entry is to be imported
  if ($_REQUEST["importNr".$entryNr] != "on") {
    return 1;
  }
  //still alive so import this entry
  //import authors and editors
  if ($entry['author']) {
    $authors = bibParseAuthors($entry['author']);
    $authorIDs = bibImportAuthors($authors, $entryNr, "author", $$addedAuthors);  
  }
  if ($entry['editor']) {
    $editors = bibParseAuthors($entry['editor']);
    $editorIDs = bibImportAuthors($editors, $entryNr, "editor", $$addedAuthors);
  }
  
  if (($authorIDs == -1)||($editorIDs == -1))
    $result = -1;
    
  //check for double citeID
  //if double citeID keep this entry (bibtex) and show it again in the import form
  $citeID = $_REQUEST["citeID".$entryNr];
  $Q = mysql_query('SELECT * FROM publication WHERE bibtex_id = "'.$citeID.'"');
  while (mysql_num_rows($Q) > 0) {
    $citeID = $citeID."_";
    $Q = mysql_query('SELECT * FROM publication WHERE bibtex_id = "'.$citeID.'"');
    $result = -2;
  }
  //if citeID ok, do a straightforward import
  if (commitPublication($entry,$citeID,$authorIDs,$editorIDs) == -1)
    $result = -3;
  
  return $result;
}

# bibImportAuthors($authors, $entryNr, $authorIDPrefix)
# returns -1 on error, otherwise the author IDs in an array
function bibImportAuthors($authors, $entryNr, $authorIDPrefix, &$addedAuthors) {
  $authorIDs = array();
  
  $rank = 1;
  foreach ($authors as $author) {
    //Only if similar authors are in the database, there is a corresponding field.
    $authorIDRef = $authorIDPrefix.$entryNr."_".$rank;
    if (isset($_REQUEST[$authorIDRef])) {
      $authorID=$_REQUEST[$authorIDRef];
    }
    else {
      $authorID = -1;
    }
    
    if ($authorID == -1) {
      $authorID = commitAuthor($author, $$addedAuthors);
      if ($authorID == -1)
        return -1;
    }
    else {
      //keep author, do nothing!
    }
    
    $authorIDs[$rank] = $authorID;
    $rank++;
  }
  return $authorIDs;
}

# commitAuthor($author, &$addedAuthors)
# Adds one author to the DB if not already present in $addedAuthors.
# returns -1 on error, authorID otherwise
function commitAuthor($author,&$addedAuthors) {
  
  //check if author was already added by looking up $addedAuthors.
  $firstname = getAigaionFirstName($author);
  $surname = trim("".$author[2]." ".$author[3]);
  if (isset($addedAuthors[$surname.', '.$firstname])) {
    $authorID = $addedAuthors[$surname.', '.$firstname];
  }
  else {
    mysql_query('INSERT INTO author(surname, name, email, institute) VALUES ("'.addslashes($surname).'","'.addslashes($firstname).'","","")');
    $authorID=mysql_insert_id();
    
    $error = "";
    $error = mysql_error();
    if ($error != "") {
      //output error message
      echo "<div class=errormessage>There was an error while committing the following Author: ".$surname.", ".$firstname."<br/>";
      echo "Please report this errormessage to your aigaion administrator.<br/>";
      echo $error."</div>";
      $authorID = -1;
    }
    
    $addedAuthors[$surname.', '.$firstname] = $authorID;
  }
  
  return $authorID;
}

# commitPublication($nextentry,$citeid,$authorids,$editorids)
# commits a new publication to the DB
# returns -1 on error, 0 otherwise
function commitPublication($entry,$citeID,$authorIDs,$editorIDs) {
  $pubID = "";
  $entry = fillEmptyFields($entry);
  
  if ($entry['mark'] == '')
    $entry['mark'] = 5;
  
  if ($entry['pages'] != '')
    list($entry['firstpage'], $entry['lastpage']) = bibParsePages($entry['pages']);
  
  if ($entry['chapter'] == '')
    $entry['chapter'] = 0;
    
  if ($entry['survey'] == '')
    $entry['survey'] = 0;
  
  if ($entry['firstpage'] == '')
    $entry['firstpage'] = 0;
  
  if ($entry['lastpage'] == '')
    $entry['lastpage'] = 0;
  
  if ($entry['month'] == '') {
    $entry['month'] = 0;
  } 
  else {
    list($month, $day) = bibParseMonth($entry['month']);
    $entry['month'] = $month;
  }


  //addslashes to all entries, to avoid mysql problems with quotes in names etc
  foreach ($entry as $key => $value)
  {
    $entry[$key] = addslashes($value);
  }

  $enteredBy = $_SESSION["personID"];
  $query = 'INSERT INTO publication (entered_by,year,title,bibtex_id,xrefkey,pub_type,type,survey,mark,';
  $query.= 'series,volume,publisher,location,issn,isbn,firstpage,lastpage,';
  $query.= 'journal,booktitle,number,institution,address,chapter,edition,';
  $query.= 'howpublished,month,organization,school,note,keywords, abstract)';
  $query.= ' VALUES ("'.$enteredBy.'","'.$entry['year'].'","'.$entry['title'].'","'.$citeID.'","'.$entry['key'].'","'.$entry['type'].'","'.normalizedType($entry['bibtexEntryType']).'","'.$entry['survey'].'",'.$entry['mark'].',';
  $query.= '"'.$entry['series'].'","'.$entry['volume'].'","'.$entry['publisher'].'","'.$entry['location'].'","'.$entry['issn'].'","'.$entry['isbn'].'",'.$entry[firstpage].','.$entry[lastpage].',';
  $query.= '"'.$entry['journal'].'","'.$entry['booktitle'].'","'.$entry['number'].'","'.$entry['institution'].'","'.$entry['address'].'",'.$entry['chapter'].',"'.$entry['edition'].'",';
  $query.= '"'.$entry['howpublished'].'","'.$entry['month'].'","'.$entry['organization'].'","'.$entry['school'].'","'.$entry['note'].'","'.$entry['keywords'].'","'.$entry['abstract'].'")';
  $res=mysql_query($query);
  $pubID = mysql_insert_id();
  
  $error = mysql_error();
  if ($error != "") {
    //output error message
    echo "<div class=errormessage>There was an error while committing the following ".getBibtexSummary($entry)."<br/>";
    echo "Please report this errormessage to your aigaion administrator.<br/>";
    echo $error."</div>";
    return -1;
  }
  
  if ($res) {
    //set publication on "read" for current person.
    $query=('INSERT INTO personpublicationmark (pub_id, person_id, mark, `read`)  VALUES ('.$pubID.', '.$enteredBy.', -1, "y")');
    $result = mysql_query($query);
  
    $error = "";
    $error = mysql_error();
    if ($error != "") {
      //output error message
      echo "<div class=errormessage>There was an error while committing the following ".getBibtexSummary($entry)."<br/>";
      echo "Please report this errormessage to your aigaion administrator.<br/>";
      echo $error."</div>";
      return -1;
    }
  }

  //add to publicationauthor, for authors and editors
  if (sizeof($authorIDs) != 0) {
    $rank=1;
    foreach ($authorIDs as $authorID) {
      $result = mysql_query('INSERT INTO publicationauthor(pub_id, author, rank, is_editor) VALUES ('.$pubID.', '.$authorID.', '.$rank.', "N")');
      
      $error = "";
      $error = mysql_error();
      if ($error != "") {
        //output error message
        echo "<div class=errormessage>There was an error while linking an author to ".getBibtexSummary($entry)."<br/>";
        echo "Please report this errormessage to your aigaion administrator.<br/>";
        echo $error."</div>";
        return -1;
      }
      
      $rank++;
    }
  }
  if (sizeof($editorIDs) != 0) {
    $rank=1;
    foreach ($editorIDs as $editorID) {
      $result = mysql_query('INSERT INTO publicationauthor(pub_id, author, rank, is_editor) VALUES ('.$pubID.', '.$editorID.', '.$rank.', "Y")');
      
      $error = "";
      $error = mysql_error();
      if ($error != "") {
        //output error message
        echo "<div class=errormessage>There was an error while linking an editor to ".getBibtexSummary($entry)."<br/>";
        echo "Please report this errormessage to your aigaion administrator.<br/>";
        echo $error."</div>";
        return -1;
      }
      $rank++;
    }
  }

  $result = mysql_query('INSERT INTO topicpublication(topic_id, pub_id) VALUES ("1", '.$pubID.')');
  
    $error = "";
    $error = mysql_error();
    if ($error != "") {
      //output error message
      echo "<div class=errormessage>There was an error while linking a topic to ".getBibtexSummary($entry)."<br/>";
      echo "Please report this errormessage to your aigaion administrator.<br/>";
      echo $error."</div>";
      return -1;
    }
  
  return 0;
}




















//import: parse the input and present a import review form.
if ($action=='import') {
  ?>
  <div class="errormessage">Please review the entries below which were found in the BiBTeX input. Uncheck the box in front of an entry if you want to skip importing that particular entry.
  <p>When you are sure that the information below is correct, press "commit" to add the entries to the database.</div>
  <?php 
  if (get_magic_quotes_gpc()==1)
    $bibtexData=stripslashes($bibtexData);

  $entries = bibParse($bibtexData);

  echo getReviewForm($entries, $bibtexData);
}

//commit: the user reviewed the input. Parse input and update
//corrections. Then add to DB.
else if ($action == 'commit') {
  
  if (get_magic_quotes_gpc()==1)
    $bibtexData=stripslashes($bibtexData);

  $entries = bibParse($bibtexData);
  
  echo bibImportEntries($entries);
  
} 
//no action specified: display blank import page
else { 
  ?>
  <p class=header>BiBTeX import</p>
  Paste the BiBTeX text in the text area below, then press "Import".
  <br/><br/>
  <p class=small>Based on the bibparse packages of bibliophile</p>
  <form method='post'>
  <table border=0>
    <tr>
      <td class=small>
        <input type=submit value='Import'>
      </td>
    </tr>
    <tr>
      <td>
        <textarea name=bibtexData wrap=virtualcols=100 cols=80 rows=25><?php echo $bibtexData; ?></textarea>
      </td>
    <td>
  </tr>
  </table>
  <input type=hidden name=action value=import>
  </form>
  <?php 
}

