<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

#Register request and session vars
$action="";
if (isset($_REQUEST["action"])) {
  $action=$_REQUEST["action"];
}
$bibtex_data="";
if (isset($_REQUEST["bibtex_data"])) {
  $bibtex_data=$_REQUEST["bibtex_data"];
}
$ris_file="off";
if (isset($_REQUEST["ris_file"])) {
  $ris_file=$_REQUEST["ris_file"];
}
#NOTE: The variables n_doimport, citeid_n, a_n_i, e_n_i are NOT registered, so they should still be accessed through the request variable.

?>
<?php 
checkRights("EDIT");


//WHEN 'IMPORT' WAS PRESSED, THE TEXT FIELD SHOULD BE ANALYSED USING BIBPARSE.
//NEXT, THE USER GETS THE CHANCE FOR A FEW LAST MINUTE CHANGES, AFTER WHICH HE SHOULD PRESS COMMIT.
if ($action=="import") {
  ?>
  <div class='errormessage'>Please review the entries below which were found in the BiBTeX input. If a similar author already exists in the database, you can choose to use that author name if you believe that is the correct one. Uncheck the box in front of an entry if you want to skip importing that particular entry.
  <p>When you are sure that the information below is correct, press 'commit' to add the entries to the database.</div>

  <?php 
  if ($ris_file=="on"){
    echo "Importing RIS file: <BR>";
    $parse=NEW parseRIS();
  }else{
  echo "Importing BIBTEX file: <BR>";

  $parse = NEW PARSEENTRIES();
}
$parsecreators = NEW PARSECREATORS();

if (get_magic_quotes_gpc()==1)
  $parse->loadBibtexString(stripslashes($bibtex_data));
else
  $parse->loadBibtexString($bibtex_data);

$parse->extractEntries();
list($preamble, $strings, $entries) = $parse->returnArrays();

//now $entries contains all bibtex entries that were found in the input text.
//the next step is to verify some properties of each entry and present the user with some options
//to approve or reject, such as alternative authornames.

//to store everything (original entries, + the final selected corrections) we use a form with action 'commit'.
echo '<form method="post">';
echo '<input type=hidden name=action value=commit>';


//AND NOW: THE MAIN POINT. SUGGESTIONS/OPPORTUNITIES FOR CORRECTION FOR EACH ENTRY.
$entrynr=0;
$nroftopics=0;
$nroftopiclinks=0;
$publicationreviewhtml="";
foreach ($entries as $nextentry) {
  if ($nextentry["bibtexEntryType"]=="aigaiontopic") {
    //feedback for topic
    $nroftopics++;
  } else if ($nextentry["bibtexEntryType"]=="aigaiontopictopiclink") {
    //feedback for topictopiclink
    $nroftopiclinks++;
  } else { //publication
    $publicationreviewhtml.= '<div class="message">';
    //allow user to skip this entry
    $publicationreviewhtml.= "<table><tr><td valign=top><INPUT CHECKED TYPE=CHECKBOX title='Uncheck to skip importing this article' NAME='".$entrynr."_doimport'></td><td>";
    $publicationreviewhtml.= writeSummary($nextentry);
    $publicationreviewhtml.= '<br>';
    $publicationreviewhtml.= '<br></td></tr>';

    $publicationreviewhtml.= '<tr><td/><td>';
    $publicationreviewhtml.=writeSimilarPublications($nextentry);
    $publicationreviewhtml.= '</td></tr>';


    $publicationreviewhtml.= '<tr><td/><td>';
    //allow different bibtex citeid...
    $publicationreviewhtml.= '<INPUT title="enter new bibtex cite id here if current cite id is wrong" name="citeid_'.$entrynr.'" value='.$nextentry["bibtexCitation"].'>&nbsp;BiBTeX cite ID';
    $publicationreviewhtml.= '<br>';
    $publicationreviewhtml.= '<br>';

    //allow user to choose authors and editors that already are in database
    $publicationreviewhtml.= '<table style="border:1px solid #E0E0E0;">';
    $publicationreviewhtml.= '<tr><td width="200"><b>Choose alternative authors</b></td><td width="200"><b>Choose alternative editors</b></td></tr>';
    $publicationreviewhtml.= '<tr>';
    $publicationreviewhtml.= '<td valign=top>';
    if ($nextentry["author"]) {
      $authors=$parsecreators->parse($nextentry["author"]);
      $publicationreviewhtml.=writeAuthorBlock($authors,$entrynr,"a");
    }
    $publicationreviewhtml.= '</td>';//end of autors block
    $publicationreviewhtml.= '<td valign=top>';//editors...
    if ($nextentry["editor"]) {
      $editors=$parsecreators->parse($nextentry["editor"]);
      $publicationreviewhtml.=writeAuthorBlock($editors,$entrynr,"e");
    }
    $publicationreviewhtml.= '</td>';
    $publicationreviewhtml.= '</tr>';
    $publicationreviewhtml.= '</table>';

    $publicationreviewhtml.= '</td></tr></table>';
    $publicationreviewhtml.= '</div>';
    $entrynr++;
  }
}

$topicreviewhtml = "";
$topicreviewhtml.= "<table><tr><td valign=top><INPUT CHECKED TYPE=CHECKBOX title='Uncheck to skip importing the topics into Aigaion' NAME='importtopics'></td><td>Import topics.</td></tr><tr><td/><td>Number of topics in import: ".$nroftopics."<br>";
$topicreviewhtml.= 'Number of topic links in import: '.$nroftopiclinks.'<br></td></tr></table>';

echo "<p class=header>Review topics to be imported</p>";
echo "<div class=message>".$topicreviewhtml."</div>";
echo "<p class=header>Review publications to be imported</p>";
echo $publicationreviewhtml;

//we might decide to store the original entries... but that would be rather tricky. I don't know if you
//can store such a complex array in a simple field without problems... better to repeat the bibtex_data
//and parse it again in the commit, the parser is fast enough. This time however the textarea is hidden.
echo '<div style="visibility:hidden;display:none;">';

echo "<INPUT TYPE=CHECKBOX " ;
if ($ris_file=="on")echo "CHECKED";
echo " name=ris_file TITLE='Check to import RIS file'>";
echo "Check to import RIS file</INPUT>";

if (get_magic_quotes_gpc()==1)
echo '<textarea name=bibtex_data >'.stripslashes($bibtex_data).'</textarea>';
else
echo '<textarea name=bibtex_data >'.$bibtex_data.'</textarea>';
echo '</div>';

//and the commit button :-)

echo '<input type=submit value="Commit">';
echo '</form>';

} else if ($action == "commit") { //COMMIT PRESSED: FIGURE OUT THE CORRECTIONS, ADD ENTRIES TO DATABASE
  //If the parse results are approved and the user pressed commit, the results should be entered in the database...
  //for this we need the original bibtex entries (to be parsed again), as well as all the input fields
  //that contain the corrections (authors etc).
  if ($ris_file=="on"){
    $parse=NEW parseRIS();
  }else{
  $parse = NEW PARSEENTRIES();
}
$parsecreators = NEW PARSECREATORS();
if (get_magic_quotes_gpc()==1)
$parse->loadBibtexString(stripslashes($bibtex_data));
else
$parse->loadBibtexString($bibtex_data);
$parse->extractEntries();
list($preamble, $strings, $entries) = $parse->returnArrays();

//now $entries contains all bibtex entries that were found in the input text, and all the corrections are stored
//in forminputs such as 'citeid_1', the (new?) cite id for entry 1

//used to decide on the fly that an entry will NOT be imported, e.g. because it was used in a crossref (crossrefs are themselves not imported now)
$killentries=array();

$entrynr=0;
$nrcommitted = 0;
$lastcommittedpubid = "";

//this array contains all added authors. If an author should be added, and an EXACT match has already been added, the reference to that exact match will be used. Key: an unique author string for this author. Value: the authorid (or editorid!)
//the same list is used for editors and authors both. If an exact match has already been added for an editor, it can also be used for a new author.
$addedauthors=array();

foreach ($entries as $nextentry) {
  if ($nextentry["bibtexEntryType"]=="aigaiontopic") {
    if ($importtopics==True) {
      echo "importing topic... (not yet implemented)";
    }
  } else if ($nextentry["bibtexEntryType"]=="aigaiontopictopiclink") {
    if ($importtopics==True) {
      echo "importing topiclink... (not yet implemented)";
    }
  } else { //publication
    //check if entry is to be imported
    $doimport_ref = $entrynr."_doimport";

    if ($killentries[$nextentry["bibtexCitation"]] == "true") {
      echo 'Entry '.$nextentry["bibtexCitation"].' skipped, was used in a crossref.<br>';
    }
    if (($_REQUEST[$doimport_ref]=='on') && ($killentries[$nextentry["bibtexCitation"]] != "true")) {
      echo '<div class="message">';
      //clear the contents of authorids and editorids...
      if (isset($authorids))unset($authorids);
      if (isset($editorids))unset($editorids);

      //for the new entry, we must know the id's of the authors (old, or new)
      //if new author: add it along the way.
      $authors=$parsecreators->parse($nextentry["author"]);
      $rank=1;
      foreach ($authors as $author) {
        $authorradioref="a_".$entrynr."_".$rank;
        $authorids[$rank]=$_REQUEST[$authorradioref];
        if ($_REQUEST[$authorradioref]==-1) {
          // if -1, no "keep", so we have to insert new.
          $authorids[$rank] = commitAuthor($author,$$addedauthors);
        }
        $rank++;
      }


      //for the new entry, we must know the id's of the editors (old, or new)
      //if new author: add it along the way.
      $editors=$parsecreators->parse($nextentry["editor"]);
      $rank=1;
      foreach ($editors as $editor) {
        $editorradioref="e_".$entrynr."_".$rank;
        $editorids[$rank]=$_REQUEST[$editorradioref];
        if ($_REQUEST[$editorradioref]==-1) {
          // if -1, no "keep", so we have to insert new
          $editorids[$rank] = commitAuthor($editor,$$addedauthors);
        }
        $rank++;
      }


      //we must know the cite-id that was chosen...
      $citeid_ref = "citeid_".$entrynr;

      // --> in that case we merge the fields of the crossref with the fields of this one.
      // in general, we'll then probably also NOT add that crossref'd entry to aigaion.
      if (($nextentry["crossref"]) && (strlen($nextentry["crossref"]) > 0)) {
        echo 'Crossref report: This entry contains a crossref '.$nextentry["crossref"].'<br>';
        //find the entry for the crossref
        $refentrynr = 0;
        foreach ($entries as $refentry) {
          if ($refentry["bibtexCitation"]==$nextentry["crossref"]) {
            //this is it: start overriding values of the current entry with those in the ref'd entry
            //Or in other words, take the referenced entry, and overrule some values of that
            echo 'Found target entry of crossref '.$refentry["bibtexCitation"].', will attempt to merge the two.<br>';
            //replace the stuff in this cite with that in that crossref
            foreach ($refentry as $key => $value) {
              if ((!$nextentry[$key]) || (strlen($nextentry[$key]) == 0) ) {
                $nextentry[$key] = $value;
                echo 'Moving value for '.$key.' from crossref to this entry<br>';
                //for editors we also need to move the values of the radioboxes..
                if ($key == "editor")
                {
                  //for the new entry, we must know the id's of the editors (old, or new)
                  //if new author: add it along the way.
                  echo $refentry["editor"];
                  $editors=$parsecreators->parse($refentry["editor"]);
                  $rank=1;
                  foreach ($editors as $editor) {
                    $editorradioref="e_".$refentrynr."_".$rank;
                    $editorids[$rank]=$_REQUEST[$editorradioref];
                    if ($_REQUEST[$editorradioref]==-1) {
                      // if -1, no "keep", so we have to insert new
                      $editorids[$rank] = commitAuthor($editor,$$addedauthors);
                    }
                    $rank++;
                    print_r($editorids);
                  }
                }
              }
              //echo $key."=".$value;
            }
            //   title in ref'd entry becomes booktitle in this entry...
            if ($refentry["title"]) {
              $nextentry["booktitle"] = $refentry["title"];
              echo 'Setting booktitle from crossref title<br>';
            }
            $killentries[$refentry["bibtexCitation"]] = "true";
          }
          $refentrynr++;
        }
      }


      //and now we must commit the article...
      $lastcommittedpubid=commitPublication($nextentry,$_REQUEST[$citeid_ref],$authorids,$editorids);
      $nrcommitted++;

      echo '</div>';
    }
    $entrynr++;
  }
}
//die();
if ($nrcommitted == 1) {
  //go to edit page of last committed entry.
  echo "<script>document.location=\"index.php?page=publicationform&command=edit&ID=".$lastcommittedpubid."\";</script>";
}

} else { //NOT A COMMIT OR IMPORT: SHOW THE FIRST IMPORT FORM.
  ?>
  <p class=header>BiBTeX import</p>
  Paste the BiBTeX text in the text area below, then press 'Import'.
  <p>
  <p>
  <p class=small>Based on the bibparse packages of bibliophile</p>



  <form method="post">
  <table border=0>

  <tr>
  <td class=small>
  <input type=submit value="Import">
  <?php 

  echo "<INPUT TYPE=CHECKBOX " ;
  if ($ris_file=="on")echo "CHECKED";
  echo " name=ris_file TITLE='Check to import RIS file'>";
  echo "Check to import RIS file</INPUT>";

  ?>
  </td>
  </tr>

  <tr>
  <td>
  <textarea name=bibtex_data wrap=virtualcols=100 cols=80 rows=25><?php echo $bibtex_data; ?></textarea>
  </td>
  <td>
  </tr>

  <input type=hidden name=action value=import>
  </table>
  </form>
  <?php }


  //IF there are alternative authors, this method will display them...
  function writeAuthorBlock($authors,$entrynr,$inputidprefix) {
    $result = "";
    $rank=1;
    $idNameArray = array();
    foreach ($authors as $author) {
      $firstname=makeAigaionFirstname($author);
      $surname   = trim($author[2]);
      $prefix    = trim($author[3]);
      //check for existence in authorslist
      $Q=mysql_query("SELECT ID, surname, name FROM author");
      $idNameArray[-1] = $surname.", ".$firstname;
      $authorfound = false;
      $keepnew = "[add new]";
      $keepnewid = -1;
      while ($R=mysql_fetch_array($Q))
      {
        if (levenshtein($surname,$R['surname']) < 3)
        {
          if (($R['surname'] != $surname) || ($R['name'] != $firstname))
          {
            $idNameArray[$R['ID']]= $R['surname'].", ".$R['name'];
            $authorfound = true;
          }
          else
          {
            $keepnew = "[keep]";
            $keepnewid=$R['ID'];
          }
        }
      }

      //Display nice form where authors can be chosen
      //============
      //title
      $result.= "<br>-- Options for BiBTeX-author ".$idNameArray[-1].": --<br>";

      //author as found in bibtex
      $result.= "<INPUT title='select to use author as found in BiBTeX' TYPE=RADIO CHECKED NAME=".$inputidprefix."_".$entrynr."_".$rank." VALUE=\"".$keepnewid."\" >".$idNameArray[-1]." ".$keepnew."<BR>";

      //option to hand-correct here?
      //$result.= "<INPUT title='select to use hand corrected author name

      //all alternatives based on levenshtein metric
      foreach ($idNameArray as $id => $name)
      {
        if ($id != -1)
        {
          $result.= "<INPUT title='select to use similar author found in database' TYPE=RADIO NAME=".$inputidprefix."_".$entrynr."_".$rank." VALUE=\"".$id."\"  >".$name." [from database]<BR>";
        }
      }
      //============

      $idNameArray = array();
      $rank++;
    }
    return $result;
  }

  function writeSummary($entry) {
    return 'Import '.$entry["bibtexEntryType"].': '.$entry["author"].', <i>"'.$entry["title"].'"</i>, '.$entry["year"].'';
  }
  function makeAigaionFirstName($author) {
    $initials = str_replace(" ", ".",trim($author[1]));
    if ($initials != "") {
      $initials .= ".";
    }
    $firstname = trim(trim($author[0]).' '.$initials);
    return $firstname;
  }
  //returns the new id of the newly commited author
  //$addedauthors contains info on previously added new authors. If an exact match is found in $addedauthors, use that id.
  //afterwards, if author added, store it in $addedauthors
  function commitAuthor($author,&$addedauthors) {
    echo 'committing author: '.$author[2].', '.makeAigaionFirstName($author).'<br>';

    //first check: was this author already added? if so, it can be found in $addedauthors. return existing ID.
    if (isset($addedauthors['SUR:'.trim(''.$author[2].' '.$author[3]).";FST:".makeAigaionFirstName($author)])) {
      return $addedauthors['SUR:'.trim(''.$author[2].' '.$author[3]).";FST:".makeAigaionFirstName($author)];
      //echo 'previously added author: '.'SUR:'.trim(''.$author[2].' '.$author[3]).";FST:".makeAigaionFirstName($author).":".$addedauthors['SUR:'.trim(''.$author[2].' '.$author[3]).";FST:".makeAigaionFirstName($author)]."<br>";
    }

    //if(true)return; a command to skip actual commit for testing...
    $surname = trim(''.$author[2].' '.$author[3]);
    $firstname = makeAigaionFirstName($author);
    $resauthadd=mysql_query("INSERT INTO author(surname, name, email, institute) VALUES ('".addslashes($surname)."','".addslashes($firstname)."','','')");
    $authid=mysql_insert_id();
    echo mysql_error();
    //die();//DR Temp testing
    echo 'New authorid: '.$authid;
    $addedauthors['SUR:'.trim(''.$author[2].' '.$author[3]).";FST:".makeAigaionFirstName($author)] = $authid;
    return $authid;
  }

  //commit the publication. authors and editors are already committes under the given id.
  function commitPublication($nextentry,$citeid,$authorids,$editorids) {
    echo 'Commit: '.$citeid.'<br>';
    //if(true)return;
    //filling in the gaps and empty fields and defaults...
    $pub_id="";
    $nextentry=fillEmptyFields($nextentry);
    if ($nextentry["mark"] == "")
    $nextentry["mark"] = 5;
    //echo $nextentry["pages"];
    if ($nextentry["pages"] != "") {
      $parsePage = new PARSEPAGE();
      list($nextentry["firstpage"], $nextentry["lastpage"]) = $parsePage->init($nextentry["pages"]);
    }
    //print_r($parsePage->init($nextentry["pages"]));
    //echo $nextentry["firstpage"];
    if ($nextentry["chapter"] == "")
    $nextentry["chapter"] = 0;
    if ($nextentry["survey"] == "")
    $nextentry["survey"] = 0;
    if ($nextentry["firstpage"] == "")
    $nextentry["firstpage"] = 0;
    if ($nextentry["lastpage"] == "")
    $nextentry["lastpage"] = 0;
    if ($nextentry["month"] == "") {
      $nextentry["month"] = 0;
    } else {
      $parseMonth = new PARSEMONTH();
      list($month, $day) = $parseMonth->init($nextentry["month"]);
      $nextentry["month"] = $month;
    }


    //addslashes to all entries, to avoid mysql problems with quotes in names etc
    foreach ($nextentry as $key => $value)
    {
      //echo $attribute."_";
      $nextentry[$key] = addslashes($value);
      //  echo $attribute."_\n";
    }

    $entered_by = $_SESSION['personID'];
    $query = "INSERT INTO publication (entered_by,year,title,bibtex_id,pub_type,type,survey,mark,";
    $query = $query."series,volume,publisher,location,issn,isbn,firstpage,lastpage,";
    $query = $query."journal,booktitle,number,institution,address,chapter,edition,";
    $query = $query."howpublished,month,organization,school,note,keywords, abstract)";
    $query = $query." VALUES ('$entered_by','".$nextentry["year"]."','".$nextentry["title"]."','".$citeid."','".$nextentry["type"]."','".normalizedType($nextentry["bibtexEntryType"])."','".$nextentry["survey"]."',".$nextentry["mark"].",";
    $query = $query."'".$nextentry["series"]."','".$nextentry["volume"]."','".$nextentry["publisher"]."','".$nextentry["location"]."','".$nextentry["issn"]."','".$nextentry["isbn"]."',".$nextentry[firstpage].",".$nextentry[lastpage].",";
    $query = $query."'".$nextentry["journal"]."','".$nextentry["booktitle"]."','".$nextentry["number"]."','".$nextentry["institution"]."','".$nextentry["address"]."',".$nextentry["chapter"].",'".$nextentry["edition"]."',";
    $query = $query."'".$nextentry["howpublished"]."','".$nextentry["month"]."','".$nextentry["organization"]."','".$nextentry["school"]."','".$nextentry["note"]."','".$nextentry["keywords"]."','".$nextentry["abstract"]."')";
    echo $query;
    $res=mysql_query($query);
    echo mysql_error();
    //die(); //DR Temp testing
    $pub_id=mysql_insert_id();


    if ($res) {
      //set publication on 'read' for current person.
      $query=("INSERT INTO personpublicationmark (pub_id, person_id, mark, `read`)  VALUES ($pub_id, '$entered_by', -1, 'y')");
      $res = mysql_query($query);
      echo mysql_error();
      //die();
    }



    //echo '<br>pub: '.$pub_id.'<br>';
    //add to publicationauthor, for authors and editors
    $rank=1;
    foreach ($authorids as $aid) {
      $resauthaddforpub=mysql_query("INSERT INTO publicationauthor(pub_id, author, rank, is_editor) VALUES ($pub_id,$aid,$rank, 'N')");
      $rank++;
    }
    $rank=1;
    foreach ($editorids as $eid) {
      $resedaddforpub=mysql_query("INSERT INTO publicationauthor(pub_id, author, rank, is_editor) VALUES ($pub_id,$eid,$rank, 'Y')");
      $rank++;
    }

    $restopicaddforpub=mysql_query("INSERT INTO topicpublication(topic_id, pub_id) VALUES ('1', $pub_id)");
    //GB: Assign file to topic given in aigaiontopic variable of bibtex entry
    if (!empty($nextentry["aigaiontopic"]))
    {
      echo $nextentry["aigaiontopic"];
      $Q=mysql_query("SELECT * FROM topic WHERE name='".$nextentry["aigaiontopic"]."'");
      if (!empty($Q))
      while ($R = mysql_fetch_array($Q)) {
        if (!empty($R))
        {
          echo "Importing topic";
          $topic_ID=$R["ID"];
          $restopicaddforpub=mysql_query("INSERT INTO topicpublication(topic_id, pub_id) VALUES ($topic_ID, $pub_id)");
        }
      }
    }

    return $pub_id; //RETURN PUBID
    //if there are any aigaion-notes in the publication...
  }

  //writes out an error message if there are publications in the database that are extremely similar to the given bibparse entry, so the user can choose to skip importing those.
  function writeSimilarPublications($entry) {
    $text = "";
    $result="";
    if ($entry["bibtexCitation"]!="") {
      //check proposed bibtexid... literal match
      $Q = mysql_query("SELECT * FROM publication WHERE bibtex_id='".$entry["bibtexCitation"]."'");
      while ($R = mysql_fetch_array($Q)) {
        $text .= "<p>BiBTeX already in use: ";
        $text .= summarizePublication($entry["bibtexCitation"]);
      }

      //check proposed bibtexid... starts with same 5 chars
      $bibinit = substr($entry["bibtexCitation"],0,5);
      $Q = mysql_query("SELECT * FROM publication WHERE bibtex_id LIKE '".$bibinit."%'");
      while ($R = mysql_fetch_array($Q)) {
        $text .= "<p>Similar existing BiBTeX ID: ";
        $text .= summarizePublication($R['bibtex_id']);
      }
    }
    //check for title -- (almost) matching articles..
    if (!strpos($entry["title"],"\"")) {
      $Q = mysql_query("SELECT * FROM publication WHERE LOWER(title) LIKE LOWER(\"".$entry["title"]."\")");
      while ($R = mysql_fetch_array($Q)) {
        $text .= "<p>Similar existing publication: ";
        $text .= summarizePublication($R['bibtex_id']);
      }
    }


    if ($text != "") {
      $result.= '<div class=errormessage>'.$text.'</div>';
    }
    return $result;
  }

  //write a summarization of the publication denoted by the given ID.
  function summarizePublication($bibtexid) {
    //write a summarization of the publication denoted by the given ID.
    $text = "";
    $Q = mysql_query("SELECT * FROM publication WHERE bibtex_id=\"".$bibtexid."\"");
    if ($Q) {
      while ($R = mysql_fetch_array($Q)) {
        $Q2 = mysql_query("SELECT surname FROM author, publicationauthor WHERE author.ID=publicationauthor.author AND publicationauthor.pub_id=".$R['pub_id']."");
        $text .= "{".$bibtexid."} ";
        if ($Q2) {
          while ($R2 = mysql_fetch_array($Q2)) {
            $text .= $R2['surname'].",";
          }
        }
        $text .= "<i>".$R['title']."</i> (".$R['year'].") ".$R['booktitle'];
      }
    }
    return $text;
  }

  //look for missing fields that should be filled (empty?) for the mysql database, and set them to ""
  function fillEmptyFields($nextentry) {
    if (!isset($nextentry["year"]))
    $nextentry["year"] = "0000";
    if (!isset($nextentry["title"]))
    $nextentry["title"] = "";
    if (!isset($nextentry["type"]))
    $nextentry["type"] = "Journal";
    if (!isset($nextentry["survey"]))
    $nextentry["survey"] = "0";
    if (!isset($nextentry["mark"]))
    $nextentry["mark"] = "6";
    if (!isset($nextentry["series"]))
    $nextentry["series"] = "";
    if (!isset($nextentry["volume"]))
    $nextentry["volume"] = "";
    if (!isset($nextentry["publisher"]))
    $nextentry["publisher"] = "";
    if (!isset($nextentry["location"]))
    $nextentry["location"] = "";
    if (!isset($nextentry["issn"]))
    $nextentry["issn"] = "";
    if (!isset($nextentry["isbn"]))
    $nextentry["isbn"] = "";
    if (!isset($nextentry["firstpage"]))
    $nextentry["firstpage"] = "";
    if (!isset($nextentry["lastpage"]))
    $nextentry["lastpage"] = "";
    if (!isset($nextentry["journal"]))
    $nextentry["journal"] = "";
    if (!isset($nextentry["booktitle"]))
    $nextentry["booktitle"] = "";
    if (!isset($nextentry["number"]))
    $nextentry["number"] = "";
    if (!isset($nextentry["institution"]))
    $nextentry["institution"] = "";
    if (!isset($nextentry["address"]))
    $nextentry["address"] = "";
    if (!isset($nextentry["chapter"]))
    $nextentry["chapter"] = "";
    if (!isset($nextentry["edition"]))
    $nextentry["edition"] = "";
    if (!isset($nextentry["howpublished"]))
    $nextentry["howpublished"] = "";
    if (!isset($nextentry["month"]))
    $nextentry["month"] = "";
    if (!isset($nextentry["organization"]))
    $nextentry["organization"] = "";
    if (!isset($nextentry["school"]))
    $nextentry["school"] = "";
    if (!isset($nextentry["note"]))
    $nextentry["note"] = "";
    if (!isset($nextentry["keywords"]))
    $nextentry["keywords"] = "";
    if (!isset($nextentry["abstract"]))
    $nextentry["abstract"] = "";
    if (!isset($nextentry["pages"]))
    $nextentry["pages"] = "";
    return $nextentry;
  }

  //normalize the publicationtype string to the spelling of Aigaion
  function normalizedType($type) {
    switch (strtolower($type) )
    {
      case "article":
      return "Journal";
      break;
      case "inproceedings":
      case "conference":
      return "Proceedings";
      break;
      case "phdthesis":
      return "Dissertation";
      break;
      case "techreport":
      return "Report";
      break;
      case "book":
      return "Book";
      break;
      case "booklet":
      return "Booklet";
      break;
      case "inbook":
      return "BookSection";
      break;
      case "incollection":
      return "Incollection";
      break;
      case "manual":
      return "Manual";
      break;
      case "mastersthesis";
      return "Mastersthesis";
      break;
      case "misc":
      return "Misc";
      break;
      case "unpublished";
      return "Unpublished";
      break;
      default :
      echo "<div class='errormessage'>";
      echo "No entrytype: ".$firstpubtype." does not exist, see http://www.ecst.csuchico.edu/~jacobsd/bib/formats/bibtex.html for details";
      echo "</div>";
      die();

    }
  }