<?php 
/*
Web based document management system
Copyright (C) 2003-2006 (in alphabetical order):
Wietse Balkema, Gerbert ten Brinke, Arthur van Bunningen, Hendri Hondorp, Dennis Reidsma

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include_once($DIR."treefunctions.php");
include_once($DIR."lib/functions/authorfunctions.php");
#Register request and session vars
$command="";
if (isset($_REQUEST["command"])) {
  $command=$_REQUEST["command"];
}
$person_id="";
if (isset($_SESSION["personID"])) {
  $person_id=$_SESSION["personID"];
}
$pub_id=""; //publication id
if (isset($_REQUEST["ID"])) {
  $pub_id=$_REQUEST["ID"];
}
$edit_type="";
if (isset($_REQUEST["edit_type"])) {
  $edit_type=$_REQUEST["edit_type"];
}
//get all the submitted data
$survey="";
if (isset($_REQUEST["survey"])) {
	if($_REQUEST["survey"] == "true")
		$survey="1";
	else
		$survey="0";
}
$mark="";
if (isset($_REQUEST["mark"])) {
  $mark=$_REQUEST["mark"];
}
$firstpage="";
if (isset($_REQUEST["firstpage"])) {
  $firstpage=$_REQUEST["firstpage"];
}
$lastpage="";
if (isset($_REQUEST["lastpage"])) {
  $lastpage=$_REQUEST["lastpage"];
}
$chapter="";
if (isset($_REQUEST["chapter"])) {
  $chapter=$_REQUEST["chapter"];
}
$entered_by="";
if (isset($_REQUEST["entered_by"])) {
  $entered_by=$_REQUEST["entered_by"];
}
$year="";
if (isset($_REQUEST["year"])) {
  $year=$_REQUEST["year"];
}
$title="";
if (isset($_REQUEST["title"])) {
  $title=$_REQUEST["title"];
}
if (get_magic_quotes_gpc()==0) {
  $title = addslashes($title);
}
$bibtex_id="";
if (isset($_REQUEST["bibtex_id"])) {
  $bibtex_id=$_REQUEST["bibtex_id"];
}
$type="";
if (isset($_REQUEST["type"])) {
  $type=$_REQUEST["type"];
}
$pub_type="";
if (isset($_REQUEST["pub_type"])) {
  $pub_type=$_REQUEST["pub_type"];
}
//Normally we think we want to enter journals :)
if ((!(isset($pub_type))) || ($pub_type == "")) {
  $pub_type = "Article";
}
$series="";
if (isset($_REQUEST["series"])) {
  $series=$_REQUEST["series"];
}
$volume="";
if (isset($_REQUEST["volume"])) {
  $volume=$_REQUEST["volume"];
}
$publisher="";
if (isset($_REQUEST["publisher"])) {
  $publisher=$_REQUEST["publisher"];
}
if (get_magic_quotes_gpc()==0) {
  $publisher = addslashes($publisher);
}
$location="";
if (isset($_REQUEST["location"])) {
  $location=$_REQUEST["location"];
}
if (get_magic_quotes_gpc()==0) {
  $location = addslashes($location);
}
$issn="";
if (isset($_REQUEST["issn"])) {
  $issn=$_REQUEST["issn"];
}
$isbn="";
if (isset($_REQUEST["isbn"])) {
  $isbn=$_REQUEST["isbn"];
}
$journal="";
if (isset($_REQUEST["journal"])) {
  $journal=$_REQUEST["journal"];
}
if (get_magic_quotes_gpc()==0) {
  $journal = addslashes($journal);
}
$booktitle="";
if (isset($_REQUEST["booktitle"])) {
  $booktitle=$_REQUEST["booktitle"];
}
if (get_magic_quotes_gpc()==0) {
  $booktitle = addslashes($booktitle);
}
$number="";
if (isset($_REQUEST["number"])) {
  $number=$_REQUEST["number"];
}
$institution="";
if (isset($_REQUEST["institution"])) {
  $institution=$_REQUEST["institution"];
}
if (get_magic_quotes_gpc()==0) {
  $institution = addslashes($institution);
}
$address="";
if (isset($_REQUEST["address"])) {
  $address=$_REQUEST["address"];
}
if (get_magic_quotes_gpc()==0) {
  $address = addslashes($address);
}
$edition="";
if (isset($_REQUEST["edition"])) {
  $edition=$_REQUEST["edition"];
}
$howpublished="";
if (isset($_REQUEST["howpublished"])) {
  $howpublished=$_REQUEST["howpublished"];
}
$month="";
if (isset($_REQUEST["month"])) {
  $month=$_REQUEST["month"];
}
$keywords="";
if (isset($_REQUEST["keywords"])) {
  $keywords=$_REQUEST["keywords"];
}
$abstract="";
if (isset($_REQUEST["abstract"])) {
  $abstract=$_REQUEST["abstract"];
}
$note="";
if (isset($_REQUEST["note"])) {
  $note=$_REQUEST["note"];
}
if (get_magic_quotes_gpc()==0) {
  $note = addslashes($note);
}
$school="";
if (isset($_REQUEST["school"])) {
  $school=$_REQUEST["school"];
}
$organization="";
if (isset($_REQUEST["organization"])) {
  $organization=$_REQUEST["organization"];
}
$return="";
if (isset($_REQUEST["return"])) {
  $return=$_REQUEST["return"];
}
$authors="";
if (isset($_REQUEST["authors"])) {
  $authors=$_REQUEST["authors"];
}
$editors="";
if (isset($_REQUEST["editors"])) {
  $editors=$_REQUEST["editors"];
}
$topics="";
if (isset($_REQUEST["topics"])) {
  $topics=$_REQUEST["topics"];
}

checkRights("EDIT");
//determine type of action
//command=="New", "Edit", "Commit"
//the special command 'change' is a variant of 'edit' that gets called when your edit data contains illegal things (duplicate bibtex etc),
//because then you don't want to clear all fields again.




if ($command=="commit")
{
  if ($bibtex_id != "")
  {
    if ($edit_type == "edit") {
      $res = mysql_query("SELECT bibtex_id FROM publication WHERE bibtex_id='".$bibtex_id."' AND pub_id!=".$pub_id."");
    }
    else if ($edit_type == "new") {
      $res = mysql_query("SELECT bibtex_id FROM publication WHERE bibtex_id='".$bibtex_id."'");
    }

    if ($res) {
    	if (mysql_numrows($res)>0) {  //apparently, there is already an article with the same bibtex ID
        echo "<div class='errormessage'>The bibtex ID is already in use, please choose another ID.</div>";
       $command = "change";
      }
    }
  }
  if ($title == "") {
    echo "<div class='errormessage'>The title field is empty, please enter a title.</div>";
    $command = "change";
  }
  if ($command == "commit")  //if it has changed in "change", something went wrong, else continue!
  {
    $stop=0;
    if ((!(isset($mark))) || ($mark == ""))
    $mark = 5;
    if ((!(isset($firstpage))) || ($firstpage == ""))
    $firstpage = 0;
    if ((!(isset($lastpage))) || ($lastpage == ""))
    $lastpage = 0;
    if ((!(isset($chapter))) || ($chapter == ""))
    $chapter  = 0;

	echo 'edit type: '.$edit_type.'<br/>';
    // The large update query for publication table
    if ($edit_type == "new") {
      $query = "INSERT INTO publication (entered_by,year,title,bibtex_id,pub_type,type,survey,mark,";
      $query = $query."series,volume,publisher,location,issn,isbn,firstpage,lastpage,";
      $query = $query."journal,booktitle,number,institution,address,chapter,edition,";
      $query = $query."howpublished,month,organization,school,note,keywords,abstract)";
      $query = $query." VALUES ('$entered_by','$year','$title','$bibtex_id','$type','$pub_type','$survey',$mark,";
      $query = $query."'$series','$volume','$publisher','$location','$issn','$isbn',$firstpage,$lastpage,";
      $query = $query."'$journal','$booktitle','$number','$institution','$address',$chapter,'$edition',";
      $query = $query."'$howpublished',$month,'$organization','$school','$note','$keywords','$abstract')";
    }
    else if ($edit_type == "edit") {
      $query = "UPDATE publication SET ";
      $query = $query."entered_by='$entered_by', ";
      $query = $query."year='$year', ";
      $query = $query."title='$title', ";
      $query = $query."bibtex_id='$bibtex_id', ";
      $query = $query."pub_type='$type', ";
      $query = $query."type='$pub_type', ";
      $query = $query."survey='$survey', ";
      $query = $query."mark=$mark, ";
      $query = $query."series='$series', ";
      $query = $query."volume='$volume', ";
      $query = $query."publisher='$publisher', ";
      $query = $query."location='$location', ";
      $query = $query."issn='$issn', ";
      $query = $query."isbn='$isbn', ";
      $query = $query."firstpage=$firstpage, ";
      $query = $query."lastpage=$lastpage, ";
      $query = $query."journal='$journal', ";
      $query = $query."booktitle='$booktitle', ";
      $query = $query."number='$number', ";
      $query = $query."institution='$institution', ";
      $query = $query."address='$address', ";
      $query = $query."chapter=$chapter, ";
      $query = $query."edition='$edition', ";
      $query = $query."howpublished='$howpublished', ";
      $query = $query."month=$month, ";
      $query = $query."organization='$organization', ";
      $query = $query."school='$school', ";
      $query = $query."note='$note', ";
      $query = $query."keywords='$keywords', ";
      $query = $query."abstract='$abstract' ";
      $query = $query."WHERE pub_id='$pub_id' ";
    }
    $res = mysql_query($query);
    
    if (!$res) //An error occurred. Show error message, then skip the rest.
        $stop=1;
    
    //for new publications, get the fresh ID
    if ($edit_type == "new") {
      $pub_id = mysql_insert_id();
    }
        
    //delete old authors
    if (($stop == 0) && ($edit_type == "edit"))
    {
      $res=mysql_query("DELETE FROM publicationauthor WHERE pub_id=".$pub_id);
      if (!$res) //An error occurred. Show error message, then skip the rest.
        $stop=1;
    }
    //add authors again
    if ($stop == 0)
    {
      $rank=1;
      $author = strtok($authors,",");
      while ($author)
      {
        $res=mysql_query("INSERT INTO publicationauthor (pub_id, author, rank, is_editor) VALUES ".
                         "('$pub_id','$author','$rank','N')");
        
        $author = strtok(",");
        $rank+=1;
      }
      if (!$res) //An error occurred. Show error message, then skip the rest.
        $stop=1;
    }
    //add editors
    if ($stop == 0)
    { 
      $rank=1;
      $editor = strtok($editors,",");
      while ($editor)
      {
         $res=mysql_query("INSERT INTO publicationauthor (pub_id, author, rank, is_editor) VALUES ".
                          "('$pub_id','$editor','$rank','Y')");
         
         $editor = strtok(",");
         $rank+=1;
      }
    
      if (!$res) //An error occurred. Show error message, then skip the rest.
        $stop=1;
    }
    
    
    //proceed with the files
    if ($stop == 0)
    {
      //files is a special case, we do not delete the main file we just stop it from being the main file..
      if ($HTTP_POST_FILES['ixfile']['tmp_name']!="")
      {
        $oldlocation = $_FILES['ixfile']['tmp_name'];
        $newname = $_FILES['ixfile']['name'];

        while (file_exists($FILEDIR.$newname))
        {
          $newname = "_".$newname;
        }

        if (!copy($oldlocation, $FILEDIR.$newname))
        {
          echo "<div class='errormessage'>Failed to copy file.</div>";
        }
        else
        {
          if ($edit_type == "edit")
          {
            //set standard files for this publication on FALSE
            $res=mysql_query("UPDATE publicationfile SET ismain='FALSE' WHERE pub_id=$pub_id");
          }
          //insert file
          $res=mysql_query("INSERT INTO publicationfile (pub_id, location, note, ismain, person_id) VALUES ($pub_id, '$newname', 'main file', 'TRUE', $entered_by)");
        }
      }
    }
    if ($stop == 1)
    {
      echo "<div class='errormessage'>An error occured while updating the publication.<br/>";
      echo "Error code: ".mysql_errno() . ": " . mysql_error() . "<br/>";
      echo "Please report the error to your system administrator.</div>";
    } 
    else
    { //everything went fine.
      if ($edit_type == "edit") {
        ?>
        <script>document.location="index.php?message=Publication updated.&page=<?php  echo (($return!="")?($return):("perpublication"))."&ID=$pub_id"; ?>";</script>
        <?php 
      }
      else {
        ?>
        <script>document.location="index.php?message=Publication added.&page=<?php  echo (($return!="")?($return):("perpublication"))."&ID=$pub_id"; ?>";</script>
        <?php 
      }
    }
  }
}
if ($command=="new")
{
  $edit_type=$command;
  echo '<p class=header>NEW PUBLICATION</p>';
  
  //show edit field
  
}
if ($command=="change")
{ //may be an edit or a new document, but another type of publication.
  //parameters to be kept are passed via commandline
  if ($edit_type=="new") {
    echo '<p class=header>NEW PUBLICATION</p>';
  }
  else if ($edit_type=="edit") {
    echo '<p class=header>CHANGE PUBLICATION</p>';
    echo '<p class=small>Here you can change the information on the selected publication.</p>';
  }
}
if ($command=="edit")
{
  $edit_type="edit";
  echo '<p class=header>CHANGE PUBLICATION</p>';
  echo '<p class=small>Here you can change the information on the selected publication.</p>';
  
  //query all the data on the requested publication
  $res=mysql_query("SELECT * FROM publication WHERE pub_id =".$pub_id.";");
  if($res)
  {
    $row=mysql_fetch_array($res);
    $entered_by=$row["entered_by"];
    $year=$row["year"];
    $title=$row["title"];
    $bibtex_id=$row["bibtex_id"];
    $type=$row["pub_type"];
    $pub_type=$row["type"];
    $survey=$row["survey"];
    $mark=$row["mark"];
    $series=$row["series"];
    $volume=$row["volume"];
    $publisher=$row["publisher"];
    $location=$row["location"];
    $issn=$row["issn"];
    $isbn=$row["isbn"];
    $firstpage=$row["firstpage"];
    $lastpage=$row["lastpage"];
    $journal=$row["journal"];
    $booktitle=$row["booktitle"];
    $number=$row["number"];
    $institution=$row["institution"];
    $address=$row["address"];
    $chapter=$row["chapter"];
    $edition=$row["edition"];
    $howpublished=$row["howpublished"];
    $month=$row["month"];
    $organization=$row["organization"];
    $school=$row["school"];
    $note=$row["note"];
    $keywords=$row["keywords"];
    $abstract=$row["abstract"];
  }
}

//here the general page is displayed
if (true)
{
  if ($edit_type !="") {
    $command = $edit_type;
  }
  
	?>
  <table class=vlist cellspacing="0">
  <form name=pubform action="">
  <tr>
    <td>Type of publication</td>
    <td>
      <?php  
        $bibentries=array('article', 'book', 'booklet', 'inbook', 'incollection', 'inproceedings', 'manual', 'mastersthesis', 'misc', 'phdthesis', 'proceedings', 'techreport', 'unpublished');
        
        echo "<select name=ixkind";
        $entryline = " ONCHANGE=\"";
        $entryline.="document.location='index.php?page=publicationform&pub_type=";
        $entryline.="'+document.pubform.ixkind.options[document.pubform.ixkind.selectedIndex].value+'";
        $entryline.="&entered_by='+document.person.ixcontactperson.value+'";
        $entryline.="&title='+document.inform.ixtitle.value+'&year='+document.inform.ixyear.value+'";
        $entryline.="&bibtex_id='+document.inform.ixciteID.value+'";
        $entryline.="&ID=".$pub_id."'+'&command=change'+'&edit_type=".$command."'+'&return=".$return."';\"";
        $entryline.=" ";
	      echo $entryline. " >";
        foreach ($bibentries as $entrytype)
        {
          echo "<OPTION VALUE=\"".$entrytype."\"";
          if ($pub_type == $entrytype)
          echo ' selected ';
          echo " > ".$entrytype. "</OPTION>";
        }
        
        echo "</select>";
      ?>
    </td>
  </tr>
  </form>
  <form name=surv action="" method="post">
  <tr>
    <td>Survey</td>
    <td>
      <input type=checkbox name=ixsurvey
      <?php  
      if (isset($survey)) {
        if ($survey == "1") {
          echo " checked";
        }
      }
      ?>
      >
    </td>
  </tr>
  </form>
  <form name=person action="" method="post">
  <tr>
    <td>Entered by</td>
    <td>
      <select name=ixcontactperson>
      <?php 
      $res=mysql_query("SELECT * FROM person ORDER BY surname;");
      if($res)
      {
        while($row=mysql_fetch_array($res))
        {
          $checkthisname = "";
          if (    (($command == "new") && ($row["ID"]==$person_id))
               || ($row["ID"] == $entered_by) ) {
            $checkthisname ="SELECTED";
          }
          echo "<option ".$checkthisname." value=".$row["ID"].">".makename($row)."</option>\n";
         /*
          if ($return == "mypublication") {
            if ($row["ID"] == $entered_by) {
              echo "<option selected value=".$row["ID"].">".makename($row)."</option>\n";
            }
          } else {
            echo "<option ".(($row["ID"]==$entered_by)?("selected"):(""))." value=".$row["ID"].">".makename($row)."</option>\n";  }
          }
         */
        }
      }
        ?>
      </select>
    </td>
  </tr>
  </form>
  <form name=inform action="" method="post">
  <tr>
    <td>Title</td>
    <td>
      <input type=text size=45 name=ixtitle <?php 
      if (isset($title)) {
        echo "value=\"".htmlentities(urldecode($title),ENT_QUOTES)."\""; //DR: why the URL decode here? the htmlentities is to ensure that garbage in the title does not break the html display.
      }
      ?>
      >
    </td>
  </tr>
  <tr>
    <td>Year published</td>
    <td>
      <?php 
      if ($command == "new")
        makeyearbox("ixyear", time());
      else
        makeyearbox("ixyear",(isset($year) ? $year : time())); 
      ?> 
    </td>
  </tr>
  <tr>
    <td>Bibtex cite ID</td>
    <td>
      <input type=text size=45 name=ixciteID <?php 
      if (isset($bibtex_id)) {
        echo " value=\"".urldecode($bibtex_id)."\"";
      }
      ?>
      >
    </td>
  </tr>
    <?php 
    //here, publication-type dependend fields are listed
    $fields = getFieldArray($pub_type);
    testNinput($fields,"type",$type,"Type (for example Talk) ");
    testNinput($fields,"series",htmlentities(urldecode($series),ENT_QUOTES),"Series ");
    testNinput($fields,"volume",$volume,"Volume ");
    testNinput($fields,"publisher",htmlentities(urldecode($publisher),ENT_QUOTES),"Publisher ");
    testNinput($fields,"address",htmlentities(urldecode($address),ENT_QUOTES),"Address ");
    testNinput($fields,"issn",$issn,"ISSN ");
    testNinput($fields,"isbn",$isbn,"ISBN ");
    if (in_array("pages",$fields))
    {
      Ninput("firstpage",$firstpage,"First page ");
      Ninput("lastpage",$lastpage,"Last page ");
    }
    testNinput($fields,"journal",htmlentities(urldecode($journal),ENT_QUOTES),"Journal ");
    testNinput($fields,"booktitle",htmlentities(urldecode($booktitle),ENT_QUOTES),"Booktitle ");
    testNinput($fields,"location",htmlentities(urldecode($location),ENT_QUOTES),"Location ");
    testNinput($fields,"number",$number,"Number ");
    testNinput($fields,"institution",htmlentities(urldecode($institution),ENT_QUOTES),"Institution ");
    testNinput($fields,"chapter",$chapter,"Chapter ");
    testNinput($fields,"edition",$edition,"Edition ");
    testNinput($fields,"howpublished",$howpublished,"How published ");
    echo "<tr><td>";
    echo "Month";
    echo "</td><td>";
    makemonthbox("ixmonth",(isset($month) ? $month : time()));
    echo "</td></tr>";
    testNinput($fields,"organization",htmlentities(urldecode($organization),ENT_QUOTES),"Organization ");
    testNinput($fields,"school",htmlentities(urldecode($school),ENT_QUOTES),"School ");
    testNinput($fields,"note",htmlentities(urldecode($note),ENT_QUOTES),"Note ");
    testNinput($fields,"keywords",htmlentities(urldecode($keywords),ENT_QUOTES),"Keywords ");
    if (in_array("abstract",$fields))
    {
      echo "<tr><td valign=top>Abstract </td><td>";
      echo "<textarea name=ixabstract wrap=virtual cols=50 rows=10>";
      if (isset($abstract))
      {
        echo htmlentities(urldecode($abstract),ENT_QUOTES);
      }
      echo "</textarea>";
      echo "</td></tr>";
    }
  ?>
  </form>
  <form name=AuthorsForm action="" method="post">
  <tr>
    <td valigh="top" colspan=2>
      <?php  if (isset($pub_type))
      {
      ?>
      <table border=0 width=100%>
        <tr>
          <td align=left width=50%>Authors</td>
          <td align=right width=50%>Editors</td>
        </tr>
        <tr>
          <td valign="top" width=50% align=left>
            <select multiple name="AuthorsBox" style="width:100%;" size="6">
            <?php 
            if ($command == "edit")
            {
              $res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='N' ORDER by rank;");
              if($res)
              {
                while($row=mysql_fetch_array($res))
                {
                  $res2=mysql_query("SELECT * FROM author WHERE ID =".$row["author"]." ORDER BY surname,name;");
                  $row=mysql_fetch_array($res2);
                  echo "<option value=".$row["ID"].">".getNameFromRow($row)."</option>\n";
                }
              }
            }
            else //new publication or change because of error in first input
            {
              $author = strtok($authors,",");
              while ($author)
              {
                $res = mysql_query("SELECT * FROM author WHERE ID = '".$author."'");
                $row=mysql_fetch_array($res);
                echo "<option value=".$row["ID"].">".getNameFromRow($row)."</option>\n";
                $author = strtok(",");
              }
            }
            ?>
            </select>
          </td>
          <td valign="top" width=50% align="right">
            <select multiple name="EditorsBox" style="width:100%;" size="6">
            <?php 
            if ($command == "edit")
            {
              $res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='Y' ORDER by rank;");
              if($res)
              {
                while($row=mysql_fetch_array($res))
                {
                  $res2=mysql_query("SELECT * FROM author WHERE ID =".$row["author"]." ORDER BY surname,name;");
                  $row=mysql_fetch_array($res2);
                  echo "<option value=".$row["ID"].">".getNameFromRow($row)."</option>\n";
                }
              }
            }
            else //new publication or change because of error in first input
            {
              $editor = strtok($editors,",");
              while ($editor)
              {
                $res = mysql_query("SELECT * FROM author WHERE ID = '".$editor."'");
                $row=mysql_fetch_array($res);
                echo "<option value=".$row["ID"].">".getNameFromRow($row)."</option>\n";
                $editor = strtok(",");
              }
            }
            ?>
            </select>
          </td>
        </tr>
        <tr>
          <td colspan=2 align=right>
            <input onclick="javascript:window.open('indexlight.php?page=listauthors&pub_id=<?php echo $pub_id; ?>&authors='+showAuthors()+'&editors='+showEditors(),'open_window','resizable, scrollbars,width=800, height=480, dependent, left=0, top=0');" value="Edit authors/editors" type="button">
          </td>
        </tr>
      </table>
    </td>
  </tr>
  </form>
  
  <form name="mainform" onSubmit="return OnSubmitForm();" method="post" enctype="multipart/form-data">
  <tr>
    <td>Local file<br/> (leave empty for no change)
    </td>
    <td>
      <input name="ixfile" type="file" size="60" accept="*/*" />
    </td>
  </tr>
  <tr>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td colspan=2 align=right>
      <input type=submit value="Submit changes">
    </td>
  </tr>
  </form>
  </table>
  <?php 
  }
}
  
//Function specific functions and scripts
function Ninput($name,$value,$string)
{
  echo "<tr><td>";
  echo $string;
  echo "</td><td>";
  echo "<input type=text size=45 name=ix".$name;
  if (isset($value))
  {
    echo " value=\"".urldecode($value)."\"";
  }
  echo "></td></tr>";
}

function testNinput($allfields,$name,$value,$string)
{
  if (in_array($name,$allfields))
  {
    Ninput($name,$value,$string);
  }
}
?>
<script SCRIPT LANGUAGE="JavaScript">
function ClearAuthors()
{
  for (var i=(document.AuthorsForm.AuthorsBox.length-1);i>=0;i--)
  {
    document.AuthorsForm.AuthorsBox.options[i] = null;
  }
}

function AddAuthor(text,value)
{
  document.AuthorsForm.AuthorsBox.options[document.AuthorsForm.AuthorsBox.length] = new Option(text,value,false,false);
}

function ClearEditors()
{
  for (var i=(document.AuthorsForm.EditorsBox.length-1);i>=0;i--)
  {
    document.AuthorsForm.EditorsBox.options[i] = null;
  }
}

function AddEditor(text,value)
{
  document.AuthorsForm.EditorsBox.options[document.AuthorsForm.EditorsBox.length] = new Option(text,value,false,false);
}

function ClearTopics()
{
  for (var i=(document.TopicsForm.TopicsBox.length-1);i>=0;i--)
  {
    document.TopicsForm.TopicsBox.options[i] = null;
  }
}

function AddTopic(text,value)
{
  document.TopicsForm.TopicsBox.options[document.TopicsForm.TopicsBox.length] = new Option(text,value,false,    false);
}

function OnSubmitForm()
{
  <?php 
  $res=mysql_query("SELECT * FROM publication WHERE pub_id =".$pub_id.";");
  $s_entered_by = "'+document.person.ixcontactperson.options[document.person.ixcontactperson.selectedIndex].value+'";
  $s_year = "'+document.inform.ixyear.value+'";
  $s_title = "'+document.inform.ixtitle.value+'";
  $s_bibtex_id = "'+document.inform.ixciteID.value+'";
  $s_pub_type = "";
  $s_type = "";
  $s_survey = "'+document.surv.ixsurvey.checked+'";
  $s_mark = "5";
  $s_series = "";
  $s_volume = "";
  $s_publisher = "";
  $s_location = "";
  $s_issn = "";
  $s_isbn = "";
  $s_firstpage = "0";
  $s_lastpage = "0";
  $s_journal = "";
  $s_booktitle = "";
  $s_number = "";
  $s_institution = "";
  $s_address = "";
  $s_chapter = "";
  $s_edition = "";
  $s_howpublished = "";
  $s_month = "";
  $s_organization = "";
  $s_school = "";
  $s_note = "";
  $s_keywords = "";
  $s_abstract = "";
  $fields = getFieldArray($pub_type);
  if (in_array("type",$fields))
  $s_type = "'+document.inform.ixtype.value+'";
  if (in_array("series",$fields))
  $s_series = "'+document.inform.ixseries.value+'";
  if (in_array("volume",$fields))
  $s_volume = "'+document.inform.ixvolume.value+'";
  if (in_array("publisher",$fields))
  $s_publisher = "'+document.inform.ixpublisher.value+'";
  if (in_array("location",$fields))
  $s_location = "'+document.inform.ixlocation.value+'";
  if (in_array("issn",$fields))
  $s_issn = "'+document.inform.ixissn.value+'";
  if (in_array("isbn",$fields))
  $s_isbn = "'+document.inform.ixisbn.value+'";
  if (in_array("pages",$fields))
  $s_firstpage = "'+document.inform.ixfirstpage.value+'";
  if (in_array("pages",$fields))
  $s_lastpage = "'+document.inform.ixlastpage.value+'";
  if (in_array("journal",$fields))
  $s_journal = "'+document.inform.ixjournal.value+'";
  if (in_array("booktitle",$fields))
  $s_booktitle = "'+document.inform.ixbooktitle.value+'";
  if (in_array("number",$fields))
  $s_number = "'+document.inform.ixnumber.value+'";
  if (in_array("institution",$fields))
  $s_institution = "'+document.inform.ixinstitution.value+'";
  if (in_array("address",$fields))
  $s_address = "'+document.inform.ixaddress.value+'";
  if (in_array("chapter",$fields))
  $s_chapter = "'+document.inform.ixchapter.value+'";
  if (in_array("edition",$fields))
  $s_edition = "'+document.inform.ixedition.value+'";
  if (in_array("howpublished",$fields))
  $s_howpublished = "'+document.inform.ixhowpublished.value+'";
  if (in_array("month",$fields))
  $s_month = "'+document.inform.ixmonth.value+'";
  if (in_array("organization",$fields))
  $s_organization = "'+document.inform.ixorganization.value+'";
  if (in_array("school",$fields))
  $s_school = "'+document.inform.ixschool.value+'";
  if (in_array("note",$fields))
  $s_note = "'+document.inform.ixnote.value+'";
  if (in_array("keywords",$fields))
  $s_keywords = "'+document.inform.ixkeywords.value+'";
  if (in_array("abstract",$fields))
  $s_abstract = "'+document.inform.ixabstract.value+'";
  $output = "document.mainform.action='index.php?page=publicationform&command=commit&edit_type=".$edit_type."";
  $output = $output."&entered_by=".$s_entered_by;
  $output = $output."&year=".$s_year;
  $output = $output."&title=".$s_title;
  $output = $output."&bibtex_id=".$s_bibtex_id;
  $output = $output."&pub_type=".$pub_type;
  $output = $output."&type=".$s_type;
  $output = $output."&survey=".$s_survey;
  $output = $output."&mark=".$s_mark;
  $output = $output."&series=".$s_series;
  $output = $output."&volume=".$s_volume;
  $output = $output."&publisher=".$s_publisher;
  $output = $output."&location=".$s_location;
  $output = $output."&issn=".$s_issn;
  $output = $output."&isbn=".$s_isbn;
  $output = $output."&firstpage=".$s_firstpage;
  $output = $output."&lastpage=".$s_lastpage;
  $output = $output."&journal=".$s_journal;
  $output = $output."&booktitle=".$s_booktitle;
  $output = $output."&number=".$s_number;
  $output = $output."&institution=".$s_institution;
  $output = $output."&address=".$s_address;
  $output = $output."&chapter=".$s_chapter;
  $output = $output."&edition=".$s_edition;
  $output = $output."&howpublished=".$s_howpublished;
  $output = $output."&month=".$s_month;
  $output = $output."&organization=".$s_organization;
  $output = $output."&school=".$s_school;
  $output = $output."&note=".$s_note;
  $output = $output."&keywords=".$s_keywords;
  $output = $output."&abstract=".$s_abstract;
  $output = $output."&authors='+showAuthors()+'&editors='+showEditors()+'";
  $output = $output."&ID=".$pub_id."'+'&return=".$return;
  $output = $output."';";
  echo $output;
  ?>
}
</script>
