<?php 
/*
Web based document management system
Copyright (C) 2003-2006 Hendri Hondorp, Dennis Reidsma, Arthur van Bunningen, Wietse Balkema

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require_once("checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage
include "displayauthors.php";
include "displaynotes.php";

/*
re-engineering

this page is included with as initialisation the mysql result from a query into the publication table.

input:
$res from table publication, which is assumed to be sorted on year
some (NEVER USED) $nonotes parameter

output: for every publication table row in the input, display publication information.
set headers for each separate year present in the data.
*/
?>
<?php 

    //if $nonotes is set to true, no notes will be displayed
    $res_main=$res;
    if($res_main) {
        while ($row=mysql_fetch_array($res_main)) { //for each row from publication table contained in query result
		echo "<tr><td>";
		$pub_id=$row["pub_id"];
        $entered=$row["entered_by"];
		$year=$row["year"];
		$title=$row["title"];
		$bibtex_id=$row["bibtex_id"];
		$pubtype=$row["type"];
		$journal=$row["journal"];
   		$iss=$row["issn"];
   		$volume=$row["volume"];
   		$firstpage=$row["firstpage"];
   		$lastpage=$row["lastpage"];
   		$series=$row["series"];
   		$volume=$row["volume"];
   		$publisher=$row["publisher"];
   		$location=$row["location"];
   		$isbn=$row["isbn"];
   		$number=$row["number"];
   		$institution=$row["institution"];
   		$booktitle=$row["booktitle"];

		if ($oldyear != "$year") {
			echo "<p class=header>".$year."</p>";
			$oldyear=$year;
			$oldpubtype="";
		}
		
		//DR 2005.06.13: a checkbox per publication, named check_<pub_id>, that can be used for e.g. 'move all to topic X'
//		echo '<input title="see bottom of page for multiple-publication-operations" type=checkbox name="check_"'.$pub_id.'">';
				
		echo "&nbsp;<a title='BiBTeX' class=small HREF='".$URL."indexlight.php?page=perbibtex&ID=".$pub_id."' target='_blank'><IMG SRC=\"".$URL.$THEME."icons/_bibtex_small.gif\" border=0></a>&nbsp;";
		
		rPrint("EDIT","<a title='edit' class=small href=\"index.php?page=publicationchange&ID=$pub_id\"><IMG SRC=\"".$URL.$THEME."icons/_edit_small.gif\" border=0></a>&nbsp;");
		$res=mysql_query("SELECT location FROM publicationfile WHERE pub_id =".$pub_id." AND ismain='TRUE'");
		if ($res) 
		{
			if ($row=mysql_fetch_array($res) ) 
			{
				rprint("PDF","<A title='view article' target='_blank' HREF=".$FILEURL.$row['location']."><IMG SRC=\"".$URL.$THEME."icons/_download_small.gif\" border=0></a>&nbsp;");
			}			    
			
		}
            
        echo displayAuthors($pub_id);
//    	    $res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='N' ORDER by rank;");
    		//if($res) {
			//include "pageshowauthors.php";
			//if ($num)
//				echo "&nbsp;";
		//}
		echo "<i><A HREF=".$ROOT."?page=perpublication&ID=".$pub_id.">".htmlspecialchars(urldecode($title))."</A></i>,&nbsp;";
		switch ($pubtype) {

     		case "Proceedings":
   			if ($booktitle) {
				echo "in <i>".htmlspecialchars(urldecode($booktitle))."</i>, ";
   			}
            echo displayEditors($pub_id);
    /*	        	$res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='Y' ORDER by rank;");
    			if($res) {
				include "pageshowauthors.php";
				if ($num) {
					echo " (eds), ";
				}
			}*/
   			if ($series) {
				echo "<i>".urldecode($series)."</i>, ";
   			}
   			if ($volume) {
				echo "volume ".urldecode($volume).", ";
   			}
			if ($publisher) {
				echo urldecode($publisher).", ";
			}
   			if ($location) {
				echo urldecode($location).", ";
   			}
  			if ($isbn) {
  				echo "ISBN&nbsp;".urldecode($isbn).", ";
     			}
  			if ($iss) {
  				echo "ISS&nbsp;".urldecode($iss).", ";
  			}
  			if ($firstpage) {
  				if ($lastpage) {
  					echo "pp.&nbsp;".$firstpage."-".$lastpage.", ";
				}
			}
		break;

     		case "Journal":
  			if ($journal) {
				echo urldecode($journal).", ";
			}
        echo displayEditors($pub_id);
/*    	        	$res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='Y' ORDER by rank;");
    			if($res) {
				include "pageshowauthors.php";
				if ($num) {
					echo " (eds), ";
				}
			}*/
  			if ($volume) {
				echo urldecode($volume);
			}
  			if ($firstpage) {
  				if ($lastpage) {
					if ($volume) {
						echo ":";
					} else {
						echo "pages&nbsp;";
					}
  					echo $firstpage."-".$lastpage.", ";
				}
			}
			else {
				if ($volume) {
					echo ", ";
				}
			}
  			if ($iss) {
  				echo "ISS&nbsp;".urldecode($iss).", ";
     			}
  	   	break;

     		case "Report":
     			if ($number) {
				echo urldecode($number).", ";
     			}
     			if ($institution) {
				echo urldecode($institution).", ";
  			}
     			if ($location) {
				echo urldecode($location).", ";
  			}
     			if ($publisher) {
				echo urldecode($publisher).", ";
  			}
     		break;

     		case "BookSection":
  			if ($firstpage) {
				echo "pp. ".urldecode($firstpage)."-";
     			}
  			if ($lastpage) {
				echo $lastpage.". ";
     			}
  			if ($titlebook) {
				echo "In&nbsp;<i>".htmlspecialchars(urldecode($titlebook))."</i>, ";
			}
            echo displayEditors($pub_id);
    	        	/*$res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='Y' ORDER by rank;");
    			if($res) {
				include "pageshowauthors.php";
				if ($num) {
					echo " (eds), ";
				}
			}*/
  			if ($publisher) {
				echo urldecode($publisher).", ";
  			}
  			if ($location) {
				echo urldecode($location).", ";
			}
  			if ($iss) {
  				echo "ISS&nbsp;".urldecode($iss).", ";
     			}
  			if ($isbn) {
  				echo "ISBN&nbsp;".urldecode($isbn).", ";
			}
     		break;

     		case "Misc":
			if ($location) {
				echo $location.", ";
			}
  	   	break;

     		case "Book":
                echo displayEditors($pub_id);
    	        	/*$res=mysql_query("SELECT * FROM publicationauthor WHERE pub_id = ".$pub_id." AND is_editor='Y' ORDER by rank;");
    			if($res) {
				include "pageshowauthors.php";
				if ($num) {
					echo " (eds), ";
				}
			}*/
		  	if ($series) {
				echo urldecode($series).", ";
		  	}
		  	if ($volume) {
				echo "Vol: ".urldecode($volume).". ";
		        }
		  	if ($publisher) {
				echo urldecode($publisher).", ";
			}
		        if ($location) {
				echo urldecode($location).", ";
		        }
		  	if ($iss) {
		  		echo "ISS&nbsp;".urldecode($iss).", ";
		        }
		  	if ($isbn) {
		  		echo "ISBN&nbsp;".urldecode($isbn).", ";
		        }
  	   	break;

     		case "Dissertation":
		     if ($location) {
			echo urldecode($location).", ";
		     }
    		break;
		}
		 // switch

        echo $year;
		
       if ((!(isset($nonotes))) || ($nonotes != true))
       { 
  		echo "<ul>";
        echo displayNotesForPublication($pub_id);

  		echo "</ul>";
	 } 
  		echo "</td>";
		echo "</TR>";
	}

    }



?>
