<?php
/*
This file offers access to a number of attachment related actions.
After performing the action, the browser will return to the specified $return page.

actions:
attachments are identified by a (pub_id,location) pair
    delete(pub_id, location, confirmed, return)
    add($pub_id, isremote, $note, $alternativename, $remotelocation, $ismain)
    open(pub_id, location) : only for attachments stored on the server!
    setmain(pub_id, location,return)
    unsetmain(pub_id, location,return)
*/

require_once($DIR."checkBase.php"); //if this script is not called from within one of the base pages, redirect to frontpage

include_once($DIR."_basicfunctions.php");

# register relevant REQUEST parameters
$action = "";
if (isset($_REQUEST["action"])) {
    $action = $_REQUEST["action"];
} 
if (get_magic_quotes_gpc()==1) {
    $action = stripslashes($action);
}
$att_id = "";
if (isset($_REQUEST["att_id"])) {
    $att_id = $_REQUEST["att_id"];
}
$pub_id = "";
if (isset($_REQUEST["pub_id"])) {
    $pub_id = $_REQUEST["pub_id"];
}
$confirmed = "";
if (isset($_REQUEST["confirmed"])) {
    $confirmed = $_REQUEST["confirmed"];
}
$note = "";
if (isset($_REQUEST["note"])) {
    $note = $_REQUEST["note"];
}
if (get_magic_quotes_gpc()==1) {
    $note = stripslashes($note);
}
$ismain = "FALSE";
if (isset($_REQUEST["ismain"])) {
    $ismain = $_REQUEST["ismain"];
}
$isremote = "FALSE";
if (isset($_REQUEST["isremote"])) {
    $isremote = $_REQUEST["isremote"];
}
$remotelocation = "";
if (isset($_REQUEST["remotelocation"])) {
    $remotelocation = $_REQUEST["remotelocation"];
}
if (get_magic_quotes_gpc()==1) {
    $remotelocation = stripslashes($remotelocation);
}
$location = "";
if (isset($_REQUEST["location"])) {
    $location = $_REQUEST["location"];
}
if (get_magic_quotes_gpc()==1) {
    $location = stripslashes($location);
}
$return = "";
if (isset($_REQUEST["return"])) {
    $return = $_REQUEST["return"];
}
$alternativename = "";
if (isset($_REQUEST["alternativename"])) {
    $alternativename = $_REQUEST["alternativename"];
}
if (get_magic_quotes_gpc()==1) {
    $alternativename = stripslashes($alternativename);
}



#depending on specified action, perform it...
switch ($action) {
    case "delete":
        include_once($DIR."lib/actions/attachmentactions.php");
        #delete.  check whether confirmed is True. If so, delete, otherwise request confirmation
        if ($confirmed) {
            //delete, return
            attachmentDelete($pub_id, $location);
            echo mysql_error();
            $_SESSION["aigaionmessage"].="Attachment deleted.<br>";
            returnTo(rawurldecode($return)."&pub_id=".$pub_id);
        } else {
            //do nothing. It seems to be the case that we don't even get here if confirmed was false...
            $_SESSION["aigaionerror"].="Something strange happened: we're in actionattachment#delete, but confirmed is false!.<br>";
            returnTo(rawurldecode($return));
        }
        break;
    case "add": 
        include_once($DIR."lib/actions/attachmentactions.php");
        if ($isremote=="FALSE") {
            $success = attachmentAddNew($pub_id, $note, $alternativename, $ismain);
        } else {
            $success = attachmentAddNewRemote($pub_id, $note, $alternativename, $remotelocation, $ismain);
        }
        if ($success) {
            $_SESSION["aigaionmessage"].="Attachment added.<br>";
        } else {
            $_SESSION["aigaionerror"].="An error occurred while uploading the new attachment.<br>";
        }
        returnTo(rawurldecode($return));
        break;
    case "edit":
        include_once($DIR."lib/actions/attachmentactions.php");
        $success = attachmentUpdateNote($pub_id, $location, $note);
        if ($success) {
            $_SESSION["aigaionmessage"].="Note updated.<br>";
        } else {
            $_SESSION["aigaionerror"].="An error occurred while updating the attachment note.<br>";
        }
        returnTo(rawurldecode($return));
        break;
    case "open": 
        #inject attachment into stream, don't return anywhere. NOTE: this will only be called for internally stored attachments!
        include_once($DIR."lib/functions/attachmentfunctions.php");
        if (injectAttachment($pub_id, $location)) {
            #success: die
            die();
        }
        #not successfull in finding att...
        #do nothing for now
        die();
        //break;
    case "setmain": 
        include_once($DIR."lib/actions/attachmentactions.php");
        attachmentSetMain($pub_id, $location);
        returnTo(rawurldecode($return));
        break;
    case "unsetmain": 
        include_once($DIR."lib/actions/attachmentactions.php");
        attachmentUnsetMain($pub_id, $location);
        returnTo(rawurldecode($return));
        break;
}

?>